#include<graphics.h>
#include<math.h>
#include<conio.h>
#include<alloc.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<process.h>

#define byte unsigned char

byte background[4096];

struct sheader
       {unsigned short int base;
	unsigned short int unk1, unk2, unk3;
	unsigned short int ochecksum;
	unsigned short int unk4;
	unsigned short int otrackdata;
       }header;

byte *objects,endheader[256];

struct strackheader
       {short int startangle, startheight;
	short int startY, startZ, startX;
	short int startWidth, poleWidth;
	byte pitside, trsurround, rbank, lbank;
	short int kerbcnum,unk1;
	short int kerbtopcolor, kerbbottomcolor, unk2;
	short int kerbtopcolor2, kerbbottomcolor2;
       }trackheader;

struct sCCsetup
       {byte fwing,rwing;
	byte g1,g2,g3,g4,g5,g6;
	byte tyretype;
	signed char brakeb;
	unsigned short grip,QA,RA,QT;
	unsigned short accel,airres,unk1,TW1,TW2,RT;
	  /*in fact unk1 is QTW, TW2 is Unk1, I knew it bad when wrote this*/
	unsigned short unk2,wetRA,unk3,unk4;
       }CCsetup;

struct command
       {unsigned char cmd;
	unsigned char a0;
	short int a1,a2,a3,a4,a5;
	struct command *elo,*kov;
       }*trcmd,*picmd;

struct trackseg
       {
	unsigned short int tlu;
	short int curvature;
	short int height;
	unsigned short int flags;
	byte rbank;
	byte lbank;
	short int sign;
	double length;
	double cumlength;
	long int cumgrad,cumheight;
	double fik,fiv;
	double r;
	double kx,ky, vx,vy;
	byte middle;
	double fim;
	double mx,my;
	double ox,oy;
	double ks[2],vs[2];
	struct command *cmd;
	struct trackseg *elo,*kov;
       }*ktrack,*kpit, *atrack,*apit;

struct bestlineseg
       {byte tlu;
	byte type;
	short int a1,a2,a3;
	long int bigrad;
	short int sign;
	double length;
	double s;
	double fik,fiv;
	double r;
	double ox,oy;
	double kx,ky,vx,vy;
	struct bestlineseg *elo,*kov, *pre;
       }*kbl,*ablseg;

double scale, anglescale, radscale, carwidth, widthscale, pitwidth;
int maxx,maxy, maxtx,maxty, dx,dy;
short int drawpoints;/*if !=0, draw centre point and radius of every best line segment*/
short int drawsegs;/*if!=0, draw lines in the track segment at the end of every tlu*/
short int lapnumindex;/* endheader[lapnumindex]=number of laps */

void drawCClinesegment(struct bestlineseg *fbl);

/*signum function*/
short int sgn(double x)
{if(x>0.0){return 1;}
 if(x==0.0){return 0;}
 return -1;
}

/*round*/
int f2i(double f)
{int a;
 if(f<0)f-=1.0;
 a=(int)(f+0.5);
 return(a);
}

/*generalized arc tangent*/
double arctan2(double sinf, double cosf)
{double f;

 if( fabs(sinf) < fabs(cosf) )
   {/*f=asin(fabs(sinf));*/f=atan(fabs(sinf/cosf));}
 else{/*f=acos(fabs(cosf));*/f=0.5*M_PI-atan(fabs(cosf/sinf));}

 if(sinf<0.0)
   {if(cosf<0.0){f=M_PI+f;}
     else{f=2*M_PI-f;}
   }
 else
   {if(cosf<0.0){f=M_PI-f;}
   }
 return f;
}

/**********************************/
/*draw an arc with variable radius*/
/**********************************/
void arc2(int x,int y,float stangle,float endangle,float str,float endr)
{float fi,r,a,fiv,r0;
 int color,px,py;

 color=getcolor();
 fiv=endangle;
 fi=stangle;
 fi=fi;
 a=(endr-str)/(fiv-fi);
 r0=str-a*fi;
 do
   {r=r0+a*fi;
    px=x+f2i(r*cos(fi));
    py=y-f2i(r*sin(fi));
    if( (px>=0)&&(px<=maxtx)&&(py>=0)&&(py<=maxty) )
      {putpixel(px,py,color);}
    if(r>10)fi+=1/r;
     else{fi+=0.1;}
   }
 while(fi<fiv);
 px=x+f2i(r*cos(fiv));
 py=y-f2i(r*sin(fiv));
 if( (px>=0)&&(px<=maxtx)&&(py>=0)&&(py<=maxty) )
   {putpixel(px,py,color);}
}

/*************/
/*draw a line*/
/*************/
void line2(int kx, int ky, int vx,int vy)
{int m,n, h, s, dx,dy, signx,signy;
 int color,px,py;

 color=getcolor();
 m=vy-ky;
 n=vx-kx;
 signx=sgn(n);
 signy=sgn(m);
 m=abs(m);
 n=abs(n);
 if( m<n )
   {h=abs(vx-kx)+1;
    dx=0;
    dy=0;
    s=0;
    while( dx<h )
       {if(s>=n)
	  {dy++;
	   s-=n;
	  }
	px=kx+signx*dx; py=ky+signy*dy;
	if( (px>=0)&&(px<=maxtx)&&(py>=0)&&(py<=maxty) )
	  {putpixel(px,py,color);}
	s+=m;
	dx++;
       }
   }
 else
   {h=abs(vy-ky)+1;
    dx=0;
    dy=0;
    s=0;
    while( dy<h )
       {if(s>=n)
	  {dx++;
	   s-=m;
	  }
	px=kx+signx*dx; py=ky+signy*dy;
	if( (px>=0)&&(px<=maxtx)&&(py>=0)&&(py<=maxty) )
	  {putpixel(px,py,color);}
	s+=n;
	dy++;
       }
   }
}

/*************************/
/*write a string to (x,y)*/
/*************************/
void writexy(int x,int y,char *str)
{int i,len;
 char s[2];

 len=strlen(str);
 s[1]=0;
 for(i=0;i<len;i++)
    {bar(x+i*8,y,x+i*8+8,y+8);
     s[0]=str[i];
     outtextxy(x+i*8,y,s);
    }
}

/**********************************************/
/*allocate memory for a new trackseg structure*/
/**********************************************/
struct trackseg *newtrackseg()
{struct trackseg *poi;

 poi=(struct trackseg*)malloc(sizeof(struct trackseg));
 if(poi==NULL)
   {fprintf(stderr,"Not enough memory.");
    exit(-1);
   }
 poi->middle=0;
 return poi;
}

/*************************************************/
/*allocate memory for a new bestlineseg structure*/
/*************************************************/
struct bestlineseg *newbestlineseg()
{struct bestlineseg *poi;

 poi=(struct bestlineseg*)malloc(sizeof(struct bestlineseg));
 if(poi==NULL)
   {fprintf(stderr,"Not enough memory.");
    exit(-1);
   }
 return poi;
}

/*************************************************/
/*allocate memory for a new command structure*/
/*************************************************/
struct command *newcommand()
{struct command *poi;

 poi=(struct command*)malloc(sizeof(struct command));
 if(poi==NULL)
   {fprintf(stderr,"Not enough memory.");
    exit(-1);
   }
 return poi;
}

/********************/
/*draw track segment*/
/********************/
void drawtracksegment(struct trackseg *ftr)
{int pbkx,pbky,pbvx,pbvy, pjkx,pjky,pjvx,pjvy, pox,poy;
 int kbkx,kbky,kbvx,kbvy,kjkx,kjky,kjvx,kjvy;
 int wbkx,wbky,wbvx,wbvy,wjkx,wjky,wjvx,wjvy;
 float str,endr,r, ksr,kvr, wkr,wvr;
 float fkx,fky,fvx,fvy;
 float dfi, x,y,deltax,deltay, s[2];
 int i,prevcolor;
 unsigned short int lkerb,rkerb, lwall,rwall, lbridge,rbridge;
 float kbw,kjw,vbw,vjw;

 if(ftr==NULL){return;}
 if(ftr->sign==4){return;}
 prevcolor=getcolor();
 lkerb=ftr->flags&2048;
 rkerb=ftr->flags&1024;
 if( (prevcolor==1)||(prevcolor==9) )/*pit segment*/
   {lwall=ftr->flags&3; rwall=lwall;
    lbridge=ftr->flags&32;
    rbridge=ftr->flags&16;
   }
 else
   {lbridge=ftr->flags&32;
    lwall=!( (ftr->flags&8192) && (!lbridge) );
    rbridge=ftr->flags&16;
    rwall=!( (ftr->flags&4096) && (!rbridge) );
   }
 if(ftr->elo)
   {kbw=(1.0+(float)ftr->elo->lbank/32.0);
    kjw=(1.0+(float)ftr->elo->rbank/32.0);
   }
 else
   {kbw=(1.0+(float)trackheader.lbank/32.0);
    kjw=(1.0+(float)trackheader.rbank/32.0);
   }
 vbw=(1.0+(float)ftr->lbank/32.0);
 vjw=(1.0+(float)ftr->rbank/32.0);
 if(ftr->middle)
   {pbvx=f2i((ftr->mx-/*(float)*/(ftr->vs[0])*cos(ftr->fiv))*scale)+dx;
     pbvy=maxty-f2i((ftr->my-/*(float)*/(ftr->vs[0])*sin(ftr->fiv))*scale)-dy;
    pjvx=f2i((ftr->mx+/*(float)*/(ftr->vs[1])*cos(ftr->fiv))*scale)+dx;
     pjvy=maxty-f2i((ftr->my+/*(float)*/(ftr->vs[1])*sin(ftr->fiv))*scale)-dy;
    kbvx=f2i((ftr->mx-1.25*ftr->vs[0]*cos(ftr->fiv))*scale)+dx;
     kbvy=maxty-f2i((ftr->my-1.25*ftr->vs[0]*sin(ftr->fiv))*scale)-dy;
    kjvx=f2i((ftr->mx+1.25*ftr->vs[1]*cos(ftr->fiv))*scale)+dx;
     kjvy=maxty-f2i((ftr->my+1.25*ftr->vs[1]*sin(ftr->fiv))*scale)-dy;
    wbvx=f2i((ftr->mx-vbw*ftr->vs[0]*cos(ftr->fiv))*scale)+dx;
     wbvy=maxty-f2i((ftr->my-vbw*ftr->vs[0]*sin(ftr->fiv))*scale)-dy;
    wjvx=f2i((ftr->mx+vjw*ftr->vs[1]*cos(ftr->fiv))*scale)+dx;
     wjvy=maxty-f2i((ftr->my+vjw*ftr->vs[1]*sin(ftr->fiv))*scale)-dy;
   }
 else
   {pbvx=f2i((ftr->vx-/*(float)*/(ftr->vs[0])*cos(ftr->fiv))*scale)+dx;
     pbvy=maxty-f2i((ftr->vy-/*(float)*/(ftr->vs[0])*sin(ftr->fiv))*scale)-dy;
    pjvx=f2i((ftr->vx+/*(float)*/(ftr->vs[1])*cos(ftr->fiv))*scale)+dx;
     pjvy=maxty-f2i((ftr->vy+/*(float)*/(ftr->vs[1])*sin(ftr->fiv))*scale)-dy;
    kbvx=f2i((ftr->vx-1.25*ftr->vs[0]*cos(ftr->fiv))*scale)+dx;
     kbvy=maxty-f2i((ftr->vy-1.25*ftr->vs[0]*sin(ftr->fiv))*scale)-dy;
    kjvx=f2i((ftr->vx+1.25*ftr->vs[1]*cos(ftr->fiv))*scale)+dx;
     kjvy=maxty-f2i((ftr->vy+1.25*ftr->vs[1]*sin(ftr->fiv))*scale)-dy;
    wbvx=f2i((ftr->vx-vbw*ftr->vs[0]*cos(ftr->fiv))*scale)+dx;
     wbvy=maxty-f2i((ftr->vy-vbw*ftr->vs[0]*sin(ftr->fiv))*scale)-dy;
    wjvx=f2i((ftr->vx+vjw*ftr->vs[1]*cos(ftr->fiv))*scale)+dx;
     wjvy=maxty-f2i((ftr->vy+vjw*ftr->vs[1]*sin(ftr->fiv))*scale)-dy;
   }
 if(ftr->sign)
   {/*curve*/
    if(drawsegs)
      {setcolor(8);
       dfi=(ftr->fiv-ftr->fik)/((float)ftr->tlu);
       for(i=1;i<ftr->tlu;i++)
	  {if(ftr->middle)
	     {if(ftr->sign*(ftr->fik+dfi*(float)i)<ftr->sign*ftr->fim)
		{s[0]=ftr->ks[0]+((ftr->vs[0]-ftr->ks[0])*dfi*(float)i)/(ftr->fim-ftr->fik);
		 s[1]=ftr->ks[1]+((ftr->vs[1]-ftr->ks[1])*dfi*(float)i)/(ftr->fim-ftr->fik);
		}
	      else{s[0]=ftr->vs[0]; s[1]=ftr->vs[1];}
	     }
	   else
	     {s[0]=ftr->ks[0]+((ftr->vs[0]-ftr->ks[0])*dfi*(float)i)/(ftr->fiv-ftr->fik);
	      s[1]=ftr->ks[1]+((ftr->vs[1]-ftr->ks[1])*dfi*(float)i)/(ftr->fiv-ftr->fik);
	     }
	   x=ftr->ox+ftr->sign*ftr->r*cos(ftr->fik+dfi*((float)i));
	   pbkx=f2i((x-s[0]*cos(ftr->fik+dfi*(float)i))*scale)+dx;
	   pjkx=f2i((x+s[1]*cos(ftr->fik+dfi*(float)i))*scale)+dx;
	   y=ftr->oy+ftr->sign*ftr->r*sin(ftr->fik+dfi*((float)i));
	   pbky=maxty-f2i((y-s[0]*sin(ftr->fik+dfi*(float)i))*scale)-dy;
	   pjky=maxty-f2i((y+s[1]*sin(ftr->fik+dfi*(float)i))*scale)-dy;
	   line2(pbkx,pbky,pjkx,pjky);
	  }
       setcolor(prevcolor);
      }
    pbkx=f2i((ftr->kx-(float)(ftr->ks[0])*cos(ftr->fik))*scale)+dx;
     pbky=maxty-f2i((ftr->ky-(float)(ftr->ks[0])*sin(ftr->fik))*scale)-dy;
    pjkx=f2i((ftr->kx+(float)(ftr->ks[1])*cos(ftr->fik))*scale)+dx;
     pjky=maxty-f2i((ftr->ky+(float)(ftr->ks[1])*sin(ftr->fik))*scale)-dy;
    kbkx=f2i((ftr->kx-1.25*(ftr->ks[0])*cos(ftr->fik))*scale)+dx;
     kbky=maxty-f2i((ftr->ky-1.25*(ftr->ks[0])*sin(ftr->fik))*scale)-dy;
    kjkx=f2i((ftr->kx+1.25*(ftr->ks[1])*cos(ftr->fik))*scale)+dx;
     kjky=maxty-f2i((ftr->ky+1.25*(ftr->ks[1])*sin(ftr->fik))*scale)-dy;
    wbkx=f2i((ftr->kx-kbw*(ftr->ks[0])*cos(ftr->fik))*scale)+dx;
     wbky=maxty-f2i((ftr->ky-kbw*(ftr->ks[0])*sin(ftr->fik))*scale)-dy;
    wjkx=f2i((ftr->kx+kjw*(ftr->ks[1])*cos(ftr->fik))*scale)+dx;
     wjky=maxty-f2i((ftr->ky+kjw*(ftr->ks[1])*sin(ftr->fik))*scale)-dy;
    pox=f2i(ftr->ox*scale)+dx;
     poy=maxty-f2i(ftr->oy*scale)-dy;
    if( ( (pbkx>=0)&&(pbkx<=maxtx)&&(pbky>=0)&&(pbky<=maxty) )
      ||( (pbvx>=0)&&(pbvx<=maxtx)&&(pbvy>=0)&&(pbvy<=maxty) )
      ||( (pbkx<0)&&(pbvx>0) )||( (pbvx<0)&&(pbkx>0) )
      ||( (pbkx<maxtx)&&(pbvx>maxtx) )||( (pbvx<maxtx)&&(pbkx>maxtx) )
      ||( (pbky<0)&&(pbvy>0) )||( (pbvy<0)&&(pbky>0) )
      ||( (pbky<maxty)&&(pbvy>maxty) )||( (pbvy<maxty)&&(pbky>maxty) )
      )
      {str=(scale*(ftr->r-(ftr->sign)*(ftr->ks[0])));
       endr=(scale*(ftr->r-(ftr->sign)*(ftr->vs[0])));
       ksr=(scale*(ftr->r-1.25*(ftr->sign)*(ftr->ks[0])));
	if(ksr<0.001){ksr=0.001;}
       kvr=(scale*(ftr->r-1.25*(ftr->sign)*(ftr->vs[0])));
	if(kvr<0.001){kvr=0.001;}
       wkr=(scale*(ftr->r-kbw*(ftr->sign)*(ftr->ks[0])));
	if(wkr<0.001){wkr=0.001;}
       wvr=(scale*(ftr->r-vbw*(ftr->sign)*(ftr->vs[0])));
	if(wvr<0.001){wvr=0.001;}
       if(ftr->middle){dfi=ftr->fim;}
	else{dfi=ftr->fiv;}
       if(ftr->sign==1)
	 {arc2(pox,poy,ftr->fik,dfi,str,endr);
	  if(lkerb)
	    {if(ftr->flags&4){setcolor(2);}
	      else{setcolor(14);}
	     arc2(pox,poy,ftr->fik,dfi,ksr,kvr);
	     line2(kbkx,kbky,pbkx,pbky);
	     if(ftr->middle==0){line2(kbvx,kbvy,pbvx,pbvy);}
	     setcolor(prevcolor);
	    }
	  if(lwall)
	    {setcolor(3);
	     if(lbridge){setcolor(11); line2(wbkx,wbky,wbvx,wbvy);}
	      else{arc2(pox,poy,ftr->fik,dfi,wkr,wvr);}
	     setcolor(prevcolor);
	    }
	 }
       if(ftr->sign==-1)
	 {arc2(pox,poy,dfi+M_PI,ftr->fik+M_PI,endr,str);
	  if(lkerb)
	    {if(ftr->flags&4){setcolor(2);}
	      else{setcolor(14);}
	     arc2(pox,poy,dfi+M_PI,ftr->fik+M_PI,kvr,ksr);
	     line2(kbkx,kbky,pbkx,pbky);
	     if(ftr->middle==0){line2(kbvx,kbvy,pbvx,pbvy);}
	     setcolor(prevcolor);
	    }
	  if(lwall)
	    {setcolor(3);
	     if(lbridge){setcolor(11); line2(wbkx,wbky,wbvx,wbvy);}
	      else{arc2(pox,poy,dfi+M_PI,ftr->fik+M_PI,wvr,wkr);}
	     setcolor(prevcolor);
	    }
	 }
       line2(pbkx,pbky,pjkx,pjky);
       if(ftr->middle==0){line2(pbvx,pbvy,pjvx,pjvy);}
      }
    if( ( (pjkx>=0)&&(pjkx<=maxtx)&&(pjky>=0)&&(pjky<=maxty) )
      ||( (pjvx>=0)&&(pjvx<=maxtx)&&(pjvy>=0)&&(pjvy<=maxty) )
      ||( (pjkx<0)&&(pjvx>0) )||( (pjvx<0)&&(pjkx>0) )
      ||( (pjkx<maxtx)&&(pjvx>maxtx) )||( (pjvx<maxtx)&&(pjkx>maxtx) )
      ||( (pjky<0)&&(pjvy>0) )||( (pjvy<0)&&(pjky>0) )
      ||( (pjky<maxty)&&(pjvy>maxty) )||( (pjvy<maxty)&&(pjky>maxty) )
      )
      {str=(scale*(ftr->r+(ftr->sign)*(ftr->ks[1])));
       endr=(scale*(ftr->r+(ftr->sign)*(ftr->vs[1])));
       ksr=(scale*(ftr->r+1.25*(ftr->sign)*(ftr->ks[1])));
	if(ksr<0.001){ksr=0.001;}
       kvr=(scale*(ftr->r+1.25*(ftr->sign)*(ftr->vs[1])));
	if(kvr<0.001){kvr=0.001;}
       wkr=(scale*(ftr->r+kjw*(ftr->sign)*(ftr->ks[1])));
	if(wkr<0.001){wkr=0.001;}
       wvr=(scale*(ftr->r+vjw*(ftr->sign)*(ftr->vs[1])));
	if(wvr<0.001){wvr=0.001;}
       if(ftr->middle){dfi=ftr->fim;}
	else{dfi=ftr->fiv;}
       if(ftr->sign==1)
	 {arc2(pox,poy,ftr->fik,dfi,str,endr);
	  if(rkerb)
	    {if(ftr->flags&4){setcolor(2);}
	      else{setcolor(14);}
	     arc2(pox,poy,ftr->fik,dfi,ksr,kvr);
	     line2(kjkx,kjky,pjkx,pjky);
	     if(ftr->middle==0){line2(kjvx,kjvy,pjvx,pjvy);}
	     setcolor(prevcolor);
	    }
	  if(rwall)
	    {setcolor(3);
	     if(rbridge){setcolor(11); line2(wjkx,wjky,wjvx,wjvy);}
	      else{arc2(pox,poy,ftr->fik,dfi,wkr,wvr);}
	     setcolor(prevcolor);
	    }
	 }
       if(ftr->sign==-1)
	 {arc2(pox,poy,dfi+M_PI,ftr->fik+M_PI,endr,str);
	  if(rkerb)
	    {if(ftr->flags&4){setcolor(2);}
	      else{setcolor(14);}
	     arc2(pox,poy,dfi+M_PI,ftr->fik+M_PI,kvr,ksr);
	     line2(kjkx,kjky,pjkx,pjky);
	     if(ftr->middle==0){line2(kjvx,kjvy,pjvx,pjvy);}
	     setcolor(prevcolor);
	    }
	  if(rwall)
	    {setcolor(3);
	     if(rbridge){setcolor(11); line2(wjkx,wjky,wjvx,wjvy);}
	      else{arc2(pox,poy,dfi+M_PI,ftr->fik+M_PI,wvr,wkr);}
	     setcolor(prevcolor);
	    }
	 }
       line2(pbkx,pbky,pjkx,pjky);
       if(ftr->middle==0){line2(pbvx,pbvy,pjvx,pjvy);}
      }
    if(ftr->middle)
      {pbkx=pbvx; pbky=pbvy; pjkx=pjvx; pjky=pjvy;
       pbvx=f2i((ftr->vx-/*(float)*/(ftr->vs[0])*cos(ftr->fiv))*scale)+dx;
	pbvy=maxty-f2i((ftr->vy-/*(float)*/(ftr->vs[0])*sin(ftr->fiv))*scale)-dy;
       pjvx=f2i((ftr->vx+/*(float)*/(ftr->vs[1])*cos(ftr->fiv))*scale)+dx;
	pjvy=maxty-f2i((ftr->vy+/*(float)*/(ftr->vs[1])*sin(ftr->fiv))*scale)-dy;
       kbkx=kbvx; kbky=kbvy; kjkx=kjvx; kjky=kjvy;
       kbvx=f2i((ftr->vx-1.25*ftr->vs[0]*cos(ftr->fiv))*scale)+dx;
	kbvy=maxty-f2i((ftr->vy-1.25*ftr->vs[0]*sin(ftr->fiv))*scale)-dy;
       kjvx=f2i((ftr->vx+1.25*ftr->vs[1]*cos(ftr->fiv))*scale)+dx;
	kjvy=maxty-f2i((ftr->vy+1.25*ftr->vs[1]*sin(ftr->fiv))*scale)-dy;
       wbkx=wbvx; wbky=wbvy; wjkx=wjvx; wjky=wjvy;
       wbvx=f2i((ftr->vx-vbw*ftr->vs[0]*cos(ftr->fiv))*scale)+dx;
	wbvy=maxty-f2i((ftr->vy-vbw*ftr->vs[0]*sin(ftr->fiv))*scale)-dy;
       wjvx=f2i((ftr->vx+vjw*ftr->vs[1]*cos(ftr->fiv))*scale)+dx;
	wjvy=maxty-f2i((ftr->vy+vjw*ftr->vs[1]*sin(ftr->fiv))*scale)-dy;
       if( ( (pbkx>=0)&&(pbkx<=maxtx)&&(pbky>=0)&&(pbky<=maxty) )
	  ||( (pbvx>=0)&&(pbvx<=maxtx)&&(pbvy>=0)&&(pbvy<=maxty) )
	  ||( (pbkx<0)&&(pbvx>0) )||( (pbvx<0)&&(pbkx>0) )
	  ||( (pbkx<maxtx)&&(pbvx>maxtx) )||( (pbvx<maxtx)&&(pbkx>maxtx) )
	  ||( (pbky<0)&&(pbvy>0) )||( (pbvy<0)&&(pbky>0) )
	  ||( (pbky<maxty)&&(pbvy>maxty) )||( (pbvy<maxty)&&(pbky>maxty) )
	  )
	  {endr=(scale*(ftr->r-(ftr->sign)*(ftr->vs[0])));
	   kvr=(scale*(ftr->r-1.25*(ftr->sign)*(ftr->vs[0])));
	    if(kvr<0.001){kvr=0.001;}
	   wvr=(scale*(ftr->r-vbw*(ftr->sign)*(ftr->vs[0])));
	    if(wvr<0.001){wvr=0.001;}
	   if(ftr->sign==1)
	     {arc2(pox,poy,dfi,ftr->fiv,endr,endr);
	      if(lkerb)
		{if(ftr->flags&4){setcolor(2);}
		  else{setcolor(14);}
		 arc2(pox,poy,dfi,ftr->fiv,kvr,kvr);
		 line2(kbvx,kbvy,pbvx,pbvy);
		 setcolor(prevcolor);
		}
	      if(lwall)
		{setcolor(3);
		 if(lbridge){setcolor(11); line2(wbkx,wbky,wbvx,wbvy);}
		  else{arc2(pox,poy,dfi,ftr->fiv,wvr,wvr);}
		 setcolor(prevcolor);
		}
	     }
	   if(ftr->sign==-1)
	     {arc2(pox,poy,ftr->fiv+M_PI,dfi+M_PI,endr,endr);
	      if(lkerb)
		{if(ftr->flags&4){setcolor(2);}
		  else{setcolor(14);}
		 arc2(pox,poy,ftr->fiv+M_PI,dfi+M_PI,kvr,kvr);
		 line2(kbvx,kbvy,pbvx,pbvy);
		 setcolor(prevcolor);
		}
	      if(lwall)
		{setcolor(3);
		 if(lbridge){setcolor(11); line2(wbkx,wbky,wbvx,wbvy);}
		  else{arc2(pox,poy,ftr->fiv+M_PI,dfi+M_PI,wvr,wvr);}
		 setcolor(prevcolor);
		}
	     }
	   line2(pbvx,pbvy,pjvx,pjvy);
	  }
	if( ( (pjkx>=0)&&(pjkx<=maxtx)&&(pjky>=0)&&(pjky<=maxty) )
	  ||( (pjvx>=0)&&(pjvx<=maxtx)&&(pjvy>=0)&&(pjvy<=maxty) )
	  ||( (pjkx<0)&&(pjvx>0) )||( (pjvx<0)&&(pjkx>0) )
	  ||( (pjkx<maxtx)&&(pjvx>maxtx) )||( (pjvx<maxtx)&&(pjkx>maxtx) )
	  ||( (pjky<0)&&(pjvy>0) )||( (pjvy<0)&&(pjky>0) )
	  ||( (pjky<maxty)&&(pjvy>maxty) )||( (pjvy<maxty)&&(pjky>maxty) )
	  )
	  {endr=(scale*(ftr->r+(ftr->sign)*(ftr->vs[1])));
	   kvr=(scale*(ftr->r+1.25*(ftr->sign)*(ftr->vs[1])));
	    if(kvr<0.001){kvr=0.001;}
	   wvr=(scale*(ftr->r+vjw*(ftr->sign)*(ftr->vs[1])));
	    if(wvr<0.001){wvr=0.001;}
	   if(ftr->sign==1)
	     {arc2(pox,poy,dfi,ftr->fiv,endr,endr);
	      if(rkerb)
		{if(ftr->flags&4){setcolor(2);}
		  else{setcolor(14);}
		 arc2(pox,poy,dfi,ftr->fiv,kvr,kvr);
		 line2(kbvx,kbvy,pbvx,pbvy);
		 setcolor(prevcolor);
		}
	      if(rwall)
		{setcolor(3);
		 if(rbridge){setcolor(11); line2(wjkx,wjky,wjvx,wjvy);}
		  else{arc2(pox,poy,dfi,ftr->fiv,wvr,wvr);}
		 setcolor(prevcolor);
		}
	     }
	   if(ftr->sign==-1)
	     {arc2(pox,poy,ftr->fiv+M_PI,dfi+M_PI,endr,endr);
	      if(rkerb)
		{if(ftr->flags&4){setcolor(2);}
		  else{setcolor(14);}
		 arc2(pox,poy,ftr->fiv+M_PI,dfi+M_PI,kvr,kvr);
		 line2(kbvx,kbvy,pbvx,pbvy);
		 setcolor(prevcolor);
		}
	      if(rwall)
		{setcolor(3);
		 if(rbridge){setcolor(11); line2(wjkx,wjky,wjvx,wjvy);}
		  else{arc2(pox,poy,ftr->fiv+M_PI,dfi+M_PI,wvr,wvr);}
		 setcolor(prevcolor);
		}
	     }
	   line2(pbvx,pbvy,pjvx,pjvy);
	  }
      }
   }
 else
   {/*straight*/
    if(drawsegs)
      {setcolor(8);
       deltax=(ftr->vx-ftr->kx)/((float)ftr->tlu);
       deltay=(ftr->vy-ftr->ky)/((float)ftr->tlu);
       for(i=1;i<ftr->tlu;i++)
	  {if(ftr->middle)
	     {if( (4.8768*(double)i)<ftr->fim )
		{s[0]=ftr->ks[0]+((ftr->vs[0]-ftr->ks[0])*4.8768*(float)i)/(ftr->fim);
		 s[1]=ftr->ks[1]+((ftr->vs[1]-ftr->ks[1])*4.8768*(float)i)/(ftr->fim);
		}
	      else{s[0]=ftr->vs[0]; s[1]=ftr->vs[1];}
	     }
	   else
	     {s[0]=ftr->ks[0]+((ftr->vs[0]-ftr->ks[0])*4.8768*(float)i)/(ftr->length);
	      s[1]=ftr->ks[1]+((ftr->vs[1]-ftr->ks[1])*4.8768*(float)i)/(ftr->length);
	     }
	   x=ftr->kx+deltax*(float)i;
	   pbkx=f2i((x-s[0]*cos(ftr->fik))*scale)+dx;
	   pjkx=f2i((x+s[1]*cos(ftr->fik))*scale)+dx;
	   y=ftr->ky+deltay*((float)i);
	   pbky=maxty-f2i((y-s[0]*sin(ftr->fik))*scale)-dy;
	   pjky=maxty-f2i((y+s[1]*sin(ftr->fik))*scale)-dy;
	   line2(pbkx,pbky,pjkx,pjky);
	  }
       setcolor(prevcolor);
      }
    pbkx=f2i((ftr->kx-(float)(ftr->ks[0])*cos(ftr->fik))*scale)+dx;
     pbky=maxty-f2i((ftr->ky-(float)(ftr->ks[0])*sin(ftr->fik))*scale)-dy;
    pjkx=f2i((ftr->kx+(float)(ftr->ks[1])*cos(ftr->fik))*scale)+dx;
     pjky=maxty-f2i((ftr->ky+(float)(ftr->ks[1])*sin(ftr->fik))*scale)-dy;
    kbkx=f2i((ftr->kx-1.25*(ftr->ks[0])*cos(ftr->fik))*scale)+dx;
     kbky=maxty-f2i((ftr->ky-1.25*(ftr->ks[0])*sin(ftr->fik))*scale)-dy;
    kjkx=f2i((ftr->kx+1.25*(ftr->ks[1])*cos(ftr->fik))*scale)+dx;
     kjky=maxty-f2i((ftr->ky+1.25*(ftr->ks[1])*sin(ftr->fik))*scale)-dy;
    wbkx=f2i((ftr->kx-kbw*(ftr->ks[0])*cos(ftr->fik))*scale)+dx;
     wbky=maxty-f2i((ftr->ky-kbw*(ftr->ks[0])*sin(ftr->fik))*scale)-dy;
    wjkx=f2i((ftr->kx+kjw*(ftr->ks[1])*cos(ftr->fik))*scale)+dx;
     wjky=maxty-f2i((ftr->ky+kjw*(ftr->ks[1])*sin(ftr->fik))*scale)-dy;
    if( ( (pbkx>=0)&&(pbkx<=maxtx)&&(pbky>=0)&&(pbky<=maxty) )
      ||( (pbvx>=0)&&(pbvx<=maxtx)&&(pbvy>=0)&&(pbvy<=maxty) )
      ||( (pbkx<0)&&(pbvx>0) )||( (pbvx<0)&&(pbkx>0) )
      ||( (pbkx<maxtx)&&(pbvx>maxtx) )||( (pbvx<maxtx)&&(pbkx>maxtx) )
      ||( (pbky<0)&&(pbvy>0) )||( (pbvy<0)&&(pbky>0) )
      ||( (pbky<maxty)&&(pbvy>maxty) )||( (pbvy<maxty)&&(pbky>maxty) )
      )
      {line2(pbkx,pbky,pbvx,pbvy);
       line2(pbkx,pbky,pjkx,pjky);
       if(!ftr->middle){line2(pbvx,pbvy,pjvx,pjvy);}
       if(lkerb)
	 {if(ftr->flags&4){setcolor(2);}
	   else{setcolor(14);}
	  line2(kbkx,kbky,kbvx,kbvy);
	  line2(kbkx,kbky,pbkx,pbky);
	  if(!ftr->middle){line2(kbvx,kbvy,pbvx,pbvy);}
	  setcolor(prevcolor);
	 }
       if(lwall)
	 {setcolor(3);
	  if(lbridge){setcolor(11);}
	  line2(wbkx,wbky,wbvx,wbvy);
	  setcolor(prevcolor);
	 }
      }
    if( ( (pjkx>=0)&&(pjkx<=maxtx)&&(pjky>=0)&&(pjky<=maxty) )
      ||( (pjvx>=0)&&(pjvx<=maxtx)&&(pjvy>=0)&&(pjvy<=maxty) )
      ||( (pjkx<0)&&(pjvx>0) )||( (pjvx<0)&&(pjkx>0) )
      ||( (pjkx<maxtx)&&(pjvx>maxtx) )||( (pjvx<maxtx)&&(pjkx>maxtx) )
      ||( (pjky<0)&&(pjvy>0) )||( (pjvy<0)&&(pjky>0) )
      ||( (pjky<maxty)&&(pjvy>maxty) )||( (pjvy<maxty)&&(pjky>maxty) )
      )
      {line2(pjkx,pjky,pjvx,pjvy);
       line2(pbkx,pbky,pjkx,pjky);
       if(!ftr->middle){line2(pbvx,pbvy,pjvx,pjvy);}
       if(rkerb)
	 {if(ftr->flags&4){setcolor(2);}
	   else{setcolor(14);}
	  line2(kjkx,kjky,kjvx,kjvy);
	  line2(pjkx,pjky,kjkx,kjky);
	  if(!ftr->middle){line2(pjvx,pjvy,kjvx,kjvy);}
	  setcolor(prevcolor);
	 }
       if(rwall)
	 {setcolor(3);
	  if(rbridge){setcolor(11);}
	  line2(wjkx,wjky,wjvx,wjvy);
	  setcolor(prevcolor);
	 }
      }
    if(ftr->middle)
      {pbkx=pbvx; pbky=pbvy; pjkx=pjvx; pjky=pjvy;
       pbvx=f2i((ftr->vx-/*(float)*/(ftr->vs[0])*cos(ftr->fiv))*scale)+dx;
	pbvy=maxty-f2i((ftr->vy-/*(float)*/(ftr->vs[0])*sin(ftr->fiv))*scale)-dy;
       pjvx=f2i((ftr->vx+/*(float)*/(ftr->vs[1])*cos(ftr->fiv))*scale)+dx;
	pjvy=maxty-f2i((ftr->vy+/*(float)*/(ftr->vs[1])*sin(ftr->fiv))*scale)-dy;
       kbkx=kbvx; kbky=kbvy; kjkx=kjvx; kjky=kjvy;
       kbvx=f2i((ftr->vx-1.25*(ftr->vs[0])*cos(ftr->fiv))*scale)+dx;
	kbvy=maxty-f2i((ftr->vy-1.25*(ftr->vs[0])*sin(ftr->fiv))*scale)-dy;
       kjvx=f2i((ftr->vx+1.25*(ftr->vs[1])*cos(ftr->fiv))*scale)+dx;
	kjvy=maxty-f2i((ftr->vy+1.25*(ftr->vs[1])*sin(ftr->fiv))*scale)-dy;
       wbkx=wbvx; wbky=wbvy; wjkx=wjvx; wjky=wjvy;
       wbvx=f2i((ftr->vx-vbw*(ftr->vs[0])*cos(ftr->fiv))*scale)+dx;
	wbvy=maxty-f2i((ftr->vy-vbw*(ftr->vs[0])*sin(ftr->fiv))*scale)-dy;
       wjvx=f2i((ftr->vx+vjw*(ftr->vs[1])*cos(ftr->fiv))*scale)+dx;
	wjvy=maxty-f2i((ftr->vy+vjw*(ftr->vs[1])*sin(ftr->fiv))*scale)-dy;
       if( ( (pbkx>=0)&&(pbkx<=maxtx)&&(pbky>=0)&&(pbky<=maxty) )
	 ||( (pbvx>=0)&&(pbvx<=maxtx)&&(pbvy>=0)&&(pbvy<=maxty) )
	 ||( (pbkx<0)&&(pbvx>0) )||( (pbvx<0)&&(pbkx>0) )
	 ||( (pbkx<maxtx)&&(pbvx>maxtx) )||( (pbvx<maxtx)&&(pbkx>maxtx) )
	 ||( (pbky<0)&&(pbvy>0) )||( (pbvy<0)&&(pbky>0) )
	 ||( (pbky<maxty)&&(pbvy>maxty) )||( (pbvy<maxty)&&(pbky>maxty) )
	 )
	 {line2(pbkx,pbky,pbvx,pbvy);
	  line2(pbvx,pbvy,pjvx,pjvy);
	  if(lkerb)
	    {if(ftr->flags&4){setcolor(2);}
	      else{setcolor(14);}
	     line2(kbkx,kbky,kbvx,kbvy);
	     line2(pbvx,pbvy,kbvx,kbvy);
	     setcolor(prevcolor);
	    }
	  if(lwall)
	    {setcolor(3);
	     if(lbridge){setcolor(11);}
	     line2(wbkx,wbky,wbvx,wbvy);
	     setcolor(prevcolor);
	    }
	 }
       if( ( (pjkx>=0)&&(pjkx<=maxtx)&&(pjky>=0)&&(pjky<=maxty) )
	 ||( (pjvx>=0)&&(pjvx<=maxtx)&&(pjvy>=0)&&(pjvy<=maxty) )
	 ||( (pjkx<0)&&(pjvx>0) )||( (pjvx<0)&&(pjkx>0) )
	 ||( (pjkx<maxtx)&&(pjvx>maxtx) )||( (pjvx<maxtx)&&(pjkx>maxtx) )
	 ||( (pjky<0)&&(pjvy>0) )||( (pjvy<0)&&(pjky>0) )
	 ||( (pjky<maxty)&&(pjvy>maxty) )||( (pjvy<maxty)&&(pjky>maxty) )
	 )
	 {line2(pjkx,pjky,pjvx,pjvy);
	  line2(pbvx,pbvy,pjvx,pjvy);
	  if(rkerb)
	    {if(ftr->flags&4){setcolor(2);}
	      else{setcolor(14);}
	     line2(kjkx,kjky,kjvx,kjvy);
	     line2(kjvx,kjvy,pjvx,pjvy);
	     setcolor(prevcolor);
	    }
	  if(rwall)
	    {setcolor(3);
	     if(rbridge){setcolor(11);}
	     line2(wjkx,wjky,wjvx,wjvy);
	     setcolor(prevcolor);
	    }
	 }
      }
   }
}

/**********************/
/*draw CC line segment*/
/**********************/
void drawCClinesegment(struct bestlineseg *fbl)
{int pbkx,pbky,pbvx,pbvy, pjkx,pjky,pjvx,pjvy, pox,poy;
 float str,endr,r;
 float fkx,fky,fvx,fvy;

 if(fbl->sign==4){return;}
 if(fbl->pre){drawCClinesegment(fbl->pre);}
     pbkx=f2i(fbl->kx*scale)+dx;
      pbky=maxty-f2i(fbl->ky*scale)-dy;
      pbvx=f2i(fbl->vx*scale)+dx;
      pbvy=maxty-f2i(fbl->vy*scale)-dy;
      if( ( (pbkx>=0)&&(pbkx<=maxtx)&&(pbky>=0)&&(pbky<=maxty) )
	||( (pbvx>=0)&&(pbvx<=maxtx)&&(pbvy>=0)&&(pbvy<=maxty) )
	||( (pbkx<0)&&(pbvx>0) )||( (pbvx<0)&&(pbkx>0) )
	||( (pbkx<maxtx)&&(pbvx>maxtx) )||( (pbvx<maxtx)&&(pbkx>maxtx) )
	||( (pbky<0)&&(pbvy>0) )||( (pbvy<0)&&(pbky>0) )
	||( (pbky<maxty)&&(pbvy>maxty) )||( (pbvy<maxty)&&(pbky>maxty) )
	)
	{switch(fbl->sign)
	   {case  0:{/*straight*/
		     //setcolor(14);
		     line2(pbkx,pbky,pbvx,pbvy);
		     break;}
	    case  1:{/*left curve*/
		     pox=f2i(fbl->ox*scale)+dx;
		     poy=maxty-f2i(fbl->oy*scale)-dy;
		     r=(scale*fbl->r);
		     arc2(pox,poy,fbl->fik,fbl->fiv,r,r);
		     if(drawpoints)
		       {line2(pbkx,pbky,pox,poy);
			line2(pbvx,pbvy,pox,poy);
		       }
		     break;}
	    case -1:{/*right curve*/
		     pox=f2i(fbl->ox*scale)+dx;
		     poy=maxty-f2i(fbl->oy*scale)-dy;
		     r=(scale*fbl->r);
		     arc2(pox,poy,fbl->fiv+M_PI,fbl->fik+M_PI,r,r);
		     if(drawpoints)
		       {line2(pbkx,pbky,pox,poy);
			line2(pbvx,pbvy,pox,poy);
		       }
		     break;}
	   }
	}
}

/********************************/
/*draw track and best line datas*/
/********************************/
void drawgraph()
{struct trackseg *ftr;
 int pbkx,pbky,pbvx,pbvy, pjkx,pjky,pjvx,pjvy, pox,poy;
 float str,endr,r;
 float fkx,fky,fvx,fvy;
 struct bestlineseg *fbl;

 /*draw track segments*/
 setfillstyle(1,0);
 bar(0,0,maxtx,maxty);
 ftr=ktrack;
 setcolor(7);
 while(ftr)
   {drawtracksegment(ftr);
    ftr=ftr->kov;
   }

 /*draw pit lane segments*/
 setcolor(1);
 ftr=kpit;
 while(ftr)
   {drawtracksegment(ftr);
    ftr=ftr->kov;
   }

 /*draw best line segments*/
 /*ksbb trlend!!!!!!!!!*/
// return;
 /**************/
 setcolor(4);
 fbl=kbl;
 while(fbl)
    {drawCClinesegment(fbl);
     fbl=fbl->kov;
    }
}

/***********************/
/*refresh the track map*/
/***********************/
void refreshmap()
{drawgraph();
 setcolor(15);
 drawtracksegment(atrack);
 setcolor(9);
 drawtracksegment(apit);
 setcolor(12);
 drawCClinesegment(ablseg);
}

/************************************/
/*refresh track and pitlane segments*/
/************************************/
void refreshtrack()
{double f,fif;
 double width, widthlen, newwidth;
 struct command *fcmd;
 struct trackseg *ftr,*pitstart;
 long int pitgrad,pithei;

 pitstart=0;
 width=2*widthscale*((double)trackheader.startWidth);
 widthlen=0;
 ftr=ktrack;
 while(ftr)
   {if(ftr->sign==4)
      {ftr=ftr->kov; continue;}
    fcmd=ftr->cmd;
    while(fcmd)
      {if(fcmd->cmd==0x85)
	 {widthlen=4.8768*((double)fcmd->a1);
	  newwidth=2*widthscale*((double)fcmd->a2);
	 }
       if(fcmd->cmd==0x86)
	 {pitstart=ftr;}
       fcmd=fcmd->kov;
      }
    if(ktrack==ftr)
      {ftr->fik=-anglescale*((double)trackheader.startangle);
       ftr->kx=0; ftr->ky=0;
      }
    else
      {ftr->fik=ftr->elo->fiv;
       ftr->kx=ftr->elo->vx; ftr->ky=ftr->elo->vy;
      }
    ftr->length=4.8768*((double)ftr->tlu);
    f=-anglescale*((double)ftr->tlu)*((double)ftr->curvature);
    ftr->fiv=ftr->fik+f;
    ftr->sign=sgn(f);
    if(ftr->sign)
      {ftr->r=ftr->length/(ftr->sign*f);
       ftr->ox=ftr->kx-ftr->sign*ftr->r*cos(ftr->fik);
       ftr->oy=ftr->ky-ftr->sign*ftr->r*sin(ftr->fik);
       ftr->vx=ftr->ox+ftr->sign*ftr->r*cos(ftr->fiv);
       ftr->vy=ftr->oy+ftr->sign*ftr->r*sin(ftr->fiv);
      }
    else
      {ftr->r=0;
       ftr->ox=0;
       ftr->oy=0;
       ftr->vx=ftr->kx-ftr->length*sin(ftr->fik);
       ftr->vy=ftr->ky+ftr->length*cos(ftr->fik);
      }
    ftr->ks[0]=width*0.5; ftr->ks[1]=ftr->ks[0];
    if(widthlen>0.01)
      {if(widthlen>ftr->length)
	 {width+=ftr->length*(newwidth-width)/widthlen;
	  ftr->middle=0;
	 }
       else
	 {if(fabs(widthlen-ftr->length)<0.0001)
	    {width=newwidth; ftr->middle=0;}
	   else{ftr->middle=1;
		if(ftr->sign)
		  {f=ftr->fik-anglescale*(widthlen/4.8768)*((double)ftr->curvature);
		   ftr->fim=f;
		   ftr->mx=ftr->ox+ftr->sign*ftr->r*cos(f);
		   ftr->my=ftr->oy+ftr->sign*ftr->r*sin(f);
		  }
		else
		  {f=widthlen;
		   ftr->fim=f;
		   ftr->mx=ftr->kx-f*sin(ftr->fik);
		   ftr->my=ftr->ky+f*cos(ftr->fik);
		  }
		width=newwidth;
	       }
	 }
       widthlen-=ftr->length;
      }
    ftr->vs[0]=width*0.5; ftr->vs[1]=ftr->vs[0];

    if(ftr->elo)
      {ftr->cumlength=ftr->elo->cumlength+ftr->length;
       ftr->cumgrad=ftr->elo->cumgrad+((long int)ftr->tlu)*((long int)ftr->height);
       ftr->cumheight=ftr->elo->cumheight+ftr->tlu*(ftr->elo->cumgrad+ftr->cumgrad)/2;
      }
    else
      {ftr->cumlength=ftr->length;
       ftr->cumgrad=(long int)trackheader.startheight;
       ftr->cumgrad+=((long int)ftr->tlu)*((long int)ftr->height);
       ftr->cumheight=ftr->tlu*(((long int)trackheader.startheight)+ftr->cumgrad)/2;
      }

    if(ftr==pitstart)
      {if(trackheader.pitside)
	 {/*pits on the left*/
	  kpit->kx=ftr->kx-cos(ftr->fik)*(ftr->ks[0]-pitwidth*0.5);
	  kpit->ky=ftr->ky-sin(ftr->fik)*(ftr->ks[0]-pitwidth*0.5);
	 }
       else
	 {/*pits on the right*/
	  kpit->kx=ftr->kx+cos(ftr->fik)*(ftr->ks[0]-pitwidth*0.5);
	  kpit->ky=ftr->ky+sin(ftr->fik)*(ftr->ks[0]-pitwidth*0.5);
	 }
       kpit->fik=ftr->fik;
       pitgrad=ftr->elo->cumgrad;
       pithei=ftr->elo->cumheight;
      }

    ftr=ftr->kov;
   }

 ftr=kpit;
 width=pitwidth;
 while(ftr)
   {if(ftr->elo)
      {ftr->kx=ftr->elo->vx; ftr->ky=ftr->elo->vy;
       ftr->fik=ftr->elo->fiv;
      }
    ftr->length=4.8768*((double)ftr->tlu);
    f=-anglescale*((double)ftr->tlu)*((double)ftr->curvature);
    ftr->fiv=ftr->fik+f;
    ftr->sign=sgn(f);
    if(ftr->sign)
      {ftr->r=ftr->length/(ftr->sign*f);
       ftr->ox=ftr->kx-ftr->sign*ftr->r*cos(ftr->fik);
       ftr->oy=ftr->ky-ftr->sign*ftr->r*sin(ftr->fik);
       ftr->vx=ftr->ox+ftr->sign*ftr->r*cos(ftr->fiv);
       ftr->vy=ftr->oy+ftr->sign*ftr->r*sin(ftr->fiv);
      }
    else
      {ftr->r=0.0;
       ftr->ox=0;
       ftr->oy=0;
       ftr->vx=ftr->kx-ftr->length*sin(ftr->fik);
       ftr->vy=ftr->ky+ftr->length*cos(ftr->fik);
      }
    if(ftr->elo)
      {ftr->cumlength=ftr->elo->cumlength+ftr->length;
       ftr->cumgrad=ftr->elo->cumgrad+((long int)ftr->tlu)*((long int)ftr->height);
       ftr->cumheight=ftr->elo->cumheight+ftr->tlu*(ftr->elo->cumgrad+ftr->cumgrad)/2;
      }
    else
      {ftr->cumlength=ftr->length;
       ftr->cumgrad=pitgrad+((long int)ftr->tlu)*((long int)ftr->height);
       ftr->cumheight=pithei+ftr->tlu*(pitgrad+ftr->cumgrad)/2;
      }
    ftr->ks[0]=pitwidth*0.5; ftr->ks[1]=pitwidth*0.5;
    ftr->vs[0]=pitwidth*0.5; ftr->vs[1]=pitwidth*0.5;
    ftr=ftr->kov;
   }

 return;
}

/**************************/
/*refresh CC line segments*/
/**************************/
void refreshCCline()
{struct bestlineseg *fbl;
 short int offset, i;
 short int cumtlu,tcumtlu;
 struct trackseg *actual;
 double a,b,c, f, cosfv,sinfv, cosa[2],sina[2],alfa[2], tanfv,ctgfv, s[2];
 double tvx,tvy, f2,df;

 if(ktrack->sign==4){return;}
 fbl=kbl;
 cumtlu=0;
 actual=ktrack;
 tcumtlu=actual->tlu;
 while(fbl)
   {if(fbl->elo==NULL)
      {fbl->fik=ktrack->fik;
       f=widthscale*((double)fbl->a1);
       fbl->kx=ktrack->kx+f*cos(ktrack->fik);
       fbl->ky=ktrack->ky+f*sin(ktrack->fik);
       offset=fbl->a2;
      }
    else
      {fbl->fik=fbl->elo->fiv;
       fbl->kx=fbl->elo->vx; fbl->ky=fbl->elo->vy;
       offset=fbl->a1;
      }

    switch(fbl->type)
      {case 0x80:{if(fbl->a3==0)
		    {fbl->r=0.0;
		     fbl->sign=0;
		    }
		  else
		    {fbl->sign=-sgn(fbl->a3);
		     fbl->r=((double)abs(fbl->a3))*(double)radscale;
		    }
		  break;}
       case 0x00:{if(fbl->a2==0)
		    {fbl->r=0.0;
		     fbl->sign=0;
		    }
		  else
		    {fbl->sign=-sgn(fbl->a2);
		     fbl->r=((double)abs(fbl->a2))*(double)radscale;
		    }
		  break;}
       case 0x40:{fbl->bigrad=fbl->a2;
		  fbl->bigrad=fbl->bigrad<<16;
		  fbl->bigrad+=(unsigned)fbl->a3;
		  if(fbl->bigrad==0)
		    {fbl->r=0.0;
		     fbl->sign=0;
		    }
		  else
		    {fbl->sign=-sgn(fbl->bigrad);
		     fbl->r=((double)labs(fbl->bigrad))*(double)radscale;
		    }
		  break;}
      }/* end of switch(fbl->type) */

    /*searching the track segment, where the CC line segment ends*/
    cumtlu+=fbl->tlu;
    while(tcumtlu<cumtlu)
      {if(actual->kov)
	 {if(actual->kov->sign==4){break;}
	   else{actual=actual->kov; tcumtlu+=actual->tlu;}
	 }
       else{break;}
      }
    if(actual->sign)
      {f=actual->fiv-(actual->fik-actual->fiv)*((double)(cumtlu-tcumtlu))/((double)actual->tlu);
       cosfv=cos(f); sinfv=sin(f);
       tvx=actual->ox+actual->sign*actual->r*cosfv;
       tvy=actual->oy+actual->sign*actual->r*sinfv;
      }
    else
      {/*tvx=actual->vx-(actual->kx-actual->vx)*((double)(cumtlu-tcumtlu))/((double)actual->tlu);
       tvy=actual->vy-(actual->ky-actual->vy)*((double)(cumtlu-tcumtlu))/((double)actual->tlu);*/
       cosfv=cos(actual->fiv); sinfv=sin(actual->fiv);
       tvx=actual->kx-sinfv*4.8768*((double)(cumtlu-tcumtlu+actual->tlu));
       tvy=actual->ky+cosfv*4.8768*((double)(cumtlu-tcumtlu+actual->tlu));
      }
    /*calculating the length, fiv, vx, vy and s values*/
    if(fbl->sign)
      {/* curved segment*/
       if(offset>0)
	 {if(fbl->pre==0){fbl->pre=newbestlineseg();}
	  fbl->pre->type=1;
	  fbl->pre->sign=0; fbl->pre->r=0.0;
	  fbl->pre->ox=0.0; fbl->pre->oy=0.0;
	  fbl->pre->kx=fbl->kx; fbl->pre->ky=fbl->ky;
	  fbl->pre->fik=fbl->fik; fbl->pre->fiv=fbl->fik;
	  fbl->pre->pre=0; fbl->pre->elo=0; fbl->pre->kov=0;
	  fbl->pre->length=((double)offset)*4.8768/256.0;
	  fbl->pre->s=0.0;
	  fbl->pre->vx=fbl->pre->kx-fbl->pre->length*sin(fbl->pre->fik);
	  fbl->pre->vy=fbl->pre->ky+fbl->pre->length*cos(fbl->pre->fik);
	  fbl->kx=fbl->pre->vx;
	  fbl->ky=fbl->pre->vy;
	 }
       else{ if(fbl->pre){free(fbl->pre); fbl->pre=0;} }
       fbl->ox=fbl->kx-fbl->sign*fbl->r*cos(fbl->fik);
       fbl->oy=fbl->ky-fbl->sign*fbl->r*sin(fbl->fik);

       if( fabs(cosfv)<fabs(sinfv) )
	 {ctgfv=cosfv/sinfv;
	  a=1/sqrt(1+ctgfv*ctgfv);
	  c=a*(tvx-fbl->ox+ctgfv*(fbl->oy-tvy))/(fbl->r*fbl->sign);
	  f=arctan2(-a,ctgfv*a);
	  if(fabs(c)>1)
	    {fbl->s=100.0;
	     fbl->fiv=fbl->fik;
	     fbl->length=1.0;
	     fbl->vx=fbl->kx-sin(fbl->fik);
	     fbl->vy=fbl->ky+cos(fbl->fik);
	     fbl->sign=4;
	     fbl=fbl->kov;
	     while(fbl){fbl->sign=4; fbl=fbl->kov;}
	     break;
	    }
	   else{f2=asin(c);}
	  alfa[0]=-f2-f;
	  s[0]=(fbl->oy-tvy+fbl->r*fbl->sign*sin(alfa[0]))/sinfv;
	  alfa[1]=M_PI+f2-f;
	  s[1]=(fbl->oy-tvy+fbl->r*fbl->sign*sin(alfa[1]))/sinfv;
	 }
       else
	 {tanfv=sinfv/cosfv;
	  a=1/sqrt(1+tanfv*tanfv);
	  c=a*(tvy-fbl->oy+tanfv*(fbl->ox-tvx))/(fbl->r*fbl->sign);
	  f=arctan2(tanfv*a,-a);
	  if(fabs(c)>1)
	    {fbl->s=100.0;
	     fbl->fiv=fbl->fik;
	     fbl->length=1.0;
	     fbl->vx=fbl->kx-sin(fbl->fik);
	     fbl->vy=fbl->ky+cos(fbl->fik);
	     fbl->sign=4;
	     fbl=fbl->kov;
	     while(fbl){fbl->sign=4; fbl=fbl->kov;}
	     break;
	    }
	  f2=asin(c);
	  alfa[0]=-f2-f;
	  s[0]=(fbl->ox-tvx+fbl->r*fbl->sign*cos(alfa[0]))/cosfv;
	  alfa[1]=M_PI+f2-f;
	  s[1]=(fbl->ox-tvx+fbl->r*fbl->sign*cos(alfa[1]))/cosfv;
	 }
       for(i=0;i<2;i++)
	  {while( (alfa[i]-fbl->fik)>2*M_PI ){alfa[i]-=2*M_PI;}
	   while( (alfa[i]-fbl->fik)<=-2*M_PI ){alfa[i]+=2*M_PI;}
	   while( fbl->sign*alfa[i] <= fbl->sign*fbl->fik )
	      {alfa[i]+=fbl->sign*2*M_PI;}
	  }
       if( ((fbl->ky-tvy)*cosfv-(fbl->kx-tvx)*sinfv) > 0.0 )
	 {if( fbl->sign*alfa[0] < fbl->sign*alfa[1] )
	    {fbl->fiv=alfa[1]; fbl->s=s[1];}
	  else{fbl->fiv=alfa[0]; fbl->s=s[0];}
	 }
       else
	 {if( fbl->sign*alfa[0] < fbl->sign*alfa[1] )
	    {fbl->fiv=alfa[0]; fbl->s=s[0];}
	  else{fbl->fiv=alfa[1]; fbl->s=s[1];}
	 }
       fbl->length=fabs(fbl->fiv-fbl->fik)*fbl->r;
       fbl->vx=tvx+fbl->s*cosfv;
       fbl->vy=tvy+fbl->s*sinfv;
/*       fbl->vx=fbl->ox+fbl->sign*fbl->r*cos(fbl->fiv);
       fbl->vy=fbl->oy+fbl->sign*fbl->r*sin(fbl->fiv);*/
      }
    else
      {/* straight segment */
       fbl->ox=0.0;
       fbl->oy=0.0;
       fbl->fik-=anglescale*((double)offset);
       if(fbl->pre){free(fbl->pre); fbl->pre=0;}
       f=sin(fbl->fik)*sinfv+cos(fbl->fik)*cosfv;
       if(fabs(f)<1e-10)
	 {fbl->s=100.0;
	  fbl->length=fbl->tlu*4.8768;
	 }
       else
	 {fbl->length=(cosfv*(tvy-fbl->ky)-sinfv*(tvx-fbl->kx))/f;
	  fbl->s=(-sin(fbl->fik)*(tvy-fbl->ky)-cos(fbl->fik)*(tvx-fbl->kx))/f;
	 }
       fbl->fiv=fbl->fik;
       fbl->vx=tvx+fbl->s*cosfv;
       fbl->vy=tvy+fbl->s*sinfv;
/*       fbl->vx=fbl->kx-fbl->length*sin(fbl->fik);
       fbl->vy=fbl->ky+fbl->length*cos(fbl->fik);*/
      }

    fbl=fbl->kov;
   }/* end of while(fbl) */

 return;
}

/**********************/
/*load track file data*/
/**********************/
void loadtrack(char *filename)
{struct trackseg *ftr,*atr;
 struct command *kcmd, *acmd, *fcmd;
 struct bestlineseg *abl,*fbl;
 FILE *trf;
 double f,fx,fy,fif;
 double width, widthlen, newwidth;
 long int li, pitgrad,pithei;
 short int si, cumCCtlu;
 unsigned short int ui;
 byte b, trackdata, pitstart;
 int endtlof;
 char str[40];

 trf=fopen(filename,"rb");
 if(trf==NULL)
   {setfillstyle(1,7); setcolor(0);
    bar(5,maxy-18,maxx,maxy-10);
    writexy(5,maxy-18,"Error: cannot open the file.");
    return;
   }

 /* free previously allocated memory */
 free(objects);
 fbl=kbl;
 while(fbl)
    {ablseg=fbl;
     fbl=fbl->kov;
     free(ablseg);
    }
 kbl=0;
 ftr=ktrack;
 while(ftr)
    {picmd=ftr->cmd;
     while(picmd)
       {trcmd=picmd;
	picmd=picmd->kov;
	free(trcmd);
       }
     atrack=ftr;
     ftr=ftr->kov;
     free(atrack);
    }
 ktrack=0;
 ftr=kpit;
 while(ftr)
    {picmd=ftr->cmd;
     while(picmd)
       {trcmd=picmd;
	picmd=picmd->kov;
	free(trcmd);
       }
     apit=ftr;
     ftr=ftr->kov;
     free(apit);
    }
 kpit=0;

 endtlof=0;
 cumCCtlu=0;
 pitstart=0;

 /*reading background picture*/
 fread(&background,1,4096,trf);

 /*reading track header*/
 fread(&ui,2,1,trf);
 header.base=ui;
 fread(&ui,2,1,trf);
 header.unk1=ui;
 fread(&ui,2,1,trf);
 header.unk2=ui;
 fread(&ui,2,1,trf);
 header.unk3=ui;
 fread(&ui,2,1,trf);
 header.ochecksum=ui;
 fread(&ui,2,1,trf);
 header.unk4=ui;
 fread(&ui,2,1,trf);
 header.otrackdata=ui;

 /*reading object datas*/
 objects=(byte*)malloc(header.otrackdata+2);
 fread(objects,1,header.otrackdata+2,trf);

 /*reading track data header*/
 fread(&si,2,1,trf);
 trackheader.startangle=si;
 fread(&si,2,1,trf);
 trackheader.startheight=si;
 fread(&si,2,1,trf);
 trackheader.startY=si;
 fread(&si,2,1,trf);
 trackheader.startZ=si;
 fread(&si,2,1,trf);
 trackheader.startX=si;
 fread(&si,2,1,trf);
 trackheader.startWidth=si;
  width=2*widthscale*((double)si);
  widthlen=0.0;
 fread(&si,2,1,trf);
 trackheader.poleWidth=si;
 fread(&b,1,1,trf);
 trackheader.pitside=b;
 fread(&b,1,1,trf);
 trackheader.trsurround=b;
 fread(&b,1,1,trf);
 trackheader.rbank=b;
 fread(&b,1,1,trf);
 trackheader.lbank=b;
 fread(&si,2,1,trf);
 trackheader.kerbcnum=si;
 fread(&si,2,1,trf);
 trackheader.unk1=si;
 fread(&si,2,1,trf);
 trackheader.kerbtopcolor=si;
 fread(&si,2,1,trf);
 trackheader.kerbbottomcolor=si;
 fread(&si,2,1,trf);
 trackheader.unk2=si;
 if(trackheader.kerbcnum==4)
   {fread(&si,2,1,trf);
    trackheader.kerbtopcolor2=si;
    fread(&si,2,1,trf);
    trackheader.kerbbottomcolor2=si;
   }
 else
   {trackheader.kerbtopcolor2=trackheader.kerbtopcolor;
    trackheader.kerbbottomcolor2=trackheader.kerbbottomcolor;
   }

 /*reading track segment data*/
 trackdata=1;
 kcmd=0;
 ktrack=0;
 while(trackdata)
   {fread(&ui,2,1,trf);
    if( (ui/256!=0)&&(ui/256!=0xFF) )
      {acmd=newcommand();
       acmd->a1=0; acmd->a2=0; acmd->a3=0; acmd->a4=0; acmd->a5=0;
       if(kcmd==0){kcmd=acmd; fcmd=acmd; acmd->elo=0; acmd->kov=0;}
       else{fcmd->kov=acmd; acmd->elo=fcmd; acmd->kov=0; fcmd=acmd;}
      }
    switch(ui/256)
      {case 0x80:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x81:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x82:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x83:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x84:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x85:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  widthlen=4.8768*((double)ui);
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  newwidth=2*widthscale*((double)ui);
		  break;}
       case 0x86:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  pitstart=1;
		  break;}
       case 0x87:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x88:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x89:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x8A:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  fread(&ui,2,1,trf);
		  acmd->a3=ui;
		  fread(&ui,2,1,trf);
		  acmd->a4=ui;
		  fread(&ui,2,1,trf);
		  acmd->a5=ui;
		  break;}
       case 0x8B:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  fread(&ui,2,1,trf);
		  acmd->a3=ui;
		  fread(&ui,2,1,trf);
		  acmd->a4=ui;
		  fread(&ui,2,1,trf);
		  acmd->a5=ui;
		  break;}
       case 0x8C:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x8D:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x8E:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0x8F:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0x90:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x91:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x92:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x93:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x94:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x95:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x96:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x97:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x98:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x99:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x9A:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0x9B:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x9C:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x9D:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x9E:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x9F:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA0:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA1:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA2:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA3:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA4:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA5:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA6:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0xA7:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0xA8:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA9:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0xAA:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  fread(&ui,2,1,trf);
		  acmd->a3=ui;
		  break;}
       case 0xAB:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0xAC:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  fread(&ui,2,1,trf);
		  acmd->a3=ui;
		  fread(&ui,2,1,trf);
		  acmd->a4=ui;
		  break;}
       case 0xFF:{atr=newtrackseg();
		  ftr->kov=atr; atr->elo=ftr; atr->kov=0;
		  ftr=atr;
		  atr->sign=4;
		  atr->cmd=kcmd;
		  kcmd=0;
		  trackdata=0;
		  break;}
       case 0x00:{atr=newtrackseg();
		  if(ktrack==0)
		    {ktrack=atr; ftr=atr; atr->elo=0; atr->kov=0;
		     atr->fik=-anglescale*((double)trackheader.startangle);
		     atr->kx=0; atr->ky=0;
		    }
		  else
		    {ftr->kov=atr; atr->elo=ftr; atr->kov=0;
		     atr->fik=ftr->fiv;
		     atr->kx=ftr->vx; atr->ky=ftr->vy;
		     ftr=atr;
		    }
		  atr->cmd=kcmd;
		  kcmd=0;
		  atr->tlu=ui;
		  atr->length=4.8768*((double)ui);
		  fread(&si,2,1,trf);
		  atr->curvature=si;
		  fread(&si,2,1,trf);
		  atr->height=si;
		  fread(&ui,2,1,trf);
		  atr->flags=ui;
		  fread(&b,1,1,trf);
		  atr->rbank=b;
		  fread(&b,1,1,trf);
		  atr->lbank=b;
		  f=-anglescale*((double)atr->tlu)*((double)atr->curvature);
		  atr->fiv=atr->fik+f;
		  atr->sign=sgn(f);
		  if(atr->sign)
		    {atr->r=atr->length/(atr->sign*f);
		     atr->ox=atr->kx-atr->sign*atr->r*cos(atr->fik);
		     atr->oy=atr->ky-atr->sign*atr->r*sin(atr->fik);
		     atr->vx=atr->ox+atr->sign*atr->r*cos(atr->fiv);
		     atr->vy=atr->oy+atr->sign*atr->r*sin(atr->fiv);
		    }
		  else
		    {atr->r=0;
		     atr->ox=0;
		     atr->oy=0;
		     atr->vx=atr->kx-atr->length*sin(atr->fik);
		     atr->vy=atr->ky+atr->length*cos(atr->fik);
		    }
		  atr->ks[0]=width*0.5; atr->ks[1]=atr->ks[0];
		  if(widthlen>0.01)
		    {if(widthlen>atr->length)
		       {width+=atr->length*(newwidth-width)/widthlen;
			atr->middle=0;
		       }
		     else
		       {if(fabs(widthlen-atr->length)<0.0001)
			  {width=newwidth; atr->middle=0;}
			else{atr->middle=1;
			     if(atr->sign)
			       {f=atr->fik-anglescale*(widthlen/4.8768)*((double)atr->curvature);
				atr->fim=f;
				atr->mx=atr->ox+atr->sign*atr->r*cos(f);
				atr->my=atr->oy+atr->sign*atr->r*sin(f);
			       }
			     else
			       {f=widthlen;
				atr->fim=f;
				atr->mx=atr->kx-f*sin(atr->fik);
				atr->my=atr->ky+f*cos(atr->fik);
			       }
			     width=newwidth;
			    }
		       }
		     widthlen-=atr->length;
		    }
		  atr->vs[0]=width*0.5; atr->vs[1]=atr->vs[0];

		  if(atr->elo)
		    {atr->cumlength=atr->elo->cumlength+atr->length;
		     atr->cumgrad=atr->elo->cumgrad+((long int)atr->tlu)*((long int)atr->height);
		     atr->cumheight=atr->elo->cumheight+atr->tlu*(atr->elo->cumgrad+atr->cumgrad)/2;
		    }
		  else
		    {atr->cumlength=atr->length;
		     atr->cumgrad=(long int)trackheader.startheight;
		     atr->cumgrad+=((long int)atr->tlu)*((long int)atr->height);
		     atr->cumheight=atr->tlu*(((long int)trackheader.startheight)+atr->cumgrad)/2;
		    }

		  if(pitstart)
		    {if(trackheader.pitside)
		       {/*pits on the left*/
			fx=atr->kx-cos(atr->fik)*(atr->ks[0]-pitwidth*0.5);
			fy=atr->ky-sin(atr->fik)*(atr->ks[0]-pitwidth*0.5);
		       }
		     else
		       {/*pits on the right*/
			fx=atr->kx+cos(atr->fik)*(atr->ks[0]-pitwidth*0.5);
			fy=atr->ky+sin(atr->fik)*(atr->ks[0]-pitwidth*0.5);
		       }
		     fif=atr->fik;
		     pitgrad=atr->elo->cumgrad;
		     pithei=atr->elo->cumheight;
		     pitstart=0;
		    }
		  break;}
      }/*end of switch(ui/256)*/
   }/*end of while(trackdata)*/

 /*reading CC line data*/
 trackdata=1;
 kbl=0;
 while(trackdata)
   {fread(&ui,2,1,trf);
    if(ui%256==0)
      {trackdata=0; break;}
    abl=newbestlineseg();
    abl->pre=0;
    if(kbl==0)
      {kbl=abl; fbl=abl; abl->elo=0; abl->kov=0;
       abl->fik=ktrack->fik;
       abl->kx=ktrack->kx; abl->ky=ktrack->ky;
      }
    else
      {fbl->kov=abl; abl->elo=fbl; abl->kov=0;
       abl->fik=fbl->fiv;
       abl->kx=fbl->vx; abl->ky=fbl->vy;
       fbl=abl;
      }
    abl->tlu=ui%256;
    cumCCtlu+=abl->tlu;
    abl->length=4.8768*((double)(abl->tlu));
    abl->s=0.0;
    abl->type=ui/256;
    switch(abl->type)
      {case 0x80:{fread(&si,2,1,trf);
		  abl->a1=si;
		   f=widthscale*((double)si);
		   abl->kx+=f*cos(ktrack->fik);
		   abl->ky+=f*sin(ktrack->fik);
		  fread(&si,2,1,trf);
		  abl->a2=si;
		  fread(&si,2,1,trf);
		  abl->a3=si;
		  if(abl->a3==0)
		    {f=0.0;
		     abl->r=0.0;
		     abl->sign=0;
		     abl->fiv=abl->fik;
		     endtlof+=abs(abl->a2);
		    }
		  else
		    {//f=-1.0*((double)abl->tlu/*-((float)abl->a2)/128.0*/)/((float)abl->a3);
		     //f*=360.0/3.14;
		     abl->sign=-sgn(abl->a3);
		     abl->r=((double)abs(abl->a3))*radscale;
		     f=abl->length/abl->r;
		     abl->fiv=abl->fik+f*abl->sign;
		     //abl->r+=((float)abl->tlu)*((float)abl->a2)/((float)abl->a3);
//		     if(abl->a2){abl->pre=newbestlineseg();}
		    }
		  break;}
       case 0x00:{fread(&si,2,1,trf);
		  abl->a1=si;
		  fread(&si,2,1,trf);
		  abl->a2=si;
		  if(abl->a2==0)
		    {f=0.0;
		     abl->r=0.0;
		     abl->sign=0;
		     abl->fiv=abl->fik;
		     endtlof+=abs(abl->a1);
		    }
		  else
		    {//f=-1.0*((float)abl->tlu/*-((float)abl->a1)/128.0*/)/((float)abl->a2);
		     //f*=360.0/3.14;
		     /**/
		     abl->length-=((double)abl->a1)/128.0;
		     abl->elo->length+=((double)abl->a1)/128.0;
		     /**/
		     abl->sign=-sgn(abl->a2);
		     abl->r=((double)abs(abl->a2))*radscale;
		     f=abl->length/abl->r;
		     abl->fiv=abl->fik+f*abl->sign;
		     //abl->r+=((float)abl->tlu)*((float)abl->a1)/((float)abl->a2);
//		     if(abl->a1){abl->pre=newbestlineseg();}
		    }
		  break;}
       case 0x40:{fread(&si,2,1,trf);
		  abl->a1=si;
		  li=0;
		  fread((byte*)(&li)+2,2,1,trf);
		  abl->a2=li/65536;
		  fread(&si,2,1,trf);
		  abl->a3=si;
		  li+=si;
		  abl->bigrad=li;
		  if(li==0)
		    {f=0.0;
		     abl->r=0.0;
		     abl->sign=0;
		     abl->fiv=abl->fik;
		     endtlof+=abs(abl->a1);
		    }
		  else
		    {//f=-1.0*((float)abl->tlu/*-((float)abl->a1)/128.0*/)/((float)li);
		     //f*=360.0/3.14;
		     abl->sign=-sgn(li);
		     abl->r=((double)labs(li))*radscale;
		     f=abl->length/abl->r;
		     abl->fiv=abl->fik+f*abl->sign;
		     //abl->r+=((float)abl->tlu)*((float)abl->a1)/((float)li);
//		     if(abl->a1){abl->pre=newbestlineseg();}
		    }
		  break;}
      }/* end of switch(abl->type) */
    if(abl->sign)
      {//abl->r=abl->length/(abl->sign*f);
       abl->ox=abl->kx-abl->sign*abl->r*cos(abl->fik);
       abl->oy=abl->ky-abl->sign*abl->r*sin(abl->fik);
       abl->vx=abl->ox+abl->sign*abl->r*cos(abl->fiv);
       abl->vy=abl->oy+abl->sign*abl->r*sin(abl->fiv);
      }
    else
      {//abl->r=0;
       abl->ox=0;
       abl->oy=0;
       abl->vx=abl->kx-abl->length*sin(abl->fik);
       abl->vy=abl->ky+abl->length*cos(abl->fik);
      }
   }/* end of while(trackdata) */

 /*reading CC setup data*/
 fread(&CCsetup.fwing,1,1,trf);
 fread(&CCsetup.rwing,1,1,trf);
 fread(&CCsetup.g1,1,1,trf);
 fread(&CCsetup.g2,1,1,trf);
 fread(&CCsetup.g3,1,1,trf);
 fread(&CCsetup.g4,1,1,trf);
 fread(&CCsetup.g5,1,1,trf);
 fread(&CCsetup.g6,1,1,trf);
 fread(&CCsetup.tyretype,1,1,trf);
 fread(&CCsetup.brakeb,1,1,trf);
 fread(&CCsetup.grip,2,1,trf);
 fread(&CCsetup.QA,2,1,trf);
 fread(&CCsetup.RA,2,1,trf);
 fread(&CCsetup.QT,2,1,trf);
 fread(&CCsetup.accel,2,1,trf);
 fread(&CCsetup.airres,2,1,trf);
 fread(&CCsetup.unk1,2,1,trf);
 fread(&CCsetup.TW1,2,1,trf);
 fread(&CCsetup.TW2,2,1,trf);
 fread(&CCsetup.RT,2,1,trf);
 fread(&CCsetup.unk2,2,1,trf);
 fread(&CCsetup.wetRA,2,1,trf);
 fread(&CCsetup.unk3,2,1,trf);
 fread(&CCsetup.unk4,2,1,trf);

 /*reading pitlane segment data*/
 trackdata=1;
 kcmd=0;
 kpit=0;
 width=pitwidth;
 newwidth=pitwidth;
 widthlen=0;
 while(trackdata)
   {fread(&ui,2,1,trf);
    if( (ui/256!=0)&&(ui/256!=0xFF) )
      {acmd=newcommand();
       acmd->a1=0; acmd->a2=0; acmd->a3=0; acmd->a4=0; acmd->a5=0;
       if(kcmd==0){kcmd=acmd; fcmd=acmd; acmd->elo=0; acmd->kov=0;}
       else{fcmd->kov=acmd; acmd->elo=fcmd; acmd->kov=0; fcmd=acmd;}
      }
    switch(ui/256)
      {case 0x80:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x81:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x82:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x83:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x84:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x85:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  widthlen=4.8768*((double)ui);
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  newwidth=2*widthscale*((double)ui);
		  break;}
       case 0x86:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x87:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x88:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x89:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x8A:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  fread(&ui,2,1,trf);
		  acmd->a3=ui;
		  fread(&ui,2,1,trf);
		  acmd->a4=ui;
		  fread(&ui,2,1,trf);
		  acmd->a5=ui;
		  break;}
       case 0x8B:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  fread(&ui,2,1,trf);
		  acmd->a3=ui;
		  fread(&ui,2,1,trf);
		  acmd->a4=ui;
		  fread(&ui,2,1,trf);
		  acmd->a5=ui;
		  break;}
       case 0x8C:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x8D:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x8E:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0x8F:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0x90:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x91:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x92:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x93:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x94:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x95:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x96:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x97:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x98:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x99:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0x9A:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0x9B:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x9C:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x9D:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x9E:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0x9F:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA0:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA1:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA2:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA3:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA4:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA5:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA6:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0xA7:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0xA8:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  break;}
       case 0xA9:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  break;}
       case 0xAA:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  fread(&ui,2,1,trf);
		  acmd->a3=ui;
		  break;}
       case 0xAB:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  break;}
       case 0xAC:{acmd->cmd=ui/256;
		  acmd->a0=ui%256;
		  fread(&ui,2,1,trf);
		  acmd->a1=ui;
		  fread(&ui,2,1,trf);
		  acmd->a2=ui;
		  fread(&ui,2,1,trf);
		  acmd->a3=ui;
		  fread(&ui,2,1,trf);
		  acmd->a4=ui;
		  break;}
       case 0xFF:{trackdata=0;
		  break;}
       case 0x00:{atr=newtrackseg();
		  if(kpit==0)
		    {kpit=atr; ftr=atr; atr->elo=0; atr->kov=0;
		     atr->fik=fif;
		     atr->kx=fx; atr->ky=fy;
		    }
		  else
		    {ftr->kov=atr; atr->elo=ftr; atr->kov=0;
		     atr->fik=ftr->fiv;
		     atr->kx=ftr->vx; atr->ky=ftr->vy;
		     ftr=atr;
		    }
		  atr->cmd=kcmd;
		  kcmd=0;
		  atr->tlu=ui;
		  atr->length=4.8768*((double)ui);
		  fread(&si,2,1,trf);
		  atr->curvature=si;
		  fread(&si,2,1,trf);
		  atr->height=si;
		  fread(&ui,2,1,trf);
		  atr->flags=ui;
		  fread(&b,1,1,trf);
		  atr->rbank=b;
		  fread(&b,1,1,trf);
		  atr->lbank=b;
		  f=-anglescale*((double)atr->tlu)*((double)atr->curvature);
		  atr->fiv=atr->fik+f;
		  atr->sign=sgn(f);
		  if(atr->sign)
		    {atr->r=atr->length/(atr->sign*f);
		     atr->ox=atr->kx-atr->sign*atr->r*cos(atr->fik);
		     atr->oy=atr->ky-atr->sign*atr->r*sin(atr->fik);
		     atr->vx=atr->ox+atr->sign*atr->r*cos(atr->fiv);
		     atr->vy=atr->oy+atr->sign*atr->r*sin(atr->fiv);
		    }
		  else
		    {atr->r=0;
		     atr->ox=0;
		     atr->oy=0;
		     atr->vx=atr->kx-atr->length*sin(atr->fik);
		     atr->vy=atr->ky+atr->length*cos(atr->fik);
		    }
		  atr->ks[0]=width*0.5; atr->ks[1]=atr->ks[0];
		  if(widthlen>0.01)
		    {if(widthlen>atr->length)
		       {width+=atr->length*(newwidth-width)/widthlen;
			atr->middle=0;
		       }
		     else
		       {if(fabs(widthlen-atr->length)<0.0001)
			  {width=newwidth; atr->middle=0;}
			else{atr->middle=1;
			     if(atr->sign)
			       {f=atr->fik-anglescale*(widthlen/4.8768)*((double)atr->curvature);
				atr->fim=f;
				atr->mx=atr->ox+atr->sign*atr->r*cos(f);
				atr->my=atr->oy+atr->sign*atr->r*sin(f);
			       }
			     else
			       {f=widthlen;
				atr->fim=f;
				atr->mx=atr->kx-f*sin(atr->fik);
				atr->my=atr->ky+f*cos(atr->fik);
			       }
			     width=newwidth;
			    }
		       }
		     widthlen-=atr->length;
		    }
		  atr->vs[0]=width*0.5; atr->vs[1]=atr->vs[0];

		  if(atr->elo)
		    {atr->cumlength=atr->elo->cumlength+atr->length;
		     atr->cumgrad=atr->elo->cumgrad+((long int)atr->tlu)*((long int)atr->height);
		     atr->cumheight=atr->elo->cumheight+atr->tlu*(atr->elo->cumgrad+atr->cumgrad)/2;
		    }
		  else
		    {atr->cumlength=atr->length;
		     atr->cumgrad=pitgrad;
		     atr->cumgrad+=((long int)atr->tlu)*((long int)atr->height);
		     atr->cumheight=pithei+atr->tlu*(pitgrad+atr->cumgrad)/2;
		    }
		  break;}
      }/*end of switch(ui/256)*/
   }/*end of while(trackdata)*/

 /*reading data from the end of file*/
 si=0;
 while(fread(endheader+si,1,1,trf)==1)
   {si++;
   }
 lapnumindex=si-10; /* index of last byte = lapnumindex+9 */
 fclose(trf);
 refreshCCline();
 sprintf(str,"CC line: %u tlu",cumCCtlu);
 writexy(5,maxy-18,str);
}

/**********************/
/*save track file data*/
/**********************/
void savetrack(char *filename)
{struct trackseg *ftr,*atr;
 struct command *acmd, *fcmd;
 struct bestlineseg *abl,*fbl;
 FILE *trf;
 short int si;
 unsigned short int ui;
 long li;

 trf=fopen(filename,"wb");
 if(trf==NULL)
   {setfillstyle(1,7); setcolor(0);
    bar(5,maxy-18,maxx,maxy-10);
    writexy(5,maxy-18,"Error: cannot open the file.");
    return;
   }

 /*writing background picture*/
 fwrite(&background,1,4096,trf);

 /*writing track header*/
 fwrite(&header.base,2,1,trf);
 fwrite(&header.unk1,2,1,trf);
 fwrite(&header.unk2,2,1,trf);
 fwrite(&header.unk3,2,1,trf);
 fwrite(&header.ochecksum,2,1,trf);
 fwrite(&header.unk4,2,1,trf);
 fwrite(&header.otrackdata,2,1,trf);

 /*writing object datas*/
 fwrite(objects,1,header.otrackdata+2,trf);

 /*writing track data header*/
 fwrite(&trackheader.startangle,2,1,trf);
 fwrite(&trackheader.startheight,2,1,trf);
 fwrite(&trackheader.startY,2,1,trf);
 fwrite(&trackheader.startZ,2,1,trf);
 fwrite(&trackheader.startX,2,1,trf);
 fwrite(&trackheader.startWidth,2,1,trf);
 fwrite(&trackheader.poleWidth,2,1,trf);
 fwrite(&trackheader.pitside,1,1,trf);
 fwrite(&trackheader.trsurround,1,1,trf);
 fwrite(&trackheader.rbank,1,1,trf);
 fwrite(&trackheader.lbank,1,1,trf);
 fwrite(&trackheader.kerbcnum,2,1,trf);
 fwrite(&trackheader.unk1,2,1,trf);
 fwrite(&trackheader.kerbtopcolor,2,1,trf);
 fwrite(&trackheader.kerbbottomcolor,2,1,trf);
 fwrite(&trackheader.unk2,2,1,trf);
 if(trackheader.kerbcnum==4)
   {fwrite(&trackheader.kerbtopcolor2,2,1,trf);
    fwrite(&trackheader.kerbbottomcolor2,2,1,trf);
   }

 /*writing track segment data*/
 ftr=ktrack;
 while(ftr)
   {/*writing commands*/
    fcmd=ftr->cmd;
    while(fcmd)
      {fwrite(&fcmd->a0,1,1,trf);
       fwrite(&fcmd->cmd,1,1,trf);
       if( (fcmd->cmd==0x80)||(fcmd->cmd==0x81)||(fcmd->cmd==0x82)||
	   (fcmd->cmd==0x88)||(fcmd->cmd==0x89)||(fcmd->cmd==0x8C)||
	   (fcmd->cmd==0x8D)||(fcmd->cmd==0x90)||(fcmd->cmd==0x91)||
	   (fcmd->cmd==0x92)||(fcmd->cmd==0x93)||(fcmd->cmd==0x94)||
	   (fcmd->cmd==0x95)||(fcmd->cmd==0x98)||(fcmd->cmd==0x99)||
	   (fcmd->cmd==0xA9)
	 )
	 {fwrite(&fcmd->a1,2,1,trf);
	 }
       if( (fcmd->cmd==0x85)||(fcmd->cmd==0x8E)||(fcmd->cmd==0x8F)||
	   (fcmd->cmd==0x9A)||(fcmd->cmd==0xA6)||(fcmd->cmd==0xA7)||
	   (fcmd->cmd==0xAB)
	 )
	 {fwrite(&fcmd->a1,2,1,trf);
	  fwrite(&fcmd->a2,2,1,trf);
	 }
       if( (fcmd->cmd==0xAA)
	 )
	 {fwrite(&fcmd->a1,2,1,trf);
	  fwrite(&fcmd->a2,2,1,trf);
	  fwrite(&fcmd->a3,2,1,trf);
	 }
       if(fcmd->cmd==0xAC)
	 {fwrite(&fcmd->a1,2,1,trf);
	  fwrite(&fcmd->a2,2,1,trf);
	  fwrite(&fcmd->a3,2,1,trf);
	  fwrite(&fcmd->a4,2,1,trf);
	 }
       if( (fcmd->cmd==0x8A)||(fcmd->cmd==0x8B)
	 )
	 {fwrite(&fcmd->a1,2,1,trf);
	  fwrite(&fcmd->a2,2,1,trf);
	  fwrite(&fcmd->a3,2,1,trf);
	  fwrite(&fcmd->a4,2,1,trf);
	  fwrite(&fcmd->a5,2,1,trf);
	 }
       fcmd=fcmd->kov;
      }
    /*writing track segment*/
    if(ftr->sign!=4)
      {fwrite(&ftr->tlu,2,1,trf);
       fwrite(&ftr->curvature,2,1,trf);
       fwrite(&ftr->height,2,1,trf);
       fwrite(&ftr->flags,2,1,trf);
       fwrite(&ftr->rbank,1,1,trf);
       fwrite(&ftr->lbank,1,1,trf);
      }
    ftr=ftr->kov;
   }
 si=65535;
 fwrite(&si,2,1,trf);

 /*writing CC line data*/
 fbl=kbl;
 while(fbl)
   {fwrite(&fbl->tlu,1,1,trf);
    fwrite(&fbl->type,1,1,trf);
    fwrite(&fbl->a1,2,1,trf);
    fwrite(&fbl->a2,2,1,trf);
    if( fbl->type/*(fbl->type==0x80)||(fbl->type==0x40)*/ )
      {fwrite(&fbl->a3,2,1,trf);}
    fbl=fbl->kov;
   }
 si=0;
 fwrite(&si,2,1,trf);

 /*writing CC setup data*/
 fwrite(&CCsetup.fwing,1,1,trf);
 fwrite(&CCsetup.rwing,1,1,trf);
 fwrite(&CCsetup.g1,1,1,trf);
 fwrite(&CCsetup.g2,1,1,trf);
 fwrite(&CCsetup.g3,1,1,trf);
 fwrite(&CCsetup.g4,1,1,trf);
 fwrite(&CCsetup.g5,1,1,trf);
 fwrite(&CCsetup.g6,1,1,trf);
 fwrite(&CCsetup.tyretype,1,1,trf);
 fwrite(&CCsetup.brakeb,1,1,trf);
 fwrite(&CCsetup.grip,2,1,trf);
 fwrite(&CCsetup.QA,2,1,trf);
 fwrite(&CCsetup.RA,2,1,trf);
 fwrite(&CCsetup.QT,2,1,trf);
 fwrite(&CCsetup.accel,2,1,trf);
 fwrite(&CCsetup.airres,2,1,trf);
 fwrite(&CCsetup.unk1,2,1,trf);
 fwrite(&CCsetup.TW1,2,1,trf);
 fwrite(&CCsetup.TW2,2,1,trf);
 fwrite(&CCsetup.RT,2,1,trf);
 fwrite(&CCsetup.unk2,2,1,trf);
 fwrite(&CCsetup.wetRA,2,1,trf);
 fwrite(&CCsetup.unk3,2,1,trf);
 fwrite(&CCsetup.unk4,2,1,trf);

 /*writing pitlane segment data*/
 ftr=kpit;
 while(ftr)
   {/*writing commands*/
    fcmd=ftr->cmd;
    while(fcmd)
      {fwrite(&fcmd->a0,1,1,trf);
       fwrite(&fcmd->cmd,1,1,trf);
       if( (fcmd->cmd==0x80)||(fcmd->cmd==0x81)||(fcmd->cmd==0x82)||
	   (fcmd->cmd==0x88)||(fcmd->cmd==0x89)||(fcmd->cmd==0x8C)||
	   (fcmd->cmd==0x8D)||(fcmd->cmd==0x90)||(fcmd->cmd==0x91)||
	   (fcmd->cmd==0x92)||(fcmd->cmd==0x93)||(fcmd->cmd==0x94)||
	   (fcmd->cmd==0x95)||(fcmd->cmd==0x98)||(fcmd->cmd==0x99)||
	   (fcmd->cmd==0xA9)
	 )
	 {fwrite(&fcmd->a1,2,1,trf);
	 }
       if( (fcmd->cmd==0x85)||(fcmd->cmd==0x8E)||(fcmd->cmd==0x8F)||
	   (fcmd->cmd==0x9A)||(fcmd->cmd==0xA6)||(fcmd->cmd==0xA7)||
	   (fcmd->cmd==0xAB)
	 )
	 {fwrite(&fcmd->a1,2,1,trf);
	  fwrite(&fcmd->a2,2,1,trf);
	 }
       if( (fcmd->cmd==0xAA)
	 )
	 {fwrite(&fcmd->a1,2,1,trf);
	  fwrite(&fcmd->a2,2,1,trf);
	  fwrite(&fcmd->a3,2,1,trf);
	 }
       if(fcmd->cmd==0xAC)
	 {fwrite(&fcmd->a1,2,1,trf);
	  fwrite(&fcmd->a2,2,1,trf);
	  fwrite(&fcmd->a3,2,1,trf);
	  fwrite(&fcmd->a4,2,1,trf);
	 }
       if( (fcmd->cmd==0x8A)||(fcmd->cmd==0x8B)
	 )
	 {fwrite(&fcmd->a1,2,1,trf);
	  fwrite(&fcmd->a2,2,1,trf);
	  fwrite(&fcmd->a3,2,1,trf);
	  fwrite(&fcmd->a4,2,1,trf);
	  fwrite(&fcmd->a5,2,1,trf);
	 }
       fcmd=fcmd->kov;
      }
    /*writing track segment*/
    fwrite(&ftr->tlu,2,1,trf);
    fwrite(&ftr->curvature,2,1,trf);
    fwrite(&ftr->height,2,1,trf);
    fwrite(&ftr->flags,2,1,trf);
    fwrite(&ftr->rbank,1,1,trf);
    fwrite(&ftr->lbank,1,1,trf);
    ftr=ftr->kov;
   }
 si=65535;
 fwrite(&si,2,1,trf);

 /*writing data to the end of file*/
 fwrite(endheader,1,lapnumindex+6,trf);
 li=0;
 fwrite(&li,4,1,trf);

 /*new offset to checksum*/
 fgetpos(trf,&li);
 ui=(unsigned int)li;
 header.ochecksum=ui-4-header.base;
 fseek(trf,4104,0);
 fwrite(&header.ochecksum,2,1,trf);

 fclose(trf);

 /*new checksum*/
// execl("checksum",filename,0);
 si=spawnl(P_WAIT,"checksum.exe",filename,filename,NULL);

}