// EditTrackSegmentDialog.cpp : implementation file
//

#include "stdafx.h"
#include "TrackEd.h"
#include "EditTrackSegmentDialog.h"
#include "TrackSeg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditTrackSegmentDialog dialog


CEditTrackSegmentDialog::CEditTrackSegmentDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CEditTrackSegmentDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditTrackSegmentDialog)
	m_nRightBank = 0;
	m_nCurvature = 0;
	m_nHeight = 0;
	m_nLeftBank = 0;
	m_nLength = 0;
	m_bKerbType = FALSE;
	m_bLBridge = FALSE;
	m_bLKerb = FALSE;
	m_bLPitWall = FALSE;
	m_bLWall = FALSE;
	m_bRBridge = FALSE;
	m_bRKerb = FALSE;
	m_bRPitWall = FALSE;
	m_bRWall = FALSE;
	m_bUnk1 = FALSE;
	m_bUnk2 = FALSE;
	m_bUnk3 = FALSE;
	m_bUnk4 = FALSE;
	m_bUnk5 = FALSE;
	m_bUnk6 = FALSE;
	m_bUnk7 = FALSE;
	//}}AFX_DATA_INIT
	m_pTrackSeg = NULL;
}


void CEditTrackSegmentDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditTrackSegmentDialog)
	DDX_Text(pDX, IDC_EDIT_RIGHT_BANK, m_nRightBank);
	DDX_Text(pDX, IDC_EDIT_CURVATURE, m_nCurvature);
	DDX_Text(pDX, IDC_EDIT_HEIGHT, m_nHeight);
	DDX_Text(pDX, IDC_EDIT_LEFT_BANK, m_nLeftBank);
	DDX_Text(pDX, IDC_EDIT_LENGTH, m_nLength);
	DDX_Check(pDX, IDC_CHECK_KERBTYPE, m_bKerbType);
	DDX_Check(pDX, IDC_CHECK_LBRIDGE, m_bLBridge);
	DDX_Check(pDX, IDC_CHECK_LKERB, m_bLKerb);
	DDX_Check(pDX, IDC_CHECK_LPITWALL, m_bLPitWall);
	DDX_Check(pDX, IDC_CHECK_LWALL, m_bLWall);
	DDX_Check(pDX, IDC_CHECK_RBRIDGE, m_bRBridge);
	DDX_Check(pDX, IDC_CHECK_RKERB, m_bRKerb);
	DDX_Check(pDX, IDC_CHECK_RPITWALL, m_bRPitWall);
	DDX_Check(pDX, IDC_CHECK_RWALL, m_bRWall);
	DDX_Check(pDX, IDC_CHECK_UNK1, m_bUnk1);
	DDX_Check(pDX, IDC_CHECK_UNK2, m_bUnk2);
	DDX_Check(pDX, IDC_CHECK_UNK3, m_bUnk3);
	DDX_Check(pDX, IDC_CHECK_UNK4, m_bUnk4);
	DDX_Check(pDX, IDC_CHECK_UNK5, m_bUnk5);
	DDX_Check(pDX, IDC_CHECK_UNK6, m_bUnk6);
	DDX_Check(pDX, IDC_CHECK_UNK7, m_bUnk7);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditTrackSegmentDialog, CDialog)
	//{{AFX_MSG_MAP(CEditTrackSegmentDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditTrackSegmentDialog message handlers

void CEditTrackSegmentDialog::SetTrackSeg(CTrackSeg *pTrackSeg)
{
	m_pTrackSeg = pTrackSeg;
}

void CEditTrackSegmentDialog::OnOK() 
{
	// transfer data to track segment
	if ( m_pTrackSeg != NULL )
	{
		UpdateData();
		// Values
		m_pTrackSeg->tlu = m_nLength;
		m_pTrackSeg->curvature = m_nCurvature;
		m_pTrackSeg->height = m_nHeight;
		m_pTrackSeg->lbank = m_nLeftBank;
		m_pTrackSeg->rbank = m_nRightBank;
		// Flags
		m_pTrackSeg->flags = 0;
		if ( m_bUnk1 )
			m_pTrackSeg->flags |= 0x8000;
		if ( m_bUnk2 )
			m_pTrackSeg->flags |= 0x4000;
		if ( m_bLWall )
			m_pTrackSeg->flags |= 0x2000;
		if ( m_bRWall )
			m_pTrackSeg->flags |= 0x1000;
		if ( m_bLKerb )
			m_pTrackSeg->flags |= 0x0800;
		if ( m_bRKerb )
			m_pTrackSeg->flags |= 0x0400;
		if ( m_bUnk3 )
			m_pTrackSeg->flags |= 0x0200;
		if ( m_bUnk4 )
			m_pTrackSeg->flags |= 0x0100;
		if ( m_bUnk5 )
			m_pTrackSeg->flags |= 0x0080;
		if ( m_bUnk6 )
			m_pTrackSeg->flags |= 0x0040;
		if ( m_bLBridge )
			m_pTrackSeg->flags |= 0x0020;
		if ( m_bRBridge )
			m_pTrackSeg->flags |= 0x0010;
		if ( m_bUnk7 )
			m_pTrackSeg->flags |= 0x0008;
		if ( m_bKerbType )
			m_pTrackSeg->flags |= 0x0004;
		if ( m_bLPitWall )
			m_pTrackSeg->flags |= 0x0002;
		if ( m_bRPitWall )
			m_pTrackSeg->flags |= 0x0001;
	}
	CDialog::OnOK();
}

BOOL CEditTrackSegmentDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	if ( m_pTrackSeg != NULL )
	{
		// Values
		m_nLength = m_pTrackSeg->tlu;
		m_nCurvature = m_pTrackSeg->curvature;
		m_nHeight = m_pTrackSeg->height;
		m_nLeftBank = m_pTrackSeg->lbank;
		m_nRightBank = m_pTrackSeg->rbank;
		// Flags
		m_bUnk1		= (m_pTrackSeg->flags & 0x8000) != 0;
		m_bUnk2		= (m_pTrackSeg->flags & 0x4000) != 0;
		m_bLWall	= (m_pTrackSeg->flags & 0x2000) != 0;
		m_bRWall	= (m_pTrackSeg->flags & 0x1000) != 0;
		m_bLKerb	= (m_pTrackSeg->flags & 0x0800) != 0;
		m_bRKerb	= (m_pTrackSeg->flags & 0x0400) != 0;
		m_bUnk3		= (m_pTrackSeg->flags & 0x0200) != 0;
		m_bUnk4		= (m_pTrackSeg->flags & 0x0100) != 0;
		m_bUnk5		= (m_pTrackSeg->flags & 0x0080) != 0;
		m_bUnk6		= (m_pTrackSeg->flags & 0x0040) != 0;
		m_bLBridge	= (m_pTrackSeg->flags & 0x0020) != 0;
		m_bRBridge	= (m_pTrackSeg->flags & 0x0010) != 0;
		m_bUnk7		= (m_pTrackSeg->flags & 0x0008) != 0;
		m_bKerbType	= (m_pTrackSeg->flags & 0x0004) != 0;
		m_bLPitWall	= (m_pTrackSeg->flags & 0x0002) != 0;
		m_bRPitWall	= (m_pTrackSeg->flags & 0x0001) != 0;

		UpdateData( FALSE );
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
