// TrackObjects.cpp: implementation of the CTrackObjects class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TrackEd.h"
#include "TrackObjects.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTrackObjects::CTrackObjects()
{
	m_pData = NULL;
	m_nDataSize = 0;
}

CTrackObjects::~CTrackObjects()
{
	if ( m_pData != NULL )
		delete m_pData;
	m_pData = NULL;
	m_nDataSize = 0;
}

size_t CTrackObjects::Save(FILE *pTrackFile)
{
	if ( m_pData == NULL )
		return 0;
	if ( m_nDataSize == NULL )
		return 0;
	if ( pTrackFile == NULL )
		return 0;
	return fwrite( m_pData, 1, m_nDataSize, pTrackFile );
}

void CTrackObjects::Load(FILE *pTrackFile, int nSize)
{
	if ( pTrackFile == NULL )
		return;
	if ( nSize != m_nDataSize )
	{
		// free current buffer, if any
		if ( m_pData != NULL )
			delete m_pData;
		m_pData = NULL;
		// create new buffer, if needed
		if ( nSize > 0 )
		{
			m_pData = new byte[ nSize ];
			m_nDataSize = nSize;
		}
	}
	// read data from file
	fread( m_pData, 1, nSize, pTrackFile );
}
