// TrackFileHeader.cpp: implementation of the CTrackFileHeader class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TrackEd.h"
#include "TrackFileHeader.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTrackFileHeader::CTrackFileHeader()
{
	m_nSizeBase = 0;
	unk1 = 0;
	unk2 = 0;
	unk3 = 0;
	m_nChecksumOffset = 0;
	m_nObjDataOffset = 0;
	m_nTrackDataOffset = 0;
	m_nNumObj = 0;
}

CTrackFileHeader::~CTrackFileHeader()
{

}

void CTrackFileHeader::Load(FILE *pTrackFile)
{
	if ( pTrackFile == NULL )
		return;

	unsigned short ui;
	fread(&ui,2,1,pTrackFile);
	m_nSizeBase=ui;
	fread(&ui,2,1,pTrackFile);
	unk1=ui;
	fread(&ui,2,1,pTrackFile);
	unk2=ui;
	fread(&ui,2,1,pTrackFile);
	unk3=ui;
	fread(&ui,2,1,pTrackFile);
	m_nChecksumOffset = ui;
	fread(&ui,2,1,pTrackFile);
	m_nObjDataOffset=ui;
	fread(&ui,2,1,pTrackFile);
	m_nTrackDataOffset=ui;
	fread(&ui,2,1,pTrackFile);
	m_nNumObj=ui;
}

size_t CTrackFileHeader::Save(FILE *pTrackFile)
{
	size_t nSaved = 0;

	if ( pTrackFile != NULL )
	{
		nSaved += fwrite(&m_nSizeBase,2,1,pTrackFile);
		nSaved += fwrite(&unk1,2,1,pTrackFile);
		nSaved += fwrite(&unk2,2,1,pTrackFile);
		nSaved += fwrite(&unk3,2,1,pTrackFile);
		nSaved += fwrite(&m_nChecksumOffset,2,1,pTrackFile);
		nSaved += fwrite(&m_nObjDataOffset,2,1,pTrackFile);
		nSaved += fwrite(&m_nTrackDataOffset,2,1,pTrackFile);
		nSaved += fwrite(&m_nNumObj,2,1,pTrackFile);
	}
	return nSaved;
}
