#!/bin/bash
# DOS Descent Registered Version 1.0=>1.5 Patch Fix Script
# Version 1.0
# 1 January 2007
# Author:  Stewart Todd Morgan
#
# THE AUTHOR OF THE CONTENTS OF THIS ARCHIVE IS IN NO WAY
# ASSOCIATED WITH INTERPLAY ENTERTAINMENT CORP. OR PARALLAX
# SOFTWARE CORP.  THE CONTENTS OF THIS ARCHIVE WAS COMPILED
# WITHOUT THE KNOWLEDGE OR APPROVAL OF INTERPLAY ENTERTAINMENT
# CORP. OR PARALLAX SOFTWARE CORP. DO NOT SEEK ASSISTANCE FROM
# INTERPLAY ENTERTAINMENT CORP. OR PARALLAX SOFTWARE CORP. IF
# YOU REQUIRE ASSISTANCE WITH THE SOFTWARE IN THIS ARCHIVE.
#
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR HIS
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#
# ****************************************************************
# WARNING:  Execute this script only on a Registered Descent
# Version 1.5 installation where the DESCENT.HOG file
# has the following attributes:
# File size:  6856183 bytes
# MD5:  1051170991544a607c3ff686d0760c98
# SHA1:  19659f7dc0a464b2778d1274cd136a7a4f02c0ca
#
# Execution of this script on a Descent installation with
# any other DESCENT.HOG file can and will cause corruption
# of the DESCENT.HOG file and render the installation
# inoperable.  This includes Registered Descent installations
# other than Version 1.5, Shareware Descent installations,
# and Descent II installations (Registered and Shareware).
#
# ****************************************************************
#
# EXECUTING THE SCRIPT
# It is assumed that the Bash shell is in /bin/bash.  If this
# is not the case, then the user should adjust the first line
# of the script to point to the actual Bash shell location.
# This shell script can be run as a Bourne shell script by
# changing the first line of the script to point to the
# Bourne shell.  The script was developed and tested in a
# SuSE Linux Version 9.3 environment.
#
# The user must have EXECUTE permission on the script.  The
# following chmod command will give READ/EXECUTE permission
# to the user and READ access to others:
#      chmod 544 linfix.sh
# If the user needs to alter the script in any way then
# the following chmod command will give WRITE access in
# addition to READ and EXECUTE:
#      chmod 744 linfix.sh
#
# The script requires no parameters, so it can be executed by
# entering the name at a command prompt.  If the user's system
# does not have the current directory in the PATH, it may be
# necessary to preface the script name with './' as follows:
#
# user@linux:~/games/descent> ./linfix.sh
#
# If no shell error messages are displayed, then the user
# can test the DESCENT.HOG file for the following properties:
# File size:  6856701 bytes
# MD5:  c792a21a30b869b1ec6d31ad64e9557e
# SHA1:  4d6fb40e943f92574aba2c9fc1574330de89905b
# These reflect a properly patched Registered Version 1.5
# DESCENT.HOG file.
#
# All temporary files generated by the script begin with the
# character sequence 'zz'.  If the script fails, the user can
# clean up temporary files by deleting those files which begin
# with the 'zz' sequence.
#
# ****************************************************************
# Isolate the DESCENT.HOG data from the beginning
# of the file to the file length field of DESCENT.SNG.
split -b 1007196 descent.hog zztemp.
split -b 1007194 zztemp.aa zzfirst.
rm zzfirst.ab
rm zztemp*
#
# Isolate the DESCENT.SNG data.
split -b 1007619 descent.hog zztemp.
split -b 1007196 zztemp.aa zzmiddle.
rm zzmiddle.aa
#
# Isolate the DESCENT.HOG data from the Ctrl-Z
# character at the end of DESCENT.SNG to the end
# of the file.
cat zztemp.ab zztemp.ac zztemp.ad zztemp.ae zztemp.af zztemp.ag > zzlast
rm zztemp*
#
# Create a file with the proper DESCENT.SNG file
# length field.
echo $'\xAC\x03' > zztemp
split -b 2 zztemp zzlen.
rm zztemp
rm zzlen.ab
#
# Create the new DSECENT.HOG file through
# the end of the existing data in DESCENT.SNG.
cat zzfirst.aa zzlen.aa zzmiddle.ab > zzfirst
rm zzfirst.aa
rm zzlen.aa
rm zzmiddle.ab
#
# Delete the old DESCENT.HOG file since we
# have gathered the data we need.
chmod 777 descent.hog
rm descent.hog
#
# Generate files with the missing DESCENT.SNG data.
echo $'game08.hmp\x09rickmelo.bnk\x09rickdrum.bnk\x0D' > zzm08
echo $'game09.hmp\x09melodic.bnk\x09drum.bnk\x0D' > zzm09
echo $'game10.hmp\x09melodic.bnk\x09drum.bnk\x0D' > zzm10
echo $'game11.hmp\x09intmelo.bnk\x09intdrum.bnk\x0D' > zzm11
echo $'game12.hmp\x09melodic.bnk\x09drum.bnk\x0D' > zzm12
echo $'game13.hmp\x09intmelo.bnk\x09intdrum.bnk\x0D' > zzm13
echo $'game14.hmp\x09intmelo.bnk\x09intdrum.bnk\x0D' > zzm14
echo $'game15.hmp\x09melodic.bnk\x09drum.bnk\x0D' > zzm15
echo $'game16.hmp\x09melodic.bnk\x09drum.bnk\x0D' > zzm16
echo $'game17.hmp\x09melodic.bnk\x09drum.bnk\x0D' > zzm17
echo $'game18.hmp\x09intmelo.bnk\x09intdrum.bnk\x0D' > zzm18
echo $'game19.hmp\x09melodic.bnk\x09drum.bnk\x0D' > zzm19
echo $'game20.hmp\x09melodic.bnk\x09drum.bnk\x0D' > zzm20
echo $'game21.hmp\x09intmelo.bnk\x09intdrum.bnk\x0D' > zzm21
echo $'game22.hmp\x09hammelo.bnk\x09hamdrum.bnk\x0D' > zzm22
#
# Combine the original DESCENT.HOG data with the missing
# DESCENT.SNG data.
cat zzfirst zzm08 zzm09 zzm10 zzm11 zzm12 zzm13 zzm14 zzm15 zzm16 zzm17 zzm18 zzm19 zzm20 zzm21 zzm22 zzlast > descent.hog
chmod 555 descent.hog
rm zzm*
rm zzfirst
rm zzlast
