////////////////////////////////////////////////
/// View 3D Screen (3D game window with HUD) ///
////////////////////////////////////////////////

//hud variables.
int hud_StatusLeft, hud_StatusRight;
int hud_LightOff, hud_LightOn;
int hud_GasMask;

//Load Images, even if this is called multiple times the internal texture caching
//will avoid wasted memory.
void UI_View3D_OnEnter()
{
	//Load the UI elements.
	hud_StatusLeft  = UI_AddImage("STATUSLF.BM", 24, 31);
	hud_StatusRight = UI_AddImage("STATUSRT.BM", 24, 31);
	hud_LightOff    = UI_AddImage("LIGHTOFF.BM", -1, -1);
	hud_LightOn		= UI_AddImage("LIGHTON.BM" , -1, -1);
	hud_GasMask		= UI_AddImage("GMASK.BM"   , -1, -1);
}

void UI_View3D_OnExit()
{
	//Normally we unload the UI elements...
	//In this case the HUD is very common (used in every level) so we'll keep the HUD resources in memory.
	//Note: all textures are automatically freed on DarkXL shutdown, so we're not leaking memory.
}

void UI_View3D_OnRender()
{
	//Render the HUD elements, based on current shields, health and ammo for the selected weapon.
	//x0, y0, w, h, red, green, blue, alpha, horizontal alignment, vertical alignment.
	float v;

	int shields = Player_GetShields();	
	//Outter Shields
	int s = Math_Clamp(shields-100, 0, 100);
	v = 0.25f + 0.75f*s*0.01f;
	int[] oleftx = {29,29,23,16};
	int[] olefty = {35,29,20,20};
	UI_RenderPolygon(4, oleftx, olefty, 0.0, v, 0.0, 1.0, UI_Align_Left, UI_Align_Bottom);
	int[] omid0x = {37,41,29,29};
	int[] omid0y = {38,32,28,35};
	UI_RenderPolygon(4, omid0x, omid0y, 0.0, v, 0.0, 1.0, UI_Align_Left, UI_Align_Bottom);
	int[] omid1x = {41,41,54,57};
	int[] omid1y = {38,32,27,35};
	UI_RenderPolygon(4, omid1x, omid1y, 0.0, v, 0.0, 1.0, UI_Align_Left, UI_Align_Bottom);
	int[] orightx = {51,57,69,60};
	int[] orighty = {29,35,20,20};
	UI_RenderPolygon(4, orightx, orighty, 0.0, v, 0.0, 1.0, UI_Align_Left, UI_Align_Bottom);
	
	//Inner Shields
	s = Math_Clamp(shields, 0, 100);
	v = 0.25f + 0.75f*s*0.01f;
	UI_RenderRect(35, 27, 14, 4, 0.0, v, 0.0, 1.0, UI_Align_Left, UI_Align_Bottom);
	int[] ileftx = {34,35,29,22};
	int[] ilefty = {31,25,19,19};
	UI_RenderPolygon(4, ileftx, ilefty, 0.0, v, 0.0, 1.0, UI_Align_Left, UI_Align_Bottom);
	int[] irightx = {61,54,48,49};
	int[] irighty = {19,19,25,31};
	UI_RenderPolygon(4, irightx, irighty, 0.0, v, 0.0, 1.0, UI_Align_Left, UI_Align_Bottom);

	//Health
	int h = Player_GetHealth();
	v = 0.25f + 0.75f*h*0.01f;
	UI_RenderRect(34, 12, 16, 16, v, v*0.25, 0.0, 1.0, UI_Align_Left, UI_Align_Bottom);
	
	//Battery power lights.
	int energy = Player_GetEnergy();
	v = 0.25f + 0.75f*Math_Saturate(energy*0.05f);
	UI_RenderRect(-48, 26, 6, 4, 0.0, v, 0.0, 1.0, UI_Align_Right, UI_Align_Bottom);
	
	v = 0.25f + 0.75f*Math_Saturate((energy-20)*0.05f);
	UI_RenderRect(-40, 30, 6, 4, 0.0, v, 0.0, 1.0, UI_Align_Right, UI_Align_Bottom);
	
	v = 0.25f + 0.75f*Math_Saturate((energy-40)*0.05f);
	UI_RenderRect(-32, 32, 6, 4, 0.0, v, 0.0, 1.0, UI_Align_Right, UI_Align_Bottom);
	
	v = 0.25f + 0.75f*Math_Saturate((energy-60)*0.05f);
	UI_RenderRect(-23, 30, 6, 4, 0.0, v, 0.0, 1.0, UI_Align_Right, UI_Align_Bottom);
	
	v = 0.25f + 0.75f*Math_Saturate((energy-80)*0.05f);
	UI_RenderRect(-16, 26, 6, 4, 0.0, v, 0.0, 1.0, UI_Align_Right, UI_Align_Bottom);
	
	//Image Handle, x0, y0, intensity, horizontal alignment, vertical alignment.
	UI_RenderImage( hud_StatusLeft,  0, 0, 1.0, UI_Align_Left,  UI_Align_Bottom  );
	UI_RenderImage( hud_StatusRight, 0, 0, 1.0, UI_Align_Right, UI_Align_Bottom );
	
	//Render the light.
	int hudLight = hud_LightOff;
	if ( Player_IsEffectActive(PLAYER_FX_HEADLIGHT) )
	{
		hudLight = hud_LightOn;
	}
	UI_RenderImage( hudLight, -24, 37, 1.0, UI_Align_Right, UI_Align_Bottom  );
	
	//Render the gas mask.
	if ( Player_IsEffectActive(PLAYER_FX_GASMASK) )
	{
		UI_RenderImage( hud_GasMask, 0, 0, 1.0, UI_Align_Center, UI_Align_Bottom );
	}
	
	//Render Ammo text.
}

void UI_View3D_OnUpdate()
{
}

void UI_View3D_OnKey(int key, int msg)
{
	if ( msg == MSG_KEY_DOWN )
	{
		//Esc key should bring up the ESC Menu.
		if ( key == UI_GetVirtualKey(KEY_ESC) )
		{
			//UIFLAG_OVERLAY means that this UI is rendered over the current screen with an
			//optional special FX.
			UI_PushScreen("UI_EscMenu", UIFLAG_OVERLAY, UI_BCKGRND_FX_GRAYSCALE);
		}
		else if ( key == UI_GetVirtualKey(KEY_F1) )	//F1 Key brings up the PDA.
		{
			//UIFLAG_NONE makes this fullscreen, which means the current screen is not rendered.
			UI_PushScreen("UI_PDA", UIFLAG_NONE, UI_BCKGRND_FX_NONE);
		}
	}
}
