/* ------------------------------------------------------------------------ */
/*                                                                          */
/*   TITLE       : DEMOVMP1.C (MSC Version)                                 */
/*                                                                          */
/*   DESCRIPTION :                                                          */
/*       This program demonstrates how to perform voice out using the       */
/*       SGVOICEM.LIB library. The voice out is using the Conventional      */
/*       memory method.                                                     */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include  <io.h>
#include  <dos.h>
#include  <bios.h>
#include  <stdio.h>
#include  <conio.h>
#include  <fcntl.h>
#include  <string.h>
#include  <stdlib.h>

#include  "sgsdk.h"
#include  "sgc.h"

/* Function Prototypes */
char far *LoadFile(char *szFilename);
int OutputVoice (char far *lpBuf);


main()
{
    char     far *lpVoiceBuf;
    unsigned version_number;
    int      iDSPPort=0x220, iIRQ=7, iDMA=1;


    /* Display SG SDK version number */
    version_number = sgGetVocLibVersion();
    printf("Sound Galaxy Developer Kit, ");
    printf("SGVOICEM Library Version ");
    printf("%d.%02d\n\n", (version_number>>8) & 0xff, version_number & 0xff);

    /* set to Sound Blaster mode */
    if (!sgSetMode(SB8MODE))
	printf("Set to Sound Blaster compatible mode.\n");

    /***
       Insert BLASTER environment and CARD detection here if desired;
       otherwise, use the configuration program for Sound Galaxy cards
       to set to the desired settings

       Set global variables to the desired IO address, IRQ and DMA channel
       Remember to use the supplied configuration program to configure
       your sound card
    ***/
    printf("\nPlease wait...acquiring card settings...\n");

    iDSPPort = TestBaseAddr();
    if (iDSPPort<0x220 || iDSPPort>0x240)
    {
	printf("Wrong base I/O address setting: %d\n", iDSPPort);
	printf("Please use configuration utility.\n");
	exit(1);
    }
    sgSetBaseAddress(iDSPPort);

    iIRQ = sg_scan_int();
    if (iIRQ<=0)
    {
	printf("Wrong IRQ setting: %d\n", iIRQ);
	printf("Please use configuration utility.\n");
	exit(1);
    }
    sgSetIRQ(iIRQ);

    iDMA = sg_test_dma();
    if (iDMA<0)
    {
	printf("Wrong DMA setting: %d\n", iDMA);
	printf("Please use configuration utility.\n");
	exit(1);
	
    }
    sgSetDMA(iDMA);

    printf("DSP Port Address = 0x%x\n", iDSPPort);
    printf("IRQ              = %d\n", iIRQ);
    printf("DMA Channel      = %d\n", iDMA);

    // set volume 
    sgDSPAux_SetVolume(MASTERVOL,12,12);
    sgDSPAux_SetVolume(VOICEVOL,12,12);

    if (!sgDSPvm_init())
	{
	sgDSPvm_speaker(0);

	lpVoiceBuf = LoadFile("DEMO.VOC");
	if (lpVoiceBuf)
		{
	    OutputVoice(lpVoiceBuf);
	    _dos_freemem(FP_SEG(lpVoiceBuf));
		}

	sgDSPvm_terminate();
	}
	else
	printf ("Error on library initialization.\n");
	return (0);
}

/* ------------------------------------------------------------------------ */
/*  USAGE:                                                                  */
/*                                                                          */
/*   char far *LoadFile (char *szFilename)                                  */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Load file into memory.                                             */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       szFileName :- File to be loaded.                                   */
/*                                                                          */
/*   EXIT:                                                                  */
/*       Pointer to the loaded memory buffer if successfull, else returns   */
/*       NULL pointer.                                                      */
/*                                                                          */
/* ------------------------------------------------------------------------ */

char far *LoadFile (char *szFilename)
{
    char        far *lpFileBuf=0, far *lpTmpPtr;
    int         Handle;
    unsigned    wByteRead;
    long        lFileSize;
    int         f_off;
    int         f_seg;    
    /* open file */
    if (!_dos_open(szFilename,O_RDONLY,&Handle))
    {
	lFileSize = filelength(Handle);

	if (!_dos_allocmem((unsigned)((lFileSize+15) >> 4),&wByteRead))
	{
	    FP_SEG(lpFileBuf) = wByteRead;
	    FP_OFF(lpFileBuf) = 0;

	    lpTmpPtr = lpFileBuf;
	    f_off=FP_OFF(lpFileBuf);
	    f_seg=FP_SEG(lpFileBuf);   
	    do
	    {
		if (!_dos_read(Handle,lpTmpPtr,0x8000,&wByteRead))
		{
		    if ( !(FP_OFF(lpTmpPtr) += wByteRead) )
			FP_SEG(lpTmpPtr) += 0x1000;
		}
		else
		{
		    printf("Load file error.\n");
		    wByteRead = 0;
		    lpFileBuf = 0;
		    _dos_freemem(FP_SEG(lpFileBuf));
		}

	    } while (wByteRead == 0x8000);
	}
	else
	    printf("Memory allocation error.\n");

	_dos_close(Handle);
    }
    else
	printf("Open %s fails.\n",szFilename);

    return(lpFileBuf);
}


/* ------------------------------------------------------------------------ */
/*  USAGE:                                                                  */
/*                                                                          */
/*   int OutputVoice (char far *lpBuf)                                      */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Output voice from a memory buffer. The user is allowed to control  */
/*       the voice output from the keyboard.                                */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       lpBuf :- Memory buffer to be output.                               */
/*                                                                          */
/*   EXIT:                                                                  */
/*       Non-zero if successful, else returns 0                             */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#pragma optimize("l", off)
int OutputVoice (char far *lpBuf)
{
    unsigned    wKey;
    int         done;


    done = 0;

    // Sub Menu
    printf("\nUse the following commands during playback:\n");
    printf("\nS: Stop output");
    printf("\nP: Pause output");
    printf("\nC: Resume output");
    printf("\n\nPress any key to play...\n\n");
    getch();

    lpBuf += ((VOCHDR far *)lpBuf)->voice_offset;

    /* turn on speaker */
    sgDSPvm_speaker(1);

#ifdef DEBUG
    //printf("Voice Status0 = %d\t", sg_voice_status);
#endif

    if (sgDSPvm_output(lpBuf) == NO_ERROR)
    {

#ifdef DEBUG
	//printf("Voice Status1 = %d\t", sg_voice_status);
#endif

	done = 1;

	/* loop until voice stop */
	while (sg_voice_status)
	{

#ifdef DEBUG
	    //printf("Voice Status2 = %d\t", sg_voice_status);
#endif

	    if (_bios_keybrd(_KEYBRD_READY))
	    {
		wKey = _bios_keybrd(_KEYBRD_READ);
		if (wKey)
		{
		    switch(toupper(wKey & 0xff))
		    {
			case 0x1b:
			case 'S' :
			    sgDSPvm_stop();
			    break;
			case 'P' :
			    sgDSPvm_pause();
			    break;
			case 'C' :
			    sgDSPvm_continue();
			    break;
			default:
			    break;
		    }
		}
	    }
	}
    }

    /* turn off speaker */
    sgDSPvm_speaker(0);

    return (done);
}
#pragma optimize("l", on)

/* EOF: DEMOVMP1.C */
