//***************************************************************************
//
// Copyright (c) 1991-93 Sierra Semiconductor Corp.
//
// FILE:    recwave.c
//
// LANGUAGE:
//          Microsoft C/C++ Version 7.0
//
// DESCRIPTION:
//
//          A stand alone utility that records one Microsoft Wave (.WAV) file
//
//          Compile:  cl /AL /c /Ox /Zp recwave.c
//          Link:     link recwave,,,aria_l;
//
// Aria is a trademark of Sierra Semiconductor Corp.
//
//***************************************************************************

// $Header:   F:\projects\ariai\dos\archives\recwave.c_v   2.0   08 Dec 1993 14:01:54   golds  $
// $Log:   F:\projects\ariai\dos\archives\recwave.c_v  $
// 
//    Rev 2.0   08 Dec 1993 14:01:54   golds
// Recompiled with API libraries version 2.5 (Fixes stereo ADPCM problem in
// older ROMs - ver. 1.6).
// 
//    Rev 1.9   08 Nov 1993 15:46:56   golds
// Fixed bug with recording mono when monitor is off,
// Changed recording level settings from 1-32767 to 1-127.
// 
//    Rev 1.8   03 Sep 1993 10:20:06   golds
// Changed mixer setup for SD8026 boards to use new API functions
// Recompiled with API library version 2.2
// 
//    Rev 1.7   13 Aug 1993 09:12:26   golds
// Added 'fact' chunk generation as specified by Microsoft
// 
//    Rev 1.6   13 Jul 1993 14:30:58   golds
// Fixed bug in write of ADPCM format
// 
//    Rev 1.0   24 Jun 1993 12:50:44   golds
// Initial revision.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#ifdef TURBOC
#include <alloc.h>
#else
#include <malloc.h>
#endif
#include <dos.h>

#include "aria.h"

#define CR  13

#define READBUFFERSIZE     63488L
#define HALFBUFFERSIZE     ((DWORD)(READBUFFERSIZE>>1))
#define WAVE_FORMAT_PCM          0x0001
#define WAVE_FORMAT_ALAW         0x0006
#define WAVE_FORMAT_MULAW        0x0007
#define WAVE_FORMAT_SIERRA_ADPCM 0x0013

#define mmioFOURCC( ch0, ch1, ch2, ch3 )                                \
                ( (DWORD)(BYTE)(ch0) | ( (DWORD)(BYTE)(ch1) << 8 ) |    \
                ( (DWORD)(BYTE)(ch2) << 16 ) | ( (DWORD)(BYTE)(ch3) << 24 ) )

typedef DWORD FOURCC;      // A four character code
#define FOURCC_RIFF        mmioFOURCC('R', 'I', 'F', 'F')
#define FOURCC_WAVE        mmioFOURCC('W', 'A', 'V', 'E')
#define FOURCC_fmt         mmioFOURCC('f', 'm', 't', ' ')
#define FOURCC_data        mmioFOURCC('d', 'a', 't', 'a')
#define FOURCC_fact        mmioFOURCC('f', 'a', 'c', 't')

#define BREAKINT  0x1B     // Control break interrupt
#define CTRLCINT  0x23     // Control C interrupt

// global variables

struct headerstruct        // RIFF WAVE file header format
   {
   FOURCC   ckID1;
   DWORD    size1;
   FOURCC   ckID2;
   FOURCC   ckID3;
   DWORD    size3;
   WORD     formatTag;
   WORD     nChannels;
   DWORD    nSamplesPerSec;
   DWORD    nAvgBytesPerSec;
   WORD     nBlockAlign;
   WORD     nBitsPerSample;
   } header;

struct headerstruct2
   {
   WORD     cbExtraSize;
   WORD     wRevision;
   } header2;

struct headerstruct3
   {
   FOURCC   ckID;
   DWORD    size;
   // Data goes here
   } header3;

struct headerstruct4
   {
   FOURCC   ckID;
   DWORD    size;
   DWORD    dwSampleLength;
   } header4;

ARIACAPS AriaCap;    // Aria capabilities structure
FILE   *samplefile;  // Sample file (.WAV)
HPBYTE buffer;       // Pointer to sample buffer
WORD   bsize;        // Size of block used to read data
DWORD  size=0L;      // Size of current buffer
DWORD  k;
DWORD  pos;
DWORD  bufpos;
DWORD  offset;
WORD   formatRate;
WORD   ch=0;
WORD   ext=0;
WORD   extmon=0;
WORD   aux=0;
WORD   auxmon=0;
WORD   lvol=0;
WORD   rvol=0;
WORD   source=EXTREC;
WORD   compress=0;
DWORD  rates[]   = {11025L,  22050L,  44100L,  32000L,  16000L,  8000L};
WORD   formats[] = {SR11KHZ, SR22KHZ, SR44KHZ, SR32KHZ, SR16KHZ, SR8KHZ};
VOID (interrupt FAR *oldctrlchandler)();
VOID (interrupt FAR *oldbreakhandler)();

extern ARIAWAVE waveCh[];  // Audio channel status
extern WORD wDSPpart;

BOOL getval (WORD FAR *, WORD, WORD);
VOID errexit (short);
VOID interrupt FAR newctrlchandler (VOID);
VOID interrupt FAR newbreakhandler (VOID);


main (short argc, LPSTR argv[])
   {
   WORD i, j;

   if (argc == 1)
      {
      printf ("\nUsage:  RECWAVE <sfile>\n\n");
      printf (  "        sfile = sound file in Microsoft Wave format (.WAV)\n");
      exit (1);
      }
   if (argc == 3 && *argv[2] == '1')
      ch = 1;

   printf ("\nRECWAVE  Version 2.0");
   printf ("\nCopyright (c) 1991-93 Sierra Semiconductor Corp.\n");

   // Look for Aria board

   if (SystemInit (ARIA_SYNTH))
      {
      printf ("\nERROR - Aria board not found\n");
      exit (1);
      }

   if (GetInterrupt () < 0)
      {
      printf ("\nERROR - Aria board interrupt not found\n");
      exit (1);
      }

   // Get capabilities structure

   GetAriaCaps ((LPBYTE) &AriaCap);

   // Open sample file

   if ((samplefile = fopen (argv[1], "w+b")) == NULL)
      errexit (-1);

   // Allocate memory for buffer

   if ((buffer = malloc ((size_t) READBUFFERSIZE)) == NULL)
      errexit(-2);

   // Get sample format

   do
      {
      printf ("\n\nEnter sample format desired:\n");
      printf ("  (1)  8-bit,  mono\n");
      printf ("  (2)  8-bit,  stereo\n");
      printf ("  (3)  16-bit, mono\n");
      printf ("  (4)  16-bit, stereo\n");
      printf ("  (5)  4-bit,  ADPCM mono   (4:1)\n");
      printf ("  (6)  4-bit,  ADPCM stereo (4:1)\n");
      if (wDSPpart >= SC18026)
         {
         printf ("  (7)  8-bit,  Mu-Law mono\n");
         printf ("  (8)  8-bit,  Mu-Law stereo\n");
         printf ("  (9)  8-bit,  A-Law mono\n");
         printf ("  (10) 8-bit,  A-Law stereo\n");
         }
      printf ("\nSelect (1-%d, or <ESC> to exit): ", 
              (wDSPpart >= SC18026)? 10: 6);
      } while (!getval (&i, 1, (wDSPpart >= SC18026)? 10: 6));

   if (i <= 2 || i >= 7)
      header.nBitsPerSample = 8;
   else
      header.nBitsPerSample = 16;

   if (i & 1)  // odd numbers are mono
      header.nChannels = 1;
   else
      header.nChannels = 2;

   if (i == 5 || i == 6)
      {
      header.nBitsPerSample = 4;
      header2.cbExtraSize = 2;
      header2.wRevision = 0x0100;
      compress = 1;
      j = 2;
      }
   else if (i == 9 || i == 10)
      compress = 2;
   else if (i == 7 || i == 8)
      compress = 3;

   // Get sample rate

   if (compress != 1)
      do
         {
         printf ("\n\nEnter sample rate desired:\n");
         printf ("  (1) 11.025 KHz\n");
         printf ("  (2) 22.050 KHz\n");
         printf ("  (3) 44.100 KHz\n");
         printf ("  (4) 32.000 KHz\n");
         printf ("  (5) 16.000 KHz\n");
         printf ("  (6)  8.000 KHz\n");
         printf ("\nSelect (1-6, or <ESC> to exit): ");
         } while (!getval (&j, 1, 6));
   
   header.nSamplesPerSec = rates[j-1];
   formatRate = formats[j-1];
   if (compress == 1)
      header.nAvgBytesPerSec = (header.nSamplesPerSec*header.nChannels) >> 1;
   else
      header.nAvgBytesPerSec = header.nSamplesPerSec * header.nChannels *
                               (header.nBitsPerSample >> 3);
   // Set format

   SetAudioFormat ((UINT) (formatRate | (i-1)));

   // Get recording source

   do
      {
      printf ("\n\nEnter recording source desired:\n");
      printf ("  (1) External microphone\n");
      printf ("  (2) External line in\n");
      printf ("  (3) Auxiliary line in (CD-ROM)\n");
      printf ("\nSelect (1-3, or <ESC> to exit): ");
      } while (!getval (&i, 1, 3));

   source = MICROPHONE;
   switch (i)
      {
      case 1:
         ext = 1;
         break;

      case 2:
         ext = 0;
         if (MIXERCHIP)
            source = EXTERNAL;
         break;

      case 3:
         source = CDROMAUDIO;
         break;
      }

   // Get monitor select

   do
      {
      printf ("\n\nMonitor the input?\n");
      printf ("  (1) Yes\n");
      printf ("  (2) No\n");
      printf ("\nSelect (1, 2, or <ESC> to exit): ");
      } while (!getval (&j, 1, 2));

   if (j == 1)
      {
      if (i <= 2)
         extmon = 0x01;
      else
         auxmon = 0x01;
      }

   // Get volume levels

   if (header.nChannels == 1)
      {
      if (i <= 2)
         extmon |= 0x10;
      else
         auxmon |= 0x10;
      do
         {
         printf ("\n\nEnter input level (1 to 127): ");
         } while (!getval (&lvol, 1, 127));

      rvol = lvol;
      }
   else
      {
      do
         {
         printf ("\n\nEnter left channel input level  (1 to 127): ");
         } while (!getval (&lvol, 1, 127));
      do
         {
         printf ("\n\nEnter right channel input level (1 to 127): ");
         } while (!getval (&rvol, 1, 127));
      }
   lvol <<= 8;
   rvol <<= 8;

   // Send mixer levels

   SetMixerConfig ((UINT) source, (UINT) ext, (UINT) extmon, (UINT) aux, 
                   (UINT) auxmon);
   SetRecordingVolume ((UINT) source, (UINT) lvol, (UINT) rvol);

   // Write header

   header.ckID1 = FOURCC_RIFF;
   header.size1 = 0L;            // Will fill this in later
   header.ckID2 = FOURCC_WAVE;
   header.ckID3 = FOURCC_fmt;
   header.size3 = 0L;            // Will fill this in later
   header.formatTag = 0;
   header.nBlockAlign = header.nChannels * (header.nBitsPerSample >> 3);
   header3.ckID = FOURCC_data;
   header3.size = 0L;            // Will fill this in later
   fwrite (&header, 1, sizeof (struct headerstruct), samplefile);
   if (compress == 2 || compress == 3)
      fwrite (&header2, 1, 2, samplefile);
   else if (compress == 1)
      fwrite (&header2, 1, sizeof (struct headerstruct2), samplefile);
   if (compress)
      {
      header4.ckID = FOURCC_fact;
      header4.size = 4L;
      header4.dwSampleLength = 0L;
      fwrite (&header4, 1, sizeof (struct headerstruct4), samplefile);
      }
   fwrite (&header3, 1, sizeof (struct headerstruct3), samplefile);
   fflush (samplefile);

   printf ("\n\nReady to record, hit a key to start ...");
   while (kbhit())
      getch();
   while (!kbhit())
      ;
   getch ();

   DISABLE
   oldctrlchandler = GETVECT (CTRLCINT);
   oldbreakhandler = GETVECT (BREAKINT);
   SETVECT (CTRLCINT, newctrlchandler);
   SETVECT (BREAKINT, newbreakhandler);
   ENABLE

   // Start sample recording

   InstallAriaInt ();
   offset = 0L;
   StartRecording ((UINT) ch, (HPBYTE) buffer, READBUFFERSIZE, 0xFFFFFFFF);

   printf ("\rRecording...                                 \n");
   while ((pos = GetAudioPosition ((UINT) ch)) > 1024L)
      {
      bufpos = GetBufferPosition ((UINT) ch);
      if (kbhit ())
         {
         getch ();
         break;
         }
      printf ("pos = %ld\r", 0xFFFFFFFF - pos);
      if (bufpos > offset && bufpos <= (offset + HALFBUFFERSIZE))
         {
         // Write data and switch to other half of buffer

         bsize = fwrite (buffer + offset, 1,
                        (size_t) HALFBUFFERSIZE, samplefile);
         fflush (samplefile); // Ensures we write the data now

         size += bsize;
         if (bsize != HALFBUFFERSIZE)
            {
            // Write error occured, hard disk may be full

            bufpos = READBUFFERSIZE;
            offset = 0L;
            break;
            }

         // Adjust buffer offset pointer

         if (offset > 0L)
            offset = 0L;
         else
            offset = HALFBUFFERSIZE;
         }
      }
   StopRecording ((UINT) ch);
   SetMixerConfig ((UINT) source, (UINT) ext, 0, (UINT) aux, 0);

   // Write any remaining samples

   fwrite (buffer + offset, 1, (size_t) (READBUFFERSIZE-bufpos-offset),
           samplefile);
   size += (READBUFFERSIZE-bufpos-offset);
   printf ("pos = %ld\r", size);

   // Rewrite header

   rewind (samplefile);
   printf ("\nSaving data...");

   header.size1 = (size + sizeof (struct headerstruct) + 
                   sizeof (struct headerstruct3)) - 8L;
   if (compress)
      header.size1 += (sizeof (struct headerstruct2) + 
                       sizeof (struct headerstruct4));
   switch (compress)
      {
      case 1:
         header.formatTag = WAVE_FORMAT_SIERRA_ADPCM;
         header.size3 = 16L + sizeof (struct headerstruct2);
         break;
      case 2:
         header.formatTag = WAVE_FORMAT_ALAW;
         header.size3 = 18L;
         break;
      case 3:
         header.formatTag = WAVE_FORMAT_MULAW;
         header.size3 = 18L;
         break;
      default:
         header.formatTag = WAVE_FORMAT_PCM;
         header.size3 = 16L;
         break;
      }
      
   if (compress == 1)
      header.nBlockAlign = header.nChannels;
   else
      header.nBlockAlign = header.nChannels * (header.nBitsPerSample >> 3);
   header3.size = size;
   fwrite (&header, 1, sizeof (struct headerstruct), samplefile);
   if (compress == 2 || compress == 3)
      {
      fwrite (&header2, 1, 2, samplefile);
      header4.dwSampleLength = size;
      }
   else if (compress == 1)
      {
      fwrite (&header2, 1, sizeof (struct headerstruct2), samplefile);
      header4.dwSampleLength = size * 2;
      }
   if (compress)
      fwrite (&header4, 1, sizeof (struct headerstruct4), samplefile);
   fwrite (&header3, 1, sizeof (struct headerstruct3), samplefile);

   // Close sample file

   fclose (samplefile);

   // Make sure recording is stopped, so we don't remove the ISR too soon

   k = 100000L;
   while (k-- > 0L && waveCh[ch].status == RECORDING)
      _asm nop

   if (k == 0L)
      printf ("\nERROR - Could not turn off recording channel");

   DISABLE
   SETVECT (CTRLCINT, oldctrlchandler);
   SETVECT (BREAKINT, oldbreakhandler);
   ENABLE

   RemoveAriaInt ();

   if (SystemInit (DEFAULT_SYNTH))
      printf ("\nERROR - Could not reset system to default mode\n");

   printf ("\nAll done\n");

   exit (0);
   }


BOOL getval (WORD FAR *val, WORD low, WORD high)
   {
   char n;
   WORD i=0;

   *val = 0;
   while ((n = getch ()) != CR)
      {
      if (n == 27)
         errexit (0);
      else if (n < '0' || n > '9')
         return FALSE;
      i = (i * 10) + (n - '0');
      putch (n);
      }
   putch (n);
   if (i >= low && i <= high)
      {
      *val = i;
      return TRUE;
      }
   return FALSE;
   }


VOID errexit (short err)
   {
   SystemInit (DEFAULT_SYNTH);
   switch (err)
      {
      case 0:
         printf ("\n");
         exit (0);

      case -1:
         printf ("\nERROR - Invalid sound file specified\n");
         break;

      case -2:
         printf ("\nERROR - Not enough memory\n");
         break;
      }
   exit (1);
   }


VOID interrupt FAR newctrlchandler (VOID)
   {
   }


VOID interrupt FAR newbreakhandler (VOID)
   {
   }

