;****************************************************************************
;*
;*  Copyright (c) 1991-93 Sierra Semiconductor Corp.
;*
;*  FILE:          pcm_isr.asm
;*
;*  FUNCTION:      PCMproc
;*
;*  LANGUAGES:     Microsoft Macro Assembler 5.1
;*                 Borland Turbo Assembler 
;*
;*  DESCRIPTION:   Interrupt service routine (ISR) for digital audio
;*                 recording and playback. A method for direct I/O is shown.
;*
;*                 For Microsoft Macro Assembler 5.1
;*                 =================================
;*                 To assemble:  masm -ML pcm_isr.asm,,;  (for small model)
;*
;*                 add:
;*
;*                   -DMEDIUMMDL  for medium model
;*                   -DCOMPACTMDL for compact model
;*                   -DLARGEMDL   for large model
;*
;*                 For Borland Turbo Assembler
;*                 ===========================
;*                 To assemble:  tasm -ml aim.asm    (for small model)
;*
;*                 add:
;*
;*                   -dMEDIUMMDL  for medium model
;*                   -dCOMPACTMDL for compact model
;*                   -dLARGEMDL   for large model
;*
;*  NOTE:  This routine requires use of the Aria Interrupt Manager (AIM).
;*
;****************************************************************************
        TITLE  pcm_isr.asm

; $Header:   F:\projects\ariai\dos\archives\pcm_isr.asv   2.2   03 Sep 1993 10:10:26   golds  $
; $Log:   F:\projects\ariai\dos\archives\pcm_isr.asv  $
; 
;    Rev 2.2   03 Sep 1993 10:10:26   golds
; Minor changes to declaration of wave info structures
; 
;    Rev 2.0   24 Jun 1993 14:06:02   golds
; Initial revision.

IFDEF LARGEMDL
        .MODEL large
ELSEIFDEF COMPACTMDL
        .MODEL compact
ELSEIFDEF MEDIUMMDL
        .MODEL medium
ELSE
        .MODEL small
ENDIF

        .286

        INCLUDE aria.inc

        .DATA

        EXTRN  _packetSize    :WORD
        EXTRN  _chCount       :WORD
        EXTRN  _audioRate     :WORD
        EXTRN  _DSPstatus     :WORD
        EXTRN  _dspbase       :WORD        ; DSP base port - must be valid

        PUBLIC _waveCh
_waveCh ARIAWAVE 4 dup (<0,0,0,0,0,0,0>)

playing db 0
busy    db 0


        .CODE

        PUBLIC _PCMproc                    ; Wave interrupt entry point
_PCMproc PROC FAR

_WaveInt       LABEL BYTE
        mov    ax, @data
        mov    ds, ax                      ; set up ds register
	ASSUME ds:@data

        cmp    busy, 0                     ; is the routine busy?
        je     next                        ; yes,
        jmp    done                        ;   return
next:
        mov    busy, 1                     ; set busy flag
        sti                                ; enable interrupts

        mov    cx, MODE0_CHANNELS          ; check each channel
        mov    di, offset _waveCh
cycle1:
        cmp    ds:[di].audioPending, ON       ; ready to turn on?
        jne    next1
                                           ; yes,
        mov    ds:[di].audioPending, INACTIVE ;   reset pending flag
        cmp    ds:[di].status, INACTIVE       ;   is channel not inactive?
        jne    nextch                      ;     goto next channel
        jmp    next2
nextch:
        inc    _chCount                    ;   increment channel counter
        jmp    next2
next1:
        cmp    ds:[di].audioPending, OFF      ; ready to turn off?
        je     turnoff
        jmp    next2
turnoff:                                   ; yes,
        cmp    ds:[di].status, PLAYING        ;   is channel playing?
        jne    notplaying
                                           ;   yes,
        mov    ax, DSPPLAYSTOP             ;     send stop play command
        jmp    short next4
notplaying:                                ;   otherwise,
        mov    ax, DSPRECSTOP              ;     send stop record command
next4:
        cli
        sendDSP
        mov    ax, MODE0_CHANNELS
        sub    ax, cx
        sendDSP
        mov    ax, DSPTERMINATOR
        sendDSP
        sti

        mov    ds:[di].audioPending, INACTIVE ; reset pending flag
        mov    ds:[di].status, INACTIVE       ; reset status flag
        dec    _chCount                    ; decrement channel counter
next2:
        dec    cx
        jz     iszero

        add    di, CHSIZE
        jmp    cycle1                      ; process next channel

        ; Set up Aria DSP Control port
iszero:
        mov    ax, INTPC_DSPWR OR INTDSP_PCWR OR C2MODE
        or     ax, _audioRate
        mov    dx, _dspbase
        add    dx, DSPCONTROL
        out    dx, ax

        mov    playing, 0

        mov    cx, MODE0_CHANNELS
        mov    di, offset _waveCh
cycle2:                                    ; for each active channel:
        mov    ax, ds:[di].status
        cmp    ax, INACTIVE
        jne    isactive

        jmp    next8
isactive:
        cmp    ax, PLAYING                 ; if playing,
        jne    next6

        ; Set up Aria DSP destination address for playback

        cli
        mov    ax, PLAY_OFFSET             ;   set FIFO address for playback
        setFIFOaddr                        ;     buffer
        inc    dx
        inc    dx

        ; Send packet

        mov    playing, 1                  ;   set playing flag

        push   ds
        push   cx
        mov    cx, _packetSize
        normalize                          ;   normalize sample pointer and
                                           ;     return sample address (ds:si)
        cld
        rep    outsw                       ;   send data packet

        jmp    short next7
next6:                                     ; else,
        ; Set up Aria DSP source address for recording

        cli
        mov    ax, REC_OFFSET              ;   set FIFO address for record
        setFIFOaddr                        ;     buffer
        inc    dx
        inc    dx

        ; Receive packet

        push   ds
        push   cx
        mov    cx, _packetSize
        normalize                          ; normalize sample pointer and
                                           ;   return sample address (ds:si)
        push   es                          ; push es
        mov    bx, di                      ; save di in bx
        mov    di, si                      ; put address in es:di
        mov    ax, ds
        mov    es, ax

        cld
        rep    insw                        ; receive data packet

        mov    di, bx                      ; restore di
        pop    es                          ; pop es
next7:
        pop    cx
        pop    ds
        sti

        mov    ax, _packetSize
        shl    ax, 1
                                           ; if less than a packet left,
        cmp    WORD PTR ds:[di].audioSize+2, 0
        ja     endofsamp
        cmp    WORD PTR ds:[di].audioSize, ax
        ja     endofsamp

        ; Last packet in sample
                                           ;   adjust pointer
        mov    ax, WORD PTR [di].audioSize
        add    WORD PTR [di].audioPtr, ax

        xor    ax, ax                      ;   adjust size and buffer offset
        mov    WORD PTR ds:[di].audioSize, ax
        mov    WORD PTR ds:[di].audioSize+2, ax
        mov    WORD PTR ds:[di].bufferOffset, ax
        mov    WORD PTR ds:[di].bufferOffset+2, ax
        mov    ds:[di].audioPending, OFF      ;   set pending OFF flag
        jmp    short next5
endofsamp:                                 ; else if end of sample,
        cmp    WORD PTR ds:[di].bufferOffset+2, 0
        ja     nextpacket
        cmp    WORD PTR ds:[di].bufferOffset, ax
        ja     nextpacket

        ; Reset pointer to start of buffer
                                           ;   adjust size
        sub    WORD PTR ds:[di].audioSize, ax
        sbb    WORD PTR ds:[di].audioSize+2, 0
                                           ;   reset pointer
        mov    ax, WORD PTR ds:[di].audioStart
        mov    WORD PTR ds:[di].audioPtr, ax
        mov    ax, WORD PTR ds:[di].audioStart+2
        mov    WORD PTR ds:[di].audioPtr+2, ax
                                           ;   adjust buffer offset
        mov    ax, WORD PTR ds:[di].bufferSize
        mov    WORD PTR ds:[di].bufferOffset, ax
        mov    ax, WORD PTR ds:[di].bufferSize+2
        mov    WORD PTR ds:[di].bufferOffset+2, ax

;;      jmp    short next5

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Duplicate code follows for speed enhancement                          ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                                                                         ;;
        ; Normalize the sample pointer                                   ;;
                                                                         ;;
        push   ds                                                        ;;
        normalize                                                        ;;
        pop    ds                                                        ;;
                                                                         ;;
        add    di, CHSIZE                                                ;;
        dec    cx                                                        ;;
        jz     next9                                                     ;;
                                                                         ;;
        jmp    cycle2                      ; goto next channel           ;;
                                                                         ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

nextpacket:                                ; else,
        ; Set up for next packet
                                           ;   adjust pointer
        add    WORD PTR ds:[di].audioPtr, ax
                                           ;   adjust buffer offset
        sub    WORD PTR ds:[di].bufferOffset, ax
        sbb    WORD PTR ds:[di].bufferOffset+2, 0
                                           ;   adjust size
        sub    WORD PTR ds:[di].audioSize, ax
        sbb    WORD PTR ds:[di].audioSize+2, 0
next5:
        ; Normalize the sample pointer

        push   ds
        normalize
        pop    ds
next8:
        add    di, CHSIZE
        dec    cx
        jz     next9

        jmp    cycle2                      ; goto next channel
next9:
        cmp    playing, 0                  ; if playing,
        je     fin

        cli                                ;    disable interrupts
        mov    ax, DSPTRANSFER             ;    send packet transfer command
        sendDSP
        mov    ax, DSPTERMINATOR
        sendDSP
        sti                                ;    enable interrupts
fin:
        cli
        mov    busy, 0                     ; clear busy flag
done:
        ret                                ; return to AIM

_PCMproc ENDP

        END

