//***************************************************************************
//
// Copyright (c) 1992-93 Sierra Semiconductor Corp.
//
// FILE:    playwave.c
//
// LANGUAGE:
//          Microsoft C/C++ Version 7.0
//
// DESCRIPTION:
//
//          A utility to test for the Aria board and report on set up
//
//          Compile:  cl /c /Ox /Zp ariatest.c
//          Link:     link ariatest,,,aria_s;
//
// Aria, Aria Synthesizer and Aria Listener are trademarks of Sierra
//  Semiconductor Corp.
// QSound is a trademark of Archer Communications
// Sound Blaster is a trademark of Creative Labs Inc.
//
//***************************************************************************

// $Header:   F:\projects\ariai\dos\archives\ariatest.c_v   2.5   27 Oct 1993 13:23:00   golds  $
// $Log:   F:\projects\ariai\dos\archives\ariatest.c_v  $
// 
//    Rev 2.5   27 Oct 1993 13:23:00   golds
// Added explicit hardware interrupt checking, instead of calling GetInterrupt().
// 
//    Rev 2.4   03 Sep 1993 10:14:04   golds
// Recompiled with API library version 2.2
// 
//    Rev 2.3   24 Jun 1993 12:50:50   golds
// Initial revision.

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "aria.h"

#define ROMOPTIONS   10

ARIACAPS AriaCap;
WORD dspintr = DEF_ARIAINT;   // Aria DSP interrupt number
WORD gwIntCount;              // Interrupt counter
WORD romcodes[ROMOPTIONS] = {SC18050, SC18051, SC18052, SC18053, SC18054, 
                             SC18055, SC18056, SC18057, SC18058, SC18059};
WORD romparts[ROMOPTIONS] = {18050, 18051, 18052, 18053, 18054,
                             18055, 18056, 18057, 18058, 18059};

short TestInterrupt (VOID);
short GenerateIntr (VOID);
static VOID interrupt FAR IntTest1 (VOID);
static VOID interrupt FAR IntTest2 (VOID);
static VOID interrupt FAR IntTest3 (VOID);

extern short DSPstatus;

main ()
   {
   short status, intr;
   WORD  aria=FALSE;
   UINT  x, n;

   printf ("\nARIATEST - Aria Board Test Program (Version 2.5)\n");
   printf ("Copyright (c) 1992-93 Sierra Semiconductor Corp.\n");

   status = SystemInit (DEFAULT_SYNTH);
   GetAriaCaps ((LPBYTE) &AriaCap);
   if (AriaCap.DSPapps & PCM_MASK)
      {
      status = SystemInit (ARIA_SYNTH);
      if (status < 0)
         printf ("\nSelecting Aria Wave Synthesis, status = %d\n", status);
      aria = TRUE;
      }

   switch (status)
      {
      case 0:
         printf ("\nAria port no.   = %03Xh", dspbase);

         printf ("\nAria interrupt ");
         if (!aria)
            printf (" = N/A");
         else if ((intr = TestInterrupt ()) < 0)
            printf ("not found!");
         else
            printf (" = IRQ %d", intr);

         x = getMem16 (DSP_PARTCODE);
         printf ("\nDSP part no.    = SC%05u", 18025 + x);

         x = GetDSPVersion ();
         printf ("\nDSP version no. = %d.%02d", x >> 8, x & 0xFF);

         x = getMem16 (ROM_PARTCODE);
         printf ("\nROM part no.    = ");

         for (n = 0; n < ROMOPTIONS; ++n)
            if (romcodes[n] == x)
               {
               printf ("SC%d", romparts[n]);
               x = 0;
               break;
               }
         if (x)
            printf ("UNKNOWN");
                                  
         x = GetVersion ();
         if (x == 0 || x == 0xFFFF)
            printf ("\nERROR reading ROM version number!");
         else
            printf ("\nROM version no. = %d.%02d", x >> 8, x & 0xFF);

         printf ("\nROM size        = %d Kbytes", AriaCap.ROMsize);
         printf ("\nROM width       = %d bit", AriaCap.ROMwidth);

         switch (AriaCap.mixerType)
            {
            case NO_MIXER:
               printf ("\nMixer type      = NONE");
               break;
            case DISCRETEMIX1:
            case DISCRETEMIX2:
            case DISCRETEMIX3:
               printf ("\nMixer type      = Discrete analog #%d",
                       AriaCap.mixerType);
               break;
            case MIXERCHIP1:
               printf ("\nMixer type      = SC18075");
               break;
            default:
               printf ("\nMixer type      = UNKNOWN");
               break;
            }
         printf ("\nRAM size        = %d Kwords", AriaCap.RAMsize);
         printf ("\nADC resolution  = %d bit", AriaCap.ADCbits);
         printf ("\nPhone interface = ");
         if (AriaCap.phoneInterface)
            printf ("Yes\n");
         else
            printf ("No\n");

         printf ("\nDSP Applications Available:");
         if (AriaCap.DSPapps & SB_MASK)
            printf ("\n   Sound Blaster(TM) emulation");
         if (AriaCap.DSPapps & PCM_MASK)
            printf ("\n   Aria PCM audio recording and playback");
         if (AriaCap.DSPapps & SYNTH_MASK)
            printf ("\n   Aria Synthesizer(TM)");
         if (AriaCap.DSPapps & PHONE_MASK)
            printf ("\n   Telephone interface");
         if (AriaCap.RAMsize >= 40)
            {
            if (AriaCap.DSPapps & SPEECH_MASK)
               printf ("\n   Aria Listener(TM)");
            if (AriaCap.DSPapps & REVERB_MASK)
               printf ("\n   Reverb effects");
            if (AriaCap.DSPapps & QSOUND_MASK)
               printf ("\n   QSound(TM) Virtual Audio");
            }
         printf ("\n");

         if (aria)
            SystemInit (DEFAULT_SYNTH);
         break;

      case -1:
         printf ("\nAria DSP not responding!\n");
         break;

      case -2:
         printf ("\nAria board could not initialize!\n");
         break;

      case -3:
         printf ("\nAria board not found!\n");
         break;

      default:
         printf ("\nUnknown status!\n");
         break;
      }
   exit (0);
   }

//***************************************************************************
//
// FUNCTION:      short TestInterrupt (VOID)
//
// DESCRIPTION:   Function to detect and return Aria system IRQ.
//
// PARAMETERS:    None
//
// RETURNS:       Interrupt request number (10, 11 or 12)
//                -1 = not in Aria Wave Synthesis mode
//                -2 = unable to detect interrupt
//
//***************************************************************************

short TestInterrupt (VOID)
   {
   WORD i;
   BYTE oldctrl;
   VOID (interrupt FAR *oldInt1)();   // Old interrupt 10 vector pointer
   VOID (interrupt FAR *oldInt2)();   // Old interrupt 11 vector pointer
   VOID (interrupt FAR *oldInt3)();   // Old interrupt 12 vector pointer

   if (INPW (DSPSTATUS) & C2MODE)
      {
      // Install dummy IRQ handlers to detect interrupt

      oldInt1 = GETVECT (ARIAINT1 + 0x68);
      oldInt2 = GETVECT (ARIAINT2 + 0x68);
      oldInt3 = GETVECT (ARIAINT3 + 0x68);
      DISABLE
      SETVECT (ARIAINT1 + 0x68, IntTest1);
      SETVECT (ARIAINT2 + 0x68, IntTest2);
      SETVECT (ARIAINT3 + 0x68, IntTest3);
      ENABLE

      // Enable all possible interrupts

      oldctrl = INP (INTCTRLR1);
      OUTP (INTCTRLR1, oldctrl & ~( (1 << (ARIAINT1 - 8)) |
                                    (1 << (ARIAINT2 - 8)) |
                                    (1 << (ARIAINT3 - 8)) ));

      // Force board to generate an interrupt

      dspintr = 0;
      gwIntCount = 0;
      GenerateIntr ();

      for (i = 0; i < SYSTEM_WAIT; ++i)   // Time delay to allow interrupt
         {
         if (dspintr)
            break;
         INPW (DSPSTATUS);
         INPW (DSPSTATUS);
         }

      // Restore original IRQ mask

      OUTP (INTCTRLR1, oldctrl);

      // Restore original interrupts

      DISABLE
      SETVECT (ARIAINT1 + 0x68, oldInt1);
      SETVECT (ARIAINT2 + 0x68, oldInt2);
      SETVECT (ARIAINT3 + 0x68, oldInt3);
      ENABLE

      if (dspintr && gwIntCount == 1)
         OUTP (INTCTRLR1, oldctrl | (1 << (dspintr - 8)));
      else
         {
         dspintr = DEF_ARIAINT;
         return -2;
         }

      return (short) dspintr;
      }

   return -1;
   }


//***************************************************************************
//
// FUNCTION:      short GenerateIntr (VOID)
//
// DESCRIPTION:   Function to force DSP to generate a PC interrupt
//
// PARAMETERS:    none
//
// RETURNS:       0 = interrupt generated
//               -1 = DSP not responding
//
//***************************************************************************

short GenerateIntr (VOID)
   {
   // Send command sequence

   DISABLE
   sendDSP (DSPGENPCINT);
   sendDSP (DSPTERMINATOR);
   ENABLE

   if (!DSPstatus)
      return -1;

   return 0;
   }

static VOID interrupt FAR IntTest1 (VOID)
   {
   dspintr = ARIAINT1;
   gwIntCount++;

   // End Of Interrupt

   OUTP (INTCTRLR1-1, 0x20);
   OUTP (INTCTRLR0-1, 0x20);
   }

static VOID interrupt FAR IntTest2 (VOID)
   {
   dspintr = ARIAINT2;
   gwIntCount++;

   // End Of Interrupt

   OUTP (INTCTRLR1-1, 0x20);
   OUTP (INTCTRLR0-1, 0x20);
   }


static VOID interrupt FAR IntTest3 (VOID)
   {
   dspintr = ARIAINT3;
   gwIntCount++;

   // End Of Interrupt

   OUTP (INTCTRLR1-1, 0x20);
   OUTP (INTCTRLR0-1, 0x20);
   }
