;****************************************************************************
;*
;*  Copyright (c) 1991-93 Sierra Semiconductor Corp.
;*
;*  FILE:          aria.inc
;*
;*  LANGUAGES:     Microsoft Macro Assembler 5.1
;*                 Borland Turbo Assembler 
;*
;*  DESCRIPTION:   Include file for aim.asm and pcm_isr.asm
;*
;****************************************************************************

; $Header:   F:\projects\ariai\dos\archives\aria.inv   2.2   03 Sep 1993 10:11:28   golds  $
; $Log:   F:\projects\ariai\dos\archives\aria.inv  $
; 
;    Rev 2.2   03 Sep 1993 10:11:28   golds
; Minor changes to declaration of wave info structures
; 
;    Rev 2.0   24 Jun 1993 14:06:32   golds
; Initial revision.

; PC write (data and control register offsets)

DSPDATA         EQU  0          ; DSP data port offset
DSPCONTROL      EQU  2          ; DSP control port offset
DMAADDRESS      EQU  4          ; DMA address port offset
DMADATA         EQU  6          ; DMA data port offset

DSPSTATUS       EQU  2          ; DSP status port offset

; ISR Application IDs

PCM_ID          EQU  0          ; PCM digital audio
SYNTH_ID        EQU  2          ; Aria synthesis
PHONE_ID        EQU  4          ; Telephone interface
SPEECH_ID       EQU  5          ; Speech Recognition

MODE0_CHANNELS  EQU  4          ; Number of audio playback channels in
                                ;   playback mode 0
ON              EQU  1
OFF             EQU  2

DSPBASE1        EQU  280h       ; Alternate DSP base ports
DSPBASE2        EQU  290h
DSPBASE3        EQU  2A0h
DSPBASE4        EQU  2B0h

DEF_DSPBASE     EQU  DSPBASE2   ; Default DSP base port

DMACHAN5        EQU  5          ; Alternate Aria DMA channels
DMACHAN6        EQU  6

DEF_DMACHAN     EQU  DMACHAN5   ; Default Aria DMA channel

DEF_PACKETSIZE  EQU  512        ; Default transfer packet size

INTPC_DSPRD     EQU  0001h      ; Interrupt PC on DSP read
INTPC_DSPWR     EQU  0002h      ; Interrupt PC on DSP write
INTDSP_PCRD     EQU  0004h      ; Interrupt DSP on PC read
INTDSP_PCWR     EQU  0008h      ; Interrupt DSP on PC write
INTPC_DMADONE   EQU  0010h      ; Interrupt PC on DMA completion
SAMP_RATE       EQU  0060h      ; Sample rate mask
 SAMP_44K       EQU  0000h      ;    44.10 kHz
 SAMP_32K       EQU  0020h      ;    31.50 kHz
 SAMP_22K       EQU  0040h      ;    22.05 kHz
 SAMP_16K       EQU  0060h      ;    15.75 kHz
C2MODE          EQU  0080h      ; Aria Wave Synthesis select
DSP_RESET       EQU  0100h      ; Reset DSP
DMA_DSPTOPC     EQU  0200h      ; DMA direction - DSP to PC
DMA_XFR         EQU  0400h      ; Initiate DMA transfer
ADC_SRC_AUX     EQU  0800h      ; ADC record source select
ADC_STEREO      EQU  1000h      ; ADC mono/stereo select
ADC_SRC_RIGHT   EQU  2000h      ; ADC monophonic source
ADC_DISABLE     EQU  4000h      ; ADC enable/disable
PORT0_BUSY      EQU  8000h      ; Data port busy flag

PLAY_OFFSET     EQU  6100h      ; Digital playback buffer offset
REC_OFFSET      EQU  6101h      ; Digital recording buffer offset
DSP_FIFO        EQU  8000h      ; DSP FIFO buffers (ending offset)

DSPSYSTEM       EQU  0000h      ; System Initialization
 ARIA_SYNTH     EQU  0
 DEFAULT_SYNTH  EQU  1
DSPWAVEPARM     EQU  0002h      ; Download Wave Parameter Table
DSPAUDIOFORMAT  EQU  0003h      ; Digital Audio Format
 SRMASK         EQU  00F0h
 SR11KHZ        EQU  0000h
 SR22KHZ        EQU  0010h
 SR44KHZ        EQU  0020h
 SR32KHZ        EQU  0030h
 SR16KHZ        EQU  0040h
 SR8KHZ         EQU  0050h
 MONO           EQU  0000h
 STEREO         EQU  0001h
 EIGHTBIT       EQU  0000h
 SIXTEENBIT     EQU  0002h
 ADPCM          EQU  0004h
DSPMASTERVOL    EQU  0004h      ; Master Volume
DSPPACKETSIZE   EQU  0005h      ; Digital Audio Packet Size
DSPPLAYMODE     EQU  0006h      ; Playback Mode
 NOSYNTH        EQU  0000h
 MINOPERATORS   EQU  0001h
 MAXOPERATORS   EQU  0002h
DSPAUXVOL       EQU  0007h      ; Auxiliary Volume
DSPMIXERLEVEL   EQU  0009h      ; Mixer Level Select
 LINELEVEL      EQU  0000h
 AMPLEVEL       EQU  0001h
 MONITOR        EQU  0010h
DSPGENPCINT     EQU  000Ah      ; Generate PC Interrupt

DSPTRANSFER     EQU  0010h      ; Digital Audio Transfer
DSPPLAYSTART    EQU  0011h      ; Start Audio Playback
 INACTIVE       EQU  0
 PLAYING        EQU  1
DSPPLAYSTOP     EQU  0012h      ; Stop Audio Playback
DSPCHANNELVOL   EQU  0013h      ; Playback Channel Volume
DSPCHANNELPAN   EQU  0014h      ; Playback Channel Pan
DSPRECSTART     EQU  0015h      ; Start Audio Recording
 RECORDING      EQU  2
 EXTREC         EQU  0001h
 AUXREC         EQU  0002h
 OUTREC         EQU  0004h
DSPRECSTOP      EQU  0016h      ; Stop Audio Recording
DSPPLAYVOL      EQU  0017h      ; Digital Audio Playback Volume
DSPRECVOL       EQU  0018h      ; Digital Audio Record Volume

DSPOPERON1      EQU  0020h      ; Operator On (Multiple loop)
DSPOPEROFF      EQU  0021h      ; Operator Off
DSPOPERCANCEL   EQU  0022h      ; Operator Cancel
DSPOPERON2      EQU  0023h      ; Operator On (Single loop)
DSPLFO_ON       EQU  0024h      ; LFO Activate
DSPLFO_OFF      EQU  0025h      ; LFO Deactivate
DSPAMP          EQU  0026h      ; Amplitude Change
DSPPAN          EQU  0027h      ; Pan Change
DSPPITCH        EQU  0028h      ; Pitch Change
DSPSYNTHVOL     EQU  0029h      ; Synthesis Volume
DSPLFORATE      EQU  002Ah      ; LFO Rate Change
DSPLFODEPTH     EQU  002Bh      ; LFO Depth Change
DSPTABLEMOD     EQU  002Ch      ; Table Modify

DSPTERMINATOR   EQU  0FFFFh     ; Command string terminator

INTCTRLR0       EQU  21h        ; Primary interrupt controller port
INTCTRLR1       EQU  0A1h       ; Slave interrupt controller port

;*** PCM Wave Channel Structure ***

ARIAWAVE STRUC
audioPtr        dd 0
audioStart      dd 0
audioSize       dd 0
bufferSize      dd 0
bufferOffset    dd 0
audioPending    dw 0
status          dw 0
ARIAWAVE ENDS

CHSIZE          EQU SIZE ARIAWAVE


;****************************************************************************
;
; Macro to send one command word to the DSP
;
; Input:  ax = DSP command word
;
; Destroys:  dx
;
;****************************************************************************

sendDSP MACRO
        LOCAL   n1, n2, n3

        push    cx
        mov     dx, _dspbase
        add     dx, DSPSTATUS
        mov     cx, 30000
        push    ax
n1:
        in      ax, dx
        shl     ax, 1
        jnc     n2

        loop    n1
n2:
        pop     ax
        or      cx, cx
        jnz     n3
        mov     _DSPstatus, 0
n3:
        dec     dx
        dec     dx
        out     dx, ax
        pop     cx
        ENDM

;****************************************************************************
;
; Macro to select digital audio FIFO buffer location
;
; Input:  cx = audio channel number (from 3 [channel 0] to 0 [channel 3])
;         ax = DSP FIFO flag address (6100h or 6101h)
;
; Output: ax = buffer location (DSP address)
;         dx = DMA address port
;
; Destroys:  bx, si
;
;****************************************************************************

setFIFOaddr     MACRO   ch
        LOCAL   loop1

        mov     dx, _dspbase
        add     dx, DMAADDRESS
        out     dx, ax          ; select address in DSP RAM
        inc     dx
        inc     dx
        in      ax, dx          ; read value
        mov     bx, ax          ; offset in bx

        push    cx              ; compute offset to FIFO
        mov     ax, cx
        mov     cx, MODE0_CHANNELS
        sub     cx, ax          ; channel number in cx
        inc     cx              ; channel + 1
        shl     cx, 1           ; channel * 2
        xor     ax, ax
        mov     si, _packetSize
loop1:
        add     ax, si
        loop    loop1
        pop     cx

        mov     si, ax
        mov     ax, DSP_FIFO
        sub     ax, si
        add     ax, bx

        dec     dx
        dec     dx
        out     dx, ax          ; set the FIFO address for DSP RAM
        ENDM


;****************************************************************************
;
; Macro to normalize the sample pointer
;
; Input:  sample pointer index in di (32 bit index)
;         ds must be pushed on stack
;
; Output: normalized address in ds:si
;         normalized sample pointer
;
; Destroys:  ax, bx
;
;****************************************************************************

normalize       MACRO
        LOCAL   norm1

        lds     si, [di].audioPtr
        mov     ax, si
        shr     ax, 4           ; divide offset by 16
        or      ax, ax          ; if result is nonzero
        jz      norm1

        mov     bx, ds
        add     bx, ax          ;    add it to segment
        pop     ds
        mov     WORD PTR [di].audioPtr+2, bx
        shl     ax, 4
        sub     si, ax          ;    normalize offset
        mov     WORD PTR [di].audioPtr, si
        push    ds
        mov     ds, bx
norm1:
        ENDM

