/* ARIAWAVE.C v0.02 */

#include <conio.h>          /* getch() */
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>            /* kbhit() */
#include "aria.h"
#include "wave.h"

int main(int argc, char *argv[])
{
  unsigned format=0;
  char *name = "test.wav";
  char dummy;

  if (argc > 1)
    name = argv[1];

  printf ("\nAriaWave v0.02 by Daniel R. Tauritz\n\n");

  printf ("Reading file... Please wait.\n");
  if ((wave_ptr = get_wav_data (&format,name)) == NULL)
  {
     printf ("Error opening file %s\n",name);
     exit(1);
  }
  printf ("File size: %u bytes \n",aria_samplesize);

  aria_getparms();
  aria_init();
  aria_install_interrupt_handler();
  aria_set_audio_format(format);
  aria_start_playback();
  printf ("Playing... Press any key to stop.\n");

  while (!kbhit());
  dummy=getch();

  aria_stop_playback();
  printf ("Goodbye!\n");

  aria_release_interrupt_handler();
  aria_reset(format);
  free (wave_ptr);

  return 0;
}
