' Get data from an EPROM, one nibble at a time via a
' 74C157 data selector.  Display on LCD and advance
' the CD4040 address counter for the next character.

' Plenty of space for additional instructions (also 16 chars
' on the LCD aren't in use!)

Symbol  E       =       5       ' Enable pin, 1 = enabled
Symbol  RS      =       4       ' Register select pin, 0 = instruction
Symbol  AB      =       7
Symbol  clk     =       6
Symbol	nsub	=	b2
Symbol  cnt     =       b3
Symbol  temb    =       b4
Symbol  char    =       b5

' Set up the Stamp's I/O lines and initialize the LCD. 


begin:  let dirs = %11111111
        let pins = %00000011            'Set to 8-bit operation. 
        pulsout E,1                     'Send data three times
        pulsout E,1                     'to initialize LCD              
        pulsout E,1                             
        let pins = %00000010            'Set to 4-bit operation. 
        pulsout E,1                     'Send above data three times.
        pulsout E,1
        let pins = %00001000
        pulsout E,1
        let char = 14                   'Set up LCD in accordance with
        gosub wr_LCD                    'Hitachi instruction manual. 
	let cnt = 0
loop:   
        let dirs = %11100000            'Set up I/O directions. 
        low ab
        let nsub = pins & %00001111     'Take low and high nibble
        high ab                         'readings from the 74C157
        let nsub = pins & %00011111 * 16 + nsub
        pulsout clk,2                   'Increment counter for next byte
        let char = nsub
	gosub wr_LCD
	if cnt < 64 then loop
	pause 200			'Wait a bit
	low     RS                      'Clear display
        let char = 1 
        gosub wr_LCD
        high    RS   
	let cnt = 0
	goto loop

' Write the ASCII character in char to the LCD. 

wr_CCD: let char = char + 48            'Call if converting # to ASCII
wr_LCD: let pins = pins & %00010000
        let temb = char / 16            'Put high nib of char into temb
        let pins = pins | temb          'OR the contents of char into pins 
        pulsout E,1                     'Blip enable pin
        let temb = char & %00001111     'Put low nib of char into temb 
        let pins = pins & %00010000     'Clear 4-bit data bus
        let pins = pins | temb          'OR the contents of temb into pins
        pulsout E,1                     'Blip enable pin
        return
