; VIDEO.INC
;
; Assembler header file for Video.asm.  This is the same stuff as in
; Video.h, only this is for assembler.
;

; MACROS ************************************************************
;

; Directory entry types.
DRIVETYPE   EQU     0
DIRTYPE     EQU     1
FILETYPE    EQU     2
NDIRROWS    EQU     18      ; number of rows in directory list display
NDIRCOLS    EQU     6       ; number of columns in directory list display


; TYPES *************************************************************
;



; GLOBAL VARIABLES **************************************************
;



; EXTERNAL SUBROUTINES **********************************************
;

EXTRN   INITVID:NEAR        ; video initialization routine
EXTRN   ENDVID:NEAR         ; video finalization routine
EXTRN   VIDPUTENTRY:NEAR    ; routine to put pattern table entry on screen
EXTRN   VIDPUTNENTRIES:NEAR ; routine to put size of pattern table on screen
EXTRN   VIDPUTPATNUM:NEAR   ; routine to put pattern number on screen
EXTRN   VIDPUTNPATTERNS:NEAR ; routine to put number of patterns on screen
EXTRN   VIDPUTNOTENUM:NEAR  ; routine to put a note number on screen
EXTRN   VIDPUTNUMS:NEAR     ; routine to set all numbers on the screen
EXTRN   VIDUPDATENUMS:NEAR  ; routine to update numbers during song playback
EXTRN   VIDPUTVOLUME:NEAR   ; routine to put the DAC volume on screen
EXTRN   VIDPUTRATE:NEAR     ; routine to put output sampling rate on screen
EXTRN   VIDPUTLOOPEN:NEAR   ; routine to put loop disable setting on screen
EXTRN   VIDPUTTICKSPER:NEAR ; routine to put ticks/division on screen
EXTRN   VIDPUTBPM:NEAR      ; routine to put beats/minute on screen
EXTRN   VIDPUTNCHANS:NEAR   ; routine to put number of channels on screen
EXTRN   VIDPUTNINSTRS:NEAR  ; routine to put number of instruments on screen
EXTRN   VIDPUTGLOBALVOL:NEAR ; routine to put global volume on screen
EXTRN   VIDPUTEMSEN:NEAR    ; routine to put EMS enable setting on screen
EXTRN   VIDPUTSAVEMEM:NEAR  ; routine to put save memory setting on screen
EXTRN   VIDPUTLOADOPT:NEAR  ; routine to put loading optimization setting on screen
EXTRN   VIDPUTMSG:NEAR      ; routine to put a message/prompt on screen
EXTRN   VIDPUTERRMSG:NEAR   ; routine to put an error message on screen
EXTRN   VIDSTARTINPUT:NEAR  ; routine to clear input line on screen
EXTRN   VIDBLOCKCURS:NEAR   ; routine to make the cursor a block
EXTRN   VIDLINECURS:NEAR    ; routine to make the cursor an underline
EXTRN   VIDGETCHAR:NEAR     ; routine to get a character from the BIOS
EXTRN   VIDGETNCHAR:NEAR    ; nonblocking routine to get a character
EXTRN   VIDPOLLCHAR:NEAR    ; routine to check for a particular character
EXTRN   VIDFLUSHKEY:NEAR    ; routine to flush the keyboard buffer
EXTRN   VIDENDINPUT:NEAR    ; routine to hide input line on screen
EXTRN   VIDMOVECURS:NEAR    ; routine to move the cursor
EXTRN   VIDPUTINPUT:NEAR    ; routine to put a string on the input line
EXTRN   VIDPUTMSG2:NEAR     ; routine to put a message on the input line
EXTRN   VIDPUTFILNAM:NEAR   ; routine to put the mod file name on screen
EXTRN   VIDPUTCMDS:NEAR     ; routine to redisplay the commands
EXTRN   VIDSTARTSEL:NEAR    ; routine to clear the screen for the file selector
EXTRN   VIDPUTDIRENT:NEAR   ; routine to display a directory entry for selector
EXTRN   VIDHILIGHT:NEAR     ; routine to highlight a directory entry
EXTRN   VIDUNHILIGHT:NEAR   ; routine to unhighlight a directory entry
EXTRN   DEBUGSTRING:NEAR    ; routine to send a string out COM2:
EXTRN   GETSYSTIME:NEAR     ; routine to get the system time
