/*
 *  USEAPI.C
 *
 *  Shows the use of the XFSAPI: XFSLIB & XFSFMX
 *
 *  Note: USEAPI uses Borland's EasyWin. I don't know, how other
 *        compilers handle generic window output.
 *
 */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "xfsapi.h"

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
  LPSTR lpszCmdLine, int cmdShow)
{

 MOUNTOPT  opt;
 XFSINFO   info;
 int       i;
 char      device[128], resource[128];

// for `printf'
_InitEasyWin();

if( !XfsInstalled() ) exit(255);

// Login
printf("%d\n", XfsLogin((LPSTR) NULL, "speedy", "guest", "guest"));

// Get XFS info
XfsNetStat( &info );
printf("Hostname ... %s\n", info.hostname);
printf("User ....... %s\n", info.username);
printf("UID ........ %d\n", info.uid);
printf("GID ........ %d\n", info.gid);
printf("Umask ...... %d\n", info.umask);

opt.rsize = 1024;
opt.wsize = 1024;
opt.retry = MOUNT_DEF_RETRY;
opt.flags = MOUNT_DEF_OPT;

// Mount a drive
printf("%d\n", XfsMountDrive("R:", "speedy", "/usr", &opt) );

// Drive Login
printf("%d\n", XfsLogin("R:", "speedy", "admin", "xyz"));


// Show used resources
i = 0;
while( WGetRedirection(i++, device, resource) == 0 )
  printf("%s %s\n", device, resource);

// Init the File Manager Extension
if( !InitFMX() ) exit(255);

// Show the mount dialog
XfsFMXCall(0, CM_MOUNT);

// Show the unmount dialog
XfsFMXCall(0, CM_UMOUNT);

DoneFMX();

return 0;
}
