// VideoEditDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VideoEdit.h"
#include "VideoEditDlg.h"
#include "DlgTran.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVideoEditDlg dialog

CVideoEditDlg::CVideoEditDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVideoEditDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVideoEditDlg)
	m_Start1 = 0.0;
	m_Start2 = 0.0;
	m_Start3 = 0.0;
	m_Stop1 = 0.0;
	m_Stop2 = 0.0;
	m_Stop3 = 0.0;
	m_AudioStart1 = 0.0;
	m_AudioStart2 = 0.0;
	m_AudioStart3 = 0.0;
	m_AudioStop1 = 0.0;
	m_AudioStop2 = 0.0;
	m_AudioStop3 = 0.0;
	m_BgStart1 = 0.0;
	m_BgStop1 = 0.0;
	m_TranStart1 = 0.0;
	m_TranStop1 = 0.0;
	m_TranStart2 = 0.0;
	m_TranStop2 = 0.0;
	m_TranStart3 = 0.0;
	m_TranStop3 = 0.0;
	m_iHeight = 240;
	m_iWidth = 320;
	m_iStretchMode = 0;
	m_iExport1 = 0.0;
	m_iExport2 = 0.0;
	m_iExport3 = 0.0;
	m_iMPEGQuality = 90;
	m_iVideoBitRate = 100;
	m_iAudioBitRate = 128;
	m_iOutputType = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVideoEditDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVideoEditDlg)
	DDX_Control(pDX, IDC_CHKCUSTOMPROFILE, m_ChkCustomProfile);
	DDX_Control(pDX, IDC_EDITWIDTH, m_EditWidth);
	DDX_Control(pDX, IDC_EDITFRAME, m_EditFrame);
	DDX_Control(pDX, IDC_EDITHEIGHT, m_EditHeight);
	DDX_Control(pDX, IDC_CHKVBRMODE, m_ChkVBRMode);
	DDX_Control(pDX, IDC_EDITABITRATE, m_EditAudioBitRate);
	DDX_Control(pDX, IDC_EDITVBITRATE, m_EditVideoBitRate);
	DDX_Control(pDX, IDC_EDITQUALITY, m_EditMPEGQuality);
	DDX_Control(pDX, IDC_OPTOUTPUTTYE, m_OptMPEG);
	DDX_Control(pDX, IDC_CBOMPEGFRAMERATE, m_CboMPEGFrameRate);
	DDX_Control(pDX, IDC_CBOMPEGTYPE, m_CboMPEGType);
	DDX_Control(pDX, IDC_EDITTRAN3, m_EditTran3);
	DDX_Control(pDX, IDC_EDITTRAN2, m_EditTran2);
	DDX_Control(pDX, IDC_EDITTRAN1, m_EditTran1);
	DDX_Control(pDX, IDC_EDITBGVIDEO, m_EditBgVideo);
	DDX_Control(pDX, IDC_CHKUSEAUDIOCOMP, m_ChkUseAudioComp);
	DDX_Control(pDX, IDC_CBOAUDIOCOMP, m_CboAudioComp);
	DDX_Control(pDX, IDC_CHKUSEVIDEOCOMP, m_ChkUseVideoComp);
	DDX_Control(pDX, IDC_OPTOUTPUT, m_OptOutput);
	DDX_Control(pDX, IDC_EDITAUDIO3, m_EditAudio3);
	DDX_Control(pDX, IDC_EDITAUDIO2, m_EditAudio2);
	DDX_Control(pDX, IDC_EDITAUDIO1, m_EditAudio1);
	DDX_Control(pDX, IDC_EDITVIDEO3, m_EditVideo3);
	DDX_Control(pDX, IDC_EDITVIDEO2, m_EditVideo2);
	DDX_Control(pDX, IDC_EDITVIDEO1, m_EditVideo1);
	DDX_Control(pDX, IDC_CBOVIDEOCOMPRESSOR, m_CboVideoComp);
	DDX_Control(pDX, IDC_CBOWMV, m_CboWMV);
	DDX_Control(pDX, IDC_VIDEOEDITCTRL1, m_VideoEdit);
	DDX_Text(pDX, IDC_EDITSTART1, m_Start1);
	DDX_Text(pDX, IDC_EDITSTART2, m_Start2);
	DDX_Text(pDX, IDC_EDITSTART3, m_Start3);
	DDX_Text(pDX, IDC_EDITENDTIME1, m_Stop1);
	DDX_Text(pDX, IDC_EDITENDTIME2, m_Stop2);
	DDX_Text(pDX, IDC_EDITENDTIME3, m_Stop3);
	DDX_Text(pDX, IDC_EDITAUDIOSTART1, m_AudioStart1);
	DDX_Text(pDX, IDC_EDITAUDIOSTART2, m_AudioStart2);
	DDX_Text(pDX, IDC_EDITAUDIOSTART3, m_AudioStart3);
	DDX_Text(pDX, IDC_EDITAUDIOSTOP1, m_AudioStop1);
	DDX_Text(pDX, IDC_EDITAUDIOSTOP2, m_AudioStop2);
	DDX_Text(pDX, IDC_EDITAUDIOSTOP3, m_AudioStop3);
	DDX_Text(pDX, IDC_EDITBGSTART1, m_BgStart1);
	DDX_Text(pDX, IDC_EDITBGENDTIME1, m_BgStop1);
	DDX_Text(pDX, IDC_EDITTRANSTART1, m_TranStart1);
	DDX_Text(pDX, IDC_EDITTRANSTOP1, m_TranStop1);
	DDX_Text(pDX, IDC_EDITTRANSTART2, m_TranStart2);
	DDX_Text(pDX, IDC_EDITTRANSTOP2, m_TranStop2);
	DDX_Text(pDX, IDC_EDITTRANSTART3, m_TranStart3);
	DDX_Text(pDX, IDC_EDITTRANSTOP3, m_TranStop3);
	DDX_Text(pDX, IDC_EDITHEIGHT, m_iHeight);
	DDX_Text(pDX, IDC_EDITWIDTH, m_iWidth);
	DDX_Radio(pDX, IDC_OPTMODE, m_iStretchMode);
	DDX_Text(pDX, IDC_EDITEXPORT1, m_iExport1);
	DDX_Text(pDX, IDC_EDITEXPORT2, m_iExport2);
	DDX_Text(pDX, IDC_EDITEXPORT3, m_iExport3);
	DDX_Text(pDX, IDC_EDITQUALITY, m_iMPEGQuality);
	DDX_Text(pDX, IDC_EDITVBITRATE, m_iVideoBitRate);
	DDX_Text(pDX, IDC_EDITABITRATE, m_iAudioBitRate);
	DDX_Radio(pDX, IDC_OPTOUTPUTTYE, m_iOutputType);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVideoEditDlg, CDialog)
	//{{AFX_MSG_MAP(CVideoEditDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTNVIDEO1, OnBtnvideo1)
	ON_BN_CLICKED(IDC_BTNVIDEO2, OnBtnvideo2)
	ON_BN_CLICKED(IDC_BTNVIDEO3, OnBtnvideo3)
	ON_BN_CLICKED(IDC_BTNAUDIO1, OnBtnaudio1)
	ON_BN_CLICKED(IDC_BTNAUDIO2, OnBtnaudio2)
	ON_BN_CLICKED(IDC_BTNAUDIO3, OnBtnaudio3)
	ON_BN_CLICKED(IDC_CHKOUTPUTWMV, OnChkoutputwmv)
	ON_BN_CLICKED(IDC_BTNSTART, OnBtnstart)
	ON_BN_CLICKED(IDC_BTNSETTING, OnBtnsetting)
	ON_BN_CLICKED(IDC_BTNSTOP, OnBtnstop)
	ON_BN_CLICKED(IDC_CHKUSEVIDEOCOMP, OnChkusevideocomp)
	ON_BN_CLICKED(IDC_CHKUSEAUDIOCOMP, OnChkuseaudiocomp)
	ON_BN_CLICKED(IDC_BTNBGVIDEO, OnBtnbgvideo)
	ON_BN_CLICKED(IDC_BTNTRAN1, OnBtntran1)
	ON_BN_CLICKED(IDC_BTNTRAN2, OnBtntran2)
	ON_BN_CLICKED(IDC_BTNTRAN3, OnBtntran3)
	ON_BN_CLICKED(IDC_BTNEXPORT1, OnBtnexport1)
	ON_BN_CLICKED(IDC_BTNEXPORT2, OnBtnexport2)
	ON_BN_CLICKED(IDC_BTNEXPORT3, OnBtnexport3)
	ON_BN_CLICKED(IDC_BTNEXPORTWAVE1, OnBtnexportwave1)
	ON_BN_CLICKED(IDC_BTNEXPORTWAVE2, OnBtnexportwave2)
	ON_BN_CLICKED(IDC_BTNEXPORTWAVE3, OnBtnexportwave3)
	ON_BN_CLICKED(IDC_OPTOUTPUTTYE, OnOptoutputtye)
	ON_BN_CLICKED(IDC_OPTAVI, OnOptavi)
	ON_BN_CLICKED(IDC_CHKVBRMODE, OnChkvbrmode)
	ON_CBN_SELCHANGE(IDC_CBOMPEGTYPE, OnSelchangeCbompegtype)
	ON_BN_CLICKED(IDC_OPTWMV, OnOptwmv)
	ON_BN_CLICKED(IDC_CHKCUSTOMPROFILE, OnChkcustomprofile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVideoEditDlg message handlers

BOOL CVideoEditDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	int iVideoCompressorCount= m_VideoEdit.GetVideoCompressors().GetCount();

	CString strVideoComp;
	for(int i=0; i< iVideoCompressorCount; i++)
	{
		strVideoComp= m_VideoEdit.GetVideoCompressors().FindVideoCompressorName(i);
		m_CboVideoComp.AddString(strVideoComp);
	}


	if(m_CboVideoComp.GetCount() >0 )
		m_CboVideoComp.SetCurSel(0);

	////////////////////////////////
	int iAudioCompressorCount= m_VideoEdit.GetAudioCompressors().GetCount();

	CString strAudioComp;
	for( i=0; i< iAudioCompressorCount; i++)
	{
		strVideoComp= m_VideoEdit.GetAudioCompressors().FindAudioCompressorName(i);
		m_CboAudioComp.AddString(strVideoComp);
	}


	if(m_CboAudioComp.GetCount() >0 )
		m_CboAudioComp.SetCurSel(0);



	int iWMVCount= m_VideoEdit.GetWMVProfiles().GetCount();

	CString strWMVProfile;
	for( i=0; i< iWMVCount; i++)
	{
		strWMVProfile= m_VideoEdit.GetWMVProfiles().FindWMVProfileName(i);
		m_CboWMV.AddString(strWMVProfile);
	}


	if(m_CboWMV.GetCount() >0 )
		m_CboWMV.SetCurSel(0);

	//m_ChkOutputWMV.SetCheck(1);
	m_CboVideoComp.EnableWindow(FALSE);

	m_OptOutput.SetCheck(1);

	GetDlgItem(IDC_EDITFRAME)->SetWindowText(_T("0"));


	

	m_CboMPEGType.AddString("VCD PAL");
	m_CboMPEGType.AddString("VCD NTSC");
	m_CboMPEGType.AddString("SVCD PAL");
	m_CboMPEGType.AddString("SVCD NTSC");
	m_CboMPEGType.AddString("DVD PAL");
	m_CboMPEGType.AddString("DVD NTSC");
	m_CboMPEGType.AddString("CUSTOM MPEG");

	m_CboMPEGType.SetCurSel(0);

	

	m_CboMPEGFrameRate.AddString("23.976");
	m_CboMPEGFrameRate.AddString("24");
	m_CboMPEGFrameRate.AddString("25");
	m_CboMPEGFrameRate.AddString("29.97");
	m_CboMPEGFrameRate.AddString("30");
	m_CboMPEGFrameRate.AddString("50");
	m_CboMPEGFrameRate.AddString("59.94");
	m_CboMPEGFrameRate.SetCurSel(0);

	m_ChkVBRMode.SetCheck(1);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVideoEditDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVideoEditDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVideoEditDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVideoEditDlg::OnBtnvideo1() 
{
	// TODO: Add your control notification handler code here

	
	char szFilter[]="All Files (*.*)|*.*|mpg (*.mpg) | *.mpg;*.mpeg|avi (*.avi) | *.avi|wmv (*.wmv)| *.wmv|asf (*.asf) | *.asf|JPEG (*.jpg)|*.jpg|Bitmap (*.bmp)|*.bmp|Gif (*.gif)|*.gif ||";
	
	CFileDialog dlg(TRUE,NULL,NULL,OFN_FILEMUSTEXIST,szFilter,this);
	
	if(dlg.DoModal()==IDOK)
	{
	
		m_EditVideo1.SetWindowText(dlg.GetPathName());


		m_Start1=0;
		double iDur=m_VideoEdit.GetFileDuration(dlg.GetPathName());

		if (iDur==0)
			m_Stop1=1;
		else
			m_Stop1=iDur;

		UpdateData(FALSE);
	}		
	else
		m_EditVideo1.SetWindowText("");

}

void CVideoEditDlg::OnBtnvideo2() 
{
	// TODO: Add your control notification handler code here
	char szFilter[]="All Files (*.*)|*.*|mpg (*.mpg) | *.mpg;*.mpeg|avi (*.avi) | *.avi|wmv (*.wmv)| *.wmv|asf (*.asf) | *.asf|JPEG (*.jpg)|*.jpg|Bitmap (*.bmp)|*.bmp|Gif (*.gif)|*.gif ||";
	
	CFileDialog dlg(TRUE,NULL,NULL,OFN_FILEMUSTEXIST,szFilter,this);

	
	if(dlg.DoModal()==IDOK)
	{
	
		m_EditVideo2.SetWindowText(dlg.GetPathName());

		m_Start2=0;
		double iDur=m_VideoEdit.GetFileDuration(dlg.GetPathName());

		if (iDur==0)
			m_Stop2=1;
		else
			m_Stop2=iDur;

		UpdateData(FALSE);

	}			
	else
		m_EditVideo2.SetWindowText("");
}

void CVideoEditDlg::OnBtnvideo3() 
{
	// TODO: Add your control notification handler code here
	char szFilter[]="All Files (*.*)|*.*|mpg (*.mpg) | *.mpg;*.mpeg|avi (*.avi) | *.avi|wmv (*.wmv)| *.wmv|asf (*.asf) | *.asf|JPEG (*.jpg)|*.jpg|Bitmap (*.bmp)|*.bmp|Gif (*.gif)|*.gif ||";
	
	CFileDialog dlg(TRUE,NULL,NULL,OFN_FILEMUSTEXIST,szFilter,this);

	
	if(dlg.DoModal()==IDOK)
	{
	
		m_EditVideo3.SetWindowText(dlg.GetPathName());

		m_Start3=0;
		double iDur=m_VideoEdit.GetFileDuration(dlg.GetPathName());

		if (iDur==0)
			m_Stop3=1;
		else
			m_Stop3=iDur;

		UpdateData(FALSE);
	}			
	else
		m_EditVideo3.SetWindowText("");
}

void CVideoEditDlg::OnBtnaudio1() 
{
	// TODO: Add your control notification handler code here

	char szFilter[]="All Files (*.*)|*.*|mpg (*.mpg) | *.mpg|avi (*.avi) | *.avi|wmv (*.wmv)| *.wmv|asf (*.asf) | *.asf |mp3 (*.mp3)| *.mp3||";
	
	CFileDialog dlg(TRUE,NULL,NULL,OFN_FILEMUSTEXIST,szFilter,this);
	
	if(dlg.DoModal()==IDOK)
	{
	
		m_EditAudio1.SetWindowText(dlg.GetPathName());

		m_AudioStart1=0;
		double iDur=m_VideoEdit.GetFileDuration(dlg.GetPathName());

		if (iDur==0)
			m_AudioStop1=1;
		else
			m_AudioStop1=iDur;

		UpdateData(FALSE);
	}		
	else
		m_EditAudio1.SetWindowText("");
	
}

void CVideoEditDlg::OnBtnaudio2() 
{
	// TODO: Add your control notification handler code here
	char szFilter[]="All Files (*.*)|*.*|mpg (*.mpg) | *.mpg|avi (*.avi) | *.avi|wmv (*.wmv)| *.wmv|asf (*.asf) | *.asf |mp3 (*.mp3)| *.mp3||";
	
	CFileDialog dlg(TRUE,NULL,NULL,OFN_FILEMUSTEXIST,szFilter,this);
	
	if(dlg.DoModal()==IDOK)
	{
	
		m_EditAudio2.SetWindowText(dlg.GetPathName());

		m_AudioStart2=0;
		double iDur=m_VideoEdit.GetFileDuration(dlg.GetPathName());

		if (iDur==0)
			m_AudioStop2=1;
		else
			m_AudioStop2=iDur;

		UpdateData(FALSE);


	}		
	else
		m_EditAudio2.SetWindowText("");
	
}

void CVideoEditDlg::OnBtnaudio3() 
{
	// TODO: Add your control notification handler code here
	char szFilter[]="All Files (*.*)|*.*|mpg (*.mpg) | *.mpg|avi (*.avi) | *.avi|wmv (*.wmv)| *.wmv|asf (*.asf) | *.asf |mp3 (*.mp3)| *.mp3||";
	
	CFileDialog dlg(TRUE,NULL,NULL,OFN_FILEMUSTEXIST,szFilter,this);
	
	if(dlg.DoModal()==IDOK)
	{
	
		m_EditAudio3.SetWindowText(dlg.GetPathName());

		m_AudioStart3=0;
		double iDur=m_VideoEdit.GetFileDuration(dlg.GetPathName());

		if (iDur==0)
			m_AudioStop3=1;
		else
			m_AudioStop3=iDur;

		UpdateData(FALSE);
	}		
	else
		m_EditAudio3.SetWindowText("");
	
}

void CVideoEditDlg::OnChkoutputwmv() 
{
	// TODO: Add your control notification handler code here

	

	
}

void CVideoEditDlg::OnBtnstart() 
{
	// TODO: Add your control notification handler code here
	
	
	CString strFilter,strProfile;
	CString strExt;
	CString strFrameRate;

	int iSel;
	UpdateData(TRUE);	

	m_VideoEdit.SetOutputFileWidth(m_iWidth);
	m_VideoEdit.SetOutputFileHeight(m_iHeight);

	if(m_iOutputType==0) //mpeg
	{
		switch(m_CboMPEGType.GetCurSel())
		{
		case 0:
			m_VideoEdit.SetOutputType(0); //vcd pal
			break;
		case 1:
			m_VideoEdit.SetOutputType(1); //vcd ntsc
			break;
		case 2:
			m_VideoEdit.SetOutputType(2); //svcd pal
			break;
		case 3:
			m_VideoEdit.SetOutputType(3); //svcd ntsc
			break;
		case 4:
			m_VideoEdit.SetOutputType(4); //dvd pal
			break;
		case 5:
			m_VideoEdit.SetOutputType(5); //dvd ntsc
			break;
		case 6:
			m_VideoEdit.SetOutputType(6); //custom mpeg

			//m_CboMPEGFrameRate.GetLBText( m_CboMPEGFrameRate.GetCurSel(),strFrameRate);

			switch(m_CboMPEGFrameRate.GetCurSel())
			{
			case 0:
				m_VideoEdit.SetFrameRate(23.976);
				break;
			case 1:
				m_VideoEdit.SetFrameRate(24);
				break;
			case 2:
				m_VideoEdit.SetFrameRate(25);
				break;
			case 3:
				m_VideoEdit.SetFrameRate(29.97);
				break;
			case 4:
				m_VideoEdit.SetFrameRate(30);
				break;
			case 5:
				m_VideoEdit.SetFrameRate(50);
				break;
			case 6:
				m_VideoEdit.SetFrameRate(59.94);
				break;
			}

			break;

		}	

		strFilter = "MPEG File (*.mpeg)|*.mpeg||";
		strExt=".mpeg";

	}
	else if(m_iOutputType==1) //avi
	{
		strFilter = "avi File (*.avi)|*.avi||";
		strExt=".avi";
	
		m_VideoEdit.SetOutputType(7); //avi

		CString strFrame;
		GetDlgItem(IDC_EDITFRAME)->GetWindowText(strFrame);
		m_VideoEdit.SetFrameRate(atoi(strFrame));
		//m_VideoEdit.SetOutputWMV(FALSE);
		
		iSel=m_CboVideoComp.GetCurSel();
		
		if(iSel!=-1)	
			m_VideoEdit.SetVideoCompressor(iSel);

		iSel=m_CboAudioComp.GetCurSel();
		
		if(iSel!=-1)	
			m_VideoEdit.SetAudioCompressor(iSel);



	}
	else if(m_iOutputType==2) //wmv
	{
	    strFilter = "wmv File (*.wmv)|*.wmv||";

		strExt=".wmv";

		m_VideoEdit.SetOutputType(8); //wmv

		 iSel=m_CboWMV.GetCurSel();

		 if(iSel!=-1)
			 m_VideoEdit.SetWMVProfile(iSel);


	}







	CString strVideo1,strVideo2,strVideo3;
	CString strAudio1,strAudio2,strAudio3;

	if(m_ChkVBRMode.GetCheck()==1)
	{
		m_VideoEdit.SetMPEGVBRMode(TRUE);
		m_VideoEdit.SetMPEGQuality(m_iMPEGQuality);
	
	}
	else
	{
		m_VideoEdit.SetMPEGVBRMode(FALSE);
		m_VideoEdit.SetMPEGAudioBitrate(m_iAudioBitRate);
		m_VideoEdit.SetMPEGVideoBitrate(m_iVideoBitRate);
	}



	m_VideoEdit.InitControl();

	m_EditVideo1.GetWindowText(strVideo1);
	m_EditVideo2.GetWindowText(strVideo2);
	m_EditVideo3.GetWindowText(strVideo3);

	m_EditAudio1.GetWindowText(strAudio1);
	m_EditAudio2.GetWindowText(strAudio2);
	m_EditAudio3.GetWindowText(strAudio3);


	if(!strVideo1.IsEmpty())
		m_VideoEdit.AddVideo(strVideo1,m_Start1,m_Stop1,m_iStretchMode);

	if(!strVideo2.IsEmpty())
		m_VideoEdit.AddVideo(strVideo2,m_Start2,m_Stop2,m_iStretchMode);

	if(!strVideo3.IsEmpty())
		m_VideoEdit.AddVideo(strVideo3,m_Start3,m_Stop3,m_iStretchMode);

	BOOL bResult;

	if(!strAudio1.IsEmpty())
			bResult=m_VideoEdit.AddAudio(strAudio1,m_AudioStart1,m_AudioStop1);
			if(!bResult)
			{		
				AfxMessageBox("audio format fail");
				return;
			}

	if(!strAudio2.IsEmpty())
			bResult=m_VideoEdit.AddAudio(strAudio2,m_AudioStart2,m_AudioStop2);
			if(!bResult)
			{		
				AfxMessageBox("audio format fail");
				return;
			}

	if(!strAudio3.IsEmpty())
			bResult=m_VideoEdit.AddAudio(strAudio3,m_AudioStart3,m_AudioStop3);
			if(!bResult)
			{		
				AfxMessageBox("audio format fail");
				return;
			}



	CString strBGVideo,strTran1,strTran2,strTran3;

	m_EditBgVideo.GetWindowText(strBGVideo);
	m_EditTran1.GetWindowText(strTran1);
	m_EditTran2.GetWindowText(strTran2);
	m_EditTran3.GetWindowText(strTran3);



	if (!strBGVideo.IsEmpty())
		m_VideoEdit.AddBgVideo(strBGVideo,m_BgStart1,m_BgStop1,m_iStretchMode);

	if(!strTran1.IsEmpty())
		m_VideoEdit.AddTransition(m_iTranID1,m_TranStart1,m_TranStop1);


	if(!strTran2.IsEmpty())
		m_VideoEdit.AddTransition(m_iTranID2,m_TranStart2,m_TranStop2);

	if(!strTran3.IsEmpty())
		m_VideoEdit.AddTransition(m_iTranID3,m_TranStart3,m_TranStop3);






	CFileDialog dlg(FALSE,"",strExt,OFN_FILEMUSTEXIST,strFilter,this);

	if(m_OptOutput.GetCheck()==1)
		m_VideoEdit.Preview();
	else
	{
		if(dlg.DoModal()==IDOK)
		{
			
			BOOL bSave=m_VideoEdit.Save(dlg.GetPathName());
			if(bSave==FALSE)
			{
				AfxMessageBox("Save Fail");
				return;
			}
			
			if(dlgProg.DoModal()==IDCANCEL)
				m_VideoEdit.Stop();
			
		}
	}
    
	
}

BEGIN_EVENTSINK_MAP(CVideoEditDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CVideoEditDlg)
	ON_EVENT(CVideoEditDlg, IDC_VIDEOEDITCTRL1, 1 /* Complete */, OnCompleteVideoeditctrl1, VTS_NONE)
	ON_EVENT(CVideoEditDlg, IDC_VIDEOEDITCTRL1, 2 /* Processing */, OnProcessingVideoeditctrl1, VTS_R8 VTS_R8)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CVideoEditDlg::OnCompleteVideoeditctrl1() 
{
	// TODO: Add your control notification handler code here
	dlgProg.PostMessage(WM_CLOSE,0,0);
	AfxMessageBox("Save Completed");
	
}

void CVideoEditDlg::OnProcessingVideoeditctrl1(double iCurPos, double iDuration) 
{
	// TODO: Add your control notification handler code here
	dlgProg.PostMessage(WM_PROGRESS,(int)iCurPos,(int)iDuration);
	
	
}

void CVideoEditDlg::OnBtnsetting() 
{
	// TODO: Add your control notification handler code here
	CString strVideoCompressor;
	
	m_CboVideoComp.GetLBText( m_CboVideoComp.GetCurSel(),strVideoCompressor);
	int iVideoCompressorIndex =m_VideoEdit.GetVideoCompressors().FindVideoCompressor(strVideoCompressor);

	BOOL bResult = m_VideoEdit.GetVideoCompressors().ShowPropertyPage(iVideoCompressorIndex);

	if(bResult==FALSE)
		AfxMessageBox("No Property Page");


	
}

void CVideoEditDlg::OnBtnstop() 
{
	// TODO: Add your control notification handler code here

	m_VideoEdit.Stop();
}

void CVideoEditDlg::OnChkusevideocomp() 
{
	// TODO: Add your control notification handler code here
	
	
	if( m_ChkUseVideoComp.GetCheck()==1)
	{
		m_VideoEdit.SetUseVideoCompressor(TRUE);
		m_CboVideoComp.EnableWindow(TRUE);
		m_CboWMV.EnableWindow(FALSE);

		//m_ChkOutputWMV.SetCheck(FALSE);

	}
	else
	{
		m_VideoEdit.SetUseVideoCompressor(FALSE);
		m_CboVideoComp.EnableWindow(FALSE);

		m_CboWMV.EnableWindow(FALSE);

		//m_ChkOutputWMV.SetCheck(TRUE);

	}





}

void CVideoEditDlg::OnChkuseaudiocomp() 
{
	// TODO: Add your control notification handler code here
	
		if( m_ChkUseAudioComp.GetCheck()==1)
		{

			m_CboAudioComp.EnableWindow(TRUE);


			//m_CboWMV.setchec
			m_VideoEdit.SetUseAudioCompressor(TRUE);
		}
		else
		{
			m_CboAudioComp.EnableWindow(FALSE);
			m_VideoEdit.SetUseAudioCompressor(FALSE);

		}

	

}

void CVideoEditDlg::OnBtnbgvideo() 
{
	// TODO: Add your control notification handler code here
char szFilter[]="All Files (*.*)|*.*|mpg (*.mpg) | *.mpg;*.mpeg|avi (*.avi) | *.avi|wmv (*.wmv)| *.wmv|asf (*.asf) | *.asf|JPEG (*.jpg)|*.jpg|Bitmap (*.bmp)|*.bmp|Gif (*.gif)|*.gif ||";
	
	CFileDialog dlg(TRUE,NULL,NULL,OFN_FILEMUSTEXIST,szFilter,this);
	
	if(dlg.DoModal()==IDOK)
	{
	
		m_EditBgVideo.SetWindowText(dlg.GetPathName());


		m_BgStart1=0;
		double iDur=m_VideoEdit.GetFileDuration(dlg.GetPathName());

		if (iDur==0)
			m_BgStop1=5;
		else
			m_BgStop1=iDur;

		UpdateData(FALSE);
	}		
	else
		m_EditBgVideo.SetWindowText("");
	
}

void CVideoEditDlg::OnBtntran1() 
{
	// TODO: Add your control notification handler code here

	CDlgTran dlg;
	dlg.m_pParent=this;

	if(dlg.DoModal()==IDOK)
	{
		m_EditTran1.SetWindowText(dlg.m_strTranName);

		m_iTranID1 =  dlg.m_iSelTran;

		m_TranStart1=1;
		m_TranStop1=2;

		UpdateData(FALSE);


	}
	else
		m_EditTran1.SetWindowText(_T(""));


}

void CVideoEditDlg::OnBtntran2() 
{
	// TODO: Add your control notification handler code here
	CDlgTran dlg;
	dlg.m_pParent=this;

	if(dlg.DoModal()==IDOK)
	{
		m_EditTran2.SetWindowText(dlg.m_strTranName);

		m_iTranID2 =  dlg.m_iSelTran;

		m_TranStart2=3;
		m_TranStop2=4;

		UpdateData(FALSE);


	}
	else
		m_EditTran2.SetWindowText(_T(""));
	
}

void CVideoEditDlg::OnBtntran3() 
{
	// TODO: Add your control notification handler code here
	CDlgTran dlg;
	dlg.m_pParent=this;

	if(dlg.DoModal()==IDOK)
	{
		m_EditTran3.SetWindowText(dlg.m_strTranName);

		m_iTranID3 =  dlg.m_iSelTran;

		m_TranStart3=5;
		m_TranStop3=6;

		UpdateData(FALSE);


	}
	else
		m_EditTran3.SetWindowText(_T(""));
	
}

void CVideoEditDlg::OnBtnexport1() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);	

	CString strVideo1;
	m_EditVideo1.GetWindowText(strVideo1);

	BOOL bResult=m_VideoEdit.GetFrame(strVideo1,m_iExport1,"c:\\test1.bmp");

	if(bResult)
		AfxMessageBox("Save to c:\\test1.bmp");
	else
		AfxMessageBox("Save fail");




}

void CVideoEditDlg::OnBtnexport2() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);	

	CString strVideo2;
	m_EditVideo2.GetWindowText(strVideo2);

	BOOL bResult=m_VideoEdit.GetFrame(strVideo2,m_iExport2,"c:\\test2.bmp");

	if(bResult)
		AfxMessageBox("Save to c:\\test2.bmp");
	else
		AfxMessageBox("Save fail");

	
}

void CVideoEditDlg::OnBtnexport3() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);	

	CString strVideo3;
	m_EditVideo3.GetWindowText(strVideo3);

	BOOL bResult=m_VideoEdit.GetFrame(strVideo3,m_iExport3,"c:\\test3.bmp");

	if(bResult)
		AfxMessageBox("Save to c:\\test3.bmp");
	else
		AfxMessageBox("Save fail");

	
}

void CVideoEditDlg::OnBtnexportwave1() 
{
	// TODO: Add your control notification handler code here

	UpdateData(TRUE);	

	CString strAudio;
	m_EditAudio1.GetWindowText(strAudio);

	m_VideoEdit.InitControl();

	
	m_VideoEdit.AddAudio(strAudio,m_AudioStart1,m_AudioStop1);

	

	BOOL bResult=m_VideoEdit.Save2Wave("c:\\wave1.wav",1,11025,1);

	if(!bResult)
		AfxMessageBox("Fail save to c:\\wave1.wav");
	
	
}

void CVideoEditDlg::OnBtnexportwave2() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);	

	CString strAudio;
	m_EditAudio2.GetWindowText(strAudio);

	m_VideoEdit.InitControl();

	
	m_VideoEdit.AddAudio(strAudio,m_AudioStart2,m_AudioStop2);

	

	BOOL bResult=m_VideoEdit.Save2Wave("c:\\wave2.wav",1,11025,1);

	if(!bResult)
		AfxMessageBox("Fail save to c:\\wave2.wav");
	
}

void CVideoEditDlg::OnBtnexportwave3() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);	

	CString strAudio;
	m_EditAudio3.GetWindowText(strAudio);

	m_VideoEdit.InitControl();

	
	m_VideoEdit.AddAudio(strAudio,m_AudioStart3,m_AudioStop3);

	

	BOOL bResult=m_VideoEdit.Save2Wave("c:\\wave3.wav",1,11025,1);

	if(!bResult)
		AfxMessageBox("Fail save to c:\\wave3.wav");
	
}

void CVideoEditDlg::OnOptoutputtye() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData(TRUE);

	if(m_iOutputType==0) //mpeg
	{

		m_CboMPEGType.EnableWindow(TRUE);
		m_CboMPEGFrameRate.EnableWindow(FALSE);
		m_EditMPEGQuality.EnableWindow(FALSE);
		m_EditVideoBitRate.EnableWindow(FALSE);
		m_EditAudioBitRate.EnableWindow(FALSE);
		m_ChkVBRMode.EnableWindow(TRUE);
		m_CboWMV.EnableWindow(FALSE);

		m_ChkUseAudioComp.EnableWindow(FALSE);
		m_ChkUseVideoComp.EnableWindow(FALSE);
		
		m_EditWidth.EnableWindow(FALSE);
		m_EditHeight.EnableWindow(FALSE);
		m_EditFrame.EnableWindow(FALSE);


	}


}

void CVideoEditDlg::OnOptavi() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);

	if(m_iOutputType==1) //avi
	{

		m_CboMPEGType.EnableWindow(FALSE);
		m_CboMPEGFrameRate.EnableWindow(FALSE);
		m_EditMPEGQuality.EnableWindow(FALSE);
		m_EditVideoBitRate.EnableWindow(FALSE);
		m_EditAudioBitRate.EnableWindow(FALSE);
		m_ChkVBRMode.EnableWindow(FALSE);
		m_CboWMV.EnableWindow(FALSE);

		m_ChkUseAudioComp.EnableWindow(TRUE);
		m_ChkUseVideoComp.EnableWindow(TRUE);
		
		m_EditWidth.EnableWindow(TRUE);
		m_EditHeight.EnableWindow(TRUE);
		m_EditFrame.EnableWindow(TRUE);


	}


	
}

void CVideoEditDlg::OnChkvbrmode() 
{
	// TODO: Add your control notification handler code here
	if(m_ChkVBRMode.GetCheck()==1)
	{
		m_EditMPEGQuality.EnableWindow(TRUE);
		m_EditVideoBitRate.EnableWindow(FALSE);
		m_EditAudioBitRate.EnableWindow(FALSE);

	}
	else
	{
		m_EditMPEGQuality.EnableWindow(FALSE);
		m_EditVideoBitRate.EnableWindow(TRUE);
		m_EditAudioBitRate.EnableWindow(TRUE);

	}

}

void CVideoEditDlg::OnSelchangeCbompegtype() 
{
	// TODO: Add your control notification handler code here

	CString strMpegType;
	m_CboMPEGType.GetLBText( m_CboMPEGType.GetCurSel(),strMpegType);

	if(strMpegType=="CUSTOM MPEG")
	{
		m_CboMPEGFrameRate.EnableWindow(TRUE);
		m_EditWidth.EnableWindow(TRUE);
		m_EditHeight.EnableWindow(TRUE);

	}
	else
	{
		m_CboMPEGFrameRate.EnableWindow(FALSE);
		m_EditWidth.EnableWindow(FALSE);
		m_EditHeight.EnableWindow(FALSE);


	}
	
}

void CVideoEditDlg::OnOptwmv() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);

	if(m_iOutputType==2) //wmv
	{

		m_CboMPEGType.EnableWindow(FALSE);
		m_CboMPEGFrameRate.EnableWindow(FALSE);
		m_EditMPEGQuality.EnableWindow(FALSE);
		m_EditVideoBitRate.EnableWindow(FALSE);
		m_EditAudioBitRate.EnableWindow(FALSE);
		m_ChkVBRMode.EnableWindow(FALSE);
		m_CboWMV.EnableWindow(TRUE);

		m_ChkUseAudioComp.EnableWindow(FALSE);
		m_ChkUseVideoComp.EnableWindow(FALSE);
		
		m_EditWidth.EnableWindow(FALSE);
		m_EditHeight.EnableWindow(FALSE);
		m_EditFrame.EnableWindow(FALSE);


	}

	
}

void CVideoEditDlg::OnChkcustomprofile() 
{
	// TODO: Add your control notification handler code here
	CString strExt=".prx";

	CString strFilter = "Window Media Encoder Profiles(*.prx)|*.prx||";

	CFileDialog dlg(TRUE,"",strExt,OFN_FILEMUSTEXIST,strFilter,this);

	if(m_ChkCustomProfile.GetCheck()==1)
	{

		if(dlg.DoModal()==IDOK)
		{
			m_VideoEdit.SetWMVCustomFileName(dlg.GetPathName());
			m_CboWMV.EnableWindow(FALSE);
			GetDlgItem(IDC_STATICCUSTOMPROFILE)->SetWindowText(dlg.GetPathName());
		}
	}
	else
	{
		m_VideoEdit.SetWMVCustomFileName(_T(""));
		GetDlgItem(IDC_STATICCUSTOMPROFILE)->SetWindowText(_T(""));
	
		m_CboWMV.EnableWindow(TRUE);
	}

	
}
