/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//	RECTANGLE.H					(c)	YoY'01						WEB: www.aestesis.org
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef							_RECTANGLE_H_
#define							_RECTANGLE_H_
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include						<stdio.h>
#include						"types.h"
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//	If you use directly the variables in the class API, it's at your own risks. Prefer the methods...   

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Arectangle
{
public:
								Arectangle						() { x=0; y=0; w=0; h=0; }
								Arectangle						(Arectangle &r);
								Arectangle						(int x, int y, int w, int h);
								Arectangle						(int x, int y);

	void						intersect						(Arectangle &r);
	void						add								(Arectangle &r);
	void						add								(int x, int y);
	void						translat						(int x, int y);
	bool						contains						(int x, int y);

	// private

	int							x;
	int							y;
	int							w;
	int							h;
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

__inline Arectangle::Arectangle(Arectangle &r)
{
	x=r.x;
	y=r.y;
	w=r.w;
	h=r.h;
}

__inline Arectangle::Arectangle(int x, int y, int w, int h)
{
	this->x=x;
	this->y=y;
	this->w=w;
	this->h=h;
}

__inline Arectangle::Arectangle(int x, int y)
{
	this->x=x;
	this->y=y;
	this->w=1;
	this->h=1;
}

__inline void Arectangle::intersect(Arectangle &r)
{
	int xx=maxi(r.x, x);
	int yy=max(r.y, y);
	w=maxi(mini(r.x+r.w, x+w)-xx, 0);
	h=maxi(mini(r.y+r.h, y+h)-yy, 0);
	x=xx;
	y=yy;
}

__inline void Arectangle::translat(int x, int y)
{
	this->x+=x;
	this->y+=y;
}

__inline void Arectangle::add(Arectangle &r)
{
	int xx=mini(r.x, x);
	int yy=mini(r.y, y);
	w=maxi(r.x+r.w, x+w)-xx;
	h=maxi(r.y+r.h, y+h)-yy;
	x=xx;
	y=yy;
}

__inline void Arectangle::add(int rx, int ry)
{
	int xx=mini(rx, x);
	int yy=mini(ry, y);
	w=maxi(rx+1, x+w)-xx;
	h=maxi(ry+1, y+h)-yy;
	x=xx;
	y=yy;
}

__inline bool Arectangle::contains(int x, int y)
{
	return (x>=this->x)&&(x<(this->x+w))&&(y>=this->y)&&(y<(this->y+h));
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif							//_RECTANGLE_H_
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
