<?xml version='1.0' encoding='UTF-8' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>
<xsl:template match="movie">
    <html>
    <head>
    <title><xsl:call-template name="originalTitle"/></title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <link rel="stylesheet" type="text/css" href="{/movies/settings/paths/css}movieInfo.css" title="none" />
    </head>
    <body>
        <table class="topTitle" cellpadding="0" cellspacing="2" border="0" >
        <tbody>
        <tr>
            <td><xsl:text> </xsl:text><xsl:call-template name="originalTitle"/><xsl:text> , (</xsl:text><xsl:call-template name="releaseYear"/><xsl:text>)</xsl:text></td>
        </tr>
        </tbody>
        </table>
        <br />
        <br />
        
        <xsl:call-template name="movieDetails"/>
        <xsl:call-template name="tehnical"/>
        
        <xsl:call-template name="plot"/>
        <xsl:call-template name="other"/>
        <xsl:call-template name="comment"/>
		<xsl:call-template name="settings"/>
    </body>
    </html>
</xsl:template>

<!-- we need this because everything that is not matched is copied to output as text-->
<xsl:template name="settings" match="settings">
</xsl:template>




<xsl:template name="movieDetails" match="movieDetails">
        <table class="" cellpadding="0" cellspacing="2" border="0" width="100%">
        <tbody>
            <tr class="tableTitle"><td colspan="2"><xsl:value-of select="../metaData/field[@name='movieDetails']/@label"/></td></tr>
            <xsl:call-template name="originalTitleTable"/>
            <xsl:call-template name="translatedTitleTable"/>
            <xsl:call-template name="genres"/>
            <xsl:call-template name="format"/>
            <xsl:call-template name="catalogId"/>
            <xsl:call-template name="cdCount"/>
            <xsl:call-template name="region"/>
            <xsl:call-template name="language"/>
            <xsl:call-template name="imdbNo"/>
            <xsl:call-template name="subtitles"/>
            <xsl:call-template name="studios"/>
            <xsl:call-template name="country"/>
        </tbody>
        </table>
        <br />
</xsl:template>

<xsl:template name="originalTitleTable" match="title/original">
    <xsl:if test="movieDetails/title/original!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='originalTitle']/@label"/>: </td>
            <td class="value">
                <xsl:value-of select="movieDetails/title/original" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="translatedTitleTable" match="title/translated">
    <xsl:if test="movieDetails/title/translated!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='translatedTitle']/@label"/>: </td>
            <td class="value">
                <xsl:value-of select="movieDetails/title/translated" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="genres" match="genres">
    <xsl:if test="count(movieDetails/genres/genre) > 0">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='genre']/@label"/>: </td>
            <td class="value">
            <xsl:for-each select="movieDetails/genres/genre">
                <xsl:value-of select="." />
                <xsl:if test="not(position() = last())"> , </xsl:if>
            </xsl:for-each>
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="format" match="format">
    <xsl:if test="movieDetails/format!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='format']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="movieDetails/format" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="catalogId" match="catalogId">
    <xsl:if test="movieDetails/catalogId!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='catalogId']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="movieDetails/catalogId" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="cdCount" match="cdCount">
    <xsl:if test="movieDetails/cdCount!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='cdCount']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="movieDetails/cdCount" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="region" match="region">
    <xsl:if test="movieDetails/region!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='region']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="movieDetails/region" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="language" match="language">
    <xsl:if test="movieDetails/language!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='language']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="movieDetails/language" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="imdbNo" match="imdbNo">
    <xsl:if test="movieDetails/imdbNo!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='IMDbNo']/@label"/>: </td>
            <td class="value">
            <a target="_blank" href="{../metaData/field[@name='IMDbUrlBeg']/@label}{movieDetails/imdbNo}"><xsl:value-of select="../metaData/field[@name='IMDbURL']/@label"/></a>
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="subtitles" match="subtitles">
    <xsl:if test="count(movieDetails/subtitles/subtitle) > 0">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='subtitles']/@label"/>: </td>
            <td class="value">
            <xsl:for-each select="movieDetails/subtitles/subtitle">
                <xsl:value-of select="." />
                <xsl:if test="not(position() = last())"> , </xsl:if>
            </xsl:for-each>
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="studios" match="studios">
    <xsl:if test="count(movieDetails/studios/studio) > 0">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='studio']/@label"/>: </td>
            <td class="value">
            <xsl:for-each select="movieDetails/studios/studio">
                <xsl:value-of select="." />
                <xsl:if test="not(position() = last())"> , </xsl:if>
            </xsl:for-each>
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="country" match="country">
    <xsl:if test="movieDetails/country!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='country']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="movieDetails/country" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>




<xsl:template name="tehnical" match="tehnical">
        <table class="" cellpadding="0" cellspacing="2" border="0" width="100%">
        <tbody>
            <tr class="tableTitle"><td colspan="2"><xsl:value-of select="../metaData/field[@name='tehnical']/@label"/></td></tr>
            <xsl:call-template name="movieLength"/>
            <xsl:call-template name="color"/>
            <xsl:call-template name="movieCodec"/>
            <xsl:call-template name="movieResolution"/>
            <xsl:call-template name="movieBitrate"/>
            <xsl:call-template name="movieFPS"/>
            <xsl:call-template name="audioBitrate"/>
            <xsl:call-template name="audioCodec"/>
            <xsl:call-template name="audioChannels"/>
            <xsl:call-template name="audioSamplerate"/>
            <xsl:call-template name="audioStreams"/>
        </tbody>
        </table>
        <br />
</xsl:template>

<xsl:template name="movieLength" match="movieLength">
    <xsl:if test="tehnical/movieLength!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='runningTime']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="tehnical/movieLength" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="color" match="color">
    <xsl:if test="tehnical/color!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='color']/@label"/>: </td>
            <td class="value">
            <xsl:choose>
                <xsl:when test="tehnical/color ='1'">
                    <xsl:value-of select="../metaData/field[@name='inColor']/@label"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="../metaData/field[@name='blackAndWhite']/@label"/>
                </xsl:otherwise>
            </xsl:choose>
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="movieCodec" match="video/codec">
    <xsl:if test="tehnical/video/codec!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='videoCodec']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="tehnical/video/codec" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="movieResolution" match="video/resolution">
    <xsl:if test="tehnical/video/resolution!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='videoResolution']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="tehnical/video/resolution" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="movieBitrate" match="video/bitrate">
    <xsl:if test="tehnical/video/bitrate!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='videoBitrate']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="tehnical/video/bitrate" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="movieFPS" match="video/fps">
    <xsl:if test="tehnical/video/fps!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='videoFPS']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="tehnical/video/fps" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="audioBitrate" match="audio/bitrate">
    <xsl:if test="tehnical/audio/bitrate!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='audioBitrate']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="tehnical/audio/bitrate" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="audioCodec" match="audio/codec">
    <xsl:if test="tehnical/audio/codec!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='audioCodec']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="tehnical/audio/codec" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="audioChannels" match="audio/channels">
    <xsl:if test="tehnical/audio/channels!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='audioChanels']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="tehnical/audio/channels" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="audioSamplerate" match="audio/samplerate">
    <xsl:if test="tehnical/audio/samplerate!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='audioSamplerate']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="tehnical/audio/samplerate" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="audioStreams" match="audio/streams">
    <xsl:if test="tehnical/audio/streams!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='audioStreams']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="tehnical/audio/streams" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>




<xsl:template name="plot" match="plot">
    <xsl:if test="plot!=''">
        <table class="" cellpadding="0" cellspacing="2" border="0" width="100%">
        <tbody>
            <tr class="tableTitle"><td><xsl:value-of select="../metaData/field[@name='plot']/@label"/></td></tr>
            <tr class="value"><td>
                <xsl:call-template name="break">
                    <xsl:with-param name="text" select="plot"/>
                </xsl:call-template>
            </td></tr>
        </tbody>
        </table>
        <br />
    </xsl:if>
</xsl:template>




<xsl:template name="other" match="other">
        <table class="" cellpadding="0" cellspacing="2" border="0" width="100%">
        <tbody>
            <tr class="tableTitle"><td colspan="2"><xsl:value-of select="../metaData/field[@name='other']/@label"/></td></tr>
            <xsl:call-template name="seen"/>
            <xsl:call-template name="myRating"/>
            <xsl:call-template name="insertDate"/>
            <xsl:call-template name="loan"/>
        </tbody>
        </table>
        <br />
</xsl:template>

<xsl:template name="seen" match="seen">
    <xsl:if test="other/seen!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='seen']/@label"/>: </td>
            <td class="value">
            <xsl:choose>
                <xsl:when test="other/seen ='1'">
                    <xsl:value-of select="../metaData/field[@name='yes']/@label"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="../metaData/field[@name='no']/@label"/>
                </xsl:otherwise>
            </xsl:choose>
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="myRating" match="myRating">
    <xsl:if test="other/myRating!=''">
    <xsl:if test="other/myRating > 0">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='myRating']/@label"/>: </td>
            <td class="value">
            <xsl:call-template name="ratingStars">
                <xsl:with-param name="no" select="other/myRating"/>
            </xsl:call-template>
            (<xsl:value-of select="other/myRating div 2" />)
            </td>
        </tr>
    </xsl:if>
    </xsl:if>
</xsl:template>

<xsl:template name="insertDate" match="insertDate">
    <xsl:if test="other/insertDate!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='insertionDate']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="other/insertDate" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="loan" match="loan">
    <xsl:if test="count(other/loan) > 0">
        <xsl:call-template name="member"/>
        <xsl:call-template name="loanDate"/>
        <xsl:call-template name="loanDays"/>
    </xsl:if>
</xsl:template>

<xsl:template name="member" match="member">
    <xsl:if test="other/loan/member!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='loanedTo']/@label"/>: </td>
            <td class="value">
            <xsl:value-of select="other/loan/member" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="loanDate" match="loan/date">
    <xsl:if test="other/loan/date!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='loanDate']/@label"/>: </td>
            <td class="value">
            <xsl:choose>
                <xsl:when test="other/loan/days > other/loan/daysMax">
                    <div class="loanOver"><xsl:value-of select="other/loan/date" /></div>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="other/loan/date" />
                </xsl:otherwise>
            </xsl:choose>
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template name="loanDays" match="loan/days">
    <xsl:if test="other/loan/days!=''">
        <tr>
            <td class="label" style="width:30%"><xsl:value-of select="../metaData/field[@name='loanDays']/@label"/>: </td>
            <td class="value">
                <xsl:value-of select="other/loan/days" />
            </td>
        </tr>
    </xsl:if>
</xsl:template>




<xsl:template name="comment" match="comment">
    <xsl:if test="comment!=''">
        <table class="" cellpadding="0" cellspacing="2" border="0" width="100%">
        <tbody>
            <tr class="tableTitle"><td><xsl:value-of select="../metaData/field[@name='comment']/@label"/></td></tr>
            <tr class="value"><td>
                <xsl:call-template name="break">
                    <xsl:with-param name="text" select="comment"/>
                </xsl:call-template>
            </td></tr>
        </tbody>
        </table>
        <br />
    </xsl:if>
</xsl:template>

<xsl:template name="originalTitle" match="title/original">
    <xsl:value-of select="movieDetails/title/original" />
</xsl:template>

<xsl:template name="translatedTitle" match="title/translated">
    <xsl:value-of select="movieDetails/title/translated" />
</xsl:template>

<xsl:template name="releaseYear" match="releaseYear">
    <xsl:value-of select="movieDetails/releaseYear" />
</xsl:template>

<xsl:template name="break">
    <xsl:param name="text" select="."/>
    <xsl:choose>
    <xsl:when test="contains($text, '&#13;&#10;')">
        <xsl:value-of disable-output-escaping="yes" select="substring-before($text, '&#13;&#10;')"/>
        <br />
        <xsl:call-template name="break">
            <xsl:with-param name="text" select="substring-after($text,'&#13;&#10;')"/>
        </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
        <xsl:value-of disable-output-escaping="yes" select="$text"/>
    </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="ratingStars">
    <xsl:param name="no" select="0"/>
    <xsl:if test="$no > 0">
        <xsl:choose>
        <xsl:when test="$no > 1">
            <img src="{/movies/settings/paths/images}star.gif"/>
            <xsl:call-template name="ratingStars">
                    <xsl:with-param name="no" select="$no - 2"/>
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
            <img src="{/movies/settings/paths/images}starh.gif"/>
        </xsl:otherwise>
        </xsl:choose>
    </xsl:if>
</xsl:template>



</xsl:stylesheet>
