<?php session_start();

#TinyEdit sample alternative storage method
#by default tinyEdit stores your storage data blocks in files
# but you could use a database or pretty much anything
# this is a sample that uses session variables for temporary storage.
# currently these are very basic blocks for storage, they need to be
# able to support more complicated blocks.
#
# you must edit tinyedit_config to include this file
# and this file must support four  functions:
#
#
#
# te_setContent(blockname,contenttext)
# te_getContent(blockname) # Must return the content as a string
#
# te_getMeta(blockname,metaName)           returns string
# te_setMeta(blockname,metaName,metaValue) 
# blockname will be a uniq identifier
# 
#
# For a mysql sample see http://www.tinyedit.com
#
#
if(!isset($_SESSION["demoblock"])) $_SESSION["demoblock"] = "Try tinyEdit now! <b>Press Ctrl-Z</b>";

function te_setContent($blockname,$contenttext)
{
    #global $_SESSION;

    $_SESSION[$blockname] = $contenttext;

}

function te_getContent($blockname)
{
    #global $_SESSION;
    
    

    if(isset($_SESSION[$blockname]))
        return( $_SESSION[$blockname]);
    else 
        return(Session_Name());
}

function te_getMeta($blockname)
{
    #global $_SESSION;
    
    if(isset($_SESSION[$blockname. "_meta"]))
    {
      return($_SESSION[$blockname . "_meta"]);
    }
     else
       {
        return(null);
       }
    
}

function te_setMeta($blockname,$meta)
{
    #global $_SESSION;
    $_SESSION[$blockname . "_meta"]= $meta;
    }


?>
