// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : trace.h
//
//  DESCRIPTION :
//         Auxiliary Trace class definition
//
// #################################################################


////////////////////////
#ifndef INCLUDED_TRACE_H
#define INCLUDED_TRACE_H
////////////////////////


// ================
#include "common.h"
// ================

// -----------------------
class ClassTrace
{
  private :
    static size_t	shift_s;
    static size_t	count_s;

    const string	file_name_;
    const size_t	line_no_;
    const string	func_name_;
    const string	pretty_func_name_;
    vector<string>	extra_info_vect_;

    const size_t	count_;

  public :
    ClassTrace (
		const string&	file_name_i,
		size_t 		line_no_i,
		const string&	func_name_i,
		const string&	pretty_func_name_i,
		const string&	extra_info_str_i = string()
		);
    ~ClassTrace ();
    void show_trace (
		const string&	step_i, 
		const string&	msg_i, 
		const string&	extra_info_i, 
		size_t		line_no_i
		);

};

//////
#endif
//////
