#!/bin/bash
#
# RatheDG Cachalot System 1.2.0. PostgreSQL startup/shutdown script.
#

DEFAULT_DIR=/opt/pgsql
DEFAULT_DATA=$DEFAULT_DIR/data
DEFAULT_LOG=/var/opt/postgresql

#
# .
#
check()
{    
    ERR=$?
    if [ $ERR -ne 0 ]; then
        echo "Failed, status code = $ERR."
        echo
        exit $ERR
    fi
}

#
# Performs PostgreSQL startup/shutdown.
#
pgsql()
{
    PGDIR=$2
    if [ -z "$PGDIR" ]; then
        PGDIR=$DEFAULT_DIR
    fi

    PGDATA=$3
    if [ -z "$PGDATA" ]; then
        PGDATA=$DEFAULT_DATA
    fi

    PGLOG=$4
    if [ -z "$PGLOG" ]; then
        PGLOG=$DEFAULT_LOG
    fi

    echo "Using PGSQL_DIRECTORY:  $PGDIR"
    echo "Using PGSQL_DATA:       $PGDATA"
    echo "Using PGSQL_LOGFILE:    $PGLOG"
	echo

	if [ "$1" == "start" ]; then
	    echo "Starting PostgreSQL."

		DO="cd `pwd`;$PGDIR/bin/pg_ctl start -s -D $PGDATA -l $PGLOG -o '-i'"
	else
	    echo "Stopping PostgreSQL."

		DO="cd `pwd`;$PGDIR/bin/pg_ctl stop -m fast -D $PGDATA -l $PGLOG"
	fi

    su - postgres -m -c "$DO"

    ERR=$?
    if [ $ERR -ne 0 ]; then
        echo "Failed, status code = $ERR."
        echo
        exit $ERR
    fi

	echo
	echo "Done."
}
          
echo

case "$1" in
	'start' | 'stop')
		pgsql $* ;;
	*)
        echo "PostgreSQL startup/shutdown."
        echo
        echo "Usage:"
        echo "    postgres.sh command [install-dir [data-dir [log-file]]]"
        echo
        echo "Commands:"
        echo "    start  -  start PostgreSQL."
        echo "    stop   -  stop PostgreSQL."
        echo
        echo "Parameters:"
        echo "    * 'install-dir' is path to PostgreSQL installation."
        echo "       Default value is $DEFAULT_DIR."
        echo "    * 'data-dir' is path to PostgreSQL data directory."
        echo "       Default value is $DEFAULT_DATA."
        echo "    * 'log-file' is path to PostgreSQL log file."
        echo "       Default value is $DEFAULT_LOG."
esac
                        
echo

