/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util;

import com.rathedg.util.exception.InvalidNamedValueException;
import com.rathedg.util.exception.InvalidValueException;

public final class StringDataConvertor {
    private static final String NULL = "null";
    private static final String EMPTY = "empty";
    private static final String NULLOREMPTY = "null or empty";
    private static final String NOTNULL = "present";
    private static final String NOTEMPTY = "not empty";
    private static final String NOTNULLNOTEMPTY = "present and not empty";
    private static final String CHAR = "single character";
    private static final String INTEGERNUM = "integer number";
    private static final String FRACTIONALNUM = "fractional number";
    private static final String FROMINTERVAL = " from interval ";

    public static boolean toNamedBoolean(String string, String string2) throws InvalidNamedValueException {
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw new InvalidNamedValueException(string, string2, "'true' or 'false'");
    }

    public static byte toNamedByte(String string, String string2) throws InvalidNamedValueException {
        try {
            return Byte.parseByte(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidNamedValueException(string, string2, INTEGERNUM);
        }
    }

    public static short toNamedShort(String string, String string2) throws InvalidNamedValueException {
        try {
            return Short.parseShort(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidNamedValueException(string, string2, INTEGERNUM);
        }
    }

    public static int toNamedInt(String string, String string2) throws InvalidNamedValueException {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidNamedValueException(string, string2, INTEGERNUM);
        }
    }

    public static long toNamedLong(String string, String string2) throws InvalidNamedValueException {
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidNamedValueException(string, string2, INTEGERNUM);
        }
    }

    public static float toNamedFloat(String string, String string2) throws InvalidNamedValueException {
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidNamedValueException(string, string2, "real or integer number");
        }
    }

    public static double toNamedDouble(String string, String string2) throws InvalidNamedValueException {
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidNamedValueException(string, string2, "real or integer number");
        }
    }

    public static String toStringEmptyAsNull(String string, String string2) throws InvalidNamedValueException {
        if (string2 != null && string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public static String toStringNotNull(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        return string2;
    }

    public static String toStringNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 != null && string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return string2;
    }

    public static String toStringNotNullNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            throw new InvalidNamedValueException(string, NULLOREMPTY, NOTNULLNOTEMPTY);
        }
        return string2;
    }

    public static String toStringNotNull(String string, String string2, String string3) {
        if (string2 == null) {
            return string3;
        }
        return string2;
    }

    public static String toStringNotEmpty(String string, String string2, String string3) {
        if (string2 != null && string2.length() == 0) {
            return string3;
        }
        return string2;
    }

    public static String toStringNotNullNotEmpty(String string, String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            return string3;
        }
        return string2;
    }

    public static Integer toEnumeratedStringPlusNull(String string, String string2, String[] stringArray, boolean bl) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedString(string, string2, stringArray, bl));
    }

    public static int toEnumeratedStringNotNull(String string, String string2, String[] stringArray, boolean bl) throws InvalidNamedValueException {
        return StringDataConvertor.toEnumeratedString(string, StringDataConvertor.toStringNotNull(string, string2), stringArray, bl);
    }

    public static int toEnumeratedStringNotNull(String string, String string2, String string3, String[] stringArray, boolean bl) throws InvalidNamedValueException {
        return StringDataConvertor.toEnumeratedString(string, StringDataConvertor.toStringNotNull(string, string2, string3), stringArray, bl);
    }

    public static Integer toEnumeratedStringEmptyAsNull(String string, String string2, String[] stringArray, boolean bl) throws InvalidNamedValueException {
        String string3 = StringDataConvertor.toStringEmptyAsNull(string, string2);
        if (string3 == null) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedString(string, string3, stringArray, bl));
    }

    public static int toEnumeratedStringNotNullNotEmpty(String string, String string2, String[] stringArray, boolean bl) throws InvalidNamedValueException {
        return StringDataConvertor.toEnumeratedString(string, StringDataConvertor.toStringNotNullNotEmpty(string, string2), stringArray, bl);
    }

    public static int toEnumeratedStringNotNullNotEmpty(String string, String string2, String string3, String[] stringArray, boolean bl) throws InvalidNamedValueException {
        return StringDataConvertor.toEnumeratedString(string, StringDataConvertor.toStringNotNullNotEmpty(string, string2, string3), stringArray, bl);
    }

    private static int toEnumeratedString(String string, String string2, String[] stringArray, boolean bl) throws InvalidNamedValueException {
        int n;
        if (bl) {
            string2 = string2.toLowerCase();
            n = 0;
            while (n < stringArray.length) {
                if (string2.equals(stringArray[n].toLowerCase())) {
                    return n;
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < stringArray.length) {
                if (string2.equals(stringArray[n])) {
                    return n;
                }
                ++n;
            }
        }
        String string3 = "one of '" + stringArray[0] + "'";
        n = 1;
        while (n < stringArray.length) {
            string3 = string3 + ",'" + stringArray[n] + "'";
            ++n;
        }
        if (bl) {
            string3 = string3 + " (case insensitive)";
        }
        if (string2.length() == 0) {
            string2 = EMPTY;
        }
        throw new InvalidNamedValueException(string, string2, string3);
    }

    public static Boolean toBooleanNotEmpty(String string, String string2, boolean bl) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (bl) {
            string2 = string2.toLowerCase();
        }
        return new Boolean(StringDataConvertor.toNamedBoolean(string, string2));
    }

    public static boolean toBooleanNotNullNotEmpty(String string, String string2, boolean bl) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (bl) {
            string2 = string2.toLowerCase();
        }
        return StringDataConvertor.toNamedBoolean(string, string2);
    }

    public static Boolean toBooleanNotEmpty(String string, String string2, boolean bl, boolean bl2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Boolean(bl);
        }
        if (bl2) {
            string2 = string2.toLowerCase();
        }
        return new Boolean(StringDataConvertor.toNamedBoolean(string, string2));
    }

    public static boolean toBooleanNotNullNotEmpty(String string, String string2, boolean bl, boolean bl2) throws InvalidNamedValueException {
        if (string2 == null) {
            return bl;
        }
        if (string2.length() == 0) {
            return bl;
        }
        if (bl2) {
            string2 = string2.toLowerCase();
        }
        return StringDataConvertor.toNamedBoolean(string, string2);
    }

    public static Boolean toBooleanEmptyAsNull(String string, String string2, boolean bl) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        if (bl) {
            string2 = string2.toLowerCase();
        }
        return new Boolean(StringDataConvertor.toNamedBoolean(string, string2));
    }

    public static Character toCharEmptyAsNull(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        return new Character(string2.charAt(0));
    }

    public static Character toCharNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        return new Character(string2.charAt(0));
    }

    public static Character toCharNotEmpty(String string, String string2, char c) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Character(c);
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        return new Character(string2.charAt(0));
    }

    public static char toCharNotNullNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        return string2.charAt(0);
    }

    public static char toCharNotNullNotEmpty(String string, String string2, char c) throws InvalidNamedValueException {
        if (string2 == null) {
            return c;
        }
        if (string2.length() == 0) {
            return c;
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        return string2.charAt(0);
    }

    public static Integer toEnumeratedCharEmptyAsNull(String string, String string2, char[] cArray) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        return new Integer(StringDataConvertor.toEnumeratedChar(string, string2.charAt(0), cArray));
    }

    public static Integer toEnumeratedCharNotEmpty(String string, String string2, char[] cArray) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        return new Integer(StringDataConvertor.toEnumeratedChar(string, string2.charAt(0), cArray));
    }

    public static int toEnumeratedCharNotNullNotEmpty(String string, String string2, char[] cArray) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        return StringDataConvertor.toEnumeratedChar(string, string2.charAt(0), cArray);
    }

    public static Character toIntervalCharEmptyAsNull(String string, String string2, char c, char c2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        char c3 = string2.charAt(0);
        if (c3 < c || c3 > c2) {
            throw new InvalidNamedValueException(string, string2, "single character from interval '" + c + "'-'" + c2 + "'");
        }
        return new Character(c3);
    }

    public static Character toIntervalCharNotEmpty(String string, String string2, char c, char c2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        char c3 = string2.charAt(0);
        if (c3 < c || c3 > c2) {
            throw new InvalidNamedValueException(string, string2, "single character from interval '" + c + "'-'" + c2 + "'");
        }
        return new Character(c3);
    }

    public static Character toIntervalCharNotEmpty(String string, String string2, char c, char c2, char c3) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Character(c);
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        char c4 = string2.charAt(0);
        if (c4 < c2 || c4 > c3) {
            throw new InvalidNamedValueException(string, string2, "single character from interval '" + c2 + "'-'" + c3 + "'");
        }
        return new Character(c4);
    }

    public static char toIntervalCharNotNullNotEmpty(String string, String string2, char c, char c2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        char c3 = string2.charAt(0);
        if (c3 < c || c3 > c2) {
            throw new InvalidNamedValueException(string, string2, "single character from interval '" + c + "'-'" + c2 + "'");
        }
        return c3;
    }

    public static char toIntervalCharNotNullNotEmpty(String string, String string2, char c, char c2, char c3) throws InvalidNamedValueException {
        if (string2 == null) {
            return c;
        }
        if (string2.length() == 0) {
            return c;
        }
        if (string2.length() > 1) {
            throw new InvalidNamedValueException(string, string2, CHAR);
        }
        char c4 = string2.charAt(0);
        if (c4 < c2 || c4 > c3) {
            throw new InvalidNamedValueException(string, string2, "single character from interval '" + c2 + "'-'" + c3 + "'");
        }
        return c4;
    }

    private static int toEnumeratedChar(String string, char c, char[] cArray) throws InvalidNamedValueException {
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) break;
            ++n;
        }
        if (n == cArray.length) {
            String string2 = "one of '" + cArray[0] + "'";
            n = 1;
            while (n < cArray.length) {
                string2 = string2 + ",'" + cArray[n] + "'";
                ++n;
            }
            throw new InvalidNamedValueException(string, String.valueOf(c), string2);
        }
        return n;
    }

    public static Byte toByteEmptyAsNull(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Byte(StringDataConvertor.toNamedByte(string, string2));
    }

    public static Byte toByteNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Byte(StringDataConvertor.toNamedByte(string, string2));
    }

    public static Byte toByteNotEmpty(String string, String string2, byte by) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Byte(by);
        }
        return new Byte(StringDataConvertor.toNamedByte(string, string2));
    }

    public static byte toByteNotNullNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toNamedByte(string, string2);
    }

    public static byte toByteNotNullNotEmpty(String string, String string2, byte by) throws InvalidNamedValueException {
        if (string2 == null) {
            return by;
        }
        if (string2.length() == 0) {
            return by;
        }
        return StringDataConvertor.toNamedByte(string, string2);
    }

    public static Integer toEnumeratedByteEmptyAsNull(String string, String string2, byte[] byArray) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedByte(string, StringDataConvertor.toNamedByte(string, string2), byArray));
    }

    public static Integer toEnumeratedByteNotEmpty(String string, String string2, byte[] byArray) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedByte(string, StringDataConvertor.toNamedByte(string, string2), byArray));
    }

    public static int toEnumeratedByteNotNullNotEmpty(String string, String string2, byte[] byArray) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedByte(string, StringDataConvertor.toNamedByte(string, string2), byArray);
    }

    public static Byte toIntervalByteEmptyAsNull(String string, String string2, byte by, byte by2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        byte by3 = StringDataConvertor.toNamedByte(string, string2);
        if (by3 < by || by3 > by2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + by + "'-'" + by2 + "'");
        }
        return new Byte(by3);
    }

    public static Byte toIntervalByteNotEmpty(String string, String string2, byte by, byte by2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        byte by3 = StringDataConvertor.toNamedByte(string, string2);
        if (by3 < by || by3 > by2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + by + "'-'" + by2 + "'");
        }
        return new Byte(by3);
    }

    public static Byte toIntervalByteNotEmpty(String string, String string2, byte by, byte by2, byte by3) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Byte(by);
        }
        byte by4 = StringDataConvertor.toNamedByte(string, string2);
        if (by4 < by2 || by4 > by3) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + by2 + "'-'" + by3 + "'");
        }
        return new Byte(by4);
    }

    public static byte toIntervalByteNotNullNotEmpty(String string, String string2, byte by, byte by2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        byte by3 = StringDataConvertor.toNamedByte(string, string2);
        if (by3 < by || by3 > by2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + by + "'-'" + by2 + "'");
        }
        return by3;
    }

    public static byte toIntervalByteNotNullNotEmpty(String string, String string2, byte by, byte by2, byte by3) throws InvalidNamedValueException {
        if (string2 == null) {
            return by;
        }
        if (string2.length() == 0) {
            return by;
        }
        byte by4 = StringDataConvertor.toNamedByte(string, string2);
        if (by4 < by2 || by4 > by3) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + by2 + "'-'" + by3 + "'");
        }
        return by4;
    }

    private static int toEnumeratedByte(String string, byte by, byte[] byArray) throws InvalidNamedValueException {
        int n = 0;
        while (n < byArray.length) {
            if (by == byArray[n]) break;
            ++n;
        }
        if (n == byArray.length) {
            String string2 = "one of '" + byArray[0] + "'";
            n = 1;
            while (n < byArray.length) {
                string2 = string2 + ",'" + byArray[n] + "'";
                ++n;
            }
            throw new InvalidNamedValueException(string, String.valueOf(by), string2);
        }
        return n;
    }

    public static Short toShortEmptyAsNull(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Short(StringDataConvertor.toNamedShort(string, string2));
    }

    public static Short toShortNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Short(StringDataConvertor.toNamedShort(string, string2));
    }

    public static Short toShortNotEmpty(String string, String string2, short s) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Short(s);
        }
        return new Short(StringDataConvertor.toNamedShort(string, string2));
    }

    public static short toShortNotNullNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toNamedShort(string, string2);
    }

    public static short toShortNotNullNotEmpty(String string, String string2, short s) throws InvalidNamedValueException {
        if (string2 == null) {
            return s;
        }
        if (string2.length() == 0) {
            return s;
        }
        return StringDataConvertor.toNamedShort(string, string2);
    }

    public static Integer toEnumeratedShortEmptyAsNull(String string, String string2, short[] sArray) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedShort(string, StringDataConvertor.toNamedShort(string, string2), sArray));
    }

    public static Integer toEnumeratedShortNotEmpty(String string, String string2, short[] sArray) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedShort(string, StringDataConvertor.toNamedShort(string, string2), sArray));
    }

    public static int toEnumeratedShortNotNullNotEmpty(String string, String string2, short[] sArray) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedShort(string, StringDataConvertor.toNamedShort(string, string2), sArray);
    }

    public static Short toIntervalShortEmptyAsNull(String string, String string2, short s, short s2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        short s3 = StringDataConvertor.toNamedShort(string, string2);
        if (s3 < s || s3 > s2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + s + "'-'" + s2 + "'");
        }
        return new Short(s3);
    }

    public static Short toIntervalShortNotEmpty(String string, String string2, short s, short s2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        short s3 = StringDataConvertor.toNamedShort(string, string2);
        if (s3 < s || s3 > s2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + s + "'-'" + s2 + "'");
        }
        return new Short(s3);
    }

    public static Short toIntervalShortNotEmpty(String string, String string2, byte by, short s, short s2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Short(by);
        }
        short s3 = StringDataConvertor.toNamedShort(string, string2);
        if (s3 < s || s3 > s2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + s + "'-'" + s2 + "'");
        }
        return new Short(s3);
    }

    public static short toIntervalShortNotNullNotEmpty(String string, String string2, short s, short s2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        short s3 = StringDataConvertor.toNamedShort(string, string2);
        if (s3 < s || s3 > s2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + s + "'-'" + s2 + "'");
        }
        return s3;
    }

    public static short toIntervalShortNotNullNotEmpty(String string, String string2, short s, short s2, short s3) throws InvalidNamedValueException {
        if (string2 == null) {
            return s;
        }
        if (string2.length() == 0) {
            return s;
        }
        short s4 = StringDataConvertor.toNamedShort(string, string2);
        if (s4 < s2 || s4 > s3) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + s2 + "'-'" + s3 + "'");
        }
        return s4;
    }

    private static int toEnumeratedShort(String string, short s, short[] sArray) throws InvalidNamedValueException {
        int n = 0;
        while (n < sArray.length) {
            if (s == sArray[n]) break;
            ++n;
        }
        if (n == sArray.length) {
            String string2 = "one of '" + sArray[0] + "'";
            n = 1;
            while (n < sArray.length) {
                string2 = string2 + ",'" + sArray[n] + "'";
                ++n;
            }
            throw new InvalidNamedValueException(string, String.valueOf(s), string2);
        }
        return n;
    }

    public static Integer toIntegerEmptyAsNull(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toNamedInt(string, string2));
    }

    public static Integer toIntegerNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toNamedInt(string, string2));
    }

    public static Integer toIntegerNotEmpty(String string, String string2, int n) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Integer(n);
        }
        return new Integer(StringDataConvertor.toNamedInt(string, string2));
    }

    public static int toIntegerNotNullNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toNamedInt(string, string2);
    }

    public static int toIntegerNotNullNotEmpty(String string, String string2, int n) throws InvalidNamedValueException {
        if (string2 == null) {
            return n;
        }
        if (string2.length() == 0) {
            return n;
        }
        return StringDataConvertor.toNamedInt(string, string2);
    }

    public static Integer toEnumeratedIntegerEmptyAsNull(String string, String string2, int[] nArray) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedInteger(string, StringDataConvertor.toNamedInt(string, string2), nArray));
    }

    public static Integer toEnumeratedIntegerNotEmpty(String string, String string2, int[] nArray) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedInteger(string, StringDataConvertor.toNamedInt(string, string2), nArray));
    }

    public static int toEnumeratedIntegerNotNullNotEmpty(String string, String string2, int[] nArray) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedInteger(string, StringDataConvertor.toNamedInt(string, string2), nArray);
    }

    public static Integer toIntervalIntegerEmptyAsNull(String string, String string2, int n, int n2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        int n3 = StringDataConvertor.toNamedInt(string, string2);
        if (n3 < n || n3 > n2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + n + "'-'" + n2 + "'");
        }
        return new Integer(n3);
    }

    public static Integer toIntervalIntegerNotEmpty(String string, String string2, int n, int n2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        int n3 = StringDataConvertor.toNamedInt(string, string2);
        if (n3 < n || n3 > n2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + n + "'-'" + n2 + "'");
        }
        return new Integer(n3);
    }

    public static Integer toIntervalIntegerNotEmpty(String string, String string2, int n, int n2, int n3) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Integer(n);
        }
        int n4 = StringDataConvertor.toNamedInt(string, string2);
        if (n4 < n2 || n4 > n3) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + n2 + "'-'" + n3 + "'");
        }
        return new Integer(n4);
    }

    public static int toIntervalIntegerNotNullNotEmpty(String string, String string2, int n, int n2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        int n3 = StringDataConvertor.toNamedInt(string, string2);
        if (n3 < n || n3 > n2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + n + "'-'" + n2 + "'");
        }
        return n3;
    }

    public static int toIntervalIntegerNotNullNotEmpty(String string, String string2, int n, int n2, int n3) throws InvalidNamedValueException {
        if (string2 == null) {
            return n;
        }
        if (string2.length() == 0) {
            return n;
        }
        int n4 = StringDataConvertor.toNamedInt(string, string2);
        if (n4 < n2 || n4 > n3) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + n2 + "'-'" + n3 + "'");
        }
        return n4;
    }

    private static int toEnumeratedInteger(String string, int n, int[] nArray) throws InvalidNamedValueException {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) break;
            ++n2;
        }
        if (n2 == nArray.length) {
            String string2 = "one of '" + nArray[0] + "'";
            n2 = 1;
            while (n2 < nArray.length) {
                string2 = string2 + ",'" + nArray[n2] + "'";
                ++n2;
            }
            throw new InvalidNamedValueException(string, String.valueOf(n), string2);
        }
        return n2;
    }

    public static Long toLongEmptyAsNull(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Long(StringDataConvertor.toNamedLong(string, string2));
    }

    public static Long toLongNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Long(StringDataConvertor.toNamedLong(string, string2));
    }

    public static Long toLongNotEmpty(String string, String string2, long l) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Long(l);
        }
        return new Long(StringDataConvertor.toNamedLong(string, string2));
    }

    public static long toLongNotNullNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toNamedLong(string, string2);
    }

    public static long toLongNotNullNotEmpty(String string, String string2, long l) throws InvalidNamedValueException {
        if (string2 == null) {
            return l;
        }
        if (string2.length() == 0) {
            return l;
        }
        return StringDataConvertor.toNamedLong(string, string2);
    }

    public static Integer toEnumeratedLongEmptyAsNull(String string, String string2, long[] lArray) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedLong(string, StringDataConvertor.toNamedLong(string, string2), lArray));
    }

    public static Integer toEnumeratedLongNotEmpty(String string, String string2, long[] lArray) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedLong(string, StringDataConvertor.toNamedLong(string, string2), lArray));
    }

    public static int toEnumeratedLongNotNullNotEmpty(String string, String string2, long[] lArray) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedLong(string, StringDataConvertor.toNamedLong(string, string2), lArray);
    }

    public static Long toIntervalLongEmptyAsNull(String string, String string2, long l, long l2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        long l3 = StringDataConvertor.toNamedLong(string, string2);
        if (l3 < l || l3 > l2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + l + "'-'" + l2 + "'");
        }
        return new Long(l3);
    }

    public static Long toIntervalLongNotEmpty(String string, String string2, long l, long l2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        long l3 = StringDataConvertor.toNamedLong(string, string2);
        if (l3 < l || l3 > l2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + l + "'-'" + l2 + "'");
        }
        return new Long(l3);
    }

    public static Long toIntervalLongNotEmpty(String string, String string2, long l, long l2, long l3) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Long(l);
        }
        long l4 = StringDataConvertor.toNamedLong(string, string2);
        if (l4 < l2 || l4 > l3) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + l2 + "'-'" + l3 + "'");
        }
        return new Long(l4);
    }

    public static long toIntervalLongNotNullNotEmpty(String string, String string2, long l, long l2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        long l3 = StringDataConvertor.toNamedLong(string, string2);
        if (l3 < l || l3 > l2) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + l + "'-'" + l2 + "'");
        }
        return l3;
    }

    public static long toIntervalLongNotNullNotEmpty(String string, String string2, long l, long l2, long l3) throws InvalidNamedValueException {
        if (string2 == null) {
            return l;
        }
        if (string2.length() == 0) {
            return l;
        }
        long l4 = StringDataConvertor.toNamedLong(string, string2);
        if (l4 < l2 || l4 > l3) {
            throw new InvalidNamedValueException(string, string2, "integer number from interval '" + l2 + "'-'" + l3 + "'");
        }
        return l4;
    }

    private static int toEnumeratedLong(String string, long l, long[] lArray) throws InvalidNamedValueException {
        int n = 0;
        while (n < lArray.length) {
            if (l == lArray[n]) break;
            ++n;
        }
        if (n == lArray.length) {
            String string2 = "one of '" + lArray[0] + "'";
            n = 1;
            while (n < lArray.length) {
                string2 = string2 + ",'" + lArray[n] + "'";
                ++n;
            }
            throw new InvalidNamedValueException(string, String.valueOf(l), string2);
        }
        return n;
    }

    public static Float toFloatEmptyAsNull(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Float(StringDataConvertor.toNamedFloat(string, string2));
    }

    public static Float toFloatNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Float(StringDataConvertor.toNamedFloat(string, string2));
    }

    public static Float toFloatNotEmpty(String string, String string2, float f) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Float(f);
        }
        return new Float(StringDataConvertor.toNamedFloat(string, string2));
    }

    public static float toFloatNotNullNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toNamedFloat(string, string2);
    }

    public static float toFloatNotNullNotEmpty(String string, String string2, float f) throws InvalidNamedValueException {
        if (string2 == null) {
            return f;
        }
        if (string2.length() == 0) {
            return f;
        }
        return StringDataConvertor.toNamedFloat(string, string2);
    }

    public static Integer toEnumeratedFloatEmptyAsNull(String string, String string2, float[] fArray) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedFloat(string, StringDataConvertor.toNamedFloat(string, string2), fArray));
    }

    public static Integer toEnumeratedFloatNotEmpty(String string, String string2, float[] fArray) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedFloat(string, StringDataConvertor.toNamedFloat(string, string2), fArray));
    }

    public static int toEnumeratedFloatNotNullNotEmpty(String string, String string2, float[] fArray) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedFloat(string, StringDataConvertor.toNamedFloat(string, string2), fArray);
    }

    public static Float toIntervalFloatEmptyAsNull(String string, String string2, float f, float f2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        float f3 = StringDataConvertor.toNamedFloat(string, string2);
        if (f3 < f || f3 > f2) {
            throw new InvalidNamedValueException(string, string2, "fractional number from interval '" + f + "'-'" + f2 + "'");
        }
        return new Float(f3);
    }

    public static Float toIntervalFloatNotEmpty(String string, String string2, float f, float f2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        float f3 = StringDataConvertor.toNamedFloat(string, string2);
        if (f3 < f || f3 > f2) {
            throw new InvalidNamedValueException(string, string2, "fractional number from interval '" + f + "'-'" + f2 + "'");
        }
        return new Float(f3);
    }

    public static Float toIntervalFloatNotEmpty(String string, String string2, float f, float f2, float f3) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Float(f);
        }
        float f4 = StringDataConvertor.toNamedFloat(string, string2);
        if (f4 < f2 || f4 > f3) {
            return new Float(f);
        }
        return new Float(f4);
    }

    public static float toIntervalFloatNotNullNotEmpty(String string, String string2, float f, float f2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        float f3 = StringDataConvertor.toNamedFloat(string, string2);
        if (f3 < f || f3 > f2) {
            throw new InvalidNamedValueException(string, string2, "fractional number from interval '" + f + "'-'" + f2 + "'");
        }
        return f3;
    }

    public static float toIntervalFloatNotNullNotEmpty(String string, String string2, float f, float f2, float f3) throws InvalidNamedValueException {
        if (string2 == null) {
            return f;
        }
        if (string2.length() == 0) {
            return f;
        }
        float f4 = StringDataConvertor.toNamedFloat(string, string2);
        if (f4 < f2 || f4 > f3) {
            throw new InvalidNamedValueException(string, string2, "fractional number from interval '" + f2 + "'-'" + f3 + "'");
        }
        return f4;
    }

    private static int toEnumeratedFloat(String string, float f, float[] fArray) throws InvalidNamedValueException {
        int n = 0;
        while (n < fArray.length) {
            if (f == fArray[n]) break;
            ++n;
        }
        if (n == fArray.length) {
            String string2 = "one of '" + fArray[0] + "'";
            n = 1;
            while (n < fArray.length) {
                string2 = string2 + ",'" + fArray[n] + "'";
                ++n;
            }
            throw new InvalidNamedValueException(string, String.valueOf(f), string2);
        }
        return n;
    }

    public static Double toDoubleEmptyAsNull(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Double(StringDataConvertor.toNamedDouble(string, string2));
    }

    public static Double toDoubleNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Double(StringDataConvertor.toNamedDouble(string, string2));
    }

    public static Double toDoubleNotEmpty(String string, String string2, double d) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Double(d);
        }
        return new Double(StringDataConvertor.toNamedDouble(string, string2));
    }

    public static double toDoubleNotNullNotEmpty(String string, String string2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toNamedDouble(string, string2);
    }

    public static double toDoubleNotNullNotEmpty(String string, String string2, double d) throws InvalidNamedValueException {
        if (string2 == null) {
            return d;
        }
        if (string2.length() == 0) {
            return d;
        }
        return StringDataConvertor.toNamedDouble(string, string2);
    }

    public static Integer toEnumeratedDoubleEmptyAsNull(String string, String string2, double[] dArray) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedDouble(string, StringDataConvertor.toNamedDouble(string, string2), dArray));
    }

    public static Integer toEnumeratedDoubleNotEmpty(String string, String string2, double[] dArray) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedDouble(string, StringDataConvertor.toNamedDouble(string, string2), dArray));
    }

    public static int toEnumeratedDoubleNotNullNotEmpty(String string, String string2, double[] dArray) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedDouble(string, StringDataConvertor.toNamedDouble(string, string2), dArray);
    }

    public static Double toIntervalDoubleEmptyAsNull(String string, String string2, double d, double d2) throws InvalidNamedValueException {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        double d3 = StringDataConvertor.toNamedDouble(string, string2);
        if (d3 < d || d3 > d2) {
            throw new InvalidNamedValueException(string, string2, "fractional number from interval '" + d + "'-'" + d2 + "'");
        }
        return new Double(d3);
    }

    public static Double toIntervalDoubleNotEmpty(String string, String string2, double d, double d2) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        double d3 = StringDataConvertor.toNamedDouble(string, string2);
        if (d3 < d || d3 > d2) {
            throw new InvalidNamedValueException(string, string2, "fractional number from interval '" + d + "'-'" + d2 + "'");
        }
        return new Double(d3);
    }

    public static Double toIntervalDoubleNotEmpty(String string, String string2, double d, double d2, double d3) throws InvalidNamedValueException {
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return new Double(d);
        }
        double d4 = StringDataConvertor.toNamedDouble(string, string2);
        if (d4 < d2 || d4 > d3) {
            throw new InvalidNamedValueException(string, string2, "fractional number from interval '" + d2 + "'-'" + d3 + "'");
        }
        return new Double(d4);
    }

    public static double toIntervalDoubleNotNullNotEmpty(String string, String string2, double d, double d2) throws InvalidNamedValueException {
        if (string2 == null) {
            throw new InvalidNamedValueException(string, NULL, NOTNULL);
        }
        if (string2.length() == 0) {
            throw new InvalidNamedValueException(string, EMPTY, NOTEMPTY);
        }
        double d3 = StringDataConvertor.toNamedDouble(string, string2);
        if (d3 < d || d3 > d2) {
            throw new InvalidNamedValueException(string, string2, "fractional number from interval '" + d + "'-'" + d2 + "'");
        }
        return d3;
    }

    public static double toIntervalDoubleNotNullNotEmpty(String string, String string2, double d, double d2, double d3) throws InvalidNamedValueException {
        if (string2 == null) {
            return d;
        }
        if (string2.length() == 0) {
            return d;
        }
        double d4 = StringDataConvertor.toNamedDouble(string, string2);
        if (d4 < d2 || d4 > d3) {
            throw new InvalidNamedValueException(string, string2, "fractional number from interval '" + d2 + "'-'" + d3 + "'");
        }
        return d4;
    }

    private static int toEnumeratedDouble(String string, double d, double[] dArray) throws InvalidNamedValueException {
        int n = 0;
        while (n < dArray.length) {
            if (d == dArray[n]) break;
            ++n;
        }
        if (n == dArray.length) {
            String string2 = "one of '" + dArray[0] + "'";
            n = 1;
            while (n < dArray.length) {
                string2 = string2 + ",'" + dArray[n] + "'";
                ++n;
            }
            throw new InvalidNamedValueException(string, String.valueOf(d), string2);
        }
        return n;
    }

    public static boolean toBoolean(String string) throws InvalidValueException {
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        throw new InvalidValueException(string, "'true' or 'false'");
    }

    public static byte toByte(String string) throws InvalidValueException {
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(string, "integer number from -128 to 127");
        }
    }

    public static short toShort(String string) throws InvalidValueException {
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(string, "integer number from -32768 to 32767");
        }
    }

    public static int toInt(String string) throws InvalidValueException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(string, "integer number from -2147483648 to 2147483647");
        }
    }

    public static long toLong(String string) throws InvalidValueException {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(string, "integer number from -9223372036854775808 to 9223372036854775807");
        }
    }

    public static float toFloat(String string) throws InvalidValueException {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(string, "number from 1.4E-45 to 3.4028235E38");
        }
    }

    public static double toDouble(String string) throws InvalidValueException {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(string, "number from " + Double.MIN_VALUE + " to " + Double.MAX_VALUE);
        }
    }

    public static String toStringEmptyAsNull(String string) throws InvalidValueException {
        if (string != null && string.length() == 0) {
            return null;
        }
        return string;
    }

    public static String toStringNotNull(String string) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        return string;
    }

    public static String toStringNotEmpty(String string) throws InvalidValueException {
        if (string != null && string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return string;
    }

    public static String toStringNotNullNotEmpty(String string) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            throw new InvalidValueException(NULLOREMPTY, NOTNULLNOTEMPTY);
        }
        return string;
    }

    public static String toStringNotNullNotEmptyPlusDef(String string, String string2) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return string2;
        }
        return string;
    }

    public static Integer toEnumeratedStringPlusNull(String string, String[] stringArray, boolean bl) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedString(string, stringArray, bl));
    }

    public static int toEnumeratedStringNotNull(String string, String[] stringArray, boolean bl) throws InvalidValueException {
        return StringDataConvertor.toEnumeratedString(StringDataConvertor.toStringNotNull(string), stringArray, bl);
    }

    public static Integer toEnumeratedStringEmptyAsNull(String string, String[] stringArray, boolean bl) throws InvalidValueException {
        String string2 = StringDataConvertor.toStringEmptyAsNull(string);
        if (string2 == null) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedString(string2, stringArray, bl));
    }

    public static int toEnumeratedStringNotNullNotEmpty(String string, String[] stringArray, boolean bl) throws InvalidValueException {
        return StringDataConvertor.toEnumeratedString(StringDataConvertor.toStringNotNullNotEmpty(string), stringArray, bl);
    }

    public static int toEnumeratedStringNotNullNotEmptyPlusDef(String string, String string2, String[] stringArray, boolean bl) throws InvalidValueException {
        return StringDataConvertor.toEnumeratedString(StringDataConvertor.toStringNotNullNotEmptyPlusDef(string, string2), stringArray, bl);
    }

    private static int toEnumeratedString(String string, String[] stringArray, boolean bl) throws InvalidValueException {
        int n;
        if (bl) {
            string = string.toLowerCase();
            n = 0;
            while (n < stringArray.length) {
                if (!string.equals(stringArray[n].toLowerCase())) {
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            n = 0;
            while (n < stringArray.length) {
                if (!string.equals(stringArray[n])) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        if (n == stringArray.length) {
            String string2 = "one of '" + stringArray[0] + "'";
            n = 1;
            while (n < stringArray.length) {
                string2 = string2 + ",'" + stringArray[n] + "'";
                ++n;
            }
            throw new InvalidValueException(string, string2);
        }
        return n;
    }

    public static Boolean toBooleanNotEmpty(String string, boolean bl) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (bl) {
            string = string.toLowerCase();
        }
        return new Boolean(StringDataConvertor.toBoolean(string));
    }

    public static boolean toBooleanNotNullNotEmpty(String string, boolean bl) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (bl) {
            string = string.toLowerCase();
        }
        return StringDataConvertor.toBoolean(string);
    }

    public static Boolean toBooleanNotEmpty(String string, boolean bl, boolean bl2) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Boolean(bl);
        }
        if (bl2) {
            string = string.toLowerCase();
        }
        return new Boolean(StringDataConvertor.toBoolean(string));
    }

    public static boolean toBooleanNotNullNotEmpty(String string, boolean bl, boolean bl2) throws InvalidValueException {
        if (string == null) {
            return bl;
        }
        if (string.length() == 0) {
            return bl;
        }
        if (bl2) {
            string = string.toLowerCase();
        }
        return StringDataConvertor.toBoolean(string);
    }

    public static Boolean toBooleanEmptyAsNull(String string, boolean bl) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (bl) {
            string = string.toLowerCase();
        }
        return new Boolean(StringDataConvertor.toBoolean(string));
    }

    public static Character toCharEmptyAsNull(String string) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        return new Character(string.charAt(0));
    }

    public static Character toCharNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        return new Character(string.charAt(0));
    }

    public static Character toCharNotEmpty(String string, char c) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Character(c);
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        return new Character(string.charAt(0));
    }

    public static char toCharNotNullNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        return string.charAt(0);
    }

    public static char toCharNotNullNotEmpty(String string, char c) throws InvalidValueException {
        if (string == null) {
            return c;
        }
        if (string.length() == 0) {
            return c;
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        return string.charAt(0);
    }

    public static Integer toEnumeratedCharEmptyAsNull(String string, char[] cArray) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        return new Integer(StringDataConvertor.toEnumeratedChar(string.charAt(0), cArray));
    }

    public static Integer toEnumeratedCharNotEmpty(String string, char[] cArray) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        return new Integer(StringDataConvertor.toEnumeratedChar(string.charAt(0), cArray));
    }

    public static int toEnumeratedCharNotNullNotEmpty(String string, char[] cArray) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        return StringDataConvertor.toEnumeratedChar(string.charAt(0), cArray);
    }

    public static Character toIntervalCharEmptyAsNull(String string, char c, char c2) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        char c3 = string.charAt(0);
        if (c3 < c || c3 > c2) {
            throw new InvalidValueException(string, "single character from interval '" + c + "'-'" + c2 + "'");
        }
        return new Character(c3);
    }

    public static Character toIntervalCharNotEmpty(String string, char c, char c2) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        char c3 = string.charAt(0);
        if (c3 < c || c3 > c2) {
            throw new InvalidValueException(string, "single character from interval '" + c + "'-'" + c2 + "'");
        }
        return new Character(c3);
    }

    public static Character toIntervalCharNotEmpty(String string, char c, char c2, char c3) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Character(c);
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        char c4 = string.charAt(0);
        if (c4 < c2 || c4 > c3) {
            throw new InvalidValueException(string, "single character from interval '" + c2 + "'-'" + c3 + "'");
        }
        return new Character(c4);
    }

    public static char toIntervalCharNotNullNotEmpty(String string, char c, char c2) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        char c3 = string.charAt(0);
        if (c3 < c || c3 > c2) {
            throw new InvalidValueException(string, "single character from interval '" + c + "'-'" + c2 + "'");
        }
        return c3;
    }

    public static char toIntervalCharNotNullNotEmpty(String string, char c, char c2, char c3) throws InvalidValueException {
        if (string == null) {
            return c;
        }
        if (string.length() == 0) {
            return c;
        }
        if (string.length() > 1) {
            throw new InvalidValueException(string, CHAR);
        }
        char c4 = string.charAt(0);
        if (c4 < c2 || c4 > c3) {
            throw new InvalidValueException(string, "single character from interval '" + c2 + "'-'" + c3 + "'");
        }
        return c4;
    }

    private static int toEnumeratedChar(char c, char[] cArray) throws InvalidValueException {
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) break;
            ++n;
        }
        if (n == cArray.length) {
            String string = "one of '" + cArray[0] + "'";
            n = 1;
            while (n < cArray.length) {
                string = string + ",'" + cArray[n] + "'";
                ++n;
            }
            throw new InvalidValueException(String.valueOf(c), string);
        }
        return n;
    }

    public static Byte toByteEmptyAsNull(String string) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Byte(StringDataConvertor.toByte(string));
    }

    public static Byte toByteNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Byte(StringDataConvertor.toByte(string));
    }

    public static Byte toByteNotEmpty(String string, byte by) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Byte(by);
        }
        return new Byte(StringDataConvertor.toByte(string));
    }

    public static byte toByteNotNullNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toByte(string);
    }

    public static byte toByteNotNullNotEmpty(String string, byte by) throws InvalidValueException {
        if (string == null) {
            return by;
        }
        if (string.length() == 0) {
            return by;
        }
        return StringDataConvertor.toByte(string);
    }

    public static Integer toEnumeratedByteEmptyAsNull(String string, byte[] byArray) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedByte(StringDataConvertor.toByte(string), byArray));
    }

    public static Integer toEnumeratedByteNotEmpty(String string, byte[] byArray) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedByte(StringDataConvertor.toByte(string), byArray));
    }

    public static int toEnumeratedByteNotNullNotEmpty(String string, byte[] byArray) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedByte(StringDataConvertor.toByte(string), byArray);
    }

    public static Byte toIntervalByteEmptyAsNull(String string, byte by, byte by2) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        byte by3 = StringDataConvertor.toByte(string);
        if (by3 < by || by3 > by2) {
            throw new InvalidValueException(string, "integer number from interval '" + by + "'-'" + by2 + "'");
        }
        return new Byte(by3);
    }

    public static Byte toIntervalByteNotEmpty(String string, byte by, byte by2) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        byte by3 = StringDataConvertor.toByte(string);
        if (by3 < by || by3 > by2) {
            throw new InvalidValueException(string, "integer number from interval '" + by + "'-'" + by2 + "'");
        }
        return new Byte(by3);
    }

    public static Byte toIntervalByteNotEmpty(String string, byte by, byte by2, byte by3) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Byte(by);
        }
        byte by4 = StringDataConvertor.toByte(string);
        if (by4 < by2 || by4 > by3) {
            throw new InvalidValueException(string, "integer number from interval '" + by2 + "'-'" + by3 + "'");
        }
        return new Byte(by4);
    }

    public static byte toIntervalByteNotNullNotEmpty(String string, byte by, byte by2) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        byte by3 = StringDataConvertor.toByte(string);
        if (by3 < by || by3 > by2) {
            throw new InvalidValueException(string, "integer number from interval '" + by + "'-'" + by2 + "'");
        }
        return by3;
    }

    public static byte toIntervalByteNotNullNotEmpty(String string, byte by, byte by2, byte by3) throws InvalidValueException {
        if (string == null) {
            return by;
        }
        if (string.length() == 0) {
            return by;
        }
        byte by4 = StringDataConvertor.toByte(string);
        if (by4 < by2 || by4 > by3) {
            throw new InvalidValueException(string, "integer number from interval '" + by2 + "'-'" + by3 + "'");
        }
        return by4;
    }

    private static int toEnumeratedByte(byte by, byte[] byArray) throws InvalidValueException {
        int n = 0;
        while (n < byArray.length) {
            if (by == byArray[n]) break;
            ++n;
        }
        if (n == byArray.length) {
            String string = "one of '" + byArray[0] + "'";
            n = 1;
            while (n < byArray.length) {
                string = string + ",'" + byArray[n] + "'";
                ++n;
            }
            throw new InvalidValueException(String.valueOf(by), string);
        }
        return n;
    }

    public static Short toShortEmptyAsNull(String string) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Short(StringDataConvertor.toShort(string));
    }

    public static Short toShortNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Short(StringDataConvertor.toShort(string));
    }

    public static Short toShortNotEmpty(String string, short s) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Short(s);
        }
        return new Short(StringDataConvertor.toShort(string));
    }

    public static short toShortNotNullNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toShort(string);
    }

    public static short toShortNotNullNotEmpty(String string, short s) throws InvalidValueException {
        if (string == null) {
            return s;
        }
        if (string.length() == 0) {
            return s;
        }
        return StringDataConvertor.toShort(string);
    }

    public static Integer toEnumeratedShortEmptyAsNull(String string, short[] sArray) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedShort(StringDataConvertor.toShort(string), sArray));
    }

    public static Integer toEnumeratedShortNotEmpty(String string, short[] sArray) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedShort(StringDataConvertor.toShort(string), sArray));
    }

    public static int toEnumeratedShortNotNullNotEmpty(String string, short[] sArray) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedShort(StringDataConvertor.toShort(string), sArray);
    }

    public static Short toIntervalShortEmptyAsNull(String string, short s, short s2) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        short s3 = StringDataConvertor.toShort(string);
        if (s3 < s || s3 > s2) {
            throw new InvalidValueException(string, "integer number from interval '" + s + "'-'" + s2 + "'");
        }
        return new Short(s3);
    }

    public static Short toIntervalShortNotEmpty(String string, short s, short s2) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        short s3 = StringDataConvertor.toShort(string);
        if (s3 < s || s3 > s2) {
            throw new InvalidValueException(string, "integer number from interval '" + s + "'-'" + s2 + "'");
        }
        return new Short(s3);
    }

    public static Short toIntervalShortNotEmpty(String string, byte by, short s, short s2) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Short(by);
        }
        short s3 = StringDataConvertor.toShort(string);
        if (s3 < s || s3 > s2) {
            throw new InvalidValueException(string, "integer number from interval '" + s + "'-'" + s2 + "'");
        }
        return new Short(s3);
    }

    public static short toIntervalShortNotNullNotEmpty(String string, short s, short s2) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        short s3 = StringDataConvertor.toShort(string);
        if (s3 < s || s3 > s2) {
            throw new InvalidValueException(string, "integer number from interval '" + s + "'-'" + s2 + "'");
        }
        return s3;
    }

    public static short toIntervalShortNotNullNotEmpty(String string, short s, short s2, short s3) throws InvalidValueException {
        if (string == null) {
            return s;
        }
        if (string.length() == 0) {
            return s;
        }
        short s4 = StringDataConvertor.toShort(string);
        if (s4 < s2 || s4 > s3) {
            throw new InvalidValueException(string, "integer number from interval '" + s2 + "'-'" + s3 + "'");
        }
        return s4;
    }

    private static int toEnumeratedShort(short s, short[] sArray) throws InvalidValueException {
        int n = 0;
        while (n < sArray.length) {
            if (s == sArray[n]) break;
            ++n;
        }
        if (n == sArray.length) {
            String string = "one of '" + sArray[0] + "'";
            n = 1;
            while (n < sArray.length) {
                string = string + ",'" + sArray[n] + "'";
                ++n;
            }
            throw new InvalidValueException(String.valueOf(s), string);
        }
        return n;
    }

    public static Integer toIntegerEmptyAsNull(String string) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toInt(string));
    }

    public static Integer toIntegerNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toInt(string));
    }

    public static Integer toIntegerNotEmpty(String string, int n) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Integer(n);
        }
        return new Integer(StringDataConvertor.toInt(string));
    }

    public static int toIntegerNotNullNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toInt(string);
    }

    public static int toIntegerNotNullNotEmpty(String string, int n) throws InvalidValueException {
        if (string == null) {
            return n;
        }
        if (string.length() == 0) {
            return n;
        }
        return StringDataConvertor.toInt(string);
    }

    public static Integer toEnumeratedIntegerEmptyAsNull(String string, int[] nArray) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedInteger(StringDataConvertor.toInt(string), nArray));
    }

    public static Integer toEnumeratedIntegerNotEmpty(String string, int[] nArray) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedInteger(StringDataConvertor.toInt(string), nArray));
    }

    public static int toEnumeratedIntegerNotNullNotEmpty(String string, int[] nArray) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedInteger(StringDataConvertor.toInt(string), nArray);
    }

    public static Integer toIntervalIntegerEmptyAsNull(String string, int n, int n2) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n3 = StringDataConvertor.toInt(string);
        if (n3 < n || n3 > n2) {
            throw new InvalidValueException(string, "integer number from interval '" + n + "'-'" + n2 + "'");
        }
        return new Integer(n3);
    }

    public static Integer toIntervalIntegerNotEmpty(String string, int n, int n2) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        int n3 = StringDataConvertor.toInt(string);
        if (n3 < n || n3 > n2) {
            throw new InvalidValueException(string, "integer number from interval '" + n + "'-'" + n2 + "'");
        }
        return new Integer(n3);
    }

    public static Integer toIntervalIntegerNotEmpty(String string, int n, int n2, int n3) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Integer(n);
        }
        int n4 = StringDataConvertor.toInt(string);
        if (n4 < n2 || n4 > n3) {
            throw new InvalidValueException(string, "integer number from interval '" + n2 + "'-'" + n3 + "'");
        }
        return new Integer(n4);
    }

    public static int toIntervalIntegerNotNullNotEmpty(String string, int n, int n2) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        int n3 = StringDataConvertor.toInt(string);
        if (n3 < n || n3 > n2) {
            throw new InvalidValueException(string, "integer number from interval '" + n + "'-'" + n2 + "'");
        }
        return n3;
    }

    public static int toIntervalIntegerNotNullNotEmpty(String string, int n, int n2, int n3) throws InvalidValueException {
        if (string == null) {
            return n;
        }
        if (string.length() == 0) {
            return n;
        }
        int n4 = StringDataConvertor.toInt(string);
        if (n4 < n2 || n4 > n3) {
            throw new InvalidValueException(string, "integer number from interval '" + n2 + "'-'" + n3 + "'");
        }
        return n4;
    }

    private static int toEnumeratedInteger(int n, int[] nArray) throws InvalidValueException {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) break;
            ++n2;
        }
        if (n2 == nArray.length) {
            String string = "one of '" + nArray[0] + "'";
            n2 = 1;
            while (n2 < nArray.length) {
                string = string + ",'" + nArray[n2] + "'";
                ++n2;
            }
            throw new InvalidValueException(String.valueOf(n), string);
        }
        return n2;
    }

    public static Long toLongEmptyAsNull(String string) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Long(StringDataConvertor.toLong(string));
    }

    public static Long toLongNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Long(StringDataConvertor.toLong(string));
    }

    public static Long toLongNotEmpty(String string, long l) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Long(l);
        }
        return new Long(StringDataConvertor.toLong(string));
    }

    public static long toLongNotNullNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toLong(string);
    }

    public static long toLongNotNullNotEmpty(String string, long l) throws InvalidValueException {
        if (string == null) {
            return l;
        }
        if (string.length() == 0) {
            return l;
        }
        return StringDataConvertor.toLong(string);
    }

    public static Integer toEnumeratedLongEmptyAsNull(String string, long[] lArray) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedLong(StringDataConvertor.toLong(string), lArray));
    }

    public static Integer toEnumeratedLongNotEmpty(String string, long[] lArray) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedLong(StringDataConvertor.toLong(string), lArray));
    }

    public static int toEnumeratedLongNotNullNotEmpty(String string, long[] lArray) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedLong(StringDataConvertor.toLong(string), lArray);
    }

    public static Long toIntervalLongEmptyAsNull(String string, long l, long l2) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        long l3 = StringDataConvertor.toLong(string);
        if (l3 < l || l3 > l2) {
            throw new InvalidValueException(string, "integer number from interval '" + l + "'-'" + l2 + "'");
        }
        return new Long(l3);
    }

    public static Long toIntervalLongNotEmpty(String string, long l, long l2) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        long l3 = StringDataConvertor.toLong(string);
        if (l3 < l || l3 > l2) {
            throw new InvalidValueException(string, "integer number from interval '" + l + "'-'" + l2 + "'");
        }
        return new Long(l3);
    }

    public static Long toIntervalLongNotEmpty(String string, long l, long l2, long l3) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Long(l);
        }
        long l4 = StringDataConvertor.toLong(string);
        if (l4 < l2 || l4 > l3) {
            throw new InvalidValueException(string, "integer number from interval '" + l2 + "'-'" + l3 + "'");
        }
        return new Long(l4);
    }

    public static long toIntervalLongNotNullNotEmpty(String string, long l, long l2) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        long l3 = StringDataConvertor.toLong(string);
        if (l3 < l || l3 > l2) {
            throw new InvalidValueException(string, "integer number from interval '" + l + "'-'" + l2 + "'");
        }
        return l3;
    }

    public static long toIntervalLongNotNullNotEmpty(String string, long l, long l2, long l3) throws InvalidValueException {
        if (string == null) {
            return l;
        }
        if (string.length() == 0) {
            return l;
        }
        long l4 = StringDataConvertor.toLong(string);
        if (l4 < l2 || l4 > l3) {
            throw new InvalidValueException(string, "integer number from interval '" + l2 + "'-'" + l3 + "'");
        }
        return l4;
    }

    private static int toEnumeratedLong(long l, long[] lArray) throws InvalidValueException {
        int n = 0;
        while (n < lArray.length) {
            if (l == lArray[n]) break;
            ++n;
        }
        if (n == lArray.length) {
            String string = "one of '" + lArray[0] + "'";
            n = 1;
            while (n < lArray.length) {
                string = string + ",'" + lArray[n] + "'";
                ++n;
            }
            throw new InvalidValueException(String.valueOf(l), string);
        }
        return n;
    }

    public static Float toFloatEmptyAsNull(String string) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Float(StringDataConvertor.toFloat(string));
    }

    public static Float toFloatNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Float(StringDataConvertor.toFloat(string));
    }

    public static Float toFloatNotEmpty(String string, float f) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Float(f);
        }
        return new Float(StringDataConvertor.toFloat(string));
    }

    public static float toFloatNotNullNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toFloat(string);
    }

    public static float toFloatNotNullNotEmpty(String string, float f) throws InvalidValueException {
        if (string == null) {
            return f;
        }
        if (string.length() == 0) {
            return f;
        }
        return StringDataConvertor.toFloat(string);
    }

    public static Integer toEnumeratedFloatEmptyAsNull(String string, float[] fArray) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedFloat(StringDataConvertor.toFloat(string), fArray));
    }

    public static Integer toEnumeratedFloatNotEmpty(String string, float[] fArray) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedFloat(StringDataConvertor.toFloat(string), fArray));
    }

    public static int toEnumeratedFloatNotNullNotEmpty(String string, float[] fArray) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedFloat(StringDataConvertor.toFloat(string), fArray);
    }

    public static Float toIntervalFloatEmptyAsNull(String string, float f, float f2) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        float f3 = StringDataConvertor.toFloat(string);
        if (f3 < f || f3 > f2) {
            throw new InvalidValueException(string, "fractional number from interval '" + f + "'-'" + f2 + "'");
        }
        return new Float(f3);
    }

    public static Float toIntervalFloatNotEmpty(String string, float f, float f2) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        float f3 = StringDataConvertor.toFloat(string);
        if (f3 < f || f3 > f2) {
            throw new InvalidValueException(string, "fractional number from interval '" + f + "'-'" + f2 + "'");
        }
        return new Float(f3);
    }

    public static Float toIntervalFloatNotEmpty(String string, float f, float f2, float f3) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Float(f);
        }
        float f4 = StringDataConvertor.toFloat(string);
        if (f4 < f2 || f4 > f3) {
            return new Float(f);
        }
        return new Float(f4);
    }

    public static float toIntervalFloatNotNullNotEmpty(String string, float f, float f2) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        float f3 = StringDataConvertor.toFloat(string);
        if (f3 < f || f3 > f2) {
            throw new InvalidValueException(string, "fractional number from interval '" + f + "'-'" + f2 + "'");
        }
        return f3;
    }

    public static float toIntervalFloatNotNullNotEmpty(String string, float f, float f2, float f3) throws InvalidValueException {
        if (string == null) {
            return f;
        }
        if (string.length() == 0) {
            return f;
        }
        float f4 = StringDataConvertor.toFloat(string);
        if (f4 < f2 || f4 > f3) {
            throw new InvalidValueException(string, "fractional number from interval '" + f2 + "'-'" + f3 + "'");
        }
        return f4;
    }

    private static int toEnumeratedFloat(float f, float[] fArray) throws InvalidValueException {
        int n = 0;
        while (n < fArray.length) {
            if (f == fArray[n]) break;
            ++n;
        }
        if (n == fArray.length) {
            String string = "one of '" + fArray[0] + "'";
            n = 1;
            while (n < fArray.length) {
                string = string + ",'" + fArray[n] + "'";
                ++n;
            }
            throw new InvalidValueException(String.valueOf(f), string);
        }
        return n;
    }

    public static Double toDoubleEmptyAsNull(String string) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Double(StringDataConvertor.toDouble(string));
    }

    public static Double toDoubleNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Double(StringDataConvertor.toDouble(string));
    }

    public static Double toDoubleNotEmpty(String string, double d) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Double(d);
        }
        return new Double(StringDataConvertor.toDouble(string));
    }

    public static double toDoubleNotNullNotEmpty(String string) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toDouble(string);
    }

    public static double toDoubleNotNullNotEmpty(String string, double d) throws InvalidValueException {
        if (string == null) {
            return d;
        }
        if (string.length() == 0) {
            return d;
        }
        return StringDataConvertor.toDouble(string);
    }

    public static Integer toEnumeratedDoubleEmptyAsNull(String string, double[] dArray) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Integer(StringDataConvertor.toEnumeratedDouble(StringDataConvertor.toDouble(string), dArray));
    }

    public static Integer toEnumeratedDoubleNotEmpty(String string, double[] dArray) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return new Integer(StringDataConvertor.toEnumeratedDouble(StringDataConvertor.toDouble(string), dArray));
    }

    public static int toEnumeratedDoubleNotNullNotEmpty(String string, double[] dArray) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        return StringDataConvertor.toEnumeratedDouble(StringDataConvertor.toDouble(string), dArray);
    }

    public static Double toIntervalDoubleEmptyAsNull(String string, double d, double d2) throws InvalidValueException {
        if (string == null || string.length() == 0) {
            return null;
        }
        double d3 = StringDataConvertor.toDouble(string);
        if (d3 < d || d3 > d2) {
            throw new InvalidValueException(string, "fractional number from interval '" + d + "'-'" + d2 + "'");
        }
        return new Double(d3);
    }

    public static Double toIntervalDoubleNotEmpty(String string, double d, double d2) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        double d3 = StringDataConvertor.toDouble(string);
        if (d3 < d || d3 > d2) {
            throw new InvalidValueException(string, "fractional number from interval '" + d + "'-'" + d2 + "'");
        }
        return new Double(d3);
    }

    public static Double toIntervalDoubleNotEmpty(String string, double d, double d2, double d3) throws InvalidValueException {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new Double(d);
        }
        double d4 = StringDataConvertor.toDouble(string);
        if (d4 < d2 || d4 > d3) {
            throw new InvalidValueException(string, "fractional number from interval '" + d2 + "'-'" + d3 + "'");
        }
        return new Double(d4);
    }

    public static double toIntervalDoubleNotNullNotEmpty(String string, double d, double d2) throws InvalidValueException {
        if (string == null) {
            throw new InvalidValueException(NULL, NOTNULL);
        }
        if (string.length() == 0) {
            throw new InvalidValueException(EMPTY, NOTEMPTY);
        }
        double d3 = StringDataConvertor.toDouble(string);
        if (d3 < d || d3 > d2) {
            throw new InvalidValueException(string, "fractional number from interval '" + d + "'-'" + d2 + "'");
        }
        return d3;
    }

    public static double toIntervalDoubleNotNullNotEmpty(String string, double d, double d2, double d3) throws InvalidValueException {
        if (string == null) {
            return d;
        }
        if (string.length() == 0) {
            return d;
        }
        double d4 = StringDataConvertor.toDouble(string);
        if (d4 < d2 || d4 > d3) {
            throw new InvalidValueException(string, "fractional number from interval '" + d2 + "'-'" + d3 + "'");
        }
        return d4;
    }

    private static int toEnumeratedDouble(double d, double[] dArray) throws InvalidValueException {
        int n = 0;
        while (n < dArray.length) {
            if (d == dArray[n]) break;
            ++n;
        }
        if (n == dArray.length) {
            String string = "one of '" + dArray[0] + "'";
            n = 1;
            while (n < dArray.length) {
                string = string + ",'" + dArray[n] + "'";
                ++n;
            }
            throw new InvalidValueException(String.valueOf(d), string);
        }
        return n;
    }
}

