/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.util.db;

import com.rathedg.util.db.ConnectionTuner;
import com.rathedg.util.db.DBConnectionSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public final class SimpleDBConnectionSource
extends DBConnectionSource {
    private String url;
    private Properties properties;
    private ConnectionTuner tuner;

    public SimpleDBConnectionSource(String string, Properties properties, ConnectionTuner connectionTuner) {
        this.url = string;
        this.properties = properties;
        this.tuner = connectionTuner;
    }

    public Connection getConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.url, this.properties);
        if (this.tuner != null) {
            this.tuner.tune(connection);
        }
        return connection;
    }

    public void releaseConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public void releaseResources() {
    }

    public String toString() {
        return "SimpleDBConnectionSource(url=" + this.url + ",properties=" + this.properties + ")";
    }
}

