/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlGui.playlist;

import com.jcraft.jorbis.JOrbisException;
import helliker.id3.ID3Exception;
import java.io.IOException;
import javazoom.Util.Debug;
import javazoom.Util.FileUtil;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jlGui.tag.MpegInfo;
import javazoom.jlGui.tag.OggVorbisInfo;
import javazoom.jlGui.tag.TagInfo;

public class PlaylistItem {
    protected String _name = null;
    protected String _displayName = null;
    protected String _location = null;
    protected boolean _isFile = true;
    protected long _seconds = -1L;
    protected boolean _isSelected = false;
    protected TagInfo _taginfo = null;

    protected PlaylistItem() {
    }

    public PlaylistItem(String string, String string2, long l, boolean bl) {
        this._name = string;
        this._seconds = l;
        this._isFile = bl;
        this.setLocation(string2);
    }

    public String getFormattedName() {
        if (this._displayName == null) {
            return this._name;
        }
        return this._displayName;
    }

    public String getName() {
        return this._name;
    }

    public String getLocation() {
        return this._location;
    }

    public boolean isFile() {
        return this._isFile;
    }

    public long getLength() {
        if (this._taginfo != null && this._taginfo.getPlayTime() > 0L) {
            return this._taginfo.getPlayTime();
        }
        return this._seconds;
    }

    public void setSelected(boolean bl) {
        this._isSelected = bl;
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void setLocation(String string) {
        this._location = string;
        if (this._isFile && this._location != null) {
            try {
                this._taginfo = new MpegInfo(string);
            }
            catch (ID3Exception iD3Exception) {
                this.trace(1, this.getClass().getName(), iD3Exception.getMessage());
                this._taginfo = null;
            }
            catch (IOException iOException) {
                this.trace(1, this.getClass().getName(), iOException.getMessage());
                this._taginfo = null;
            }
            catch (JavaLayerException javaLayerException) {
                this._taginfo = null;
            }
            if (this._taginfo == null) {
                try {
                    this._taginfo = new OggVorbisInfo(string);
                }
                catch (JOrbisException jOrbisException) {
                    this._taginfo = null;
                }
                catch (IOException iOException) {
                    this.trace(1, this.getClass().getName(), iOException.getMessage());
                    this._taginfo = null;
                }
            }
        }
        this._displayName = this.getFormattedDisplayName();
    }

    public String getFormattedLength() {
        long l = this.getLength();
        String string = "";
        if (l > -1L) {
            if (l >= 3600L) {
                string = FileUtil.rightPadString(l / 3600L + "", '0', 2) + ":";
                l -= 3600L;
            }
            string = string + FileUtil.rightPadString(l / 60L + "", '0', 2) + ":" + FileUtil.padString(l % 60L + "", '0', 2);
        } else {
            string = "" + l;
        }
        return string;
    }

    private String getFormattedDisplayName() {
        if (this._taginfo == null) {
            return null;
        }
        String string = this.getFormattedLength();
        if (this._taginfo.getTitle() != null && !this._taginfo.getTitle().equals("") && this._taginfo.getArtist() != null && !this._taginfo.getArtist().equals("")) {
            return "(" + string + ") " + this._taginfo.getTitle() + " - " + this._taginfo.getArtist();
        }
        return "(" + string + ") " + this._name;
    }

    public String getM3UExtInf() {
        if (this._taginfo == null) {
            return this._seconds + "," + this._name;
        }
        return this.getFormattedLength() + "," + this._taginfo.getTitle() + " - " + this._taginfo.getArtist();
    }

    public TagInfo getTagInfo() {
        return this._taginfo;
    }

    private void trace(int n, String string, String string2) {
        Debug debug = Debug.getInstance();
        debug.log(n, string + ":" + string2);
    }
}

