/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlGui.applet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.sampled.convert.MpegFormatConversionProvider;
import org.tritonus.sampled.file.MpegAudioFileReader;

public class AppletMpegSPIWorkaround {
    public static boolean DEBUG = false;

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        try {
            return AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec");
            }
            try {
                Class.forName("org.tritonus.sampled.convert.MpegFormatConversionProvider");
                return new MpegFormatConversionProvider().getAudioInputStream(audioFormat, audioInputStream);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Mpeg codec not properly installed");
            }
        }
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioInputStream:file)");
            }
            return AppletMpegSPIWorkaround.getAudioInputStream(bufferedInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)bufferedInputStream).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)bufferedInputStream).close();
            throw iOException;
        }
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        try {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioInputStream:url)");
            }
            return AppletMpegSPIWorkaround.getAudioInputStream(bufferedInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)bufferedInputStream).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)bufferedInputStream).close();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioFileFormat:file)");
            }
            audioFileFormat = AppletMpegSPIWorkaround.getAudioFileFormat(bufferedInputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((InputStream)bufferedInputStream).close();
        return audioFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        try {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioFileFormat:url)");
            }
            audioFileFormat = AppletMpegSPIWorkaround.getAudioFileFormat(bufferedInputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        ((InputStream)bufferedInputStream).close();
        return audioFileFormat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        Throwable throwable2;
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            AudioFileFormat audioFileFormat;
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec (AudioFileFormat)");
            }
            try {
                Class.forName("org.tritonus.sampled.file.MpegAudioFileReader");
                inputStream.mark(4096);
                audioFileFormat = new MpegAudioFileReader().getAudioFileFormat(inputStream);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    throw new IllegalArgumentException("Mpeg codec not properly installed");
                }
                catch (Throwable throwable2) {
                    Object var4_5 = null;
                    inputStream.reset();
                }
            }
            Object var4_4 = null;
            inputStream.reset();
            return audioFileFormat;
        }
        throw throwable2;
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.err.println("Using AppletMpegSPIWorkaround to get codec");
            }
            try {
                Class.forName("org.tritonus.sampled.file.MpegAudioFileReader");
                return new MpegAudioFileReader().getAudioInputStream(inputStream);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Mpeg codec not properly installed");
            }
        }
    }
}

