// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : t-maxval.cpp
//
//  DESCRIPTION :
//         Class TuringMachine : getting max value methods (Implementation)
//
// ##############################################################


// =================
#include "turing-s.h"
// =================


// =========
void TuringMachine::set_max_user_defined_program_state_size()
{
vector<state_t>	tmp_all_program_states (get_all_user_defined_program_states());

  assert (max_size_of_user_defined_program_states_ == 0);
  max_size_of_user_defined_program_states_ = get_max_size(tmp_all_program_states);
  assert (max_size_of_user_defined_program_states_);

}

// =========
void TuringMachine::set_max_size_of_user_defined_and_required_states()
{

max_size_of_user_defined_and_required_states_ = max_size_of_user_defined_program_states_;

map<CurSituation, state_t>::const_iterator pos_iter;
  for (pos_iter = user_required_check_point_program_states_.begin();
       pos_iter != user_required_check_point_program_states_.end();
       pos_iter++)
  {
    max_size_of_user_defined_and_required_states_ = MAX_VALUE (max_size_of_user_defined_and_required_states_, pos_iter->second.size());
  }	


  for (size_t i = 0; i < neutral_program_states_.size(); i++)
  {
    max_size_of_user_defined_and_required_states_ = MAX_VALUE (max_size_of_user_defined_and_required_states_, neutral_program_states_[i].size());
  }

  for (size_t i = 0; i < pre_initial_program_states_.size(); i++)
  {
    max_size_of_user_defined_and_required_states_ = MAX_VALUE (max_size_of_user_defined_and_required_states_, pre_initial_program_states_[i].size());
  }


  for (size_t i = 0; i < post_halting_program_states_.size(); i++)
  {
    max_size_of_user_defined_and_required_states_ = MAX_VALUE (max_size_of_user_defined_and_required_states_, post_halting_program_states_[i].size());
  }


  assert (max_size_of_user_defined_and_required_states_);

} // set_max_size_of_user_defined_and_required_states


// =========
void TuringMachine::set_max_size_of_program_states()
{
  max_size_of_program_states_ = MAX_VALUE (max_size_of_user_defined_and_required_states_, max_size_of_extra_program_states_);
  assert (max_size_of_program_states_);
}


// =========
void TuringMachine::set_max_size_of_extra_program_states_size()
{
vector<state_t>	tmp_all_extra_program_states (get_all_extra_program_states());

  assert (max_size_of_extra_program_states_ == 0);
  max_size_of_extra_program_states_ = get_max_size(tmp_all_extra_program_states);
  assert (max_size_of_extra_program_states_);

}


// =========
void TuringMachine::set_max_size_of_user_defined_alphabet_symbol()
{
Tapes_t::const_iterator pos_iter;
  assert (max_size_of_user_defined_alphabet_symbol_ == 0);
  for (pos_iter = tapes_[MASTER_COMPUTATION_TAPE].begin(); 
       pos_iter != tapes_[MASTER_COMPUTATION_TAPE].end(); 
       pos_iter++
       )
  {
    max_size_of_user_defined_alphabet_symbol_ = MAX_VALUE (max_size_of_user_defined_alphabet_symbol_, pos_iter->second.max_symbol_size_);
  }
}

