// ==============================================================
//
//  Copyright (c) 2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : Turing Machine with faults, failures and recovery
//             C++ Simulator
//
//  FILE     : t-descr.cpp
//
//  DESCRIPTION :
//         Class TuringMachine : description methods (Implementation)
//
// ##############################################################


// =================
#include "turing-s.h"
// =================


// =========			 
string TuringMachine::get_descr_of_program_state (
		const state_t&	state_i, 
		bool setw_flag_i, 
		bool prefix_flag_i, 
		bool suffix_flag_i
		) const
{
string	this_kind_description;
string	top_kind_description;
string	sub_kind_description;

  if (is_initial_program_state (state_i))
  {
    assert (this_kind_description.empty());
    assert (top_kind_description.empty());
    assert (sub_kind_description.empty());
    top_kind_description = get_descr_of_program_state_top_kind_s (PROGRAM_STATE_TOP_KIND__USER_DEFINED);
    this_kind_description = get_descr_of_user_defined_program_state_kind_s (USER_DEFINED_PROGRAM_STATE_KIND__INITIAL);
  }

  if (is_halting_program_state (state_i))
  {
    assert (this_kind_description.empty());
    assert (top_kind_description.empty());
    assert (sub_kind_description.empty());
    top_kind_description = get_descr_of_program_state_top_kind_s (PROGRAM_STATE_TOP_KIND__USER_DEFINED);
    this_kind_description = get_descr_of_user_defined_program_state_kind_s (USER_DEFINED_PROGRAM_STATE_KIND__HALTING);
  }

  if (is_internal_program_state (state_i))
  {
    assert (this_kind_description.empty());
    assert (top_kind_description.empty());
    assert (sub_kind_description.empty());
    top_kind_description = get_descr_of_program_state_top_kind_s (PROGRAM_STATE_TOP_KIND__USER_DEFINED);
    this_kind_description = get_descr_of_user_defined_program_state_kind_s (USER_DEFINED_PROGRAM_STATE_KIND__INTERNAL);
  }


  if (is_neutral_program_state (state_i))
  {
    assert (this_kind_description.empty());
    assert (top_kind_description.empty());
    assert (sub_kind_description.empty());
    top_kind_description = get_descr_of_program_state_top_kind_s (PROGRAM_STATE_TOP_KIND__NEUTRAL);

    for (size_t i = 0; i < NUMBER_OF_NEUTRAL_PROGRAM_STATE_KINDS; i++)
    {
      if (state_i == neutral_program_states_[i])
      {
        this_kind_description = get_descr_of_neutral_program_state_kind_s (static_cast<NeutralProgramStateKinds>(i));
        break;
      }
     
    }
    assert (!top_kind_description.empty());
    assert (!this_kind_description.empty());
    
  }

  if (is_pre_initial_program_state (state_i))
  {
    assert (this_kind_description.empty());
    assert (top_kind_description.empty());
    assert (sub_kind_description.empty());
    top_kind_description = get_descr_of_program_state_top_kind_s (PROGRAM_STATE_TOP_KIND__PRE_INITIAL);
    this_kind_description = get_descr_of_pre_initial_program_state_kind_s (PRE_INITIAL_PROGRAM_STATE_KIND__INITIAL);
  }


  if (is_post_halting_program_state (state_i))
  {
    assert (this_kind_description.empty());
    assert (top_kind_description.empty());
    assert (sub_kind_description.empty());
    top_kind_description = get_descr_of_program_state_top_kind_s (PROGRAM_STATE_TOP_KIND__POST_HALTING);
    this_kind_description = get_descr_of_post_halting_program_state_kind_s (POST_HALTING_PROGRAM_STATE_KIND__HALTING);
  }

  if (is_user_required_check_point_program_state (state_i))
  {
    assert (this_kind_description.empty());
    assert (top_kind_description.empty());
    assert (sub_kind_description.empty());
    top_kind_description = get_descr_of_program_state_top_kind_s (PROGRAM_STATE_TOP_KIND__USER_REQUIRED);
    this_kind_description = get_descr_of_user_required_program_state_kind_s (USER_REQUIRED_PROGRAM_STATE_KIND__CHECK_POINT);
  }

EmbeddedProgramStateKinds	the_kind;
size_t				the_index;
  if (is_embedded_program_state (state_i, the_kind, the_index))
  {
    assert (this_kind_description.empty());
    assert (top_kind_description.empty());
    assert (sub_kind_description.empty());
    top_kind_description = get_descr_of_program_state_top_kind_s (PROGRAM_STATE_TOP_KIND__EMBEDDED);
    sub_kind_description = get_descr_of_embedded_program_states__themselves_s (the_kind, the_index);
    this_kind_description = get_descr_of_embedded_program_state_kinds_s (the_kind);
  }

  assert (!this_kind_description.empty());
  assert (!top_kind_description.empty());

const string str_prefix (prefix_flag_i ? (top_kind_description) : string());
const string str_suffix (suffix_flag_i ? (sub_kind_description) : string());

ostringstream oss;
  oss << "";
  if (setw_flag_i)
  {
    oss << setw (max_size_of_descr_of_program_state_top_kinds_s)
        << left;
  }
  oss << str_prefix.c_str()
      << "  ";


ostringstream oss2;
const string delim1 ("  ");
  oss2 << this_kind_description.c_str();
  if (!str_suffix.empty())
  {
    oss2 << delim1;
  }
  oss2 << str_suffix.c_str();

const size_t max_sub_size = get_max_size_descr_of_embedded_program_states__themselves_s();
  if (setw_flag_i)
  {
    oss << setw (max_size_of_descr_of_embedded_program_state_kinds_s + max_sub_size + delim1.size())
        << left;
  }
  oss << oss2.str().c_str();

  return oss.str();
}


// =========			 
string	TuringMachine::get_descr_of_tape_kind_s (TapeKinds kind_i)
{
  assert (kind_i >= 0);
  assert (kind_i < NUMBER_OF_TAPE_KINDS);
  assert (static_cast<size_t>(kind_i) < descr_of_tape_kinds_s.size());

  assert (!descr_of_tape_kinds_s[kind_i].empty());

  assert (max_size_of_descr_of_tape_kinds_s > 0);

  return descr_of_tape_kinds_s[kind_i];
}



// =========			 
string	TuringMachine::get_descr_of_program_state_top_kind_s (ProgramStateTopKinds kind_i)
{
  assert (kind_i >= 0);
  assert (kind_i < NUMBER_OF_PROGRAM_STATE_TOP_KINDS);
  assert (static_cast<size_t>(kind_i) < descr_of_program_state_top_kinds_s.size());

  assert (!descr_of_program_state_top_kinds_s[kind_i].empty());

  assert (max_size_of_descr_of_program_state_top_kinds_s > 0);

  return descr_of_program_state_top_kinds_s[kind_i];
}


// =========			 
string	TuringMachine::get_descr_of_user_defined_program_state_kind_s (UserDefinedProgramStateKinds kind_i)
{
  assert (kind_i >= 0);
  assert (kind_i < NUMBER_OF_USER_DEFINED_PROGRAM_STATE_KINDS);
  assert (static_cast<size_t>(kind_i) < descr_of_user_defined_program_state_kinds_s.size());

  assert (!descr_of_user_defined_program_state_kinds_s[kind_i].empty());

  assert (max_size_of_descr_of_user_defined_program_state_kinds_s > 0);

  return descr_of_user_defined_program_state_kinds_s[kind_i];
}

// =========			 
string	TuringMachine::get_descr_of_neutral_program_state_kind_s (NeutralProgramStateKinds kind_i)
{
  assert (kind_i >= 0);
  assert (kind_i < NUMBER_OF_NEUTRAL_PROGRAM_STATE_KINDS);
  assert (static_cast<size_t>(kind_i) < descr_of_neutral_program_state_kinds_s.size());

  assert (!descr_of_neutral_program_state_kinds_s[kind_i].empty());

  assert (max_size_of_descr_of_neutral_program_state_kinds_s > 0);

  return descr_of_neutral_program_state_kinds_s[kind_i];

}


// =========			 
string	TuringMachine::get_descr_of_pre_initial_program_state_kind_s (PreInitialProgramStateKinds kind_i)
{
  assert (kind_i >= 0);
  assert (kind_i < NUMBER_OF_PRE_INITIAL_PROGRAM_STATE_KINDS);
  assert (static_cast<size_t>(kind_i) < descr_of_pre_initial_program_state_kinds_s.size());

  assert (!descr_of_pre_initial_program_state_kinds_s[kind_i].empty());

  assert (max_size_of_descr_of_pre_initial_program_state_kinds_s > 0);

  return descr_of_pre_initial_program_state_kinds_s[kind_i];

}



// =========			 
string	TuringMachine::get_descr_of_post_halting_program_state_kind_s (PostHaltingProgramStateKinds kind_i)
{
  assert (kind_i >= 0);
  assert (kind_i < NUMBER_OF_POST_HALTING_PROGRAM_STATE_KINDS);
  assert (static_cast<size_t>(kind_i) < descr_of_post_halting_program_state_kinds_s.size());

  assert (!descr_of_post_halting_program_state_kinds_s[kind_i].empty());

  assert (max_size_of_descr_of_post_halting_program_state_kinds_s > 0);

  return descr_of_post_halting_program_state_kinds_s[kind_i];

}



// =========			 
string	TuringMachine::get_descr_of_user_required_program_state_kind_s (UserRequiredProgramStateKinds kind_i)
{
  assert (kind_i >= 0);
  assert (kind_i < NUMBER_OF_USER_REQUIRED_PROGRAM_STATE_KINDS);
  assert (static_cast<size_t>(kind_i) < descr_of_user_required_program_state_kinds_s.size());

  assert (!descr_of_user_required_program_state_kinds_s[kind_i].empty());

  assert (max_size_of_descr_of_user_required_program_state_kinds_s > 0);

  return descr_of_user_required_program_state_kinds_s[kind_i];

}


// =========			 
string TuringMachine::get_descr_of_embedded_program_states__themselves_s (
			EmbeddedProgramStateKinds	kind_i,
			size_t			index_i
			)
{
const size_t the_size = descr_of_embedded_program_states_s.size();
  assert (the_size > 0);
  assert (kind_i >= 0);
  assert (kind_i < NUMBER_OF_EMBEDDED_PROGRAM_STATE_KINDS);
  assert (static_cast<size_t>(kind_i) < descr_of_embedded_program_states_s.size());

  assert (static_cast<size_t>(kind_i) < the_size);

  assert (index_i < descr_of_embedded_program_states_s[kind_i].size());

  assert (!descr_of_embedded_program_states_s[kind_i][index_i].empty());

  return descr_of_embedded_program_states_s[kind_i][index_i];

}

// =========			 
size_t	TuringMachine::get_max_size_descr_of_embedded_program_states__themselves_s ()
{
size_t ret_val = 0;
  for (size_t i = 0; i < descr_of_embedded_program_states_s.size(); i++)
  {
    for (size_t j = 0; j < descr_of_embedded_program_states_s[i].size(); j++)
    { 
      ret_val = MAX_VALUE (ret_val, descr_of_embedded_program_states_s[i][j].size());
    }
  }
  return ret_val;

}
							    
// =========			 
string TuringMachine::get_descr_of_embedded_program_state_kinds_s (
			EmbeddedProgramStateKinds	kind_i
			)
{
  assert (kind_i >= 0);
  assert (kind_i < NUMBER_OF_EMBEDDED_PROGRAM_STATE_KINDS);
  assert (static_cast<size_t>(kind_i) < descr_of_embedded_program_state_kinds_s.size());

  assert (!descr_of_embedded_program_state_kinds_s[kind_i].empty());

  assert (max_size_of_descr_of_embedded_program_state_kinds_s > 0);

  return descr_of_embedded_program_state_kinds_s[kind_i];

}

