/*
 * Decompiled with CFR 0.152.
 */
package vscript;

import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import vscript.AttrHolder;
import vscript.TagBody;
import vscript.TagInfo;
import vscript.interpreter.TagInterpreter;
import vscript.message.MessageNode;
import vscript.parser.Parser;

public class Tag {
    private String tagName;
    private String tagIdentifier;
    private HashMap headerAttrMap = new HashMap(8);
    private StringBuffer body;
    private LinkedList subTags = new LinkedList();
    private String tagData;
    private MessageNode messageNode;

    public Tag(String string, String string2, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        this.tagName = string;
        this.tagIdentifier = string2;
        this.body = stringBuffer2;
        List list = Parser.getElements(stringBuffer.toString(), 44);
        this.headerAttrMap = Parser.parseAttributes(list.toArray(new String[0]));
    }

    public void parseTagBody(List list) {
        try {
            TagBody tagBody = Parser.parse(this.body.toString(), list);
            this.subTags.addAll(tagBody.subtag);
            this.tagData = tagBody.tagData;
        }
        catch (ParseException parseException) {
            System.out.println(parseException.toString());
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getFullTagName() {
        return this.messageNode.getFullName();
    }

    public String getTagIdentifier() {
        return this.tagIdentifier;
    }

    public String getAttributeValue(String string) {
        String string2;
        AttrHolder attrHolder;
        Object object = this.headerAttrMap.get(string);
        if (this.messageNode != null && object == null && (object = this.headerAttrMap.get("attr")) != null && (attrHolder = (AttrHolder)(object = this.messageNode.getObject(Parser.parseMessage((string2 = (String)object) + ".m()")))) != null) {
            object = attrHolder.getValue(string);
        }
        return (String)object;
    }

    public List getSubTag() {
        return this.subTags;
    }

    public List getSubTag(String string) {
        LinkedList<Tag> linkedList = new LinkedList<Tag>();
        if (this.subTags.size() == 0) {
            return linkedList;
        }
        ListIterator listIterator = this.subTags.listIterator(0);
        while (listIterator.hasNext()) {
            Tag tag = (Tag)listIterator.next();
            if (!tag.getTagName().equals(string)) continue;
            linkedList.add(tag);
        }
        return linkedList;
    }

    public String getTagData() {
        return this.tagData;
    }

    public void setTagData(String string) {
        this.tagData = string;
    }

    public void removeSubTag(String string) {
        ListIterator listIterator = this.subTags.listIterator(0);
        while (listIterator.hasNext()) {
            Tag tag = (Tag)listIterator.next();
            if (!tag.getTagName().equals(string)) continue;
            listIterator.remove();
        }
    }

    public void setMessageNode(MessageNode messageNode) {
        this.messageNode = messageNode;
    }

    public TagInterpreter getInterpreter() {
        TagInfo tagInfo = TagInfo.getTagInfo();
        return tagInfo.getInterpreterInstance(this.tagName);
    }
}

