/*
 * Decompiled with CFR 0.152.
 */
package vscript.GUI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import vscript.GUI.VLabel;
import vscript.VSRHelper;
import vscript.interpreter.EventTagManager;
import vscript.interpreter.TagInterpreter;
import vscript.message.Messagable;
import vscript.message.Message;

public class VTextField
extends JPanel
implements Messagable,
ActionListener {
    private JTextField textField;
    private VLabel label;
    private EventTagManager etm;

    public VTextField(VLabel vLabel, JTextField jTextField) {
        this.textField = jTextField;
        this.label = vLabel;
        this.setLayout(new BorderLayout());
        if (vLabel != null) {
            this.setBackground(VSRHelper.backColor);
            vLabel.setForeground(VSRHelper.foreColor);
            this.add((Component)vLabel, "West");
            this.add((Component)jTextField, "Center");
            jTextField.setCaretColor(jTextField.getForeground());
        } else {
            this.add((Component)jTextField, "Center");
        }
        jTextField.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.etm.processEvent("action");
    }

    public void handleMessage(Message message) {
        TagInterpreter.handleMessageGUI(this, message);
        String string = message.getMessageString();
        String[] stringArray = message.getArguments();
        if (string.equals("settext")) {
            this.textField.setText(stringArray[0]);
        } else if (string.equals("seticon") && this.label != null) {
            this.label.setIconStr(stringArray[0]);
        }
        if (string.equals("setlabeltext") && this.label != null) {
            this.label.setText(stringArray[0]);
        }
        if (string.equals("clear")) {
            this.textField.setText("");
        }
    }

    public void setEventTagManager(EventTagManager eventTagManager) {
        this.etm = eventTagManager;
    }

    public String getDataValue(String string) {
        if (string != null) {
            if (string.equals("data")) {
                return this.textField.getText();
            }
            if (string.equals("labeldata") && this.label != null) {
                return this.label.getText();
            }
        }
        return null;
    }
}

