/*
 * Decompiled with CFR 0.152.
 */
package vscript.GUI;

import java.awt.Component;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import vscript.GUI.CardContainerPanel;
import vscript.Tag;
import vscript.TagBody;
import vscript.VSRHelper;
import vscript.VScriptRunner;
import vscript.message.Message;
import vscript.parser.Parser;

public class VScriptRunnerPanel
extends CardContainerPanel {
    private JPanel firstPanel = new JPanel();
    private JFileChooser chooser;
    private HashMap fileMap = new HashMap(4);
    private String result = "false";

    public VScriptRunnerPanel() {
        this.setBackground(VSRHelper.backColor);
        this.firstPanel.setBackground(VSRHelper.backColor);
        this.add((Component)this.firstPanel, "vsr_first");
        try {
            this.chooser = new JFileChooser(VSRHelper.getVSRHelper().userDir);
        }
        catch (SecurityException securityException) {
            this.chooser = null;
        }
    }

    public void handleMessage(Message message) {
        VScriptRunner vScriptRunner = VScriptRunner.getVScriptRunner();
        super.handleMessage(message);
        try {
            String[] stringArray = message.getArguments();
            String string = message.getMessageString();
            if (stringArray.length == 0) {
                return;
            }
            if (string.equals("load")) {
                if (stringArray.length == 1) {
                    vScriptRunner.loadScript(stringArray[0]);
                }
            } else if (string.equals("reload")) {
                vScriptRunner.reLoadScript(stringArray[0]);
            } else if (string.equals("unload")) {
                vScriptRunner.unLoadScript(stringArray[0]);
            } else if (string.equals("interpret")) {
                if (stringArray.length == 1) {
                    vScriptRunner.interpretScript(stringArray[0], null, null, null);
                } else if (stringArray.length == 2) {
                    vScriptRunner.interpretScript(stringArray[0], stringArray[1], null, null);
                } else if (stringArray.length == 3) {
                    stringArray[2] = stringArray[2].substring(1, stringArray[2].length() - 1);
                    vScriptRunner.interpretScript(stringArray[0], stringArray[1], stringArray[2], null);
                }
            } else if (string.equals("sinterpret")) {
                if (stringArray.length < 2) {
                    return;
                }
                if (stringArray[1].length() > 0 && stringArray[1].charAt(0) == '(') {
                    stringArray[1] = stringArray[1].substring(1, stringArray[1].length() - 1);
                }
                TagBody tagBody = Parser.parse(stringArray[1], null);
                if (tagBody.subtag.size() == 0) {
                    return;
                }
                Tag tag = (Tag)tagBody.subtag.get(0);
                if (tag == null) {
                    return;
                }
                if (stringArray.length == 2) {
                    vScriptRunner.interpretScript(stringArray[0], null, null, tag);
                } else if (stringArray.length == 3) {
                    vScriptRunner.interpretScript(stringArray[0], stringArray[2], null, tag);
                } else if (stringArray.length == 4) {
                    stringArray[3] = stringArray[3].substring(1, stringArray[3].length() - 1);
                    vScriptRunner.interpretScript(stringArray[0], stringArray[2], stringArray[3], tag);
                }
            } else if (string.equals("run")) {
                vScriptRunner.showScript(stringArray[0]);
            } else if (string.equals("loadfile")) {
                if (stringArray.length == 1) {
                    vScriptRunner.loadFile(stringArray[0]);
                }
            } else if (string.equals("selectfile")) {
                String string2 = "Select";
                if (stringArray.length >= 1) {
                    String string3;
                    if (stringArray.length == 2) {
                        string2 = stringArray[1];
                    }
                    if ((string3 = this.showChooser(string2)) != null) {
                        this.fileMap.put(stringArray[0], string3);
                    }
                }
            } else if (string.equals("savefile")) {
                this.saveFile(stringArray);
            } else if (string.equals("print")) {
                System.out.println(stringArray[0]);
            } else if (string.equals("setbaseurl")) {
                VSRHelper.getVSRHelper().baseDir = stringArray[0].substring(0, stringArray[0].lastIndexOf(47) + 1);
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private String showChooser(String string) {
        if (this.chooser == null) {
            return null;
        }
        int n = this.chooser.showDialog(this, string);
        String string2 = null;
        if (n == 0) {
            try {
                string2 = this.chooser.getSelectedFile().toURL().toString();
                this.result = "true";
            }
            catch (Exception exception) {}
        } else {
            this.result = "false";
        }
        return string2;
    }

    private void saveFile(String[] stringArray) {
        if (stringArray.length == 2) {
            try {
                if (stringArray[0].length() == 0) {
                    stringArray[0] = this.showChooser("Save");
                    if (stringArray[0] == null) {
                        return;
                    }
                    if (this.result.equals("false")) {
                        return;
                    }
                }
                if (stringArray[0].startsWith("file:/")) {
                    stringArray[0] = stringArray[0].substring(6);
                }
                FileWriter fileWriter = new FileWriter(stringArray[0]);
                fileWriter.write(stringArray[1]);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println(iOException.toString());
            }
        }
    }

    public String getDataValue(String string) {
        VScriptRunner vScriptRunner = VScriptRunner.getVScriptRunner();
        String string2 = (String)this.fileMap.get(string.substring(5));
        if (string.startsWith("file:")) {
            byte[] byArray;
            string = string.substring(5);
            if (string2 != null) {
                string = string2;
            }
            if ((byArray = vScriptRunner.getFile(string)) != null) {
                return new String(byArray);
            }
            System.out.println(string + " Not loaded");
            return null;
        }
        if (string.startsWith("name:")) {
            return string2;
        }
        if (string.equals("result")) {
            return this.result;
        }
        if (string.equals("stdout")) {
            String string3 = VSRHelper.getVSRHelper().getOutput();
            if (string3 == null) {
                return "";
            }
            return string3;
        }
        if (string.equals("userdir")) {
            return VSRHelper.getVSRHelper().userDir;
        }
        System.out.println(string + ": Wrong request to vsr");
        return null;
    }
}

