/*
 * Decompiled with CFR 0.152.
 */
package vscript.GUI;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import vscript.VSRHelper;
import vscript.image.ImageKit;
import vscript.interpreter.EventTagManager;
import vscript.interpreter.TagInterpreter;
import vscript.message.Messagable;
import vscript.message.Message;

public class ImagePanel
extends JPanel
implements Messagable {
    private Image image;
    private Image bimage;
    private String align;
    private boolean zoom;
    private boolean redraw;
    private int prevWidth;
    private int prevHeight;
    private Image imgBuffer;
    private int x;
    private int y;
    private Color bColor;
    private boolean buttonize;

    public ImagePanel(Image image, Image image2, String string, Color color, boolean bl, boolean bl2) {
        this.image = image;
        this.bimage = image2;
        this.align = string;
        this.zoom = bl;
        this.bColor = color;
        this.buttonize = bl2;
        if (bl) {
            this.align = null;
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        if (image != null) {
            mediaTracker.addImage(image, 1);
        }
        if (image2 != null) {
            mediaTracker.addImage(image2, 2);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n != this.prevWidth || n2 != this.prevHeight) {
            this.redraw = true;
            this.imgBuffer = null;
        }
        this.prevWidth = n;
        this.prevHeight = n2;
        if (this.redraw) {
            if (this.bimage != null && this.bimage.getWidth(null) > 0) {
                this.imgBuffer = !this.buttonize ? ImageKit.tileImage(this.bimage, n, n2, 0, 0) : ImageKit.buildButtonImage(this.bimage, n, n2, null);
            }
            if (this.image != null && this.image.getWidth(null) > 0) {
                if (this.imgBuffer == null) {
                    this.imgBuffer = new BufferedImage(n, n2, 1);
                }
                Graphics graphics2 = this.imgBuffer.getGraphics();
                if (this.align != null) {
                    this.align(n, n2, this.image.getWidth(null), this.image.getHeight(null));
                }
                if (this.bColor != null && this.bimage == null) {
                    graphics2.setColor(this.bColor);
                    graphics2.fillRect(0, 0, n, n2);
                }
                if (!this.zoom) {
                    graphics2.drawImage(this.image, this.x, this.y, null);
                } else {
                    graphics2.drawImage(this.image, this.x, this.y, n, n2, null);
                }
            }
        }
        if (this.imgBuffer != null) {
            graphics.drawImage(this.imgBuffer, 0, 0, null);
            this.redraw = false;
        } else {
            this.redraw = true;
        }
    }

    private void align(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < this.align.length()) {
            char c = this.align.charAt(n5);
            switch (c) {
                case 'c': {
                    this.x = n / 2 - n3 / 2;
                    this.y = n2 / 2 - n4 / 2;
                    break;
                }
                case 'l': {
                    this.x = 0;
                    break;
                }
                case 'r': {
                    this.x = n - n3;
                    break;
                }
                case 't': {
                    this.y = 0;
                    break;
                }
                case 'b': {
                    this.y = n2 - n4;
                }
            }
            ++n5;
        }
    }

    public void handleMessage(Message message) {
        TagInterpreter.handleMessageGUI(this, message);
        String string = message.getMessageString();
        if (string != null) {
            String[] stringArray = message.getArguments();
            if (string.equals("clear")) {
                this.image = null;
                if (this.bimage == null) {
                    this.imgBuffer = null;
                }
                this.redraw = true;
                this.repaint();
            } else if (string.equals("align") && !this.zoom) {
                if (stringArray.length == 1) {
                    this.align = stringArray[0];
                    this.imgBuffer = null;
                    this.redraw = true;
                    this.repaint();
                }
            } else if (string.equals("loadimage") && stringArray.length == 1) {
                Image image = VSRHelper.getVSRHelper().getImage(null, stringArray[0]);
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(image, 3);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (image.getWidth(null) > 0) {
                    this.image = image;
                    this.imgBuffer = null;
                    this.redraw = true;
                    this.repaint();
                }
            }
        }
    }

    public void setEventTagManager(EventTagManager eventTagManager) {
    }

    public String getDataValue(String string) {
        return null;
    }
}

