/*
 * Decompiled with CFR 0.152.
 */
package com.develop.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class LittleEndianOutputStream
extends FilterOutputStream
implements DataOutput {
    public static final byte FLAGS_NULL = 0;
    public static final byte FLAGS_NONNULL = 1;
    public static final int SIZEOF_CHAR = 2;
    protected int written;
    static byte[] bytes256 = new byte[256];

    public LittleEndianOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    private void incCount(int n) {
        int n2 = this.written + n;
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        }
        this.written = n2;
    }

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.incCount(n2);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.out.write(bl ? 1 : 0);
        this.incCount(1);
    }

    public final void writeByte(int n) throws IOException {
        this.out.write(n);
        this.incCount(1);
    }

    public final void writeShort(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n >>> 0 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        this.incCount(2);
    }

    public final void writeChar(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n >>> 0 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        this.incCount(2);
    }

    public final void writeInt(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n >>> 0 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 24 & 0xFF);
        this.incCount(4);
    }

    public final void writeLong(long l) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write((int)(l >>> 0) & 0xFF);
        outputStream.write((int)(l >>> 8) & 0xFF);
        outputStream.write((int)(l >>> 16) & 0xFF);
        outputStream.write((int)(l >>> 24) & 0xFF);
        outputStream.write((int)(l >>> 32) & 0xFF);
        outputStream.write((int)(l >>> 40) & 0xFF);
        outputStream.write((int)(l >>> 48) & 0xFF);
        outputStream.write((int)(l >>> 56) & 0xFF);
        this.incCount(8);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeCurrency(BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 8) {
            bigInteger = new BigInteger(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
        }
        this.writeRBytes(byArray);
    }

    private void writeRBytes(byte[] byArray) throws IOException {
        int n;
        OutputStream outputStream = this.out;
        int n2 = n = byArray.length < 8 ? byArray.length : 8;
        if (byArray.length <= 8) {
            int n3 = n - 1;
            while (n3 >= 0) {
                outputStream.write(byArray[n3]);
                --n3;
            }
            n3 = n;
            while (n3 < 8) {
                outputStream.write(0);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < 8) {
                outputStream.write(-1);
                ++n4;
            }
        }
        this.incCount(8);
    }

    public final void writeBytes(byte[] byArray) throws IOException {
        OutputStream outputStream = this.out;
        int n = byArray.length;
        outputStream.write(byArray);
        this.incCount(n);
    }

    public final void writeBytes(String string) throws IOException {
        OutputStream outputStream = this.out;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            outputStream.write((byte)string.charAt(n2));
            ++n2;
        }
        this.incCount(n);
    }

    public final void writeChars(String string) throws IOException {
        OutputStream outputStream = this.out;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            outputStream.write(c >>> 0 & 0xFF);
            outputStream.write(c >>> 8 & 0xFF);
            ++n2;
        }
        this.incCount(n * 2);
    }

    public final void writeStringUnicode(String string) throws IOException {
        if (string == null) {
            this.writeByte(0);
            return;
        }
        this.writeByte(1);
        int n = string.length();
        this.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            this.writeChar(string.charAt(n2));
            ++n2;
        }
    }

    public final void writeStringANSI(String string) throws IOException {
        if (string == null) {
            this.writeByte(0);
            return;
        }
        this.writeByte(1);
        int n = string.length();
        this.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            this.write((byte)string.charAt(n2));
            ++n2;
        }
    }

    public final void writeUTF(String string) throws IOException {
        throw new IllegalStateException("No support for LittleEndian UTF");
    }

    static final int writeUTF(String string, DataOutput dataOutput) throws IOException {
        throw new IllegalStateException("No support for LittleEndian UTF");
    }

    public final int size() {
        return this.written;
    }

    public void writeZeroBytes(int n) throws IOException {
        while (n >= 256) {
            this.write(bytes256, 0, 256);
            n -= 256;
        }
        this.write(bytes256, 0, n);
    }
}

