/*
 * Decompiled with CFR 0.152.
 */
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;

class ServiceClass
implements Runnable {
    private loadbalanced m;
    private String name;
    private String address;
    private String status;
    private int port;
    private boolean RUNNING;
    private boolean LOGGING;
    private boolean ALIVE;
    private boolean ISCONNECTED;
    private int KEEPALIVE_TIME = 2000;
    private int KEEPALIVE_FREQUENCY = 5000;
    private int FAILED_CHECKS = 0;
    private int KEEPALIVE_MAX_FAILED_CHECKS = 2;
    private long CURRENT_TIME;
    private long LAST_CHECK_TIME;
    private long hits = 0L;

    public ServiceClass(loadbalanced loadbalanced2) {
        this.m = loadbalanced2;
        this.LOGGING = loadbalanced.LOGGING;
        this.CURRENT_TIME = System.currentTimeMillis();
        this.status = new String("active");
    }

    public ServiceClass(loadbalanced loadbalanced2, String string) {
        this.m = loadbalanced2;
        this.name = string;
        this.LOGGING = loadbalanced.LOGGING;
        this.CURRENT_TIME = System.currentTimeMillis();
        this.status = new String("active");
    }

    public ServiceClass(loadbalanced loadbalanced2, String string, int n) {
        this.m = loadbalanced2;
        this.address = string;
        this.port = n;
        this.LOGGING = loadbalanced.LOGGING;
        this.CURRENT_TIME = System.currentTimeMillis();
        this.status = new String("active");
    }

    public void run() {
        if (this.LOGGING) {
            this.m.logEvent("ServiceClass " + this.name + " Thread Started");
        }
        while (this.RUNNING) {
            this.checkService();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.LOGGING) {
            this.m.logEvent("ServiceClass " + this.name + " Thread Exited");
        }
    }

    public void setKeepAliveTimeOut(int n) {
        block2: {
            try {
                this.KEEPALIVE_TIME = n * 1000;
            }
            catch (Exception exception) {
                this.KEEPALIVE_TIME = 2000;
                if (!this.LOGGING) break block2;
                this.m.logEvent("ServiceClass " + this.name + " setKeepAliveTimeout(): " + exception);
            }
        }
    }

    public void setKeepAliveFrequency(int n) {
        block2: {
            try {
                this.KEEPALIVE_FREQUENCY = n * 1000;
            }
            catch (Exception exception) {
                this.KEEPALIVE_FREQUENCY = 5000;
                if (!this.LOGGING) break block2;
                this.m.logEvent("ServiceClass " + this.name + " setKeepAliveFrequency(): " + exception);
            }
        }
    }

    public void setKeepAliveMaxFailure(int n) {
        block2: {
            try {
                this.KEEPALIVE_MAX_FAILED_CHECKS = n;
            }
            catch (Exception exception) {
                this.KEEPALIVE_MAX_FAILED_CHECKS = 2;
                if (!this.LOGGING) break block2;
                this.m.logEvent("ServiceClass " + this.name + " setKeepAliveMaxFailure(): " + exception);
            }
        }
    }

    public int getKeepAliveFrequency() {
        return this.KEEPALIVE_FREQUENCY;
    }

    public int getKeepAliveTimeOut() {
        return this.KEEPALIVE_TIME;
    }

    public int getKeepAliveMaxFailure() {
        return this.KEEPALIVE_MAX_FAILED_CHECKS;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public synchronized void activate() {
        this.status = "active";
        if (!this.RUNNING) {
            this.RUNNING = true;
            Thread thread = new Thread(this);
            thread.start();
        }
        if (this.LOGGING) {
            this.m.logEvent("Service " + this.name + " changed state to active");
        }
    }

    public synchronized void suspend() {
        this.status = "shutdown";
        this.RUNNING = false;
        if (this.LOGGING) {
            this.m.logEvent("Service " + this.name + " changed state to administratively shutdown");
        }
    }

    public synchronized void down() {
        if (this.status.equals("active")) {
            this.status = "down";
            if (this.LOGGING) {
                this.m.logEvent("Service " + this.name + " changed state to down");
            }
        }
    }

    public synchronized void setStatus(String string) {
        this.status = string;
    }

    public synchronized void setName(String string) {
        this.name = string;
    }

    public synchronized void hitCounter() {
        ++this.hits;
    }

    public synchronized long getHitCounter() {
        return this.hits;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public void checkService() {
        if (this.status.equals("shutdown")) {
            return;
        }
        this.CURRENT_TIME = System.currentTimeMillis();
        if (this.CURRENT_TIME - this.LAST_CHECK_TIME < (long)this.KEEPALIVE_FREQUENCY) {
            return;
        }
        this.LAST_CHECK_TIME = System.currentTimeMillis();
        try {
            Socket socket = null;
            socket = new Socket(this.address, this.port);
            socket.setSoTimeout(this.KEEPALIVE_TIME);
            socket.close();
            this.LAST_CHECK_TIME = System.currentTimeMillis();
        }
        catch (ConnectException connectException) {
            ++this.FAILED_CHECKS;
            if (this.FAILED_CHECKS >= this.KEEPALIVE_MAX_FAILED_CHECKS && this.getStatus().equals("active")) {
                this.FAILED_CHECKS = 0;
                this.down();
            }
            this.LAST_CHECK_TIME = System.currentTimeMillis();
            return;
        }
        catch (UnknownHostException unknownHostException) {
            this.m.logEvent("Service " + this.name + ".checkService(): Cannot resolve host " + this.address);
            if (this.getStatus().equals("active")) {
                this.FAILED_CHECKS = 0;
                this.down();
            }
            this.LAST_CHECK_TIME = System.currentTimeMillis();
            return;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            this.m.logEvent("Service " + this.name + ".checkService(): No Route To " + this.address);
            if (this.getStatus().equals("active")) {
                this.FAILED_CHECKS = 0;
                this.down();
            }
            this.LAST_CHECK_TIME = System.currentTimeMillis();
            return;
        }
        catch (Exception exception) {
            this.m.logEvent("Service " + this.name + ".checkService(): " + exception);
            if (this.getStatus().equals("active")) {
                this.FAILED_CHECKS = 0;
                this.down();
            }
            this.LAST_CHECK_TIME = System.currentTimeMillis();
            return;
        }
        this.FAILED_CHECKS = 0;
        if (this.getStatus().equals("down")) {
            this.activate();
        }
    }
}

