// ClientDlg.cpp : implementation file
//

#include "stdafx.h"
#include <malloc.h>
#include "Client.h"
#include "ClientDlg.h"
#include "RFSCLT.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


int nConnection;
HANDLE hFile;
char sError[1024];
char sFile[MAX_PATH];
char sPath[MAX_PATH];

CClientDlg::CClientDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CClientDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CClientDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CClientDlg, CDialog)
	//{{AFX_MSG_MAP(CClientDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_CONNECT, OnBtnConnect)
	ON_BN_CLICKED(IDC_BTN_DISCONNECT, OnBtnDisconnect)
	ON_BN_CLICKED(IDC_BTN_FIND, OnBtnFind)
	ON_BN_CLICKED(IDC_BTN_CREATE_FILE, OnBtnCreateFile)
	ON_BN_CLICKED(IDC_BTN_DELETE_FILE, OnBtnDeleteFile)
	ON_BN_CLICKED(IDC_BTN_CREATE_DIR, OnBtnCreateDir)
	ON_BN_CLICKED(IDC_BTN_DELETE_DIR, OnBtnDeleteDir)
	ON_BN_CLICKED(IDC_BTN_OPEN_FILE, OnBtnOpenFile)
	ON_BN_CLICKED(IDC_BTN_CLOSE_FILE, OnBtnCloseFile)
	ON_BN_CLICKED(IDC_BTN_READ_FILE, OnBtnReadFile)
	ON_BN_CLICKED(IDC_BTN_WRITE, OnBtnWrite)
	ON_BN_CLICKED(IDC_BTN_GET_INFO, OnBtnGetInfo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClientDlg message handlers

BOOL CClientDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// Load default values
	SetDlgItemText(IDC_EDIT_HOST,"LocalHost");
	SetDlgItemText(IDC_EDIT_PORT,"7007");
	SetDlgItemText(IDC_EDIT_USER,"adm");
	SetDlgItemText(IDC_EDIT_PWD,"adm");
	SetDlgItemText(IDC_EDIT_FIND,"CDRIVE:\\*.*");
	SetDlgItemText(IDC_EDIT_FILE1,"CDRIVE:\\testfile.txt");
	SetDlgItemText(IDC_EDIT_FILE2,"CDRIVE:\\Test");
	SetDlgItemText(IDC_EDIT_FILE3,"CDRIVE:\\WINNT\\win.ini");
	SetDlgItemText(IDC_EDIT_INFO,"CDRIVE:\\WINNT\\win.ini");
	SetDlgItemText(IDC_EDIT_FILE,"");
	SetDlgItemText(IDC_EDIT_APPEND,";new line\r\n");
	return TRUE;
}

void CClientDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); 
		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
		CDialog::OnPaint();
}

HCURSOR CClientDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void DisplayErrorMessage(int nError)
{
   RFS_GetErrorText(nError,sError);
   MessageBox(NULL,sError,"Error",MB_OK);
}


void CClientDlg::OnBtnConnect() 
{
	char sHost[100], sPort[10],sUser[100], sPwd[100];
	GetDlgItem(IDC_EDIT_HOST)->GetWindowText(sHost,sizeof(sHost));
	GetDlgItem(IDC_EDIT_PORT)->GetWindowText(sPort,sizeof(sPort));
	GetDlgItem(IDC_EDIT_USER)->GetWindowText(sUser,sizeof(sUser));
	GetDlgItem(IDC_EDIT_PWD)->GetWindowText(sPwd,sizeof(sPwd));
	int nPort = atoi(sPort);
	int nRet = RFS_Connect(sHost,nPort,sUser,sPwd,&nConnection);
	(nRet>0) ? DisplayErrorMessage(nRet) : MessageBox("Connected");
}

void CClientDlg::OnBtnDisconnect() 
{
	int nRet = RFS_Disconnect(nConnection);
}

void CClientDlg::OnBtnFind() 
{
	HANDLE hSearch;
	RFS_FILE_INFO FileInfo;
	char sItem[100];
	int nRet;

	GetDlgItem(IDC_EDIT_FIND)->GetWindowText(sPath,sizeof(sPath));

	nRet = RFS_FileFindFirst(nConnection,sPath,&hSearch,sFile,&FileInfo);
	while ((nRet==0)&(strlen(sFile)>0))
	{
		if (FileInfo.bDirectory)
			strcpy(sItem,"<D> ");
		else
			strcpy(sItem,"<F> ");
		strcat(sItem,sFile);
		((CListBox*)GetDlgItem(IDC_LIST1))->AddString(sItem);
		nRet = RFS_FileFindNext(nConnection,hSearch,sFile,&FileInfo);
	}
	if (nRet>0) DisplayErrorMessage(nRet);
}

void CClientDlg::OnBtnCreateFile() 
{
	GetDlgItem(IDC_EDIT_FILE1)->GetWindowText(sFile,sizeof(sFile));
	int nRet = RFS_FileCreate(nConnection,sFile);
	(nRet>0) ? DisplayErrorMessage(nRet) : MessageBox("File created");
}

void CClientDlg::OnBtnDeleteFile() 
{
	GetDlgItem(IDC_EDIT_FILE1)->GetWindowText(sFile,sizeof(sFile));
	int nRet = RFS_FileDelete(nConnection,sFile);
	(nRet>0) ? DisplayErrorMessage(nRet) : MessageBox("File deleted");
}

void CClientDlg::OnBtnCreateDir() 
{
	GetDlgItem(IDC_EDIT_FILE2)->GetWindowText(sPath,sizeof(sPath));
	int nRet = RFS_CreateDir(nConnection,sPath);
	(nRet>0) ? DisplayErrorMessage(nRet) : MessageBox("Directory created");
}

void CClientDlg::OnBtnDeleteDir() 
{
	GetDlgItem(IDC_EDIT_FILE2)->GetWindowText(sPath,sizeof(sPath));
	int nRet = RFS_DeleteDir(nConnection,sPath);
	(nRet>0) ? DisplayErrorMessage(nRet) : MessageBox("Directory deleted");	
}

void CClientDlg::OnBtnOpenFile() 
{
	GetDlgItem(IDC_EDIT_FILE3)->GetWindowText(sFile,sizeof(sFile));
	int nRet = RFS_FileOpen(nConnection,sFile,RFS_FILE_READWRITE,&hFile);
	(nRet>0) ? DisplayErrorMessage(nRet) : MessageBox("Opened");	
}

void CClientDlg::OnBtnCloseFile() 
{
	int nRet = RFS_FileClose(nConnection,hFile);
	(nRet>0) ? DisplayErrorMessage(nRet) : MessageBox("Closed");	
}

void CClientDlg::OnBtnReadFile() 
{
	DWORD dwNewPos;
	DWORD dwFileSize;
	DWORD dwRead;
	int nRet;
	nRet = RFS_FileSetPointer(nConnection,hFile,0,RFS_FILE_END,&dwNewPos);
	if (nRet>0) {
		DisplayErrorMessage(nRet);
		return;
	}
	else
		dwFileSize = dwNewPos;
    nRet = RFS_FileSetPointer(nConnection,hFile,0,RFS_FILE_BEGIN,&dwNewPos);
	if (nRet>0) {
		DisplayErrorMessage(nRet);
		return;
	}
	
	char Buffer[99999];
	if (dwFileSize > 99999)
		dwFileSize = 99999;
	
	CEdit* edit = (CEdit*)GetDlgItem(IDC_EDIT_FILE);
	if ((nRet = RFS_FileRead(nConnection,hFile,Buffer,dwFileSize,&dwRead))==0)
	{
		Buffer[dwRead]=0;
		edit->SetWindowText(Buffer);
	}
	else
		DisplayErrorMessage(nRet);	
}

void CClientDlg::OnBtnWrite() 
{
	DWORD dwNewPos;
	DWORD dwWritten;
	char Buffer[1024];
	int nRet;
	nRet = RFS_FileSetPointer(nConnection,hFile,0,RFS_FILE_END,&dwNewPos);
	if (nRet==0) 
	{
		GetDlgItem(IDC_EDIT_APPEND)->GetWindowText(Buffer,sizeof(Buffer));
		RFS_FileWrite(nConnection,hFile,Buffer,strlen(Buffer),&dwWritten);
		
	}
	else
	{
		DisplayErrorMessage(nRet);
		return;
	}
}

void CClientDlg::OnBtnGetInfo() 
{

	char sInfo[1024];
	RFS_FILE_INFO FileInfo;
	GetDlgItem(IDC_EDIT_INFO)->GetWindowText(sFile,sizeof(sFile));
	int nRet = RFS_FileGetInfo(nConnection,sFile,&FileInfo);
	if (nRet>0) 
		DisplayErrorMessage(nRet);
	else
	{
		char sSize[10];
		CTime t(FileInfo.ftLastWriteTime);
		itoa(FileInfo.dwFileSize,sSize,10);
		strcpy(sInfo,"Size: ");
		strcat(sInfo,sSize);
		strcat(sInfo," Kb, Modified: ");
		strcat(sInfo,t.Format("%m/%d/%Y %H:%M:%S"));
		MessageBox(sInfo);
	}
}

