/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.KeyRef;
import org.apache.xerces.impl.xs.identity.UniqueOrKey;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractIDConstraintTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDKeyrefTraverser
extends XSDAbstractIDConstraintTraverser {
    public XSDKeyrefTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    void traverse(Element krElem, XSElementDecl element, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(krElem, false, schemaDoc);
        String krName = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        if (krName == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_KEYREF, SchemaSymbols.ATT_NAME});
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        QName kName = (QName)attrValues[XSAttributeChecker.ATTIDX_REFER];
        if (kName == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_KEYREF, SchemaSymbols.ATT_REFER});
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        UniqueOrKey key = null;
        IdentityConstraint ret = (IdentityConstraint)this.fSchemaHandler.getGlobalDecl(schemaDoc, 5, kName);
        if (ret != null) {
            if (ret.getType() == 1 || ret.getType() == 0) {
                key = (UniqueOrKey)ret;
            } else {
                this.reportSchemaError("src-resolve", new Object[]{kName.rawname, "identity constraint key/unique"});
            }
        }
        if (key == null) {
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        KeyRef keyRef = new KeyRef(krName, element.fName, key);
        this.traverseIdentityConstraint(keyRef, krElem, schemaDoc, attrValues);
        if (key.getFieldCount() != keyRef.getFieldCount()) {
            this.reportSchemaError("c-props-correct.2", new Object[]{krName, key.getIdentityConstraintName()});
        } else {
            grammar.addIDConstraintDecl(element, keyRef);
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
    }
}

