// file tun_util.cpp
//(C) 1996 Alessandro Mordacci
//(C) 1996 SMC Sistemi di Misura e Controllo
//    Via Caduti del Lavoro, 26 - Pisa (Italy)
//    Tel. +39 50 525484
#include "lnk_util.h"
#include "dbg_util.h"
#include <strstrea.h>

char *GetSysErrlist(int iErrorCode);

// On some compilers including errno.h generates some errors.
// We do not include this file but define ourselves some stuff.
extern int _sys_nerr;         // errno.h
extern char *_sys_errlist[ ]; // errno.h

#ifndef EMFILE  //errno.h
#define EMFILE   4      /* Too many open files      */
#endif
#ifndef EACCES  // errno.h
#define EACCES   5      /* Permission denied        */
#endif
#ifndef EBADF  // errno.h
#define EBADF    6      /* Bad file number          */
#endif
#ifndef EFAULT  // errno.h
#define EFAULT  14      /* Unknown error            */
#endif
#ifndef EINVAL  // errno.h
#define EINVAL  19      /* Invalid argument         */
#endif
#ifndef EINTR  // errno.h
#define EINTR   39      /* Interrupted function call */
#endif


struct SocketError {
	char *szWSACode;
	char *szCode;
	int  nCode;
	char *szDescription;
};

SocketError sockErrorTable[] =
{
  //Windows code			Berkeley 			Error	Interpretation

 {"WSAEINTR",					"EINTR",					EINTR,					_sys_errlist[EINTR]  },
 {"WSAEBADF",					"EBADF",					EBADF,					_sys_errlist[EBADF]  },
 {"WSEACCES",					"EACCES",				EACCES,					_sys_errlist[EACCES] },
 {"WSAEFAULT",					"EFAULT",				EFAULT,					_sys_errlist[EFAULT] },
 {"WSAEINVAL",					"EINVAL",				EINVAL,					_sys_errlist[EINVAL] },
 {"WSAEMFILE",					"EMFILE",				EMFILE,					_sys_errlist[EMFILE] },
 
 {"WSAEWOULDBLOCK",			"EWOULDBLOCK",			EWOULDBLOCK,			0 },
 {"WSAEINPROGRESS",			"EINPROGRESS",			EINPROGRESS,			"This error is returned if any Windows Sockets API function is called while a blocking function is in progress." },
 {"WSAEALREADY",				"EALREADY",				EALREADY,				0 },
 {"WSAENOTSOCK",				"ENOTSOCK",				ENOTSOCK,				0 },
 {"WSAEDESTADDRREQ",			"EDESTADDRREQ",		EDESTADDRREQ,			0 },
 {"WSAEMSGSIZE",				"EMSGSIZE",				EMSGSIZE,				0 },
 {"WSAEPROTOTYPE",			"EPROTOTYPE",			EPROTOTYPE,				0 },
 {"WSAENOPROTOOPT",			"ENOPROTOOPT",			ENOPROTOOPT,			0 },
 {"WSAEPROTONOSUPPORT",		"EPROTONOSUPPORT",	EPROTONOSUPPORT,		0 },
 {"WSAESOCKTNOSUPPORT",		"ESOCKTNOSUPPORT",	ESOCKTNOSUPPORT,		0 },

 {"WSAEOPNOTSUPP",			"EOPNOTSUPP",			EOPNOTSUPP,				0 },
 {"WSAEPFNOSUPPORT",			"EPFNOSUPPORT",		EPFNOSUPPORT,			0 },
 {"WSAEAFNOSUPPORT",			"EAFNOSUPPORT",		EAFNOSUPPORT,			0 },
 {"WSAEADDRINUSE",			"EADDRINUSE",			EADDRINUSE,				0 },
 {"WSAEADDRNOTAVAIL",		"EADDRNOTAVAIL",		EADDRNOTAVAIL,			0 },
 {"WSAENETDOWN",				"ENETDOWN",				ENETDOWN,				"As in BSD.  This error may be reported at any time if the Windows Sockets implementation detects an underlying failure." },
 {"WSAENETUNREACH",			"ENETUNREACH",			ENETUNREACH,			0 },
 {"WSAENETRESET",				"ENETRESET",			ENETRESET,				0 },
 {"WSAECONNABORTED",			"ECONNABORTED",		ECONNABORTED,			0 },
 {"WSAECONNRESET",			"ECONNRESET",			ECONNRESET,				0 },
 {"WSAENOBUFS",				"ENOBUFS",				ENOBUFS,					0 },
 {"WSAEISCONN",				"EISCONN",				EISCONN,					0 },
 {"WSAENOTCONN",				"ENOTCONN",				ENOTCONN,				0 },
 {"WSAESHUTDOWN",				"ESHUTDOWN",			ESHUTDOWN,				0 },
 {"WSAETOOMANYREFS",			"ETOOMANYREFS",		ETOOMANYREFS,			0 },
 {"WSAETIMEDOUT",				"ETIMEDOUT",			ETIMEDOUT,				0 },
 {"WSAECONNREFUSED",			"ECONNREFUSED",		ECONNREFUSED,			0 },
 {"WSAELOOP",					"ELOOP",					ELOOP,					0 },

 {"WSAENAMETOOLONG",			"ENAMETOOLONG",		ENAMETOOLONG,			0 },
 {"WSAEHOSTDOWN",				"EHOSTDOWN",			EHOSTDOWN,				0 },
 {"WSAEHOSTUNREACH",			"EHOSTUNREACH",		EHOSTUNREACH,			0 },

 {"WSASYSNOTREADY",			 0,						WSASYSNOTREADY,		"Returned by WSAStartup()indicating that the network subsystem is unusable." },
 {"WSAVERNOTSUPPORTED",	 	 0,						WSAVERNOTSUPPORTED,  "Returned by WSAStartup()indicating that the Windows Sockets DLL cannot support this app." },
 {"WSANOTINITIALISED",		 0,						WSANOTINITIALISED,	"Returned by any function except WSAStartup() indicating that a successful WSAStartup() has not yet been performed." },
 {"WSAHOST_NOT_FOUND",		"HOST_NOT_FOUND",		HOST_NOT_FOUND,		0 },
 {"WSATRY_AGAIN",				"TRY_AGAIN",			TRY_AGAIN,				0 },
 {"WSANO_RECOVERY",			"NO_RECOVERY",			NO_RECOVERY,			0 },
 {"WSANO_DATA",				"NO_DATA",				NO_DATA,					0 },
};

char *GetSysErrlist(int iErrorCode)
{
 if ( iErrorCode < _sys_nerr)
	 return _sys_errlist[iErrorCode];
 return "Unknown Error Code";
}

static char *chkStr(char *szChk)
{
 if (szChk==0)
	 return "";
 return szChk;
}
static char *selectStr(char *sz1, char *sz2)
{
 if (sz1!=0)
	 return sz1;
 if (sz2!=0)
	 return sz2;
 return "";
}

//	szWSACode szCode nCode szDescription


char *GetSocketErrorText(int nCode, char *szSkErrBuf, int iLen)
{
 szSkErrBuf[0] = 0; szSkErrBuf[iLen-1] = 0;
 ostrstream os(szSkErrBuf, iLen-2);
 for(int i =0; i<sizeof(sockErrorTable); i++)
	 if (sockErrorTable[i].nCode == nCode) {
		 os<<nCode<<" "<<selectStr(sockErrorTable[i].szCode, sockErrorTable[i].szWSACode)
			<<chkStr(sockErrorTable[i].szDescription)<<ends;
		 return szSkErrBuf;
	 }
 os<<nCode<<" (Unknown error code)"<<ends;
 return szSkErrBuf;
}

char *GetSocketErrorText(char *szSkErrBuf, int iLen)
{
 return GetSocketErrorText(GetSocketError(), szSkErrBuf, iLen );
}

void socketErrorExit(char *msg)
{
 char szBuff[256];
 cerr<<msg<<" - error code = "<<GetSocketErrorText(szBuff,256)<<endl;
 mySleep(5);
 exit(3);
}

void initWinsockLib(void)
{
 WORD wVersionRequested;
 WSADATA wsaData;
 int err;
 wVersionRequested = MAKEWORD( 1, 1 );
 err = WSAStartup( wVersionRequested, &wsaData );
 if ( err != 0 ) {
	 cerr<<"cannot find winsock.dll"<<endl;
	 exit(1);
 }
 if ( LOBYTE( wsaData.wVersion ) != 1 ||
			HIBYTE( wsaData.wVersion ) != 1 ) {
	 /* Tell the user that we couldn't find a useable */
	 /* winsock.dll.                                  */
	 cerr<<"winsock.dll is an old version"<<endl;
	 WSACleanup( );
	 exit(2);
 }
}

int bindMySocket(SOCKET s)
{
 SOCKADDR_IN sin;
 u_short alport = 8080;
 sin.sin_family = AF_INET;
 sin.sin_addr.s_addr = 0;
 sin.sin_port = htons(alport);
 if (bind(s, (LPSOCKADDR)&sin, sizeof (sin)) == 0)
	 return 0;
 return SOCKET_ERROR;
}

int sendAllBytes ( SOCKET s, const char * buf, int len, int flags )
{
 int n_send_total, n_last;
 n_send_total = send (s, buf, len, flags);
 if (n_send_total == SOCKET_ERROR)
	 return n_send_total;
 while (n_send_total < len) {
	 n_last = send(s, &(buf[n_send_total]), (len - n_send_total), flags);
	 if (n_last == SOCKET_ERROR)
		 return n_send_total;
	 n_send_total +=n_last;
 }
 return n_send_total;
}

void waitThread(unsigned long ulID, DWORD dwTimeout)
{
 DWORD dwReturnCode;
 dwReturnCode = WaitForSingleObject (
	 (HANDLE) ulID,	   // handle of object to wait for
	 dwTimeout	// time-out interval in milliseconds
 );
 if (dwReturnCode == WAIT_FAILED) {
	 int ierr = GetLastError();
	 if (ierr!=EBADF)
		 cerr<<"waitThread failed - error = "<<ierr
			  <<" "<<GetSysErrlist(ierr)<<endl;
 } else if (dwReturnCode ==  WAIT_TIMEOUT) {
	 DbgCoutMsg("timeout (") DbgMsg(dwTimeout) DbgMsgLn("ms) in waitThread");
 }
}

void mySleep(int iSec)
{
 Sleep(iSec*((DWORD)1000));
}


