/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.ImageProducer;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uk.co.visualisationsystems.QuickFire.ImageProducer.QuickFireImageProducerException;
import uk.co.visualisationsystems.QuickFire.ImageProducer.QuickFireSprite;

public class QuickFireImageProducer
implements ImageProducer,
Runnable {
    private String threadID;
    private Vector consumerList = new Vector();
    private int width;
    private int height;
    private int MaxSprites;
    private QuickFireSprite[] sprite;
    private QuickFireSprite watermarkSprite;
    private int[] image;
    private Thread thread;
    private boolean productionEnabled;
    private boolean oneShot;
    private int delayMS;

    public QuickFireImageProducer(int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.image = new int[this.width * this.height];
        this.MaxSprites = n3;
        this.sprite = new QuickFireSprite[this.MaxSprites + 1];
        int n4 = 0;
        while (n4 <= this.MaxSprites) {
            this.sprite[n4] = null;
            ++n4;
        }
        this.watermarkSprite = null;
        this.threadID = Long.toHexString(System.currentTimeMillis());
        this.thread = new Thread((Runnable)this, "QuickFireImageProducer");
    }

    public void Halt() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (!this.isConsumer(imageConsumer)) {
            this.consumerList.addElement(imageConsumer);
        }
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        if (this.isConsumer(imageConsumer)) {
            this.consumerList.removeElement(imageConsumer);
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumerList.indexOf(imageConsumer) != -1;
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        this.thread.start();
        this.productionEnabled = true;
        this.oneShot = false;
        this.delayMS = 50;
    }

    public void Refresh(boolean bl) {
        this.oneShot = bl;
    }

    public void ProductionEnabled(boolean bl) {
        this.productionEnabled = bl;
    }

    public void ProductionRate(int n) {
        this.delayMS = n;
    }

    private void ProduceImage() {
        int n = 0;
        while (n <= this.MaxSprites) {
            if (this.sprite[n] != null) {
                this.sprite[n].DrawSprite(this.image, this.width, this.height);
            }
            ++n;
        }
        if (this.watermarkSprite != null) {
            this.watermarkSprite.DrawSprite(this.image, this.width, this.height);
        }
        Hashtable hashtable = new Hashtable();
        DirectColorModel directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        Vector vector = (Vector)this.consumerList.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
            imageConsumer.setColorModel(directColorModel);
            imageConsumer.setDimensions(this.width, this.height);
            imageConsumer.setProperties(hashtable);
            imageConsumer.setHints(2);
            imageConsumer.setPixels(0, 0, this.width, this.height, (ColorModel)directColorModel, this.image, 0, this.width);
            imageConsumer.imageComplete(2);
        }
    }

    public void run() {
        System.out.println("ImageProducer.run() - Started (0x" + this.threadID + ")");
        try {
            try {
                while (true) {
                    if (this.productionEnabled || this.oneShot) {
                        this.ProduceImage();
                        this.oneShot = false;
                    }
                    try {
                        Thread.sleep(this.delayMS);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (ThreadDeath threadDeath) {
                System.out.println("ImageProducer.run() - ThreadDeath: " + threadDeath.getMessage() + " (0x" + this.threadID + ")");
                throw threadDeath;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            System.out.println("ImageProducer.run() - Finished (0x" + this.threadID + ")");
            throw throwable;
        }
    }

    public void EnableWatermark(boolean bl) {
        if (bl) {
            this.watermarkSprite = new QuickFireSprite(1, 20, 20, true);
            this.watermarkSprite.SetColour(0xFF0000);
            this.watermarkSprite.PolyBegin(10, 0);
            this.watermarkSprite.SetColour(65280);
            this.watermarkSprite.PolyDrawTo(20, 20);
            this.watermarkSprite.SetColour(255);
            this.watermarkSprite.PolyDrawTo(0, 20);
            this.watermarkSprite.PolyEnd();
            this.watermarkSprite.MoveTo(0, 0);
            this.watermarkSprite.Scale(1.0, 1.0);
            this.watermarkSprite.Rotate(0.0);
        } else {
            this.watermarkSprite = null;
        }
    }

    public int DisplayWidth() {
        return this.width;
    }

    public int DisplayHeight() {
        return this.height;
    }

    public int SpriteCount() {
        return this.MaxSprites;
    }

    private void InvalidSpriteNumber(int n) throws QuickFireImageProducerException {
        throw new QuickFireImageProducerException("Invalid sprite number (" + n + ")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void SpriteCreate(int n, int n2, int n3, int n4) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            if (n2 <= 0) throw new QuickFireImageProducerException("Invalid number of images (" + n2 + ") requested for sprite number " + n);
            this.sprite[n] = new QuickFireSprite(n2, n3, n4, true);
            this.sprite[n].MoveTo(n3, 0);
            this.sprite[n].Scale(1.0, 1.0);
            this.sprite[n].Rotate(0.0);
            return;
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpriteDestroy(int n) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n] = null;
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public int SpriteGetNumFrames(int n) throws QuickFireImageProducerException {
        int n2 = 0;
        if (n >= 0 && n <= this.MaxSprites) {
            n2 = this.sprite[n].getNumFrames();
        } else {
            this.InvalidSpriteNumber(n);
        }
        return n2;
    }

    public int SpriteGetWidth(int n) throws QuickFireImageProducerException {
        int n2 = 0;
        if (n >= 0 && n <= this.MaxSprites) {
            n2 = this.sprite[n].getWidth();
        } else {
            this.InvalidSpriteNumber(n);
        }
        return n2;
    }

    public int SpriteGetHeight(int n) throws QuickFireImageProducerException {
        int n2 = 0;
        if (n >= 0 && n <= this.MaxSprites) {
            n2 = this.sprite[n].getHeight();
        } else {
            this.InvalidSpriteNumber(n);
        }
        return n2;
    }

    public int SpriteGetPixelAt(int n, int n2, int n3) throws QuickFireImageProducerException {
        int n4 = -1;
        if (n >= 0 && n <= this.MaxSprites) {
            n4 = this.sprite[n].getPixelAt(n2, n3);
        } else {
            this.InvalidSpriteNumber(n);
        }
        return n4;
    }

    public void SpriteSelectFrame(int n, int n2) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].SelectFrame(n2);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpriteMove(int n, int n2, int n3) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].MoveTo(n2, n3);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpriteScale(int n, double d, double d2) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].Scale(d, d2);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpriteRotate(int n, double d) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].Rotate(d);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpriteSetColour(int n, int n2) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].SetColour(n2);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpritePlot(int n, int n2, int n3) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].Plot(n2, n3);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpriteDrawTo(int n, int n2, int n3) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].DrawTo(n2, n3);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpriteSetText(int n, Image image, int n2, int n3, int n4, int n5) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].SetText(image, n2, n3, n4, n5);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpritePutImage(int n, Image image, int n2, int n3, int n4, int n5, int n6) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].PutImage(image, n2, n3, n4, n5, n6);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpriteClearArea(int n, int n2, int n3, int n4, int n5) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].ClearArea(n2, n3, n4, n5);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpriteFillArea(int n, int n2, int n3, int n4, int n5) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].FillArea(n2, n3, n4, n5);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpritePolyBegin(int n, int n2, int n3) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].PolyBegin(n2, n3);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpritePolyDrawTo(int n, int n2, int n3) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].PolyDrawTo(n2, n3);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpritePolyEnd(int n) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].PolyEnd();
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpriteCopyArea(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            this.sprite[n].CopyArea(n2, n3, n4, n5, n6, n7);
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public void SpriteMerge(int n, int n2, int n3, int n4) throws QuickFireImageProducerException {
        if (n >= 0 && n <= this.MaxSprites) {
            if (n2 >= 0 && n2 <= this.MaxSprites) {
                this.sprite[n].Merge(this.sprite[n2], n3, n4);
            } else {
                this.InvalidSpriteNumber(n2);
            }
        } else {
            this.InvalidSpriteNumber(n);
        }
    }

    public long SpriteCollision(int n, long l) throws QuickFireImageProducerException {
        long l2 = 0L;
        if (n >= 0 && n <= this.MaxSprites) {
            long l3 = 1L;
            int n2 = 1;
            while (n2 <= this.MaxSprites) {
                if (n2 != n && this.sprite[n2] != null && (l & 1L) == 1L && this.sprite[n].Hit(this.sprite[n2])) {
                    l2 |= l3;
                }
                l >>= 1;
                l3 <<= 1;
                ++n2;
            }
        } else {
            this.InvalidSpriteNumber(n);
        }
        return l2;
    }
}

