VERSION 4.00
Begin VB.Form Dial
   Appearance      =   0  'Flat
   BackColor       =   &H80000005&
   Caption         =   "Dial"
   ClientHeight    =   3330
   ClientLeft      =   4365
   ClientTop       =   4740
   ClientWidth     =   6195
   BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851}
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   4020
   Left            =   4305
   LinkTopic       =   "Form1"
   ScaleHeight     =   3330
   ScaleWidth      =   6195
   Top             =   4110
   Width           =   6315
   Begin VB.Timer Timer1
      Enabled         =   0   'False
      Interval        =   250
      Left            =   240
      Top             =   360
   End
   Begin VB.TextBox eResult
      Height          =   3375
      Left            =   0
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   0
      Width           =   6255
   End
   Begin VB.Menu mExit
      Caption         =   "EXIT"
   End
   Begin VB.Menu mDial1
      Caption         =   "DIAL1"
      Visible         =   0   'False
   End
   Begin VB.Menu mDial2
      Caption         =   "DIAL2"
      Visible         =   0   'False
   End
   Begin VB.Menu mDial3
      Caption         =   "DIAL3"
      Visible         =   0   'False
   End
   Begin VB.Menu mDial4
      Caption         =   "DIAL4"
      Visible         =   0   'False
   End
   Begin VB.Menu mDial5
      Caption         =   "DIAL5"
      Visible         =   0   'False
   End
End
Attribute VB_Name = "Dial"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

Option Explicit


Private Sub DisplayLine(X As String)
eResult.Text = eResult.Text + X + Chr$(13) + Chr$(10)
End Sub

Private Sub ShowError(ByVal ErrCode As Long)
Dim Code As Long
Dim Buffer As String * 81
Code = mddErrorText(ErrCode, Buffer, 80)
Call DisplayLine(Left$(Buffer, Code))
End Sub

Private Sub DialTheEntry(ByVal Entry As Long)
Dim Code As Long
mDial1.Enabled = False
mDial2.Enabled = False
mDial3.Enabled = False
mDial4.Enabled = False
mDial5.Enabled = False
' entries numbered from 0, not 1
Code = mddBeginDial(Entry-1)
If Code < 0 Then
  Call ShowError(Code)
Else
  Timer1.Enabled = True
End If
End Sub

Private Sub Form_Load()
' Load Form
Dim Code As Integer
Dim Version As Integer
Dim S1, S2, S3 As String
Dim Buffer As String * 81
Dim NbrEntries As Long
Call DisplayLine("DIAL 6/7/2000")
' attach MDD
Code = mddAttach(MDD_KEY_CODE)
If Code < 0 Then
  MsgBox "ERROR: Cannot attach. Check MDD_KEY_CODE."
  End
End If
' get MDD version number
Version = mddDebug(MDD_GET_VERSION, Buffer, 80)
S1 = "MarshallSoft DUN Dialer Version "
S2 = Hex$(Version)
S3 = Mid$(S2, 1, 1) + "." + Mid$(S2, 2, 1) + "." + Mid$(S2, 3, 1)
Call DisplayLine(S1 + S3)
' get registration string
Code = mddDebug(MDD_GET_REGISTRATION, Buffer, 80)
Call DisplayLine(Left$(Buffer, Code))
' load dial entries
Code = mddLoadEntries()
If Code <= 0 Then
  Call DisplayLine("No DUN entries installed")
Else
  ' save # entries
  NbrEntries = Code
  ' list all dialing entries
  If NbrEntries >= 1 Then
    Code = mddGetEntry(0, Buffer, 80)
    mDial1.Caption = Buffer
    mDial1.Visible = True
  End If
  If NbrEntries >= 2 Then
    Code = mddGetEntry(1, Buffer, 80)
    mDial2.Caption = Buffer
    mDial2.Visible = True
  End If
  If NbrEntries >= 3 Then
    Code = mddGetEntry(2, Buffer, 80)
    mDial3.Caption = Buffer
    mDial3.Visible = True
  End If
  If NbrEntries >= 4 Then
     Code = mddGetEntry(3, Buffer, 80)
     mDial4.Caption = Buffer
     mDial4.Visible = True
  End If
  If NbrEntries >= 5 Then
     Code = mddGetEntry(4, Buffer, 80)
     mDial5.Caption = Buffer
     mDial5.Visible = True
  End If
End If
Call DisplayLine("Ready to dial")
End Sub

Private Sub mDIAL1_Click()
Call DisplayLine("Dialing " + mDial1.Caption)
Call DialTheEntry(1)
End Sub

Private Sub mDial2_Click()
Call DisplayLine("Dialing " + mDial2.Caption)
Call DialTheEntry(2)
End Sub

Private Sub mDial3_Click()
Call DisplayLine("Dialing " + mDial3.Caption)
Call DialTheEntry(3)
End Sub

Private Sub mDial4_Click()
Call DisplayLine("Dialing " + mDial4.Caption)
Call DialTheEntry(4)
End Sub

Private Sub mDial5_Click()
Call DisplayLine("Dialing " + mDial5.Caption)
Call DialTheEntry(5)
End Sub

Private Sub mExit_Click()
Dim Code As Long
Code = mddHangup()
Code = mddRelease()
End
End Sub

Private Sub Timer1_Timer()
Dim Code As Long
Dim Status As Long
Dim Buffer As String * 81
Dim X As String
Status = mddDialStatus()
If Status < 0 Then
  Timer1.Enabled = False
  Call ShowError(Status)
Else
  If Status <> LastStatus Then
    LastStatus = Status
    ' display status
    Code = mddStatusText(Status, Buffer, 80)
    If Code > 0 Then
      X = "Status " + Str$(Status) + " " + Left$(Buffer, Code)
      Call DisplayLine(X)
      If (LastStatus = MDD_IS_CONNECTED) Or (LastStatus = MDD_IS_DISCONNECTED) Then
        Timer1.Enabled = False
        Call DisplayLine("Type EXIT to hangup.")
      End If
    End If
  End If
End If
End Sub


