// TVtunnerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TVtunner.h"
#include "TVtunnerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTVtunnerDlg dialog

CTVtunnerDlg::CTVtunnerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTVtunnerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTVtunnerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTVtunnerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTVtunnerDlg)
	DDX_Control(pDX, IDC_CHECK1, m_ChkMute);
	DDX_Control(pDX, IDC_LIST1, m_ListTVChannel);
	DDX_Control(pDX, IDC_EDITCOUNTRY, m_EditCountry);
	DDX_Control(pDX, IDC_CBODEVICE, m_CboDevice);
	DDX_Control(pDX, IDC_STATICPHOTO, m_Pic);
	DDX_Control(pDX, IDC_VIDEOCAPCTRL1, m_VideoCap1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTVtunnerDlg, CDialog)
	//{{AFX_MSG_MAP(CTVtunnerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTNSTART, OnBtnstart)
	ON_BN_CLICKED(IDC_BTNSNAPSHOT, OnBtnsnapshot)
	ON_BN_CLICKED(IDC_BTNCAPTURE, OnBtncapture)
	ON_BN_CLICKED(IDC_BTNSTOPCAP, OnBtnstopcap)
	ON_LBN_SELCHANGE(IDC_LIST1, OnSelchangeList1)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTVtunnerDlg message handlers

BOOL CTVtunnerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

		int i;

	int iDeviceCount= m_VideoCap1.GetDevices().GetCount();
	CString strDeviceName;

	for(i=0; i <iDeviceCount;i++)
	{

		strDeviceName=m_VideoCap1.GetDevices().FindDeviceName(i);
		m_CboDevice.AddString(strDeviceName);
	}

	if(m_CboDevice.GetCount()>0)
		m_CboDevice.SetCurSel(0);


	m_EditCountry.SetWindowText("1");

	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTVtunnerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTVtunnerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTVtunnerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTVtunnerDlg::OnBtnstart() 
{
	// TODO: Add your control notification handler code here

	for (int j=0;j < m_ListTVChannel.GetCount();j++)
	{
	   m_ListTVChannel.DeleteString(0);
	}


	CString strCountryCode;
	m_EditCountry.GetWindowText(strCountryCode);
	m_VideoCap1.SetCountryCode(atoi(strCountryCode));

	m_VideoCap1.Start();




	BOOL bIsTVDevice=m_VideoCap1.ScanTVChannels();

	if(!bIsTVDevice)
		AfxMessageBox("No TV Tunner found");
	
	
	int iTotalChannel,iSignal;
	CString strChannelName;

	iTotalChannel=m_VideoCap1.GetTVChannels().GetCount();

	for(int i=0 ;i < iTotalChannel; i++)
	{

		//m_ListTVChannel.
		strChannelName=m_VideoCap1.GetTVChannels().FindChannelNo(i);
		//m_VideoCap1.ge

		iSignal=m_VideoCap1.GetTVChannels().FindChannelSignal(i);

		if(iSignal!=0)
				m_ListTVChannel.AddString(strChannelName);
	}
	
	
}

void CTVtunnerDlg::OnBtnsnapshot() 
{
	// TODO: Add your control notification handler code here
	TCHAR cAppPath[MAX_PATH];
	GetCurrentDirectory(MAX_PATH, cAppPath);
	CString strPath=CString(cAppPath) ;

	CString strfile=strPath+"\\test.bmp";

	BOOL b=m_VideoCap1.SnapShot(strfile);

	m_Pic.SetImgFile(strfile);
	Invalidate();
	
}

void CTVtunnerDlg::OnBtncapture() 
{
	// TODO: Add your control notification handler code here
	
	char szFilter[]="avi file(*.avi)|*.avi|All Files(*.*)|*.*|| ";
	
	CFileDialog dlg(FALSE,"avi","*.avi",OFN_FILEMUSTEXIST,szFilter,this);
	
	if(dlg.DoModal()==IDOK)
	{


		
		m_VideoCap1.SetCaptureAudio(TRUE);

		m_VideoCap1.SetCaptureVideo(TRUE);
		m_VideoCap1.SetShowPreview(TRUE);

		
		m_VideoCap1.SetUseAudioCompressor(FALSE);

		m_VideoCap1.SetUseVideoCompressor(FALSE);
		m_VideoCap1.SetCaptureFileName(dlg.GetPathName());
		
		m_VideoCap1.SetCaptureMode(TRUE);
		
		
		
		int iResult=m_VideoCap1.Start();
		
		
		if(iResult== -1)
		{
			
			AfxMessageBox("Capture Failure, Video/Audio compressor not correct or capture file opening");
			return;
		}		
		

		
	}
	
	
}

void CTVtunnerDlg::OnBtnstopcap() 
{
	// TODO: Add your control notification handler code here

	m_VideoCap1.Stop();

	m_VideoCap1.SetCaptureMode(FALSE);
	m_VideoCap1.Start();

	
}

void CTVtunnerDlg::OnSelchangeList1() 
{
	// TODO: Add your control notification handler code here

	CString strChannel;
	m_ListTVChannel.GetText(m_ListTVChannel.GetCurSel(),strChannel);

	m_VideoCap1.SetChannel(atoi(strChannel));	
	
}

void CTVtunnerDlg::OnCheck1() 
{
	// TODO: Add your control notification handler code here
	if(m_ChkMute.GetCheck()==BST_CHECKED)	
		m_VideoCap1.SetTVMute(TRUE);
	else
		m_VideoCap1.SetTVMute(FALSE);

}

void CTVtunnerDlg::OnButton1() 
{
	// TODO: Add your control notification handler code here

	m_VideoCap1.ShowVideoCapturePropertyPage();
	
}
