// STConfig -- program to run all apps in subdirectory indicated
// by the current hardware profile as set at system boot.
//
//   Copyright (c) 1997 by 3Com Corporation, Santa Clara, California.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#define STRICT
#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#ifdef _MSC_VER
#define bool int
#define true 1
#define false 0
#endif	// _MSC_VER

#include "stconfig.h"

HWND statusWin;
bool FFFlag = true;
WIN32_FIND_DATA FindData;
HANDLE FindHandle = INVALID_HANDLE_VALUE;
char path[MAX_PATH];

char AppName[] = "StConfig";

LRESULT CALLBACK StConfigDlgProc (HWND hDlg, UINT wMsg, 
				  WPARAM wParam, LPARAM lParam)
{
	switch (wMsg)
	{
	    case WM_INITDIALOG:
		return (0);
	    case WM_SYSCOMMAND:
		if (wParam == SC_CLOSE)
		{
			EndDialog (hDlg, TRUE);
			if (FindHandle != INVALID_HANDLE_VALUE)
				CloseHandle (FindHandle);
			return (TRUE);
		}
		break;
	    case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		    case IDCANCEL:
			EndDialog (hDlg, TRUE);
			if (FindHandle != INVALID_HANDLE_VALUE)
				CloseHandle (FindHandle);
			return (TRUE);
		    default:
			return (0);
		}
	}
	return DefWindowProc (hDlg, wMsg, wParam, lParam) ;
}

void NextFile (void)
{
	int status, len;
	char fname[MAX_PATH];
	char prog[MAX_PATH];

	if (FFFlag)
	{
		strcpy (fname, path);
		strcat (fname, "\\*.*");
		FindHandle = FindFirstFile (fname, &FindData);
		status = FindHandle != INVALID_HANDLE_VALUE;
		FFFlag = false;
	}
	else status = FindNextFile (FindHandle, &FindData);
	if (!status) PostQuitMessage (0);
	else
	{
  		if ((FindData.dwFileAttributes &
		     (FILE_ATTRIBUTE_DIRECTORY |
		      FILE_ATTRIBUTE_HIDDEN |
		      FILE_ATTRIBUTE_SYSTEM |
		      FILE_ATTRIBUTE_TEMPORARY)) == 0)
  		{
			strcpy (fname, path);
  			strcat (fname, "\\");
			strcat (fname, FindData.cFileName);
			strcpy (prog, FindData.cFileName);
			len = strlen (prog);
			if (strcmp (prog + len - 4, ".lnk") == 0)
				prog[len - 4] = '\0';
			SendMessage (GetDlgItem (statusWin, IDFILE),
				     WM_SETTEXT, 0, (LONG) prog);
			ShellExecute (statusWin, NULL, FindData.cFileName,
				      NULL, NULL, SW_SHOWNORMAL);
		}
	}
}

//
// Create the application's main window.
//
void InitApp (HINSTANCE hinst)
{
	HKEY configkey;
	char cn_key[100];
	char cn[100];
	unsigned long cn_len;
	long retval;
	WNDCLASS  wc;

	wc.style	= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc	= StConfigDlgProc;
	wc.cbClsExtra	= 0;
	wc.cbWndExtra	= DLGWINDOWEXTRA;
	wc.hInstance	= hinst;
	wc.hIcon	= LoadIcon(hinst, AppName);
	wc.hCursor	= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground= (HBRUSH)(COLOR_3DFACE + 1);
	wc.lpszMenuName	= NULL;
	wc.lpszClassName= AppName;
	retval = RegisterClass(&wc);
	retval = RegOpenKeyEx (HKEY_LOCAL_MACHINE, 
			       REGKEY, 
			       0,
			       KEY_READ,
			       &configkey);
	cn_len = sizeof (cn);
	retval = RegQueryValueEx (configkey, 
				  CURRENT, 
				  NULL,
				  NULL,
				  (unsigned char *) cn, 
				  &cn_len);
	strcpy (cn_key, CNPREFIX);
	strcat (cn_key, cn);
	cn_len = sizeof (cn);
	retval = RegQueryValueEx (configkey, 
				  cn_key, 
				  NULL,
				  NULL,
				  (unsigned char *) cn, 
				  &cn_len);
	if (!SetCurrentDirectory (cn)) 
	{
		retval = GetLastError ();
		PostQuitMessage (0);
	}
	GetCurrentDirectory (sizeof (path), path);
}

/*************************************************************************\
*
*  FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)
*
*  PURPOSE: Creates the dialogbox.
*
*  COMMENTS:
*
\*************************************************************************/

int APIENTRY WinMain (HINSTANCE hInstance,
                      HINSTANCE hPrevInstance,
                      LPSTR     lpCmdLine,
                      int       nCmdShow)


{
	UNREFERENCED_PARAMETER( nCmdShow );
	UNREFERENCED_PARAMETER( lpCmdLine );
	UNREFERENCED_PARAMETER( hPrevInstance );

	MSG msg;
	
	// Initialize the search state
	InitApp (hInstance);

	// Create the modeless dialog box window
	statusWin = CreateDialog (hInstance,
				  AppName,
				  NULL,
				  NULL);
	if (statusWin == NULL) return (0);
	ShowWindow (statusWin, nCmdShow) ;

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		NextFile ();
	}

	return (msg.wParam);
}
