/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class LRUCache
implements Serializable {
    private transient Hashtable map = new Hashtable();
    private transient Vector queue = new Vector();
    private int maxItems = 25;

    public LRUCache() {
    }

    public LRUCache(int maxItems) {
        if (maxItems <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxItems = maxItems;
    }

    public void emptyCache() {
        this.map.clear();
        this.queue.removeAllElements();
    }

    public void setMaxItems(int newMaxItems) {
        int size;
        if (newMaxItems <= 0) {
            throw new IllegalArgumentException();
        }
        while ((size = this.queue.size()) > newMaxItems) {
            Object lastKey = this.queue.elementAt(size - 1);
            this.queue.removeElementAt(size - 1);
            this.map.remove(lastKey);
        }
        this.maxItems = newMaxItems;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void put(Object key, Object item) {
        int size = this.queue.size();
        if (size >= this.maxItems) {
            Object lastKey = this.queue.elementAt(size - 1);
            this.queue.removeElementAt(size - 1);
            if (lastKey != null) {
                this.map.remove(lastKey);
            }
        }
        this.map.put(key, item);
        this.queue.insertElementAt(key, 0);
    }

    public Object get(Object key) {
        Object item = this.map.get(key);
        if (item != null) {
            this.queue.removeElement(key);
            this.queue.insertElementAt(key, 0);
        }
        return item;
    }
}

