/* flokecore.c - This file is a part of Floke Integrity
 *      Copyright (C) 2000 Jon Wickmann
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by Jon Wickmann <jon.wickmann@excite.com>, 2000.
 * For contact information please see http://www.angelfire.com/wi/wickmann/contact.html
 * Floke Integrity http://www.angelfire.com/wi/wickmann/floke.html
 * Please observe modification guidelines in the documentation
 *
 * History:
 * File last modified 2000.12.29. JWi
 *			- Added stuff for Wizard/Welcome screen
 * modified 2000.09.14. JWi
 *  */
#include "chainmem.h"
#include "types.h"



HINSTANCE hinstGLB;
HWND mainDLG;


//Function pototypes

//static extern BOOL CALLBACK DLG_WIZARDFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
//static BOOL CALLBACK DLG_WIZARDFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);

static BOOL CALLBACK DLGABOUTFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
static BOOL CALLBACK ACKFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
static BOOL CALLBACK PREFFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
static BOOL CALLBACK DialogFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
static BOOL CALLBACK DLGTSKOPTNFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
//static BOOL CALLBACK DLG_WIZARDFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
//static BOOL CALLBACK DLG_WIZARDFunc (HWND hwndDlg ,UINT msg ,WPARAM wParam ,LPARAM lParam );


//Globals for the report engine
unsigned int files=0; //Files scanned

//Debuging verbose levels
#define ERRVERBOSELEVELZERO 0 //No verbose
#define ERRVERBOSELEVELONE 10 //Memory allocations
#define ERRVERBOSELEVELTWO 20 // Not yet in use, but great to have
#define ERRVERBOSELEVELTHREE 30 // Data (besides hashes and files) modified in memory
#define ERRVERBOSELEVELFOUR 40 //Filename and hashes, their reads and memory modifications, including verifications
#define ERRVERBOSELEVELFIVE 50 //Function identifiers


//Use debug helpers
//#define DEBUGHELPERS

#ifdef DEBUGHELPERS
FILE *errverboseout; //Io stream to send error messages to
#endif




BOOL sha_file(char filename[MAX_PATH], unsigned long buffer[5]);
void proccessfile(char filename[MAX_PATH],char basepath[MAX_PATH]);
struct fileentry *memAllocfile(struct fileentry *inPrev);
struct direntry *memAllocdir(struct direntry *inPrev);

//Availabel HASH functions
#define SHA1 	1
#define MD5		2
#define RMD160	3
#define TIGER	4

//Configuration variabels
#define FLOKECOREMAJORVERSION 0
#define FLOKECOREMINORVERSION 0
#define FLOKECOREBUILDVERSION 1

unsigned char CR[1]; // To hold carrier return
unsigned char dirmarker[2]; // To hold dir markers
unsigned char endoffilemarker[1]; // To hold EOF marker
unsigned char lineend[1];
unsigned char verbose;

#define NIL 0 //ZERO
#define SEARCHPATTERNLENGHT 40 //Lenght of searchpattern ie "*.com|*.exe|"

unsigned char hash=MD5; //Which HASH function is in use

unsigned char databasefile[MAX_PATH]; //Database file
unsigned char databasefileversion; //Which version is the database file in
BOOL compressdatabase; //Compress database

struct reportstuct {
	//report options
	unsigned char reportfile[MAX_PATH]; //File for report
	BOOL makeheader;
	BOOL makeheader_time;
	BOOL reportScannedFiles;
	BOOL reportScannedFilesWithHashes;
	BOOL reportCleardFiles;
	BOOL reportCleardFilesWithHashes;
	BOOL reportChangedFiles;
	BOOL reportChangedFilesWithHashes;
	BOOL reportDeletedFiles;
	BOOL reportDeletedFilesWithHashes;
	BOOL reportNewFiles;
	BOOL reportNewFilesWithHashes;
	BOOL reportAccesDeniedFiles;
	BOOL makesummary;
}	*report;

typedef struct {
    u32 A,B,C,D;	  /* chaining variables */
    u32  nblocks;
    byte buf[64];
    int  count;
} MD5_CONTEXT;


typedef struct {
    u32  h0,h1,h2,h3,h4;
    u32  nblocks;
    byte buf[64];
    int  count;
} SHA1_CONTEXT;

typedef struct {
    u32  h0,h1,h2,h3,h4;
    u32  nblocks;
    byte buf[64];
    int  count;
} RMD160_CONTEXT;

typedef unsigned long long u64;
#define HAVE_U64_TYPEDEF

typedef struct {
    u64  h0, h1, h2; //JWi
    byte buf[64];
    int  count;
    u32  nblocks;
} TIGER_CONTEXT;



//static void sha1_final(SHA1_CONTEXT *hd);

struct hashinfostruct {
	BOOL any_hash_working;
	BOOL md5_working;
	BOOL sha1_working;
	BOOL rmd160_working;
	BOOL tiger_working;
	size_t hashlenght; //in bytes
} *hashinfo;

//Fileinfo
unsigned char databasefileid[]="@$FLO";
unsigned char databasefileid2[]="123FLO";
#define DBFILEVERSION_FIRST_STANDARD 1
unsigned char databasefileversion=DBFILEVERSION_FIRST_STANDARD; //Which version is the database file in

unsigned char searchpattern[SEARCHPATTERNLENGHT]; //searchpatern
unsigned char startpath[MAX_PATH];
