LPDIRECT3DRMFACE GetFaceAt(LPDIRECT3DRMVIEWPORT  IRMVport,
                           LPDIRECT3DRMFRAME     IFrame,
                           LPDIRECT3DRMFACEARRAY IFaces,
                           int X, int Y)
{
  if ((!IRMVport) || (!IFrame) || (!IFaces)) return NULL;
  DWORD size = IFaces->GetSize();
  if (!size) return NULL;

  D3DVALUE w, z;
  D3DVALUE last_z = FLT_MAX;
  D3DVECTOR frame_pos;
  D3DVECTOR scene_pos;
  D3DRMVECTOR4D plane_pos;
  D3DVECTOR plane[3];
  LPDIRECT3DRMFACE result = NULL;
  for (DWORD i = 0; i < size; i++) {
    LPDIRECT3DRMFACE Iface = NULL;
    IFaces->GetElement(i, &Iface);
    if (!Iface) continue;
    DWORD vcount = Iface->GetVertexCount();
    if (vcount < 3) { Iface->Release(); continue; }
    LPPOINT pts = new POINT[vcount];
    memset(pts, 0, sizeof(POINT)*vcount);
    memset(&plane, 0, sizeof(plane));
    for (DWORD v = 0; v < vcount; v++) {
       HRESULT hr;
       hr = Iface->GetVertex(v, &frame_pos, NULL);
       assert(HR_SUCCEEDED(hr));
       hr = IFrame->Transform(&scene_pos, &frame_pos);
       assert(HR_SUCCEEDED(hr));
       hr = IRMVport->Transform(&plane_pos, &scene_pos);
       assert(HR_SUCCEEDED(hr));
       w = plane_pos.w;
       if (w != 0) {
          pts[v].x = int(plane_pos.x / w);
          pts[v].y = int(plane_pos.y / w);
          if (v < 3) {
             plane[v].x = plane_pos.x / w;
             plane[v].y = plane_pos.y / w;
             plane[v].z = plane_pos.z / w;
          } // if (v < 3)
       } // if (w != 0)
    } // for v
    HRGN hrgn = CreatePolygonRgn(pts, vcount, WINDING);
    if (PtInRegion(hrgn, X, Y)) {
       //   :
       D3DVALUE A, B, C, D, E, F;
       A  = (Y - plane[0].y);
       A *= (plane[2].z - plane[0].z);
       A *= (plane[1].x - plane[0].x);
       B  = (X - plane[0].x);
       B *= (plane[2].y - plane[0].y);
       B *= (plane[1].z - plane[0].z);
       C  = (X - plane[0].x);
       C *= (plane[1].y - plane[0].y);
       C *= (plane[2].z - plane[0].z);
       D  = (Y - plane[0].y);
       D *= (plane[1].z - plane[0].z);
       D *= (plane[2].x - plane[0].x);
       E  = (plane[1].x - plane[0].x);
       E *= (plane[2].y - plane[0].y);
       F  = (plane[1].y - plane[0].y);
       F *= (plane[2].x - plane[0].x);
       z = (A + B - C - D) / (E - F) + plane[0].z;

       //  ,    :
       // z = (plane[0].z+plane[1].z+plane[2].z) / 3;

       if (z < last_z) {
          last_z = z;
          if (result) result->Release();
          result = Iface;
          result->AddRef();
       }
    } // if (PtInRegion(hrgn, X, Y))
    DeleteObject(hrgn);
    delete[] pts;
    Iface->Release();
  } // for i
  return result;
}//---------------------------------------------------------