// KEHOME/java/mkrGetData.java
// Aug/27/2003
// usage: java -DKBDATA=kbdata mkrGetData subject predicate object

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Client;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.XML;

/**
*	Get value for subject, predicate
*/
public class mkrGetData
{
    public static void main(String argv[])
    {
	String info      = "# INFO: mkrGetData: ";
	String error     = "# ERROR: mkrGetData: ";
	String debug     = "no";
	String Subflag   = "includeSubClasses=yes";
	String Superflag = "includeSuperClasses=yes";
	String flags     = "";

	String kbdata    = System.getProperty("KBDATA");
	String subject   = argv[0];
	String predicate = argv[1];
	String object    = argv[2];

	if (debug == "yes") {
	  System.out.println(info + "kbdata = "    + kbdata);
	  System.out.println(info + "subject = "   + subject);
	  System.out.println(info + "predicate = " + predicate);
	  System.out.println(info + "object = "    + object);
	}
	if (subject.equals("?")) {
		if (debug == "yes") System.out.println("# qtype = qsubject");
		flags = "inverse=yes";
		subject = object;
	} else if (predicate.equals("?")) {
		if (debug == "yes") System.out.println("# qtype = qverb");
		predicate = "arcs";
		flags = "inverse=no";
	} else if (object.equals("?")) {
		if (debug == "yes") System.out.println("# qtype = qobject");
		flags = "inverse=no";
	} else {
		if (debug == "yes") System.out.println("# qtype = unknown");
		System.out.println(error +
			"subject <"   + subject   + "> " +
			"predicate <" + predicate + "> " +
			"object <"    + object    + "> ");

		System.out.println("# usage: GetData subject predicate ?");
		System.out.println("# usage: GetData subject ? ?");
		System.out.println("# usage: GetData ? predicate object");
		return;
	}
	if (debug == "yes") {
	  System.out.println(info + "flags = "     + flags);
	}

	Client tap = new Client(kbdata);
	Resource answer = get_data(tap,subject,predicate,flags);
	if (answer.count() == 0) {
		System.out.println("  " + info + "count = " + answer.count());
	} else if (predicate.equals("arcs")) {
		if (flags.equals("inverse=no")) {
			get_property_values(tap,subject,answer);
		} else {
			print_column(answer);
		}
	} else {
		print_column(answer);
	}
	return;
    } // end main()

/**
*	print one answer per line
*/
    public static void print_column(Resource answer)
    {
	for(int x = 0; x < answer.count(); ++x) {
	    System.out.println("  " + answer.item(x).value);
	}
	return;
    }
/**
*	print one line with comma separators
*/
    public static void print_line(Resource answer)
    {
	int n = answer.count();
	for(int x = 0; x < n-1; ++x) {
	System.out.print(answer.item(x).value + ", ");
	}
	System.out.println(answer.item(n-1).value);
	return;
    }

/**
*	get all property values of subject
*/
    public static void get_property_values(
	Client tap,
	String subject,
	Resource proplist
    )
    {
	String info  = "  # INFO: get_property_values: ";
	String debug = "no";
	String flags = "inverse=no";

	for(int x = 0; x < proplist.count(); ++x) {
	    String property = proplist.item(x).value;
	    if (debug == "yes") {
		System.out.println(info + "property = " + property);
	    }
	    if (property.equals("arcs")) continue;

	    Resource answer = get_data(tap,subject,property,flags);
	    System.out.print("  " + property + " = ");
	    print_line(answer);
	}
	return;
    } // end get_property_values()


/**
*	MKE interface to TAP GetData()
*/
    public static Resource get_data(
	Client tap,
	String subject,
	String predicate,
	String flags
    )
    {
	String tapuri = "http://tap.stanford.edu/data/";
	String info   = "  # INFO: get_data: ";
	String debug  = "no";

	if (debug == "yes") {
	  System.out.println(info + "subject = "   + subject);
	  System.out.println(info + "predicate = " + predicate);
	  System.out.println(info + "flags = "     + flags);
	}

	String uriSubject = Qname.GetNameURI(subject);
	String uriPredicate = Qname.GetNameURI(predicate);

	if (debug == "yes") {
	  System.out.println(info + "tapuri = "       + tapuri);
	  System.out.println(info + "uriSubject = "   + uriSubject);
	  System.out.println(info + "uriPredicate = " + uriPredicate);
	}
	Resource answer = tap.GetData(uriSubject,uriPredicate,flags);
	for(int x = 0; x < answer.count(); ++x) {
	        String tapAnswer = answer.item(x).value;
	        String mkrAnswer = XML.SplitNamespace(tapAnswer).tag;
		answer.item(x).value = mkrAnswer;
	}
	return answer;
    } // end get_data()

} // end class
