//<HTML><XMP>
// KEHOME/test/mkrPutData.java
// Aug/18/2003

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Client;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.XML;
import edu.stanford.TAP.KB;

import edu.stanford.TAP.KB_MemHash;
import edu.stanford.TAP.Import_Guess;
import edu.stanford.TAP.Export_RDF;
import edu.stanford.TAP.Export_MCF;
import java.io.*;

public class mkrPutData
{

    // put the path to the kb you want to modify here. or pass it in.
    public static final String kbFile = "C:/home/ke/data/tap.rdf";

    public static void main(String argv[])
    {
	String tapuri    = "http://tap.stanford.edu/data/";
	String subject   = argv[0];
	String predicate = argv[1];
	String object    = argv[2];
	String flags     = "";
	String debug     = "yes";

	if (!Abbrev.IsStandardTag(subject)) {
	    subject = tapuri + subject;
	}
	if (!Abbrev.IsStandardTag(predicate)) {
	    predicate = tapuri + predicate;
	}
	if (   (predicate.equals("type"))
	    || (predicate.equals("subClassOf"))
	    || (predicate.equals("locatedIn"))
	) {
		if (!Abbrev.IsStandardTag(object)) {
		    object = tapuri + object;
		}
	}
	if (debug == "yes") {
	  System.out.println("# INFO: PutData: tapuri = "    + tapuri);
	  System.out.println("# INFO: PutData: kbFile = "    + kbFile);
	  System.out.println("# INFO: PutData: subject = "   + subject);
	  System.out.println("# INFO: PutData: predicate = " + predicate);
	  System.out.println("# INFO: PutData: object = "    + object);
	}

	KB kb = new KB_MemHash();
	Import_Guess.LoadFile(kb, kbFile);
	kb.Assert(subject,predicate,object);
	FileOutputStream out = null;
	try {
            out = new FileOutputStream(kbFile);
	}
	catch(FileNotFoundException e) {
            System.out.println("Couldn't open output file " + kbFile);
            return;
	}
	if(kbFile.endsWith(".rdf")) {
            Export_RDF.DoSerialize(out, kb);
	}
	else if(kbFile.endsWith(".mcf")) {
            Export_MCF.DoSerialize(out, kb);
	}

    }
}

//</XMP></HTML>
