// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'RVStyle.pas' rev: 5.00

#ifndef RVStyleHPP
#define RVStyleHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <RVScroll.hpp>	// Pascal unit
#include <RVMapWht.hpp>	// Pascal unit
#include <RVClasses.hpp>	// Pascal unit
#include <ImgList.hpp>	// Pascal unit
#include <Registry.hpp>	// Pascal unit
#include <IniFiles.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Rvstyle
{
//-- type declarations -------------------------------------------------------
struct TRVScreenAndDevice
{
	int ppixScreen;
	int ppiyScreen;
	int ppixDevice;
	int ppiyDevice;
	int LeftMargin;
	int RightMargin;
} ;

typedef TRVScreenAndDevice *PRVScreenAndDevice;

#pragma option push -b-
enum TRVSaveFormat { rvsfText, rvsfHTML, rvsfRTF, rvsfRVF };
#pragma option pop

#pragma option push -b-
enum TRVLoadFormat { rvlfText, rvlfHTML, rvlfRTF, rvlfRVF, rvlfURL, rvlfOther };
#pragma option pop

#pragma option push -b-
enum TRVRTFSaveArea { rv_rtfs_TextStyle, rv_rtfs_ParaStyle, rv_rtfs_CellProps, rv_rtfs_RowProps, rv_rtfs_Doc 
	};
#pragma option pop

#pragma option push -b-
enum TRVHTMLSaveArea { rv_thms_Head, rv_thms_BodyAttribute, rv_thms_Body, rv_thms_End };
#pragma option pop

#pragma option push -b-
enum TRVReaderUnicode { rvruMixed, rvruNoUnicode, rvruOnlyUnicode };
#pragma option pop

#pragma option push -b-
enum TRVReaderStyleMode { rvrsUseSpecified, rvrsUseClosest, rvrsAddIfNeeded };
#pragma option pop

#pragma option push -b-
enum TRVFReaderStyleMode { rvf_sIgnore, rvf_sInsertMap, rvf_sInsertMerge };
#pragma option pop

#pragma option push -b-
enum TRVColorMode { rvcmColor, rvcmPrinterColor, rvcmGrayScale, rvcmBlackAndWhite, rvcmBlackOnWhite 
	};
#pragma option pop

typedef unsigned TRVCodePage;

#pragma option push -b-
enum TRVItemBackgroundStyle { rvbsColor, rvbsStretched, rvbsTiled, rvbsCentered };
#pragma option pop

typedef void *TCheckpointData;

#pragma option push -b-
enum TRVTextDrawState { rvtsSelected, rvtsHover, rvtsItemStart, rvtsItemEnd, rvtsDrawItemStart, rvtsDrawItemEnd, 
	rvtsControlFocused };
#pragma option pop

typedef Set<TRVTextDrawState, rvtsSelected, rvtsControlFocused>  TRVTextDrawStates;

#pragma option push -b-
enum TRVPageBreakType { rvpbSoftPageBreak, rvpbPageBreak };
#pragma option pop

#pragma option push -b-
enum TRVBreakStyle { rvbsLine, rvbsRectangle, rvbs3d };
#pragma option pop

#pragma option push -b-
enum TRVVAlign { rvvaBaseline, rvvaMiddle };
#pragma option pop

#pragma option push -b-
enum TRVBorderStyle { rvbNone, rvbSingle, rvbDouble, rvbTriple, rvbThickInside, rvbThickOutside };
#pragma option pop

#pragma option push -b-
enum TRVListType { rvlstBullet, rvlstPicture, rvlstImageList, rvlstDecimal, rvlstLowerAlpha, rvlstUpperAlpha, 
	rvlstLowerRoman, rvlstUpperRoman, rvlstImageListCounter, rvlstUnicodeBullet };
#pragma option pop

#pragma option push -b-
enum TRVMarkerAlignment { rvmaLeft, rvmaRight, rvmaCenter };
#pragma option pop

#pragma option push -b-
enum TRVListLevelOption { rvloContinuous, rvloLevelReset, rvloLegalStyleNumbering };
#pragma option pop

typedef Set<TRVListLevelOption, rvloContinuous, rvloLegalStyleNumbering>  TRVListLevelOptions;

typedef AnsiString TRVMarkerFormatString;

typedef WideString TRVMarkerFormatStringW;

#pragma option push -b-
enum TRVFOption { rvfoSavePicturesBody, rvfoSaveControlsBody, rvfoIgnoreUnknownPicFmt, rvfoIgnoreUnknownCtrls, 
	rvfoConvUnknownStylesToZero, rvfoConvLargeImageIdxToZero, rvfoSaveBinary, rvfoUseStyleNames, rvfoSaveBack, 
	rvfoLoadBack, rvfoSaveTextStyles, rvfoSaveParaStyles, rvfoSaveLayout, rvfoLoadLayout, rvfoSaveDocProperties, 
	rvfoLoadDocProperties };
#pragma option pop

typedef Set<TRVFOption, rvfoSavePicturesBody, rvfoLoadDocProperties>  TRVFOptions;

#pragma option push -b-
enum TRVFWarning { rvfwUnknownPicFmt, rvfwUnknownCtrls, rvfwConvUnknownStyles, rvfwConvLargeImageIdx, 
	rvfwConvToUnicode, rvfwConvFromUnicode, rvfwInvalidPicture };
#pragma option pop

typedef Set<TRVFWarning, rvfwUnknownPicFmt, rvfwInvalidPicture>  TRVFWarnings;

#pragma option push -b-
enum TRVControlAction { rvcaAfterRVFLoad, rvcaDestroy, rvcaMoveToUndoList, rvcaMoveFromUndoList, rvcaDestroyInUndoList, 
	rvcaBeforeRVFSave, rvcaAfterRVFSave };
#pragma option pop

#pragma option push -b-
enum TRVItemAction { rviaInserting, rviaInserted, rviaTextModifying, rviaDestroying, rviaMovingToUndoList 
	};
#pragma option pop

#pragma option push -b-
enum TRVProtectOption { rvprStyleProtect, rvprModifyProtect, rvprDeleteProtect, rvprConcateProtect, 
	rvprRVFInsertProtect, rvprDoNotAutoSwitch, rvprParaStartProtect, rvprSticking, rvprStickToTop, rvprStickToBottom 
	};
#pragma option pop

typedef Set<TRVProtectOption, rvprStyleProtect, rvprStickToBottom>  TRVProtectOptions;

#pragma option push -b-
enum TRVParaOption { rvpaoNoWrap, rvpaoReadOnly, rvpaoStyleProtect, rvpaoDoNotWantReturns };
#pragma option pop

typedef Set<TRVParaOption, rvpaoNoWrap, rvpaoDoNotWantReturns>  TRVParaOptions;

#pragma option push -b-
enum TRVTextOption { rvteoHTMLCode, rvteoRTFCode };
#pragma option pop

typedef Set<TRVTextOption, rvteoHTMLCode, rvteoRTFCode>  TRVTextOptions;

#pragma option push -b-
enum TRVSaveOption { rvsoOverrideImages, rvsoFirstOnly, rvsoMiddleOnly, rvsoLastOnly, rvsoDefault0Style, 
	rvsoNoHypertextImageBorders, rvsoImageSizes, rvsoForceNonTextCSS, rvsoUseCheckpointsNames, rvsoMarkersAsText, 
	rvsoInlineCSS, rvsoNoDefCSSStyle };
#pragma option pop

typedef Set<TRVSaveOption, rvsoOverrideImages, rvsoNoDefCSSStyle>  TRVSaveOptions;

#pragma option push -b-
enum TRVRTFOption { rvrtfSaveStyleSheet, rvrtfDuplicateUnicode, rvrtfSaveEMFAsWMF, rvrtfSaveJpegAsJpeg, 
	rvrtfSaveBitmapDefault, rvrtfSaveEMFDefault };
#pragma option pop

typedef Set<TRVRTFOption, rvrtfSaveStyleSheet, rvrtfSaveEMFDefault>  TRVRTFOptions;

#pragma option push -b-
enum TRVFontStyle { rvfsOverline, rvfsAllCaps };
#pragma option pop

typedef Set<TRVFontStyle, rvfsOverline, rvfsAllCaps>  TRVFontStyles;

#pragma option push -b-
enum TRVAlignment { rvaLeft, rvaRight, rvaCenter, rvaJustify };
#pragma option pop

typedef TCustomIniFile TRVIniFile;
;

#pragma option push -b-
enum TRVSaveCSSOption { rvcssOnlyDifference, rvcssIgnoreLeftAlignment, rvcssNoDefCSSStyle };
#pragma option pop

typedef Set<TRVSaveCSSOption, rvcssOnlyDifference, rvcssNoDefCSSStyle>  TRVSaveCSSOptions;

#pragma option push -b-
enum TRVFontInfoProperty { rvfiFontName, rvfiSize, rvfiCharset, rvfiUnicode, rvfiBold, rvfiItalic, rvfiUnderline, 
	rvfiStrikeout, rvfiOverline, rvfiAllCaps, rvfiVShift, rvfiColor, rvfiBackColor, rvfiJump, rvfiHoverBackColor, 
	rvfiHoverColor, rvfiJumpCursor, rvfiNextStyleNo, rvfiProtection, rvfiCharScale, rvfiBaseStyleNo, rvfiBiDiMode, 
	rvfiCharSpacing, rvfiHTMLCode, rvfiRTFCode };
#pragma option pop

#pragma option push -b-
enum TRVParaInfoProperty { rvpiFirstIndent, rvpiLeftIndent, rvpiRightIndent, rvpiSpaceBefore, rvpiSpaceAfter, 
	rvpiAlignment, rvpiNextParaNo, rvpiDefStyleNo, rvpiLineSpacing, rvpiLineSpacingType, rvpiBackground_Color, 
	rvpiBackground_BO_Left, rvpiBackground_BO_Top, rvpiBackground_BO_Right, rvpiBackground_BO_Bottom, rvpiBorder_Color, 
	rvpiBorder_Style, rvpiBorder_Width, rvpiBorder_InternalWidth, rvpiBorder_BO_Left, rvpiBorder_BO_Top, 
	rvpiBorder_BO_Right, rvpiBorder_BO_Bottom, rvpiBorder_Vis_Left, rvpiBorder_Vis_Top, rvpiBorder_Vis_Right, 
	rvpiBorder_Vis_Bottom, rvpiNoWrap, rvpiReadOnly, rvpiStyleProtect, rvpiDoNotWantReturns, rvpiBiDiMode 
	};
#pragma option pop

typedef Set<TRVFontInfoProperty, rvfiFontName, rvfiRTFCode>  TRVFontInfoProperties;

typedef Set<TRVParaInfoProperty, rvpiFirstIndent, rvpiBiDiMode>  TRVParaInfoProperties;

#pragma option push -b-
enum TRVLineSpacingType { rvlsPercent, rvlsSpaceBetween };
#pragma option pop

#pragma option push -b-
enum TRVStyleMergeMode { rvs_merge_SmartMerge, rvs_merge_Map, rvs_merge_Append };
#pragma option pop

#pragma option push -b-
enum TRVSelectionMode { rvsmChar, rvsmWord, rvsmParagraph };
#pragma option pop

#pragma option push -b-
enum TRVSelectionStyle { rvssItems, rvssLines };
#pragma option pop

class DELPHICLASS TRVStyle;
typedef void __fastcall (__closure *TRVDrawTextBackEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int StyleNo, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState, bool &DoDefault
	);

typedef void __fastcall (__closure *TRVApplyStyleEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas, 
	int StyleNo, bool &DoDefault);

typedef void __fastcall (__closure *TRVApplyStyleColorEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int StyleNo, TRVTextDrawStates DrawState, bool &DoDefault);

typedef void __fastcall (__closure *TRVDrawStyleTextEvent)(TRVStyle* Sender, const AnsiString s, Graphics::TCanvas* 
	Canvas, int StyleNo, int SpaceBefore, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState
	, bool &DoDefault);

typedef void __fastcall (__closure *TRVStyleHoverSensitiveEvent)(TRVStyle* Sender, int StyleNo, bool 
	&Sensitive);

typedef void __fastcall (__closure *TRVDrawCheckpointEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int X, int Y, int ItemNo, int XShift, bool RaiseEvent, Controls::TControl* Control, bool &DoDefault
	);

typedef void __fastcall (__closure *TRVDrawPageBreakEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int Y, int XShift, TRVPageBreakType PageBreakType, Controls::TControl* Control, bool &DoDefault);
	

typedef void __fastcall (__closure *TRVDrawParaRectEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int ParaNo, const Windows::TRect &ARect, bool &DoDefault);

class DELPHICLASS TCustomRVInfo;
class PASCALIMPLEMENTATION TCustomRVInfo : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	int FBaseStyleNo;
	AnsiString FName;
	bool FStandard;
	
protected:
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID) = 0 
		;
	DYNAMIC bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping) = 0 
		;
	DYNAMIC int __fastcall SimilarityValue(TCustomRVInfo* Value) = 0 ;
	
public:
	__fastcall virtual TCustomRVInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual AnsiString __fastcall GetDisplayName(void);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs, const AnsiString DefName);
	
__published:
	__property int BaseStyleNo = {read=FBaseStyleNo, write=FBaseStyleNo, default=-1};
	__property AnsiString StyleName = {read=FName, write=FName};
	__property bool Standard = {read=FStandard, write=FStandard, default=1};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TCustomRVInfo(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFontInfo;
class PASCALIMPLEMENTATION TFontInfo : public TCustomRVInfo 
{
	typedef TCustomRVInfo inherited;
	
private:
	Rvscroll::TRVBiDiMode FBiDiMode;
	bool FJump;
	Controls::TCursor FJumpCursor;
	AnsiString FFontName;
	int FSize;
	Graphics::TColor FColor;
	Graphics::TColor FBackColor;
	Graphics::TColor FHoverColor;
	Graphics::TColor FHoverBackColor;
	Graphics::TFontStyles FStyle;
	TRVFontStyles FStyleEx;
	int FVShift;
	int FNextStyleNo;
	Graphics::TFontCharset FCharset;
	bool FUnicode;
	TRVProtectOptions FProtection;
	TRVTextOptions FOptions;
	int FCharScale;
	int FCharSpacing;
	void __fastcall SingleSymbolsReader(Classes::TReader* reader);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID);
	DYNAMIC bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping);
	DYNAMIC int __fastcall SimilarityValue(TCustomRVInfo* Value);
	
public:
	__fastcall virtual TFontInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall AssignToLogFont(tagLOGFONTA &LogFont, Graphics::TCanvas* Canvas);
	void __fastcall Apply(Graphics::TCanvas* Canvas, Rvscroll::TRVBiDiMode DefBiDiMode);
	void __fastcall ApplyColor(Graphics::TCanvas* Canvas, TRVStyle* RVStyle, TRVTextDrawStates DrawState
		, bool Printing, TRVColorMode ColorMode);
	void __fastcall Draw(const AnsiString s, Graphics::TCanvas* Canvas, int ThisStyleNo, int SpaceBefore
		, int Left, int Top, int Width, int Height, TRVStyle* RVStyle, TRVTextDrawStates DrawState, bool Printing
		, bool PreviewCorrection, TRVColorMode ColorMode, Rvscroll::TRVBiDiMode DefBiDiMode);
	void __fastcall DrawVertical(const AnsiString s, Graphics::TCanvas* Canvas, int ThisStyleNo, int SpaceBefore
		, int Left, int Top, int Width, int Height, TRVStyle* RVStyle, TRVTextDrawStates DrawState);
	bool __fastcall IsEqual(TFontInfo* Value, TRVFontInfoProperties IgnoreList);
	HIDESBASE void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const 
		AnsiString fs);
	HIDESBASE void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const 
		AnsiString fs, bool JumpByDefault, Controls::TCursor DefJumpCursor);
	void __fastcall SaveCSSToStream(Classes::TStream* Stream, TFontInfo* BaseStyle, bool Multiline);
	
__published:
	__property Graphics::TFontCharset Charset = {read=FCharset, write=FCharset, default=1};
	__property AnsiString FontName = {read=FFontName, write=FFontName};
	__property int Size = {read=FSize, write=FSize, default=10};
	__property Graphics::TFontStyles Style = {read=FStyle, write=FStyle, default=0};
	__property int VShift = {read=FVShift, write=FVShift, default=0};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483640};
	__property Graphics::TColor BackColor = {read=FBackColor, write=FBackColor, default=536870911};
	__property Graphics::TColor HoverBackColor = {read=FHoverBackColor, write=FHoverBackColor, default=536870911
		};
	__property Graphics::TColor HoverColor = {read=FHoverColor, write=FHoverColor, default=536870911};
	__property TRVFontStyles StyleEx = {read=FStyleEx, write=FStyleEx, default=0};
	__property bool Jump = {read=FJump, write=FJump, default=0};
	__property Controls::TCursor JumpCursor = {read=FJumpCursor, write=FJumpCursor, default=101};
	__property int CharScale = {read=FCharScale, write=FCharScale, default=100};
	__property int CharSpacing = {read=FCharSpacing, write=FCharSpacing, default=0};
	__property int NextStyleNo = {read=FNextStyleNo, write=FNextStyleNo, default=-1};
	__property Rvscroll::TRVBiDiMode BiDiMode = {read=FBiDiMode, write=FBiDiMode, default=0};
	__property bool Unicode = {read=FUnicode, write=FUnicode, default=0};
	__property TRVProtectOptions Protection = {read=FProtection, write=FProtection, default=0};
	__property TRVTextOptions Options = {read=FOptions, write=FOptions, default=0};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TFontInfo(void) { }
	#pragma option pop
	
};


class DELPHICLASS TCustomRVInfos;
class PASCALIMPLEMENTATION TCustomRVInfos : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	Classes::TPersistent* FOwner;
	
public:
	__fastcall TCustomRVInfos(TMetaClass* ItemClass, Classes::TPersistent* Owner);
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall MergeWith(TCustomRVInfos* Styles, TRVStyleMergeMode Mode, Rvclasses::TRVIntegerList* 
		Mapping, Rvclasses::TRVIntegerList* TextStyleMapping);
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TCustomRVInfos(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFontInfos;
class PASCALIMPLEMENTATION TFontInfos : public TCustomRVInfos 
{
	typedef TCustomRVInfos inherited;
	
private:
	TFontInfo* FInvalidItem;
	HIDESBASE TFontInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TFontInfo* Value);
	TFontInfo* __fastcall GetInvalidItem(void);
	void __fastcall SetInvalidItem(const TFontInfo* Value);
	
public:
	int PixelsPerInch;
	__fastcall virtual ~TFontInfos(void);
	int __fastcall FindStyleWithCharset(int BaseStyle, Graphics::TFontCharset Charset);
	int __fastcall FindStyleWithFontStyle(int BaseStyle, Graphics::TFontStyles Value, Graphics::TFontStyles 
		Mask);
	int __fastcall FindStyleWithFontSize(int BaseStyle, int Size);
	int __fastcall FindStyleWithColor(int BaseStyle, Graphics::TColor Color, Graphics::TColor BackColor
		);
	int __fastcall FindStyleWithFontName(int BaseStyle, const AnsiString FontName);
	int __fastcall FindSuchStyle(int BaseStyle, TFontInfo* Style, TRVFontInfoProperties Mask);
	int __fastcall FindStyleWithFont(int BaseStyle, Graphics::TFont* Font);
	HIDESBASE TFontInfo* __fastcall Add(void);
	TFontInfo* __fastcall AddFont(AnsiString Name, int Size, Graphics::TColor Color, Graphics::TColor BackColor
		, Graphics::TFontStyles Style);
	TFontInfo* __fastcall AddFontEx(AnsiString Name, int Size, Graphics::TColor Color, Graphics::TColor 
		BackColor, Graphics::TFontStyles Style, Graphics::TFontCharset Charset);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, Controls::TCursor 
		DefJumpCursor);
	__property TFontInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
	__property TFontInfo* InvalidItem = {read=GetInvalidItem, write=SetInvalidItem};
public:
	#pragma option push -w-inl
	/* TCustomRVInfos.Create */ inline __fastcall TFontInfos(TMetaClass* ItemClass, Classes::TPersistent* 
		Owner) : TCustomRVInfos(ItemClass, Owner) { }
	#pragma option pop
	
};


class DELPHICLASS TRVRect;
class PASCALIMPLEMENTATION TRVRect : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	int FTop;
	int FLeft;
	int FRight;
	int FBottom;
	bool __fastcall IsEqualEx(TRVRect* Value, bool IgnL, bool IgnT, bool IgnR, bool IgnB);
	int __fastcall SimilarityValue(TRVRect* Value, int Weight);
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall SetAll(int Value);
	void __fastcall InflateRect(Windows::TRect &Rect);
	void __fastcall InflateRectSaD(Windows::TRect &Rect, const TRVScreenAndDevice &sad);
	void __fastcall AssignToRect(Windows::TRect &Rect);
	void __fastcall AssignToRectIfGreater(Windows::TRect &Rect);
	bool __fastcall IsEqual(TRVRect* Value);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	
__published:
	__property int Left = {read=FLeft, write=FLeft, default=0};
	__property int Right = {read=FRight, write=FRight, default=0};
	__property int Top = {read=FTop, write=FTop, default=0};
	__property int Bottom = {read=FBottom, write=FBottom, default=0};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TRVRect(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVRect(void) : Classes::TPersistent() { }
	#pragma option pop
	
};


class DELPHICLASS TRVBooleanRect;
class PASCALIMPLEMENTATION TRVBooleanRect : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FTop;
	bool FLeft;
	bool FRight;
	bool FBottom;
	bool __fastcall IsEqualEx(TRVBooleanRect* Value, bool IgnL, bool IgnT, bool IgnR, bool IgnB);
	
public:
	__fastcall TRVBooleanRect(bool DefValue);
	void __fastcall SetAll(bool Value);
	void __fastcall SetValues(bool ALeft, bool ATop, bool ARight, bool ABottom);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	bool __fastcall IsEqual(TRVBooleanRect* Value);
	bool __fastcall IsEqual2(bool ALeft, bool ATop, bool ARight, bool ABottom);
	bool __fastcall IsAllEqual(bool Value);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	
__published:
	__property bool Left = {read=FLeft, write=FLeft, default=1};
	__property bool Right = {read=FRight, write=FRight, default=1};
	__property bool Top = {read=FTop, write=FTop, default=1};
	__property bool Bottom = {read=FBottom, write=FBottom, default=1};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TRVBooleanRect(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVBorder;
class PASCALIMPLEMENTATION TRVBorder : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	Graphics::TColor FColor;
	TRVBorderStyle FStyle;
	int FWidth;
	int FInternalWidth;
	TRVBooleanRect* FVisibleBorders;
	TRVRect* FBorderOffsets;
	void __fastcall SetBorderOffsets(const TRVRect* Value);
	void __fastcall SetVisibleBorders(const TRVBooleanRect* Value);
	int __fastcall SimilarityValue(TRVBorder* Value);
	
protected:
	void __fastcall DoDraw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas, int Width, int InternalWidth
		, int OnePixelWidth, TRVColorMode ColorMode);
	
public:
	__fastcall TRVBorder(void);
	__fastcall virtual ~TRVBorder(void);
	void __fastcall Draw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas);
	void __fastcall DrawSaD(const Windows::TRect &Rect, Graphics::TCanvas* Canvas, const TRVScreenAndDevice 
		&sad, TRVColorMode ColorMode);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	bool __fastcall IsEqual(TRVBorder* Value);
	bool __fastcall IsEqual_Para(TRVBorder* Value, TRVParaInfoProperties IgnoreList);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	int __fastcall GetTotalWidth(void);
	
__published:
	__property int Width = {read=FWidth, write=FWidth, default=1};
	__property int InternalWidth = {read=FInternalWidth, write=FInternalWidth, default=1};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483640};
	__property TRVBorderStyle Style = {read=FStyle, write=FStyle, default=0};
	__property TRVBooleanRect* VisibleBorders = {read=FVisibleBorders, write=SetVisibleBorders};
	__property TRVRect* BorderOffsets = {read=FBorderOffsets, write=SetBorderOffsets};
};


class DELPHICLASS TRVBackgroundRect;
class PASCALIMPLEMENTATION TRVBackgroundRect : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TRVRect* FBorderOffsets;
	Graphics::TColor FColor;
	void __fastcall SetBorderOffsets(const TRVRect* Value);
	int __fastcall SimilarityValue(TRVBackgroundRect* Value);
	
public:
	__fastcall TRVBackgroundRect(void);
	__fastcall virtual ~TRVBackgroundRect(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall PrepareDraw(Windows::TRect &Rect);
	void __fastcall PrepareDrawSaD(Windows::TRect &Rect, const TRVScreenAndDevice &sad);
	void __fastcall Draw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas, bool Printing, TRVColorMode 
		ColorMode);
	bool __fastcall IsEqual(TRVBackgroundRect* Value);
	bool __fastcall IsEqual_Para(TRVBackgroundRect* Value, TRVParaInfoProperties IgnoreList);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	
__published:
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=536870911};
	__property TRVRect* BorderOffsets = {read=FBorderOffsets, write=SetBorderOffsets};
};


class DELPHICLASS TParaInfo;
class PASCALIMPLEMENTATION TParaInfo : public TCustomRVInfo 
{
	typedef TCustomRVInfo inherited;
	
private:
	int FFirstIndent;
	int FLeftIndent;
	int FRightIndent;
	int FSpaceBefore;
	int FSpaceAfter;
	int FLineSpacing;
	TRVLineSpacingType FLineSpacingType;
	TRVAlignment FAlignment;
	TRVBorder* FBorder;
	int FNextParaNo;
	TRVBackgroundRect* FBackground;
	TRVParaOptions FOptions;
	Rvscroll::TRVBiDiMode FBiDiMode;
	int FDefStyleNo;
	void __fastcall SetBorder(const TRVBorder* Value);
	void __fastcall SetBackground(const TRVBackgroundRect* Value);
	bool __fastcall ExtraLineSpacing(void);
	
protected:
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID);
	DYNAMIC bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping);
	DYNAMIC int __fastcall SimilarityValue(TCustomRVInfo* Value);
	
public:
	__fastcall virtual TParaInfo(Classes::TCollection* Collection);
	__fastcall virtual ~TParaInfo(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	HIDESBASE void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const 
		AnsiString fs);
	HIDESBASE void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const 
		AnsiString fs);
	bool __fastcall IsEqual(TParaInfo* Value, TRVParaInfoProperties IgnoreList);
	void __fastcall SaveCSSToStream(Classes::TStream* Stream, TParaInfo* BaseStyle, bool Multiline, bool 
		IgnoreLeftAlignment, bool IgnoreLeftIndents);
	
__published:
	__property int FirstIndent = {read=FFirstIndent, write=FFirstIndent, default=0};
	__property int LeftIndent = {read=FLeftIndent, write=FLeftIndent, default=0};
	__property int RightIndent = {read=FRightIndent, write=FRightIndent, default=0};
	__property int SpaceBefore = {read=FSpaceBefore, write=FSpaceBefore, default=0};
	__property int SpaceAfter = {read=FSpaceAfter, write=FSpaceAfter, default=0};
	__property TRVAlignment Alignment = {read=FAlignment, write=FAlignment, default=0};
	__property TRVBorder* Border = {read=FBorder, write=SetBorder};
	__property TRVBackgroundRect* Background = {read=FBackground, write=SetBackground};
	__property int NextParaNo = {read=FNextParaNo, write=FNextParaNo, default=-1};
	__property int DefStyleNo = {read=FDefStyleNo, write=FDefStyleNo, default=-1};
	__property int LineSpacing = {read=FLineSpacing, write=FLineSpacing, default=100};
	__property TRVLineSpacingType LineSpacingType = {read=FLineSpacingType, write=FLineSpacingType, default=0
		};
	__property TRVParaOptions Options = {read=FOptions, write=FOptions, nodefault};
	__property Rvscroll::TRVBiDiMode BiDiMode = {read=FBiDiMode, write=FBiDiMode, default=0};
};


class DELPHICLASS TParaInfos;
class PASCALIMPLEMENTATION TParaInfos : public TCustomRVInfos 
{
	typedef TCustomRVInfos inherited;
	
private:
	TParaInfo* FInvalidItem;
	HIDESBASE TParaInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TParaInfo* Value);
	TParaInfo* __fastcall GetInvalidItem(void);
	void __fastcall SetInvalidItem(const TParaInfo* Value);
	
public:
	HIDESBASE TParaInfo* __fastcall Add(void);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	int __fastcall FindSuchStyle(int BaseStyle, TParaInfo* Style, TRVParaInfoProperties Mask);
	int __fastcall FindStyleWithAlignment(int BaseStyle, TRVAlignment Alignment);
	__property TParaInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
	__property TParaInfo* InvalidItem = {read=GetInvalidItem, write=SetInvalidItem};
public:
	#pragma option push -w-inl
	/* TCustomRVInfos.Create */ inline __fastcall TParaInfos(TMetaClass* ItemClass, Classes::TPersistent* 
		Owner) : TCustomRVInfos(ItemClass, Owner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TParaInfos(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVMarkerFont;
class PASCALIMPLEMENTATION TRVMarkerFont : public Graphics::TFont 
{
	typedef Graphics::TFont inherited;
	
private:
	bool __fastcall StoreName(void);
	bool __fastcall StoreHeight(void);
	
public:
	__fastcall TRVMarkerFont(void);
	bool __fastcall IsEqual(Graphics::TFont* Font);
	bool __fastcall IsDefault(void);
	
__published:
	__property Charset ;
	__property Color ;
	__property Name  = {stored=StoreName};
	__property Style ;
	__property Height  = {stored=StoreHeight};
public:
	#pragma option push -w-inl
	/* TFont.Destroy */ inline __fastcall virtual ~TRVMarkerFont(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVListLevel;
class PASCALIMPLEMENTATION TRVListLevel : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	TRVListType FListType;
	Graphics::TPicture* FPicture;
	Imglist::TCustomImageList* FImageList;
	int FImageIndex;
	AnsiString FFormatString;
	WideString FFormatStringW;
	int FLeftIndent;
	int FFirstIndent;
	int FMarkerIndent;
	TRVMarkerAlignment FMarkerAlignment;
	TRVMarkerFont* FFont;
	TRVListLevelOptions FOptions;
	int FStartFrom;
	Graphics::TPicture* __fastcall GetPicture(void);
	void __fastcall SetPicture(const Graphics::TPicture* Value);
	TRVMarkerFont* __fastcall GetFont(void);
	void __fastcall SetFont(const TRVMarkerFont* Value);
	bool __fastcall StoreFont(void);
	bool __fastcall StorePicture(void);
	void __fastcall ImageListTagWriter(Classes::TWriter* Writer);
	void __fastcall ImageListTagReader(Classes::TReader* Reader);
	void __fastcall FormatStringWCodeWriter(Classes::TWriter* Writer);
	void __fastcall FormatStringWCodeReader(Classes::TReader* Reader);
	void __fastcall FormatStringCodeWriter(Classes::TWriter* Writer);
	void __fastcall FormatStringCodeReader(Classes::TReader* Reader);
	bool __fastcall StoreImageList(void);
	Classes::TPersistent* __fastcall GetRVFRVData(void);
	
protected:
	virtual AnsiString __fastcall GetDisplayName(void);
	bool __fastcall IsSimpleEqual(TRVListLevel* Value);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	int __fastcall SimilarityValue(TRVListLevel* Value);
	
public:
	__fastcall virtual TRVListLevel(Classes::TCollection* Collection);
	__fastcall virtual ~TRVListLevel(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	AnsiString __fastcall GetHTMLOpenTagForCSS(void);
	AnsiString __fastcall GetIndentCSSForTextVersion(void);
	void __fastcall HTMLOpenTag(Classes::TStream* Stream, bool UseCSS);
	void __fastcall HTMLCloseTag(Classes::TStream* Stream, bool UseCSS);
	bool __fastcall HasPicture(void);
	bool __fastcall UsesFont(void);
	bool __fastcall HasNumbering(void);
	bool __fastcall HasVariableWidth(void);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const AnsiString 
		fs);
	
__published:
	__property TRVListType ListType = {read=FListType, write=FListType, default=0};
	__property int StartFrom = {read=FStartFrom, write=FStartFrom, default=1};
	__property Imglist::TCustomImageList* ImageList = {read=FImageList, write=FImageList, stored=StoreImageList
		};
	__property int ImageIndex = {read=FImageIndex, write=FImageIndex, default=0};
	__property AnsiString FormatString = {read=FFormatString, write=FFormatString, stored=false};
	__property WideString FormatStringW = {read=FFormatStringW, write=FFormatStringW, stored=false};
	__property int LeftIndent = {read=FLeftIndent, write=FLeftIndent, default=0};
	__property int FirstIndent = {read=FFirstIndent, write=FFirstIndent, default=10};
	__property int MarkerIndent = {read=FMarkerIndent, write=FMarkerIndent, default=0};
	__property TRVMarkerAlignment MarkerAlignment = {read=FMarkerAlignment, write=FMarkerAlignment, default=0
		};
	__property Graphics::TPicture* Picture = {read=GetPicture, write=SetPicture, stored=StorePicture};
	__property TRVMarkerFont* Font = {read=GetFont, write=SetFont, stored=StoreFont};
	__property TRVListLevelOptions Options = {read=FOptions, write=FOptions, default=3};
};


class DELPHICLASS TRVListLevelCollection;
class PASCALIMPLEMENTATION TRVListLevelCollection : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	Classes::TPersistent* FOwner;
	HIDESBASE TRVListLevel* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, const TRVListLevel* Value);
	
public:
	__fastcall TRVListLevelCollection(Classes::TPersistent* Owner);
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	HIDESBASE TRVListLevel* __fastcall Add(void);
	HIDESBASE TRVListLevel* __fastcall Insert(int Index);
	bool __fastcall IsSimpleEqual(TRVListLevelCollection* Value);
	__property TRVListLevel* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TRVListLevelCollection(void) { }
	#pragma option pop
	
};


class DELPHICLASS TRVListInfo;
class PASCALIMPLEMENTATION TRVListInfo : public TCustomRVInfo 
{
	typedef TCustomRVInfo inherited;
	
private:
	TRVListLevelCollection* FLevels;
	bool FOneLevelPreview;
	int FListID;
	void __fastcall SetLevels(const TRVListLevelCollection* Value);
	int __fastcall GetListID(void);
	void __fastcall ReadListID(Classes::TReader* Reader);
	void __fastcall WriteListID(Classes::TWriter* Writer);
	
protected:
	DYNAMIC int __fastcall SimilarityValue(TCustomRVInfo* Value);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	
public:
	DYNAMIC bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID);
	DYNAMIC bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping);
	__fastcall virtual TRVListInfo(Classes::TCollection* Collection);
	__fastcall virtual ~TRVListInfo(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	HIDESBASE void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const 
		AnsiString fs);
	HIDESBASE void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section, const 
		AnsiString fs);
	bool __fastcall HasNumbering(void);
	bool __fastcall AllNumbered(void);
	bool __fastcall HasVariableWidth(void);
	__property int ListID = {read=GetListID, nodefault};
	
__published:
	__property TRVListLevelCollection* Levels = {read=FLevels, write=SetLevels};
	__property bool OneLevelPreview = {read=FOneLevelPreview, write=FOneLevelPreview, default=0};
};


class DELPHICLASS TRVListInfos;
class PASCALIMPLEMENTATION TRVListInfos : public TCustomRVInfos 
{
	typedef TCustomRVInfos inherited;
	
private:
	HIDESBASE TRVListInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, const TRVListInfo* Value);
	void __fastcall RemoveImageList(Imglist::TCustomImageList* ImageList);
	
public:
	Classes::TPersistent* FRVData;
	HIDESBASE TRVListInfo* __fastcall Add(void);
	HIDESBASE TRVListInfo* __fastcall Insert(int Index);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, const AnsiString Section);
	int __fastcall FindSuchStyle(TRVListInfo* Style, bool AddIfNotFound);
	int __fastcall FindStyleWithLevels(TRVListLevelCollection* Levels, const AnsiString StyleNameForAdding
		, bool AddIfNotFound);
	__property TRVListInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
public:
	#pragma option push -w-inl
	/* TCustomRVInfos.Create */ inline __fastcall TRVListInfos(TMetaClass* ItemClass, Classes::TPersistent* 
		Owner) : TCustomRVInfos(ItemClass, Owner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TRVListInfos(void) { }
	#pragma option pop
	
};


typedef TMetaClass*TRVFontInfoClass;

typedef TMetaClass*TRVParaInfoClass;

typedef TMetaClass*TRVListInfoClass;

class PASCALIMPLEMENTATION TRVStyle : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	Graphics::TPicture* FInvalidPicture;
	Graphics::TColor FColor;
	Graphics::TColor FHoverColor;
	Graphics::TColor FSelColor;
	Graphics::TColor FSelTextColor;
	Graphics::TColor FInactiveSelColor;
	Graphics::TColor FInactiveSelTextColor;
	Graphics::TColor FCheckpointColor;
	Graphics::TColor FCheckpointEvColor;
	Controls::TCursor FJumpCursor;
	TFontInfos* FTextStyles;
	TParaInfos* FParaStyles;
	TRVListInfos* FListStyles;
	bool FFullRedraw;
	short FSpacesInTab;
	Graphics::TColor FPageBreakColor;
	Graphics::TColor FSoftPageBreakColor;
	TRVApplyStyleColorEvent FOnApplyStyleColor;
	TRVApplyStyleEvent FOnApplyStyle;
	TRVDrawStyleTextEvent FOnDrawStyleText;
	TRVStyleHoverSensitiveEvent FOnStyleHoverSensitive;
	TRVDrawTextBackEvent FOnDrawTextBack;
	TRVDrawCheckpointEvent FOnDrawCheckpoint;
	TRVDrawPageBreakEvent FOnDrawPageBreak;
	TRVDrawParaRectEvent FOnDrawParaBack;
	int FDefUnicodeStyle;
	TRVCodePage FDefCodePage;
	bool FUseSound;
	TRVSelectionMode FSelectionMode;
	TRVSelectionStyle FSelectionStyle;
	Controls::TCursor FLineSelectCursor;
	void __fastcall SetTextStyles(TFontInfos* Value);
	void __fastcall SetParaStyles(TParaInfos* Value);
	void __fastcall SetListStyles(TRVListInfos* Value);
	Graphics::TColor __fastcall GetHoverColorByColor(Graphics::TColor Color);
	Graphics::TPicture* __fastcall GetInvalidPicture(void);
	void __fastcall SetInvalidPicture(const Graphics::TPicture* Value);
	
protected:
	virtual void __fastcall ReadState(Classes::TReader* Reader);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
public:
	int ItemNo;
	int OffsetInItem;
	Classes::TPersistent* RVData;
	void __fastcall ResetTextStyles(void);
	void __fastcall ResetParaStyles(void);
	__fastcall virtual TRVStyle(Classes::TComponent* AOwner);
	__fastcall virtual ~TRVStyle(void);
	virtual TMetaClass* __fastcall GetTextStyleClass(void);
	virtual TMetaClass* __fastcall GetParaStyleClass(void);
	virtual TMetaClass* __fastcall GetListStyleClass(void);
	int __fastcall AddTextStyle(void);
	void __fastcall DeleteTextStyle(int Index);
	void __fastcall SaveINI(const AnsiString FileName, const AnsiString Section);
	void __fastcall LoadINI(const AnsiString FileName, const AnsiString Section);
	void __fastcall SaveToINI(Inifiles::TCustomIniFile* ini, AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TCustomIniFile* ini, AnsiString Section);
	void __fastcall SaveReg(const AnsiString BaseKey);
	void __fastcall LoadReg(const AnsiString BaseKey);
	void __fastcall SaveCSSToStream(Classes::TStream* Stream, TRVSaveCSSOptions AOptions);
	bool __fastcall SaveCSS(const AnsiString FileName, TRVSaveCSSOptions AOptions);
	Graphics::TColor __fastcall GetHoverColor(int StyleNo);
	void __fastcall DrawTextBack(Graphics::TCanvas* Canvas, int ItemNo, int StyleNo, Classes::TPersistent* 
		RVData, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState);
	void __fastcall ApplyStyle(Graphics::TCanvas* Canvas, int StyleNo, Rvscroll::TRVBiDiMode DefBiDiMode
		);
	void __fastcall ApplyStyleColor(Graphics::TCanvas* Canvas, int StyleNo, TRVTextDrawStates DrawState
		, bool Printing, TRVColorMode ColorMode);
	void __fastcall DrawStyleText(const AnsiString s, Graphics::TCanvas* Canvas, int ItemNo, int OffsetInItem
		, int StyleNo, Classes::TPersistent* RVData, int SpaceBefore, int Left, int Top, int Width, int Height
		, TRVTextDrawStates DrawState, bool Printing, bool PreviewCorrection, TRVColorMode ColorMode, Rvscroll::TRVBiDiMode 
		DefBiDiMode);
	void __fastcall DrawCheckpoint(Graphics::TCanvas* Canvas, int X, int Y, int ItemNo, int XShift, bool 
		RaiseEvent, Controls::TControl* Control);
	void __fastcall DrawPageBreak(Graphics::TCanvas* Canvas, int Y, int XShift, TRVPageBreakType PageBreakType
		, Controls::TControl* Control);
	void __fastcall DrawParaBack(Graphics::TCanvas* Canvas, int ParaNo, const Windows::TRect &Rect, bool 
		Printing, TRVColorMode ColorMode);
	bool __fastcall StyleHoverSensitive(int StyleNo);
	
__published:
	__property TFontInfos* TextStyles = {read=FTextStyles, write=SetTextStyles};
	__property TParaInfos* ParaStyles = {read=FParaStyles, write=SetParaStyles};
	__property TRVListInfos* ListStyles = {read=FListStyles, write=SetListStyles};
	__property short SpacesInTab = {read=FSpacesInTab, write=FSpacesInTab, default=8};
	__property Controls::TCursor JumpCursor = {read=FJumpCursor, write=FJumpCursor, default=101};
	__property Controls::TCursor LineSelectCursor = {read=FLineSelectCursor, write=FLineSelectCursor, default=106
		};
	__property bool FullRedraw = {read=FFullRedraw, write=FFullRedraw, default=0};
	__property bool UseSound = {read=FUseSound, write=FUseSound, default=1};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483643};
	__property Graphics::TColor HoverColor = {read=FHoverColor, write=FHoverColor, default=536870911};
	__property Graphics::TColor SelColor = {read=FSelColor, write=FSelColor, default=-2147483635};
	__property Graphics::TColor SelTextColor = {read=FSelTextColor, write=FSelTextColor, default=-2147483634
		};
	__property Graphics::TColor InactiveSelColor = {read=FInactiveSelColor, write=FInactiveSelColor, default=-2147483635
		};
	__property Graphics::TColor InactiveSelTextColor = {read=FInactiveSelTextColor, write=FInactiveSelTextColor
		, default=-2147483634};
	__property Graphics::TColor CheckpointColor = {read=FCheckpointColor, write=FCheckpointColor, default=32768
		};
	__property Graphics::TColor CheckpointEvColor = {read=FCheckpointEvColor, write=FCheckpointEvColor, 
		default=65280};
	__property Graphics::TColor PageBreakColor = {read=FPageBreakColor, write=FPageBreakColor, default=-2147483632
		};
	__property Graphics::TColor SoftPageBreakColor = {read=FSoftPageBreakColor, write=FSoftPageBreakColor
		, default=-2147483633};
	__property TRVSelectionMode SelectionMode = {read=FSelectionMode, write=FSelectionMode, default=1};
		
	__property TRVSelectionStyle SelectionStyle = {read=FSelectionStyle, write=FSelectionStyle, default=0
		};
	__property int DefUnicodeStyle = {read=FDefUnicodeStyle, write=FDefUnicodeStyle, default=-1};
	__property TRVCodePage DefCodePage = {read=FDefCodePage, write=FDefCodePage, default=0};
	__property Graphics::TPicture* InvalidPicture = {read=GetInvalidPicture, write=SetInvalidPicture};
	__property TRVApplyStyleEvent OnApplyStyle = {read=FOnApplyStyle, write=FOnApplyStyle};
	__property TRVApplyStyleColorEvent OnApplyStyleColor = {read=FOnApplyStyleColor, write=FOnApplyStyleColor
		};
	__property TRVDrawStyleTextEvent OnDrawStyleText = {read=FOnDrawStyleText, write=FOnDrawStyleText};
		
	__property TRVStyleHoverSensitiveEvent OnStyleHoverSensitive = {read=FOnStyleHoverSensitive, write=
		FOnStyleHoverSensitive};
	__property TRVDrawTextBackEvent OnDrawTextBack = {read=FOnDrawTextBack, write=FOnDrawTextBack};
	__property TRVDrawCheckpointEvent OnDrawCheckpoint = {read=FOnDrawCheckpoint, write=FOnDrawCheckpoint
		};
	__property TRVDrawPageBreakEvent OnDrawPageBreak = {read=FOnDrawPageBreak, write=FOnDrawPageBreak};
		
	__property TRVDrawParaRectEvent OnDrawParaBack = {read=FOnDrawParaBack, write=FOnDrawParaBack};
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint crJump = 0x65;
static const Shortint crRVFlipArrow = 0x6a;
static const Shortint rvsNormal = 0x0;
static const Shortint rvsHeading = 0x1;
static const Shortint rvsSubheading = 0x2;
static const Shortint rvsKeyword = 0x3;
static const Shortint rvsJump1 = 0x4;
static const Shortint rvsJump2 = 0x5;
static const Shortint rvsBreak = 0xffffffff;
static const Shortint rvsCheckpoint = 0xfffffffe;
static const Shortint rvsPicture = 0xfffffffd;
static const Shortint rvsHotspot = 0xfffffffc;
static const Shortint rvsComponent = 0xfffffffb;
static const Shortint rvsBullet = 0xfffffffa;
static const Shortint rvsBack = 0xfffffff9;
static const Shortint rvsVersionInfo = 0xfffffff8;
static const Shortint rvsDocProperty = 0xfffffff7;
static const Shortint rvsHotPicture = 0xfffffff6;
static const Shortint rvsListMarker = 0xfffffff5;
static const Shortint LAST_DEFAULT_STYLE_NO = 0x5;
static const int rvsDefStyle = 0x7fffffff;
extern PACKAGE TRVRTFOptions rvrtfDefault;
extern PACKAGE TRVFontInfoProperties RVAllFontInfoProperties;
extern PACKAGE TRVParaInfoProperties RVAllParaInfoProperties;
extern PACKAGE TRVParaInfoProperties RVAllParaBackgroundProperties;
extern PACKAGE TRVParaInfoProperties RVAllParaBorderProperties;
extern PACKAGE bool RichViewResetStandardFlag;
extern PACKAGE void __fastcall RVWrite(Classes::TStream* Stream, const AnsiString s);
extern PACKAGE void __fastcall RVWriteLn(Classes::TStream* Stream, const AnsiString s);
extern PACKAGE void __fastcall RVWriteX(Classes::TStream* Stream, const AnsiString s, bool Multiline
	);

}	/* namespace Rvstyle */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Rvstyle;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// RVStyle
