/*------------------------------------------------------------------------------
 Implementing "fields"
 The main property settings:
 - rvoTagsArePChars in RichViewEdit1->Options (so each item can have associated string)
 - RVStyle1->TextStyles collection has two styles (for static text and for fields)
   Especially look at Protection properties
 - RichViewEdit1 is set to "use predefined set of styles" (right click on
   RichViewEdit1 in design time, then choose "Settings")
 - AcceptDragDropFormats = []

------------------------------------------------------------------------------*/

#include <vcl\vcl.h>
#include <SysUtils.hpp>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"


TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
bool GetFieldLocation(TCustomRVData* RootRVData, const AnsiString field,
  TCustomRVData* &RVData, int &ItemNo)
{
  for (int i=0; i<RootRVData->ItemCount; i++)
    if (RootRVData->GetItemStyle(i)==rvsTable)
    {
      TRVTableItemInfo* table = (TRVTableItemInfo*)(RootRVData->GetItem(i));
      for (int r=0; r<table->Rows->Count; r++)
        for (int c=0; c<table->Rows->Items[r]->Count; c++)
          if (table->Cells[r][c])
            if (GetFieldLocation(table->Cells[r][c]->GetRVData(), field, RVData, ItemNo))
              return true;
    }
    else if (AnsiString(PChar(RootRVData->GetItemTag(i)))==field)
    {
      ItemNo = i;
      RVData = RootRVData->GetSourceRVData();
      return true;
    }
  return false;
}
//---------------------------------------------------------------------------
AnsiString GetFieldValue(TCustomRichView* rv, const AnsiString field)
{
  TCustomRVData* RVData;
  int ItemNo;
  if (GetFieldLocation(rv->RVData, field, RVData, ItemNo))
    return RVData->GetItemTextA(ItemNo);
  else
    return "";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichViewEdit1->Clear();
  RichViewEdit1->AddNL("2 + 2 =", 1,0);
  RichViewEdit1->AddNLTag("  ", 0,-1, Integer(StrNew("answer1")));
  RichViewEdit1->AddNL("?", 1,-1);
  RichViewEdit1->AddNL("3 + 3 =", 1,0);
  RichViewEdit1->AddNLTag("  ", 0,-1, Integer(StrNew("answer2")));
  RichViewEdit1->AddNL("?", 1,-1);
  RichViewEdit1->Format();
  RichViewEdit1->SetSelectionBounds(1,2,1,2);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichViewEdit1Paste(TCustomRichViewEdit *Sender,
	bool &DoDefault)
{
  // allowing to paste only one line text
  
  AnsiString s = Clipboard()->AsText;
  if (!strchr(s.c_str(), '\r') && !strchr(s.c_str(), '\n'))
    RichViewEdit1->InsertText(s,false);
  DoDefault = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  AnsiString s = GetFieldValue(RichViewEdit1, "answer1");
  if (StrToIntDef(Trim(s), 0)!=4)
  {
    Application->MessageBox("Wrong! Try again","Test", 0);
    return;
  }
  s = GetFieldValue(RichViewEdit1, "answer2");
  if (StrToIntDef(Trim(s), 0)!=6)
  {
    Application->MessageBox("Wrong! Try again", "Test", 0);
    return;
  }
  Application->MessageBox("Test is passed", "Test", 0);
}
//---------------------------------------------------------------------------
