#ifndef __PROCESS_H
#define __PROCESS_H

#ifndef __DEFS_H__
#include <defs.h>
#endif

#define P_WAIT    0
#define P_NOWAIT  1
#define P_OVERLAY 2

#ifdef __cplusplus
extern "C" {
#endif
void       _RTL_NORM abort(void);
void       _RTL_NORM _cexit(void);
void       _RTL_NORM _c_exit(void);
void       _RTL_NORM exit(int __status);
void       _RTL_NORM _exit(int __status);

int        _RTL_NORM execl(const char *path, const char *argv0,...);
int        _RTL_NORM execle(const char *path, const char *argv0,...);
int        _RTL_NORM execlp(const char *path, const char *argv0,...);
int        _RTL_NORM execlpe(const char *path, const char *argv0,...);
int        _RTL_NORM execv(const char *path, const char **argv);
int        _RTL_NORM execve(const char *path, const char **argv, const char **env);
int        _RTL_NORM execvp(const char *path, const char **argv);
int        _RTL_NORM execvpe(const char *path, const char **argv, const char **env);

int        _RTL_NORM spawnl(int mode,const char *path, const char *argv0,...);
int        _RTL_NORM spawnle(int mode,const char *path, const char *argv0,...);
int        _RTL_NORM spawnlp(int mode,const char *path, const char *argv0,...);
int        _RTL_NORM spawnlpe(int mode,const char *path, const char *argv0,...);
int        _RTL_NORM spawnv(int mode,const char *path, const char **argv);
int        _RTL_NORM spawnve(int mode,const char *path, const char **argv, const char **env);
int        _RTL_NORM spawnvp(int mode,const char *path, const char **argv);
int        _RTL_NORM spawnvpe(int mode,const char *path, const char **argv, const char **env);

#ifdef __cplusplus
};
#endif

#endif /* __PROCESS_H */