/* 
   Copyright 2001-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222

**********************************************************************

DIALOG.C holds some simple helper functions for dealing with some of
the standard controls

**********************************************************************

*/
//
// MODTOOL
//
// Copyright (c) !998 David Lindauer (LADSOFT)
//
// see license.txt for licensing info
//
// ==============================================================
//
// DIALOG.CPP
//
// dialog box utility functions, for setting retrieving values
//
#define STRICT
#include <windows.h>
#include <stdio.h>

// ==============================================================
// enable or disable a control
void DisableControl(HWND hwnd, int control, int disable)
{
	HWND hwndedit = GetDlgItem(hwnd,control);
   EnableWindow(hwndedit, !disable) ;
}
// ==============================================================
//
// set an edit field to read only
void SetEditFieldRO(HWND hwnd, int control)
{
	HWND hwndedit = GetDlgItem(hwnd,control);
	SendMessage(hwndedit,EM_SETREADONLY,TRUE,0);
}

// ==============================================================
//
// set the value of an edit field
//
void SetEditField(HWND hWnd,int control, char *text)
{
	HWND hwndedit = GetDlgItem(hWnd,control);
	SendMessage(hwndedit,EM_SETSEL,0,-1);
	SendMessage(hwndedit,EM_REPLACESEL,0,(LPARAM) text);
	SendMessage(hwndedit,EM_SETSEL,0,-1);
	SendMessage(hwndedit,EM_SETLIMITTEXT,255,0);
}
void SetEditFieldValue(HWND hWnd,int control, long value)
{
	char string[256];
	sprintf(string,"%ld",value);
	SetEditField(hWnd,control,string);
}
// ==============================================================
//
// get the value of an edit field
//
void GetEditField(HWND hWnd, int control, char *text)
{
	HWND hwndedit = GetDlgItem(hWnd,control);
	char itext[260];
	int rv ;
	itext[0] = 0;
	itext[1] = 1;
	rv = SendMessage(hwndedit,EM_GETLINE,0,(LPARAM) itext);
	itext[rv] = 0;
	strcpy(text,itext);
}
long GetEditFieldValue(HWND hWnd, int control)
{
	char string[256];
	GetEditField(hWnd,control,string);
	return atoi(string);
}
// ==============================================================
// 
// handle checkboxes
//
void SetCBField(HWND hWnd, int control, int value)
{
	CheckDlgButton(hWnd,control,value);
}
int GetCBField(HWND hWnd, int control)
{
	return IsDlgButtonChecked(hWnd,control);
}

// ==============================================================
//
// set focus 
void NewFocus(HWND hWnd, int control)
{
	HWND hwndc = GetDlgItem(hWnd,control);
	SetFocus(hwndc);
}

void AddComboString(HWND hwnd, int control, char *string)
{
	HWND hwndc = GetDlgItem(hwnd,control) ;
	SendMessage(hwndc,CB_ADDSTRING,0, (LPARAM)string) ;
}
void SetComboSel(HWND hwnd, int control, int sel)
{
	HWND hwndc = GetDlgItem(hwnd,control) ;
	SendMessage(hwndc,CB_SETCURSEL,sel, 0) ;
}
int GetComboSel(HWND hwnd, int control)
{
	HWND hwndc = GetDlgItem(hwnd,control) ;
	return SendMessage(hwndc,CB_GETCURSEL,0, 0) ;
}