/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <errno.h>
#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <libp.h>

int _fmode = O_TEXT;
int _uihandles[HANDLE_MAX], _uimodes[HANDLE_MAX],_uiflags[HANDLE_MAX] ;
char _uinames[HANDLE_MAX][256] ;

#pragma startup uio_init 138
#pragma rundown uio_rundown 50 /* 11 */

static void uio_init(void)
{
   int i ;
   _ll_uioinit() ; /* sets first three handles */
   for (i=0; i < 3; i++) {
      _uimodes[i] = _fmode ;
   }
   for (i=3; i < HANDLE_MAX; i++)
      _uihandles[i] = -1 ;
}
static void uio_rundown(void)
{
   int i ;
   for (i=3; i < HANDLE_MAX; i++)
      if (_uihandles[i] != -1) {
         _ll_close(_uihandles[i]) ;
         _uihandles[i] = -1 ;
      }
}
int _uiohandle(int __handle)
{
   if (__handle >= HANDLE_MAX || __handle < 0) {
      errno = EBADF ;
      return -1 ;
   }
   if (_uihandles[__handle] == -1)
      errno = EBADF ;
   return _uihandles[__handle] ;
}
int _uinewhandpos(void)
{
   int i;
   for (i=0; i < HANDLE_MAX; i++)
      if (_uihandles[i] == -1)
         return i ;
   errno = EMFILE ;
   return -1 ;
}